/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Some handy string functions.
 */

#import <String.h>
#import <Foundation/NSAutoreleasePool.h>

@implementation NSString (GrouchExtension)

// remove whitespace and put in lower case.
- (NSString*)screenNameKey
{
	NSMutableString *r = [NSMutableString new];
	NSString *src = [self lowercaseString];
	unichar c;
	int i;

	for( i=0; i<[src length]; ++i )
		switch( (c=[src characterAtIndex:i]) )
		{
			case '\t':
			case ' ':
				break;
			default:
				[r appendString:
				[NSString stringWithCharacters:&c length:1]];
		}
	[r autorelease];
	return r;
}

- (NSAttributedString*)attributed
{
	return [[[NSAttributedString alloc] initWithString:self] autorelease];
}

@end
