/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Convert the junk strings and cryptic binary that is OSCAR into
 * an NSStringEncoding.  Or at least try to.
 */

#import <Oscar/OscarEncoding.h>

@implementation OscarEncoding

// Get encoding for profile or chat room text

+ (NSStringEncoding)get:(NSString*)str
{
	str = [str lowercaseString];

	if( [str rangeOfString:@"us-ascii"].length )
		return NSASCIIStringEncoding;
	if( [str rangeOfString:@"utf-8"].length )
		return NSUTF8StringEncoding;
	if( [str rangeOfString:@"unicode-2-0"].length )
		return NSUnicodeStringEncoding;
	if( [str rangeOfString:@"iso-8559-1"].length )
		return NSISOLatin1StringEncoding;
	if( [str rangeOfString:@"iso-8559-2"].length )
		return NSISOLatin2StringEncoding;
#ifdef GNUSTEP
	if( [str rangeOfString:@"iso-8559-3"].length )
		return NSISOLatin3StringEncoding;
	if( [str rangeOfString:@"iso-8559-4"].length )
		return NSISOLatin4StringEncoding;
	if( [str rangeOfString:@"iso-8559-5"].length )
		return NSISOLatin5StringEncoding;
	if( [str rangeOfString:@"iso-8559-6"].length )
		return NSISOLatin6StringEncoding;
	if( [str rangeOfString:@"iso-8559-7"].length )
		return NSISOLatin7StringEncoding;
	if( [str rangeOfString:@"iso-8559-8"].length )
		return NSISOLatin8StringEncoding;
	if( [str rangeOfString:@"iso-8559-9"].length )
		return NSISOLatin9StringEncoding;
#endif
	
	return [NSString defaultCStringEncoding];
}

// Get encoding for channel 1 Instant Message

+ (NSStringEncoding)getForChannel1:(int)set withSub:(int)sub
{
	switch(set)
	{
	case 0:
		return NSASCIIStringEncoding;
	case 2:
		return NSUnicodeStringEncoding;	
	case 3:
		/*
		 * This is in theory a bad idea, but Mac AIM does it too.
		 */
		return NSISOLatin1StringEncoding;
	case 0xd:
		return NSISOLatin1StringEncoding;
	default:
		return [NSString defaultCStringEncoding];
	}
}

+ (void)encodeString:(NSString*)str
	encodingName:(NSString**)encoding
	encodingID:(NSStringEncoding*)enc
	intFlag:(int*)r and:(int*)s;
{
	if( [str canBeConvertedToEncoding:*enc=NSASCIIStringEncoding] )
	{
		*enc = NSASCIIStringEncoding;
		*encoding = @"us-ascii";
		*r = 0;
		*s = 0xffff;
		return;
	}
	else if( [str canBeConvertedToEncoding:*enc=NSISOLatin1StringEncoding] )
	{
		*encoding = @"iso-8859-1";
		*r = 3;
		*s = 0;
	}
	else if( [str canBeConvertedToEncoding:*enc=NSUnicodeStringEncoding] )
	{
		*encoding = @"unicode-2-0";
		*r = 2;
		*s = 0;		// ???
	}
	else
	{
		// Good luck...
		*encoding = @"us-ascii";
		*r = 3;
		*s = 0;
		*enc = [NSString defaultCStringEncoding];
	}
}

@end
