/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * The "capabilities" handler for channel 2 messages.
 */

#import <Oscar/OscarClient.h>
#import <Oscar/OscarTlvList.h>

#import <Foundation/NSDictionary.h>
#import <Foundation/NSData.h>

#define OSCAR_MSG_COOKIE_SIZE	8
#define OSCAR_CAP_SIZE		16

@protocol OscarCapHandler

- (NSData*)capabilityBuffer;
- (BOOL)handleCapability:(const void *)cap
	from:(id<GrouchUser>)user onClient:(OscarClient*)cli
	type:(int)type cookie:(const void *)cookie tlv:(OscarTlvListIn*)tlv
	message:(NSString*)str;

@end

@interface OscarCapHandler : NSObject <OscarCapHandler>
{
	NSMutableDictionary *caps;
}

+ sharedInstance;
- (void)add:(id<OscarCapHandler>)caps;

- (NSData*)capabilityBuffer;

- (BOOL)handleCapability:(const void *)cap
	from:(id<GrouchUser>)user onClient:(OscarClient*)cli
	type:(int)type cookie:(const void *)cookie tlv:(OscarTlvListIn*)tlv
	message:(NSString*)str;

@end

@interface OscarCapHandlerSimple : NSObject <OscarCapHandler>
{
	const unsigned char *cap;
	size_t len;
}

- (NSData*)capabilityBuffer;
- (BOOL)handleCapability:(const void *)cap
	from:(id<GrouchUser>)user onClient:(OscarClient*)cli
	type:(int)type cookie:(const void *)cookie tlv:(OscarTlvListIn*)tlv
	message:(NSString*)str;
@end

@interface OscarCapChatInvite : OscarCapHandlerSimple
@end
