/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This is the ugliest class in the whole program.  I was relatively
 * new to objc, wasn't sure what the direction of the API was going to
 * be (very early on), and I came up with some really bad interfaces.
 * I apologize.
 *
 * However, this is useful for outputting FLAP messages.
 * write them with:  [flap write:obj];
 *		or:  [flap write:obj withType:FLAP_SIGNON];
 * Of course, this assumes you know something about the Oscar protocol.
 */ 

#import <Foundation/NSObject.h>
#include <stddef.h>

@class NSString;
@class OscarTlvListIn;

@interface OscarBuffer : NSObject
{
	// I came up with this messed up linked list structure
	// because I wanted to have the buffer be able to contain
	// other buffers.  That way, the length headers (calculated
	// upon write) would be completely programmer-independent.
	// Yes, the linked list is ugly, but I kind of like the result.
	struct oscarbuffer_node
	{
		enum { BUFFER, OBJ } type;
		union
		{
			id obj;
			struct
			{
				void *buf;
				size_t len, alloc;
			} mem;
		} data;
		struct oscarbuffer_node *next;
	} *head, *tail;
}

// NB: these are not auto-released.
// what did you think this was, boy, java?!
// if you're wondering what "tag" means, see OscarCache.h
+ (OscarBuffer*) snacWithFamily: (int) fam andType: (int)type
			 andFlags:(int)flags andTag:f;
+ (OscarBuffer*) snacWithFamily: (int) fam andType: (int)type
			 andTag:f;

- init;
- (void)dealloc;

// This interface is ugly.
- createHeapBuffer: (void**)ptrptr withLength: (size_t*)len;

- add: obj;
- addBuffer: (const void *)buf withLength: (size_t) len;
- addByte: (char)c;
- addInt16: (int)i;
- addInt32: (int)i;
- addString: (NSString*)s;		// You can also call add: here

- addTLV: (int)type;
- addTLV: (int)type with:obj;
- addTLV: (int)type withBuffer:(const void *)buf andLength:(size_t)l;
- addTLV: (int)type withInt16:(int) i;
- addTLV: (int)type withInt32:(int) i;
- addTLV: (int)type withString:(NSString*)s;

- (OscarBuffer*)bufferByRemovingTlv:(int)tlv;
- (OscarTlvListIn*)bufferAsTlv;
@end

/*
 * Putting these here randomly.  It needs some ifdefs for
 * portability and the -add*: methods already have those
 * so this is as good a place as any
 */
int oscar_int16_get( const void * );
long oscar_int32_get( const void * );
