/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Channel joining dialog.
 */

#import <JoinChannel.h>
#import <ClientInstance.h>
#import <User.h>
#import <ErrorWindow.h>

#import <Grouch/GrouchStringTool.h>

#import <Renaissance/Renaissance.h>
#import <AppKit/AppKit.h>

@implementation JoinChannel

- init
{
	NSArray *instances = [ClientInstance clientInstances];
	int i;

	[NSBundle loadGSMarkupNamed:@"JoinChannel" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];

	for( i=0; i<[instances count]; ++i )
	{
		ClientInstance *cli = [instances objectAtIndex:i];
		[instanceField addItemWithObjectValue:[cli nick]];
	}

	if( [instanceField numberOfItems] )
	{
		[instanceField selectItemAtIndex:0];
		[instanceField setObjectValue:
		  [instanceField objectValueOfSelectedItem]];
	}

	return self;
}

- (void)setLogin:(NSString*)str
{
	[instanceField setStringValue:str];
}

- (BOOL)windowShouldClose:sender
{
	[window autorelease];
	[channelField release];
	[instanceField release];
	[self release];
	return YES;
}

- (void)doJoin
{
	NSString *me = [instanceField stringValue];
	ClientInstance *cli = [ClientInstance clientByName:me];
	if( cli )
	{
		NSString *where = [channelField stringValue];
		if( ![where length] )
			[ErrorWindow errorWithString:
			 [GrouchString getString:@"vague-form"]];
		else
		{
			id<GrouchSession> ses = [cli session];
			[ses joinChannel:where];
			[window performClose:self];
		}
	}
	else
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"no-session"]];
}

@end
