/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <InfoWindow.h>
#import <String.h>
#import <Defaults.h>

#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSBundle.h>
#import <Renaissance/Renaissance.h>

@implementation InfoWindow

+ infoWithNick:(NSString*)nick
{
	return [[[InfoWindow new] initWithNick:nick] autorelease];
}

- initWithNick:(NSString*)nick
{
	name = [nick retain];
	return self;
}

- (void)dealloc
{
	[name release];
	[super dealloc];
}

- (void)finishedProfile
{
	if( !window )
	{
		[self createWindow];
		if( output )
		{
			NSTextStorage *text = [output textStorage];
			NSString *str = [GrouchString getString:@"no-profile"];
			if( text )
				[text appendAttributedString:[str attributed]];
		}
	}
}

- (void)createWindow
{
	if( !window )
	{
		[NSBundle loadGSMarkupNamed:@"InfoWindow" owner:self];
		[window orderFront:nil];
		[window makeKeyWindow];
		[window setTitle:[NSString stringWithFormat:@"%@%@",
		 [window title], name]];
		[window release];
		[output release];
	}
}

- (void)profile:(NSString*)str
{
	NSTextStorage *text;
	[self createWindow];
	text = [output textStorage];
	[text beginEditing];
	str = [NSString stringWithFormat:@"%@%@",
		[Defaults defaultTextTags], str];
	[text appendAttributedString:[str parseHtml]];
	[text endEditing];
	[output setSelectedRange:NSMakeRange(0,0)];
}

- (void)awayMessage:(NSString*)str
{
	NSTextStorage *text;
	[self createWindow];
	text = [output textStorage];
	[text beginEditing];
	str = [NSString stringWithFormat:@"%@%@<hr>",
		[Defaults defaultTextTags], str];
	[text insertAttributedString:[str parseHtml] atIndex:0];
	[text endEditing];
	[output setSelectedRange:NSMakeRange(0,0)];
}

- (BOOL)windowShouldClose:sender
{
	return YES;
}

@end
