/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This is the main UI class that the OSCAR code can interact with.
 * In practice we may have several of these (1 for each user you are
 * logged in as)
 */

#import <Grouch/GrouchClient.h>
#import <User.h>

@class GrouchTimedDictionary, AwayMessageWindow, BuddyList;
@class NSAttributedString, NSArray, NSMutableDictionary, NSWindow;

@class ClientInstance;

@interface ClientInstance : NSObject <GrouchClient>
{
	GrouchTimedDictionary *users, *chatRooms;
	id<GrouchSession> sock;
	NSString *nick;

	NSMutableDictionary *autoResponses;
	NSString *awayMsg;
	AwayMessageWindow *awayWindow;

	NSWindow *statusWindow;
	NSTextField *statusLabel;
	BOOL statusDone;

	BuddyList *listWindow;

	NSMutableDictionary *dependentWindows;

	BOOL finishing, loggedOff;
}

// Access clients that are currently running
// To create a new one use [[[-alloc] -init] setSock:]
+ (ClientInstance*)clientByName:(NSString*)name;
+ (NSArray*)clientInstances;

- init;
- (void)dealloc;
- (void)setSock:(id<GrouchSession>)sock;

- (void)addDependentWindow:(NSWindow*)wnd;
- (void)removeDependentWindow:(NSWindow*)wnd;

// Use this to disconnect.
// It will lead to releases.
- (void)logOff;

- (void)setAway:(NSString*)awayMsg;
- (void)returnFromAway;
- (void)processAutoReply:(NSString*)nick;

- (BOOL)isAway;

- (void)setProfile:(NSString*)profile;

- (void)reloadData:(BOOL)newList;

// Conform to GrouchClient protocol
- (void)welcome:(NSString*)nick;
- (void)bye;
- (void)statusMessage:(NSString*)status;
- (void)error:(NSString*)error fatal:(BOOL)fatal;
- (id<GrouchUser>)getUser:(NSString*)str;
- (id<GrouchChannel>)getChannel:(NSString*)str;

// Format incoming messages.
- (NSAttributedString*)formatMessage:(NSString*)msg from:(NSString*)user
  withFlags:(GrouchMessageFlags)flags;

// Accessor junk.
- (id<GrouchSession>)session;
- (NSArray*)getUsers;
- (NSArray*)getGroups;
- (NSString*)nick;

@end 
