/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <Grouch/NSBundle+Grouch.h>
#import <Grouch/GrouchClient.h>
#import <Foundation/NSArray.h>

@implementation NSBundle (Grouch)

- (BOOL)isGrouchProtocolPlugin
{
	Class c = [self principalClass];
	return c ? [c conformsToProtocol:@protocol(GrouchBundle)] : NO;
}

- (NSArray*)listGrouchProtocols
{
	NSMutableArray *r = [NSMutableArray array];
	NSArray *src = [self pathsForResourcesOfType:@"bundle" inDirectory:nil];
	int i;
	for( i=0; i<[src count]; ++i )
		[r addObject:[NSBundle bundleWithPath:[src objectAtIndex:i]]];
	return r;
}

- (id<GrouchSession>)loadGrouchClient:(id<GrouchClient>)cli
  forHost:(NSString*)host atPort:(int)port
  withLogin:(NSString*)login andPassword:(NSString*)passwd
{
	if( [self isGrouchProtocolPlugin] )
	{
		id <GrouchBundle> b; 
		id <GrouchSession> g;
		b = [[self principalClass] new];
		g = [b loadGrouchClient:cli forHost:host atPort:port
			withLogin:login andPassword:passwd];
		[(NSObject*)b release];
		return g;
	}
	else
		return nil;
}


@end
