/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

@class NSStream, NSInputStream, NSOutputStream;

@interface GrouchSocketMac : NSObject <GrouchSocketBackend>
{
	GrouchSocket *fd;
	NSInputStream *in;
	NSOutputStream *out;
	BOOL writeThreadLive;
}

+ socketForHost:(NSString*)host atPort:(int)port
  withRunLoop:(NSRunLoop*)loop forSocket:(GrouchSocket*)sock;
- initForHost:(NSString*)host atPort:(int)port
  withRunLoop:(NSRunLoop*)loop forSocket:(GrouchSocket*)sock;

- (void)startWriteThread;
- (GrouchSocketEvent)pollSocketEvents;
- (void)setBlocking:(BOOL)b;

- (int)write:(const void*)buf length:(int)len;

@end

