/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Set alias/rename window.
 */

#import <AppKit/AppKit.h>
#import <Renaissance/Renaissance.h>

#import <AliasWindow.h>
#import <User.h>
#import <ClientInstance.h>

@implementation AliasWindow

+ windowForClient:(ClientInstance*)c forObject:obj
{
	return [[self alloc] initWithClient:c forObject:obj];
}

- initWithClient:(ClientInstance*)c forObject:obj
{
	NSString *currentStringValue = nil;

	object = [(NSObject*)obj retain];
	cli = c;

	if( [object isKindOfClass:[User class]] )
		currentStringValue = [(User*)object alias];
	else if( [object isKindOfClass:[NSArray class]] )
		currentStringValue = [(NSArray*)object objectAtIndex:0];

	[NSBundle loadGSMarkupNamed:@"AliasWindow" owner:self];
	[cli addDependentWindow:window];

	[alias setStringValue:currentStringValue];
	[window makeFirstResponder:alias];
	[window orderFront:nil];
	[window makeKeyWindow];
	return self;
}

- (void)dealloc
{
	if( window )
		[window performClose:self];
	[super dealloc];
}

- (void)go:sender
{
	NSString *newAlias = [alias stringValue];
	id<GrouchSession> ses = [cli session];
	[ses rename:object to:newAlias];
	[window performClose:self];
}

- (BOOL)windowShouldClose:sender
{
	[cli removeDependentWindow:window];
	[object release];
	[window autorelease];
	window = nil;
	[alias release];
	[self release];
	return YES;
}

@end
