dnl Copyright (C) 1993-2006 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Paul Eggert.

AC_PREREQ(2.13)

AC_DEFUN([CL_LONGDOUBLE],
[AC_CACHE_CHECK(for long double type, cl_cv_c_longdouble, [
AC_TRY_RUN([
#include <stdlib.h>
int main()
{ long double x = 2.7182818284590452354L; x = x*x; exit (x==0.0L); }
],
cl_cv_c_longdouble=yes, cl_cv_c_longdouble=no, [
dnl When cross-compiling, use the test from gnulib.
AC_TRY_COMPILE([
  /* The Stardent Vistra knows sizeof(long double), but does not support it.  */
  long double foo = 0.0;
  /* On Ultrix 4.3 cc, long double is 4 and double is 8.  */
  int array [2*(sizeof(long double) >= sizeof(double)) - 1];
  ], , cl_cv_c_longdouble=yes, cl_cv_c_longdouble=no)])
])
if test $cl_cv_c_longdouble = yes; then
  AC_DEFINE(HAVE_LONGDOUBLE, ,[Define if compiler supports long double type])
fi
])
