# CiviCRM 5.4.0

Released August 1, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-20430](https://issues.civicrm.org/jira/browse/CRM-20430) A permission
  'save Report Criteria'
  ([12107](https://github.com/civicrm/civicrm-core/pull/12107))**

  Permission to edit the criteria for saved reports is now separate from the
  permission to access and preview modifications of report criteria.  This will
  prevent non-privileged users from modifying the criteria of an organization's
  standard reports.  However when upgrading, site administrators will need to
  grant the Save Report Criteria permission to roles that need that capability.

- **[dev/core#174](https://lab.civicrm.org/dev/core/issues/174) Consistently use
  swappable cache interfaces
  ([12321](https://github.com/civicrm/civicrm-core/pull/12321),
  [12322](https://github.com/civicrm/civicrm-core/pull/12322),
  [12323](https://github.com/civicrm/civicrm-core/pull/12323),
  [12330](https://github.com/civicrm/civicrm-core/pull/12330),
  [12331](https://github.com/civicrm/civicrm-core/pull/12331),
  [12336](https://github.com/civicrm/civicrm-core/pull/12336),
  [12342](https://github.com/civicrm/civicrm-core/pull/12342),
  [12348](https://github.com/civicrm/civicrm-core/pull/12348),
  [12354](https://github.com/civicrm/civicrm-core/pull/12354),
  [12362](https://github.com/civicrm/civicrm-core/pull/12362),
  [12368](https://github.com/civicrm/civicrm-core/pull/12368),
  [12376](https://github.com/civicrm/civicrm-core/pull/12376),
  [12378](https://github.com/civicrm/civicrm-core/pull/12378),
  [12379](https://github.com/civicrm/civicrm-core/pull/12379),
  [12380](https://github.com/civicrm/civicrm-core/pull/12380),
  [12381](https://github.com/civicrm/civicrm-core/pull/12381),
  [12389](https://github.com/civicrm/civicrm-core/pull/12389), and
  [215](https://github.com/civicrm/civicrm-packages/pull/215))**

  Sites using Redis or Memcache for caches and sessions will now use those
  facilities exclusively rather than retaining the `civicrm_cache` table as
  a backstop.  This improves performance for these sites, especially those
  using multiple MySQL servers.

  As a precaution, Redis or Memcache administrators with very active sites
  may wish to double-check that they have ample capacity for their caches and
  sessions.

  For developers, the `CRM_Utils_Cache` APIs now support expiration/TTL
  times and [PSR-16 CacheInterface](https://www.php-fig.org/psr/psr-16/).
  The Civi implementation is slightly more permissive than the PSR-16
  specification; for full compliance, enable `CIVICRM_PSR16_STRICT`.

- **[CRM-21574](https://issues.civicrm.org/jira/browse/CRM-21574) Allow to
  disable sending of email from source contact for tell a friend on pcp
  ([12355](https://github.com/civicrm/civicrm-core/pull/12355)) (preliminary
  work)**

  Emails from the "tell a friend" feature are sent as if they are from the
  donor's address.  This can cause delivery failures as the site may not be a
  valid source for the donor's email domain.  Changes here are preliminary
  cleanup.

- **[dev/core#32](https://lab.civicrm.org/dev/core/issues/32) Add option to
  disable cancel button on a profile form
  ([11883](https://github.com/civicrm/civicrm-core/pull/11883))**

  The Cancel button is now optional on profile forms.

- **[CRM-21392](https://issues.civicrm.org/jira/browse/CRM-21392) Allow viewing
  groups/smartgroups as as other entities (eg. memberships, events)
  ([11241](https://github.com/civicrm/civicrm-core/pull/11241))**

  The Find Groups page now has a similar "View Results As" feature as the
  Advanced Search: you can choose to view memberships, events, activities, etc.
  of group subscribers rather than the contacts themselves.

- **[CRM-21622](https://issues.civicrm.org/jira/browse/CRM-21622) Make the Add
  Parent Groups on Group Settings be a multiselect
  ([11481](https://github.com/civicrm/civicrm-core/pull/11481))**

  The New Group form now allows you to set multiple parent groups for a single
  group.

- **[CRM-21460](https://issues.civicrm.org/jira/browse/CRM-21460) Programmatic
  access to job execution status
  ([11337](https://github.com/civicrm/civicrm-core/pull/11337))**

  Extension developers can implement two new hooks, `hook_civicrm_preJob` and
  `hook_civicrm_postJob`, which are invoked before and after executing a
  scheduled job.

- **Change default for `CIVICRM_CONTAINER_CACHE` to simplify admin/developer
  experience ([12426](https://github.com/civicrm/civicrm-core/pull/12426))**

- **[dev/core#223](https://lab.civicrm.org/dev/core/issues/223) Expose prefix
  and suffix in reports
  ([12394](https://github.com/civicrm/civicrm-core/pull/12394))**

  Individuals' prefix and suffix fields are now available as columns and filters
  among the contact fields in most reports.

- **[dev/core#101](https://lab.civicrm.org/dev/core/issues/101) Allow further
  customization of search form in hooks
  ([12078](https://github.com/civicrm/civicrm-core/pull/12078))**

  Fields are no longer explicitly included in the search form template since
  that makes it hard to add or remove fields.  Instead, the fields are listed in
  template variables, and the template iterates over the list to render the
  field elements.

- **[dev/core#183](https://lab.civicrm.org/dev/core/issues/183) Temporary tables
  should follow consistent naming convention
  ([12311](https://github.com/civicrm/civicrm-core/pull/12311)) (partially
  completed)**

  This moves towards naming temporary tables--both true temporary tables in
  MySQL and regular tables created for temporary use--in a consistent manner in
  order to help database administrators employ replication policies based upon
  table names.

- **[dev/core#144](https://lab.civicrm.org/dev/core/issues/144)
  `getCustomFieldID` switch to API, add caching, add full string return option
  ([12218](https://github.com/civicrm/civicrm-core/pull/12218) and
  [12283](https://github.com/civicrm/civicrm-core/pull/12283))**

  The function to retrieve a custom field ID now relies upon APIv3 rather than
  an *ad hoc* SQL query.  It also contains an option to return the ID preceded
  by `custom_`.  Finally, the function caches the result and attempts to return
  the cached value rather than looking it up each time.

- **[dev/core#47](https://lab.civicrm.org/dev/core/issues/47) Add "clone"
  functionality to scheduled jobs
  ([11945](https://github.com/civicrm/civicrm-core/pull/11945))**

  Scheduled jobs can now be copied, including their parameters, both from the
  Scheduled Jobs page and through a new `Job.clone` API method.

### CiviCase

- **[dev/core#107](https://lab.civicrm.org/dev/core/issues/107) After creating a
  new case, the assignee for each activity must be selected manually
  ([11998](https://github.com/civicrm/civicrm-core/pull/11998))**

  You can now select the default assignee for each activity in the standard
  timeline for a case type.  This may be defined according to a relationship
  with the client, a single specific contact, or the contact who created the
  case.

- **CiviCase, added reference of activities from different timelines.
  ([12236](https://github.com/civicrm/civicrm-core/pull/12236))**

  From an activity on a case timeline, you can now reference any activity
  available to the case--not just those on that case timeline.

### CiviContribute

- **Add support for hidden fields in general (and 'token' specifically) on the
  payment form. ([12332](https://github.com/civicrm/civicrm-core/pull/12332)
  and [12391](https://github.com/civicrm/civicrm-core/pull/12391))**

  A new authorization token field is added to the payment form to support
  token-based payment processors.

- **[CRM-21808](https://issues.civicrm.org/jira/browse/CRM-21808) Install custom
  group for Contribution or ContributioRecur subtypes based on XML file
  ([11726](https://github.com/civicrm/civicrm-core/pull/11726))**

  Extensions created custom data sets for contributions can now specify the
  custom data to apply only to a single financial type.

- **(dev/core/50) and
  [dev/core#195](https://lab.civicrm.org/dev/core/issues/195) Add Separate
  Sub-tabs for Contributions and Recurring  Contributions
  ([11956](https://github.com/civicrm/civicrm-core/pull/11956) and
  [12345](https://github.com/civicrm/civicrm-core/pull/12345))**

  The Contributions tab on a contact now contains two sub-tabs--one for single
  contributions, and the other for recurring contribution series--instead of
  displaying one after the other.

- **[dev/core#96](https://lab.civicrm.org/dev/core/issues/96) Expose source
  column in booking report
  ([12374](https://github.com/civicrm/civicrm-core/pull/12374))**

  The contribution Source field is now available as a column and filter on the
  Bookkeeping Transactions report.

- **Use html5 color input for contribution page widget
  ([12339](https://github.com/civicrm/civicrm-core/pull/12339))**

### CiviMail

- **[dev/mail#1](https://lab.civicrm.org/dev/mail/issues/1) Add pause/resume
  functionality to civicrm bulk mailing.
  ([11803](https://github.com/civicrm/civicrm-core/pull/11803) and
  [12284](https://github.com/civicrm/civicrm-core/pull/12284))**

  A CiviMail mailing that is scheduled or in progress can now be paused in order
  to allow an urgent message to go out first.

- **Add in bootstrap button classes to CiviMail interface
  ([12013](https://github.com/civicrm/civicrm-core/pull/12013) and
  [12338](https://github.com/civicrm/civicrm-core/pull/12338))**

  This allows the interfaces to be themed more easily by Bootstrap-based themes.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#222](https://lab.civicrm.org/dev/core/issues/222) Importing
  contacts with dedupe rule does not use the rule
  ([12393](https://github.com/civicrm/civicrm-core/pull/12393))**

- **[dev/core#284](https://lab.civicrm.org/dev/core/issues/284) Aggressive cache
  clearing significantly increases test time
  ([12590](https://github.com/civicrm/civicrm-core/pull/12590))**

  Settings, compiled Javascript, extension, and other caches are now only
  flushed along with the `default` CiviCRM cache if an external cache like Redis or
  Memcache is in use. (This reproduces the `5.3` behavior.)

- **[dev/core#279](https://lab.civicrm.org/dev/core/issues/279) When Merging two
  contacts, Flip between original and duplicate link not working in WordPress
  ([12568](https://github.com/civicrm/civicrm-core/pull/12568))**

- **Handle 'Check for Matching Contact(s)' button with ajax
  ([12552](https://github.com/civicrm/civicrm-core/pull/12552))**

  This resolves a bug where the "Check for Matching Contact(s)" button would not
  work if AJAX Deduping is enabled.

- **[dev/core#131](https://lab.civicrm.org/dev/core/issues/131) Add in missing
  UK shire Monmouthshire
  ([12538](https://github.com/civicrm/civicrm-core/pull/12538)) (follow-up on
  previous work)**

  Many individual sites had manually added the county of Monmouthshire in Wales
  to the `civicrm_state_province` table, and upgrading to 5.3.0, which added the
  missing record, would cause them a database error.

- **[dev/core#258](https://lab.civicrm.org/dev/core/issues/258) Possible
  unreleased regression - message template update altered customised template
  ([12492](https://github.com/civicrm/civicrm-core/pull/12492))**

- **[dev/core#249](https://lab.civicrm.org/dev/core/issues/249) Contact Export
  fails in 5.4 when trying to export using the All radio button
  ([12447](https://github.com/civicrm/civicrm-core/pull/12447))**

- **[dev/core#234](https://lab.civicrm.org/dev/core/issues/234) Upgrade Steps in
  5.3.alpha1 may not have been run
  ([12419](https://github.com/civicrm/civicrm-core/pull/12419),
  [12420](https://github.com/civicrm/civicrm-core/pull/12420), and
  [12425](https://github.com/civicrm/civicrm-core/pull/12425))**

- **[dev/core#155](https://lab.civicrm.org/dev/core/issues/155) Improvements and
  bugfixes to Option Groups UI
  ([12233](https://github.com/civicrm/civicrm-core/pull/12233) and
  [12411](https://github.com/civicrm/civicrm-core/pull/12411))**

  The Option Groups page now displays whether each option group is reserved or
  enabled.  In addition, sites using sample data no longer have the sample
  custom fields reserved.

- **[CRM-20184](https://issues.civicrm.org/jira/browse/CRM-20184) Some System
  Workflow templates still miss {contact.email_greeting}
  ([12296](https://github.com/civicrm/civicrm-core/pull/12296))**

  This makes receipt templates more consistent in using the contact's email
  greeting when sent to individuals.

- **[dev/core#41](https://lab.civicrm.org/dev/core/issues/41) Search Builder:
  Not empty with date or integer custom fields gives a sql warning
  ([12351](https://github.com/civicrm/civicrm-core/pull/12351) and
  [12363](https://github.com/civicrm/civicrm-core/pull/12363))**

- **Make all form tasks inherit from `CRM_Core_Form_Task`
  ([12318](https://github.com/civicrm/civicrm-core/pull/12318))**

  This addresses some export problems caused by tasks lacking certain properties
  because their classes did not extend `CRM_Core_Form_Task`.

- **[dev/core#178](https://lab.civicrm.org/dev/core/issues/178) Redis driver -
  Error messages are invisible
  ([12303](https://github.com/civicrm/civicrm-core/pull/12303))**

  The log now contains error messages passed from Redis.

- **[dev/core#180](https://lab.civicrm.org/dev/core/issues/180) Deleting custom
  values and custom_hook parameter `$entity_id` empty
  ([12309](https://github.com/civicrm/civicrm-core/pull/12309))**

  The ID of the affected entity is now passed to `hook_civicrm_custom` when a
  value is deleted from a custom field.

- **Fix access to scheduled reminders for admins without event access
  ([11733](https://github.com/civicrm/civicrm-core/pull/11733))**

  Users with Administer CiviCRM permission but lacking Manage Events permission
  would get an error when trying to create a non-event scheduled reminder.

- **Only treat a request as a get request (and hence use GET) if it starts with
  get ([12308](https://github.com/civicrm/civicrm-core/pull/12308))**

- **[dev/core#179](https://lab.civicrm.org/dev/core/issues/179) Redis driver -
  Allow anonymous connections
  ([12304](https://github.com/civicrm/civicrm-core/pull/12304))**

  Redis no longer attempts to authenticate when no password is set, such as on
  local development environments.

- **[dev/core#177](https://lab.civicrm.org/dev/core/issues/177) Redis driver -
  Reports incorrect value for cache-miss
  ([12302](https://github.com/civicrm/civicrm-core/pull/12302))**

  When a cache key is undefined, Redis now returns `NULL` rather than `FALSE`.

- **[dev/core#175](https://lab.civicrm.org/dev/core/issues/175) Smart group
  involving relationship type filter display incorrect results.
  ([12301](https://github.com/civicrm/civicrm-core/pull/12301))**

- **Make Send SMS permission independent of Edit Contact permission
  ([12067](https://github.com/civicrm/civicrm-core/pull/12067))**

  You no longer need the permission to edit a contact (in addition to the Send
  SMS permission) to send the contact a SMS message.

- **[dev/core#134](https://lab.civicrm.org/dev/core/issues/134) Search Builder
  broken filter for Source Contact ID
  ([12181](https://github.com/civicrm/civicrm-core/pull/12181))**

- **[dev/core#140](https://lab.civicrm.org/dev/core/issues/140) add missing
  pseudoconstant for `option_group_id` in CustomField.xml
  ([12195](https://github.com/civicrm/civicrm-core/pull/12195))**

  Extensions creating custom fields can now refer to option groups by name
  rather than ID.

- **[dev/accessiblity#3](https://lab.civicrm.org/dev/accessibility/issues/3) Add
  aria-label (and label?) to form elements missing them
  ([12209](https://github.com/civicrm/civicrm-core/pull/12209) and
  [213](https://github.com/civicrm/civicrm-packages/pull/213)) (partial work)**

  Besides adding `aria-label` attributes to sub-elements of the Quickform
  date field, event info pages no longer wrap basic information labels in
  `<label>` tags.

- **[CRM-20711](https://issues.civicrm.org/jira/browse/CRM-20711) Error - DB
  Constraint Violation - GroupContact, get API
  ([12408](https://github.com/civicrm/civicrm-core/pull/12408))**

  This adds the `location_id` field to the `civicrm_group_contact` table on
  older sites that lack it.

- **[dev/core#152](https://lab.civicrm.org/dev/core/issues/152) -
  AdvMulti-Select cleanup
  ([531](https://github.com/civicrm/civicrm-drupal/pull/531)) (follow-up work)**

  This removes a couple of references to the now-removed "Advanced Multi-select"
  custom field type

- **Upgrade Mime_mail to fix issues with PHP7.2
  ([205](https://github.com/civicrm/civicrm-packages/pull/205))**

- **Apply fixes to have DB package support PHP7.2
  ([207](https://github.com/civicrm/civicrm-packages/pull/207))**

- **[dev/core#117](https://lab.civicrm.org/dev/core/issues/117) Remove usage of
  `each()` This is deprecated in php7.2
  ([211](https://github.com/civicrm/civicrm-packages/pull/211)) (follow-up
  work)**

- **Declare Subparts as array in mimePart to support PHP7.2
  ([210](https://github.com/civicrm/civicrm-packages/pull/210))**

- **[CRM-19798](https://issues.civicrm.org/jira/browse/CRM-19798) Memory leak in
  API3 EntityTag get operations
  ([12276](https://github.com/civicrm/civicrm-core/pull/12276))**

### CiviCase

- **Fix regression on case export from recent export fix
  ([12588](https://github.com/civicrm/civicrm-core/pull/12588))**

  This resolves undefined property PHP notices when exporting cases.

- **[dev/core#24](https://lab.civicrm.org/dev/core/issues/24) Passing an array
  for contact_id/client_id to Case.Create API when updating an existing case
  causes case to be "reassigned"
  ([11830](https://github.com/civicrm/civicrm-core/pull/11830))**

- **[CRM-21815](https://issues.civicrm.org/jira/browse/CRM-21815) On re-opening
  a civicase - Case Coordinator (and other roles) are not reinstated
  ([11736](https://github.com/civicrm/civicrm-core/pull/11736))**

- **[dev/core#165](https://lab.civicrm.org/dev/core/issues/165) Bad link in
  civicrm/case/activity/view breadcrumb
  ([12279](https://github.com/civicrm/civicrm-core/pull/12279))**

### CiviContribute

- **[CRM-21637](https://issues.civicrm.org/jira/browse/CRM-21637) Search
  Criteria for Card Type ID and Card Number not respected in Batch
  ([11495](https://github.com/civicrm/civicrm-core/pull/11495))**

  The card type and card number filters for financial transactions in the
  accounting batch interface now work as expected.

- **[CRM-21854](https://issues.civicrm.org/jira/browse/CRM-21854) Contribution
  start date and end dates are not respected
  ([11881](https://github.com/civicrm/civicrm-core/pull/11881) and
  [12504](https://github.com/civicrm/civicrm-core/pull/12504))**

- **[dev/core#264](https://lab.civicrm.org/dev/core/issues/264) Fatal Error on
  editing Financial Transaction
  ([12502](https://github.com/civicrm/civicrm-core/pull/12502))**

- **[dev/core#220](https://lab.civicrm.org/dev/core/issues/220) State
  province/country doesn't show properly in the report
  ([12390](https://github.com/civicrm/civicrm-core/pull/12390))**

  This resolves a bug in the Contribution History by Relationship report where
  strange values would appear for the State/Province and Country fields.

- **[dev/core#202](https://lab.civicrm.org/dev/core/issues/202) Empty row under
  currency drop down
  ([12356](https://github.com/civicrm/civicrm-core/pull/12356))**

  A warning now appears when a site has a disabled currency that is set as
  default.

- **[dev/core#88](https://lab.civicrm.org/dev/core/issues/88) Make sure
  `financial_type_id` is set when a contribution is created
  ([11907](https://github.com/civicrm/civicrm-core/pull/11907))**

  This resolves a bug where the financial type would not be set on a one-time
  contribution made through a contribution page.

- **[dev/core#170](https://lab.civicrm.org/dev/core/issues/170) contribution
  detail report errors when soft credits column is exposed
  ([12281](https://github.com/civicrm/civicrm-core/pull/12281) and
  [12282](https://github.com/civicrm/civicrm-core/pull/12282))**

- **Fix e-notice, remove legacy code pattern
  ([12298](https://github.com/civicrm/civicrm-core/pull/12298))**

  This resolves a PHP notice when printing contribution receipts in bulk.

- **[dev/core#56](https://lab.civicrm.org/dev/core/issues/56) Cancel Recurring
  Contribution activity should have a source record id
  ([11964](https://github.com/civicrm/civicrm-core/pull/11964))**

  The activity created when cancelling a recurring contribution now has the
  recurring contribution ID as the `source_record_id`.

- **[dev/financial#14](https://lab.civicrm.org/dev/financial/issues/14) PayPal
  Express recurring payment causes warning messages
  ([12091](https://github.com/civicrm/civicrm-core/pull/12091))**

- **[CRM-20697](https://issues.civicrm.org/jira/browse/CRM-20697) Online pay now
  anomalies (contribution transfer to new contact)
  ([11578](https://github.com/civicrm/civicrm-core/pull/11578))**

  The Pay Now form now uses contact ID and checksum to validate the
  contribution's contact to avoid creating new contacts when an anonymous
  visitor fulfills a pending contribution.

### CiviEvent

- **[dev/core#272](https://lab.civicrm.org/dev/core/issues/272) Fatal Error
  (Regression) on PCP pages associated with Events
  ([12533](https://github.com/civicrm/civicrm-core/pull/12533))**

- **[dev/core#124](https://lab.civicrm.org/dev/core/issues/124) Registration
  approval issues ([12160](https://github.com/civicrm/civicrm-core/pull/12160)
  and [12417](https://github.com/civicrm/civicrm-core/pull/12417))**

  This resolves a PHP warning and some confusing aspects of handling event
  registration approvals.

### CiviGrant

- **[dev/core#187](https://lab.civicrm.org/dev/core/issues/187) Fix typo in
  `CRM_Grant_Form_Task` that prevents retrieving session key from URL
  ([12317](https://github.com/civicrm/civicrm-core/pull/12317))**

### CiviMail

- **[dev/core#133](https://lab.civicrm.org/dev/core/issues/133) Reply-to field
  with empty string get saved in DB as `NULL`
  ([12176](https://github.com/civicrm/civicrm-core/pull/12176))**

- **[CRM-20320](https://issues.civicrm.org/jira/browse/CRM-20320) Error in PEAR
  SMTP causes mailing job to fail when an error occurs during one connection
  ([11840](https://github.com/civicrm/civicrm-core/pull/11840))**

  CiviMail will now disconnect the SMTP connection when a connection error is
  detected and record the group of messages as not delivered.  This allows it to
  reconnect later and send the messages.

- **[CRM-17753](https://issues.civicrm.org/jira/browse/CRM-17753) Newsletter
  confirmation emails shouldn't use do-not-reply@yourdomain.org
  ([12270](https://github.com/civicrm/civicrm-core/pull/12270)) (preliminary
  work)**

- **[CRM-21779](https://issues.civicrm.org/jira/browse/CRM-21779) Civimail
  allows adding current draft mailing recipients to recipients field
  ([11724](https://github.com/civicrm/civicrm-core/pull/11724))**

### CiviMember

- **[dev/membership#4](https://lab.civicrm.org/dev/membership/issues/4) Admin
  Membership type is displayed on Public contribution page.
  ([12178](https://github.com/civicrm/civicrm-core/pull/12178))**

- **[dev/core#276](https://lab.civicrm.org/dev/core/issues/276) Undefined index:
  is_override on submit credit card membership
  ([12563](https://github.com/civicrm/civicrm-core/pull/12563))**

- **[dev/core#151](https://lab.civicrm.org/dev/core/issues/151) Action to Update
  Recurring Contributions From Membership View is Never Shown
  ([12228](https://github.com/civicrm/civicrm-core/pull/12228))**

  The table to view recurring contributions on a membership now displays the
  Edit action where appropriate.

- **[CRM-21682](https://issues.civicrm.org/jira/browse/CRM-21682) Automatic
  membership renewal fixes
  ([12313](https://github.com/civicrm/civicrm-core/pull/12313) and
  [12314](https://github.com/civicrm/civicrm-core/pull/12314)) (preliminary
  work)**

- **[CRM-21177](https://issues.civicrm.org/jira/browse/CRM-21177) Wrong interval
  of recurring payment for auto-renewing membership
  ([12289](https://github.com/civicrm/civicrm-core/pull/12289)) (preliminary
  work)**

### Joomla Integration

- **[dev/joomla#1](https://lab.civicrm.org/dev/joomla/issues/1) CiviEvent menu
  listing showing old events
  ([46](https://github.com/civicrm/civicrm-joomla/pull/46))**

### WordPress Integration

- **[dev/wordpress#1](https://lab.civicrm.org/dev/wordpress/issues/1)
  CiviCRM-WordPress - Gutenberg Compatibility: Do not parse shortcodes in REST
  context ([130](https://github.com/civicrm/civicrm-wordpress/pull/130))**

- **[CRM-21565](https://issues.civicrm.org/jira/browse/CRM-21565) Change mkdir
  to use correct and more secure mode numbers
  ([120](https://github.com/civicrm/civicrm-wordpress/pull/120))**

## <a name="misc"></a>Miscellany

- **(NFC) Convert files to use linux line endings not windows
  ([12531](https://github.com/civicrm/civicrm-core/pull/12531))**

- **Move DAO function to DAO class, call it from Merge class
  ([12340](https://github.com/civicrm/civicrm-core/pull/12340))**

- **NFC code cleanup for AuthNet, Paypal, PaypalPro IPNs
  ([12386](https://github.com/civicrm/civicrm-core/pull/12386))**

- **[dev/core#203](https://lab.civicrm.org/dev/core/issues/203) Cruft code in
  `CRM_Core_BAO_OptionGroup::add()`
  ([12357](https://github.com/civicrm/civicrm-core/pull/12357))**

- **Remove unused instances of usedTable
  ([12341](https://github.com/civicrm/civicrm-core/pull/12341) and
  [12349](https://github.com/civicrm/civicrm-core/pull/12349))**

- **(NFC) CiviUnitTestCase - Fix edge-case for mis-reported error
  ([12347](https://github.com/civicrm/civicrm-core/pull/12347))**

- **NFC Code cleanup to core task class
  ([12316](https://github.com/civicrm/civicrm-core/pull/12316))**

- **[NFC] Stop passing no-longer-part-of-signature variable
  ([12329](https://github.com/civicrm/civicrm-core/pull/12329))**

- **Fix typo in api explorer sample code
  ([12324](https://github.com/civicrm/civicrm-core/pull/12324))**

- **Remove unused code variable
  ([12299](https://github.com/civicrm/civicrm-core/pull/12299))**

- **Confirm & lock in group.get handling of is_active
  ([12295](https://github.com/civicrm/civicrm-core/pull/12295))**

- **Remove unused function getRecuringTransactionStatus from PayflowPro c…
  ([12294](https://github.com/civicrm/civicrm-core/pull/12294))**

- **Add upgrade function for message templates that does not involve copying the
  whole template ([12224](https://github.com/civicrm/civicrm-core/pull/12224))**

- **Function extraction BAO_Export class
  ([12288](https://github.com/civicrm/civicrm-core/pull/12288))**

- **Partial refactor of completeMembershipFromContribution
  ([12271](https://github.com/civicrm/civicrm-core/pull/12271))**

- **[NFC] Fix line endings (Jenkins where were you)
  ([12280](https://github.com/civicrm/civicrm-core/pull/12280))**

- **Towards fixing household merge export, extract function, add test, fix prev
  ([12272](https://github.com/civicrm/civicrm-core/pull/12272))**

- **Standardise line endings away from windows line endings to linux
  ([212](https://github.com/civicrm/civicrm-packages/pull/212))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel; Australian
Greens - Seamus Lee; Bastien Ho; Caltha - Tomasz Pietrzkowski; CiviCoop - Jaap
Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp -
Camilo Rodriguez, Michael Devery, René Olivo, Vinu Varshith Sekar; Electronic
Frontier Foundation - Mark Burdett; Fuzion - Jitendra Purohit; Ginkgo Street
Labs - Frank Gómez; JMA Consulting - Monish Deb; Johan Vervloet; John
Kingsnorth; Kanzu Code - Carl Andrew Lema; Left Join Labs - Sean Madsen; MJW
Consulting - Matthew Wire; Pradeep Nayak; Romain Thouvenin; Squiffle Consulting -
Aidan Saunders; Tadpole Collective - Kevin Cristiano; Third Sector Design -
Michael McAndrew; Tom Bloor; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; baernm; Blackfly Solutions - Alan Dixon; Bob
Silvern; Borislav Zlatanov; Caltha - Michal Mach; cartbar; Christian Wach;
Circle Interactive - Dave Jenkins; CiviCoop - Erik Hommel; Community Builders -
Andrew Perry; CompuCorp - Guanhuan Chen, Omar Abu Hussein; Coop SymbioTIC -
Mathieu Lutfy; Drupal Association - Lizz Trudeau; Evan Chute; Forest CRM
Consulting - Tamar Meir; Freeform Solutions - Herb van den Dool; Ginkgo Street
Labs - Dan O'Brien; Hugo do Carmo; JMA Consulting - Joe Murray; Lemniscus - Noah
Miller; Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone
Technology Consulting - Jon Goldberg; MJCO - Mikey O'Toole; Oxfam Germany -
Thomas Schüttler; Richard van Oosterhout; Robin Fenwick; Semper IT - Karin
Gerritsen; Stephen Palmstrom; Tech To The People - Xavier Dutoit; Timbsoft
Technologies - Tunbola Ogunwande

## <a name="feedback"></a>Feedback

These release notes are edited by Andrew Hunt.  If you'd like to provide
feedback on them, please log in to https://chat.civicrm.org/civicrm and contact
`@agh1`.
