/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_INPUT_H
#define ArmageTron_INPUT_H

#include "rSDL.h"
#include "tString.h"
#include "defs.h"
#include "tLinkedList.h"
#include <assert.h>

#define uMAX_PLAYERS 8

extern bool su_mouseGrab;

// ***************************
//      player controls
// ***************************

#define uMAX_ACTIONS 300

// the possible actions; player actions and global actions

class uAction:public tListItem<uAction>{
 protected:
  int localID;  // unique id on this host
  int globalID; // unique ID send from the server
public:
  typedef enum {uINPUT_DIGITAL,uINPUT_ANALOG} uInputType;

  uInputType type;
  tString    internalName;
  tString    description;
  tString    helpText;

  uAction(uAction *&anchor,const char *name,const char *desc,const char *help,
	 uInputType t=uINPUT_DIGITAL);

  virtual ~uAction();

  unsigned short ID() const{return globalID;}
};


// player actions (move,shoot) and global actions (stop game, pause..)

class uActionPlayer:public uAction{
public:
  uActionPlayer(const char *name,const char *desc,
		const char *help,uInputType t=uINPUT_DIGITAL);

  virtual ~uActionPlayer();
  
  bool operator==(const uActionPlayer &x);

  static uActionPlayer *Find(int globalID);
};

class uActionCamera:public uAction{
public:
  uActionCamera(const char *name,const char *desc,
		const char *help,uInputType t=uINPUT_DIGITAL);

  virtual ~uActionCamera();
  
  bool operator==(const uActionCamera &x);
};

// global actions 
class uActionGlobal:public uAction{
public:
  uActionGlobal(const char *name,const char *desc,
		const char *help,uInputType t=uINPUT_DIGITAL);

  virtual ~uActionGlobal();
  
  bool operator==(const uActionGlobal &x);

  // binding that should interrupt chat/console input
  static bool IsBreakingGlobalBind(int sym);
};




// *********************************************
// generic keypress/mouse movement binding class
// *********************************************

class uBind{
  friend class uMenuItemInput;
public:
  uAction *act;

  uBind(uAction *a):act(a){};
  uBind(istream &s);
  virtual ~uBind(){};

  virtual void Write(ostream &s);

  virtual bool CheckPlayer(int p)=0;

  virtual bool Activate(REAL x)=0;
};


// extra binds for mouse (and joystick, as soon as SDL supports it) movement:
#define SDLK_MOUSE_X_PLUS   (SDLK_LAST+1)
#define SDLK_MOUSE_X_MINUS  (SDLK_LAST+2)
#define SDLK_MOUSE_Y_PLUS   (SDLK_LAST+3)
#define SDLK_MOUSE_Y_MINUS  (SDLK_LAST+4)
#define SDLK_MOUSE_Z_PLUS   (SDLK_LAST+5)
#define SDLK_MOUSE_Z_MINUS  (SDLK_LAST+6)
#define SDLK_MOUSE_BUTTON_1 (SDLK_LAST+7)
#define SDLK_MOUSE_BUTTON_2 (SDLK_LAST+8)
#define SDLK_MOUSE_BUTTON_3 (SDLK_LAST+9)
#define SDLK_MOUSE_BUTTON_4 (SDLK_LAST+10)
#define SDLK_MOUSE_BUTTON_5 (SDLK_LAST+11)
#define SDLK_MOUSE_BUTTON_6 (SDLK_LAST+12)
#define SDLK_MOUSE_BUTTON_7 (SDLK_LAST+13)
#define SDLK_NEWLAST        (SDLK_LAST+14)
#define MOUSE_BUTTONS 7

// one key_action for every keysym
extern uBind *keymap[SDLK_NEWLAST];



// *****************
// Player binds
// *****************

class uBindPlayer:public uBind{
  int            ePlayer;
public:
  uBindPlayer(uAction *a,int p):uBind(a),ePlayer(p){};
  uBindPlayer(istream &s);
  virtual ~uBindPlayer(){};

  static bool IsKeyWord(const char *n);

  virtual bool CheckPlayer(int p);

  virtual void Write(ostream &s);

  virtual bool Activate(REAL x);
};


// *****************
// Global actions
// *****************

typedef bool ACTION_FUNC(REAL x);

class uActionGlobalFunc: public tListItem<uActionGlobalFunc>{
  ACTION_FUNC   *func;
  uActionGlobal *act;
  bool           rebindable;

 public:
  uActionGlobalFunc(uActionGlobal *a, ACTION_FUNC *f, bool rebind = true);
  static bool IsBreakingGlobalBind(uAction *act);
  static bool GlobalAct(uAction *act, REAL x);
};


// ***************************
//      player prototype
// ***************************

class uPlayerPrototype{
 protected:
  static uPlayerPrototype* playerConfig[uMAX_PLAYERS];
  int id;
 public:
  uPlayerPrototype();
  virtual ~uPlayerPrototype();

  virtual bool         Act(uAction *act, REAL x)=0;
  virtual const char * Name() const            =0;

  static uPlayerPrototype* PlayerConfig(int i);
  static int Num();
};



// the input configuration menu
void su_InputConfig(int player);
void su_InputConfigCamera(int player);
void su_InputConfigGlobal();
bool su_HandleEvent(SDL_Event &e);
void su_InputSync(); // tells the input system that a new frame has been drawn;
// autorepeat functions may be called.

#endif

