/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_GAME_H
#define ArmageTron_GAME_H

#include "nNetObject.h"

class eGrid;

typedef enum{gFREESTYLE,gDUEL,gHUMAN_VS_AI}
gGameType;

extern gGameType sg_gameType;


typedef enum{gFINISH_EXPRESS,gFINISH_IMMEDIATELY,gFINISH_SPEEDUP,gFINISH_NORMAL}
gFinishType;

extern gFinishType sg_finishType;

class gGame:public nNetObject{
  unsigned short state;      // the gamestate we are currently in 
  unsigned short stateNext; // if a state change has been requested 

  bool goon;

  int rounds; // the number of rounds played

  double startTime; // time of the match start

  int warning; // timeout warnings

  tCONTROLLED_PTR(eGrid) grid;  // the grid the game takes place 

  void Init();
public:
  gGame();
  gGame(nMessage &m);
  virtual ~gGame();
  virtual void WriteSync(nMessage &m);
  virtual void ReadSync(nMessage &m);
  virtual nDescriptor &CreatorDescriptor() const;

  static void NetSync(); // do all the network syncronisation.
  static void NetSyncIdle(); // do all the network syncronisation and wait a bit.

  virtual void StateUpdate(); // switch to new gamestate (does all
  // the real work around here).
  virtual void  SetState(unsigned short act,unsigned short next);
  virtual short GetState(){return state;}

  // make sure the clients are catching up
  void SyncState(unsigned short state);

  virtual void Timestep(REAL time,bool cam=false); // do all the world simulation
  virtual void Analysis(REAL time); // do we have a winner?

  virtual bool GameLoop(bool input=true); // return values: exit the game loop?

  bool GridIsReady(int c); // can we transfer gameObjects that
  // need the grid to exist?

  void NoLongerGoOn();

  void StartNewMatch();

  void StartNewMatchNow();
};

void EnterGame();

void MainMenu(bool ingame=false);

bool GridIsReady(int c);

void Activate(bool act);

#endif

