#!/bin/sh
# AQEMU 0.7.3 Configure Script
# Lisence: GPL v2
# Author: Andrey Rijov (aka RDron)
# Author: Michael Brandstetter

# Print Help
if [ "$1" = "--help" ]; then
	echo "Available one option: \"--disable-embedded-display\" - This disable embedded VNC display in AQEMU"
	exit 0
fi

# Find qmake
echo "Find Qt on this system..."

QMAKE_PATH=""

if which qmake-qt4 > /dev/null 2>&1; then
	QMAKE_PATH="$(which qmake-qt4)"
	echo -e "OK. Qt installed.\n"
else
	if which qmake > /dev/null 2>&1; then
		QMAKE_PATH="$(which qmake)"
		echo -e "OK. Qt installed.\n"
	else
		echo "Error! Qt not installed on this system!"
		exit 1
	fi
fi

# Check qmake version
echo "Check Qt version..."
QMAKE_VERSION="$($QMAKE_PATH -query QT_VERSION | awk -F "." '{print$1"."$2}')"

if [[ $QMAKE_VERSION = "4.4" || $QMAKE_VERSION = "4.5" || $QMAKE_VERSION = "4.6" ]]; then
	echo -e "OK. Qt Version is $QMAKE_VERSION.\n"
else
	echo "Error! Your qt version $QMAKE_VERSION is too low install a newer one."
	exit 2
fi

# Use Embedded VNC Display?
AQEMU_PROJECT_FILE="AQEMU.pro"

if [ "$1" = "--disable-embedded-display" ]; then
	echo -e "Embedded VNC display disabled\n"
	AQEMU_PROJECT_FILE="AQEMU_Without_VNC.pro"
else
	echo "Find headers for compilation of embedded VNC display..."
	
	if whereis rfb > /dev/null 2>&1;
	then
		VNC_HEADERS_PATH="$(whereis rfb|awk '{print$2}')"
		
		if [ -e $VNC_HEADERS_PATH/rfbclient.h ]; then
			echo -e "OK. Headers found.\n"
		else
			echo "Error! Cannot find VNC headers!"
			echo "To continue compilation install libvncserver"
			echo "http://libvncserver.sourceforge.net/"
			echo ""
			echo "Or you can disable this option by running: ./configure --disable-embedded-display"
			exit 3
		fi
	else
		echo "Error! Cannot find VNC headers!"
		echo "To continue compilation install libvncserver"
		echo "http://libvncserver.sourceforge.net/"
		echo ""
		echo "Or you can disable this option by running: ./configure --disable-embedded-display"
		exit 4
	fi
fi

# Final Stage
echo -e "Configuring..."
	
if $QMAKE_PATH $AQEMU_PROJECT_FILE
then
	echo -e "OK. Configuring complete, make files created.\n"
	echo "Type make to build AQEMU."
	exit 0
else
	echo "\nError! qmake returns non 0 value!"
	exit 5
fi
