/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20200330

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#if !defined(MACOS_COMPILE) && !(defined(__OS2__) && defined(IDE_COMPILE))
#ifdef __GNUC__
#undef alloca
#ifndef ANDROID_COMPILE
#define        alloca(n)       __builtin_alloca (n)
#endif
#else
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H.  */
#if !defined(_AIX) && !defined(WINCE)
#ifndef _MSC_VER
extern char *alloca();
#else
#define alloca(n)   _alloca(n)
#endif  /* MSVC */
#endif /* Not AIX and not WINCE.  */
#endif /* HAVE_ALLOCA_H.  */
#endif /* GCC.  */
#endif /* MACOS OS2 */

/* SunOS 4.x specific stuff */
#if defined(sun) || defined(__sun)
#  if !defined(__SVR4) && !defined(__svr4__)
#    ifdef __sparc__
#      define YYFREE
#    endif
#  endif
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"

#ifdef AMIGA_MORPHOS
#undef REG_PC
#endif

#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

#ifdef __IBMC__
static void __yy_memcpy (char *to, char *from, int count);
#endif

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern void free_buffer(void);
extern void make_buffer(char *str);
extern int yylex(void);
extern int cur_len, last_len;

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COND_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

#define YYDEBUG 1

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 135 "mon_parse.y"
typedef union {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 173 "mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_LOG 279
#define CMD_LOGNAME 280
#define CMD_SIDEFX 281
#define CMD_DUMMY 282
#define CMD_RETURN 283
#define CMD_BLOCK_READ 284
#define CMD_BLOCK_WRITE 285
#define CMD_UP 286
#define CMD_DOWN 287
#define CMD_LOAD 288
#define CMD_SAVE 289
#define CMD_VERIFY 290
#define CMD_BVERIFY 291
#define CMD_IGNORE 292
#define CMD_HUNT 293
#define CMD_FILL 294
#define CMD_MOVE 295
#define CMD_GOTO 296
#define CMD_REGISTERS 297
#define CMD_READSPACE 298
#define CMD_WRITESPACE 299
#define CMD_RADIX 300
#define CMD_MEM_DISPLAY 301
#define CMD_BREAK 302
#define CMD_TRACE 303
#define CMD_IO 304
#define CMD_BRMON 305
#define CMD_COMPARE 306
#define CMD_DUMP 307
#define CMD_UNDUMP 308
#define CMD_EXIT 309
#define CMD_DELETE 310
#define CMD_CONDITION 311
#define CMD_COMMAND 312
#define CMD_ASSEMBLE 313
#define CMD_DISASSEMBLE 314
#define CMD_NEXT 315
#define CMD_STEP 316
#define CMD_PRINT 317
#define CMD_DEVICE 318
#define CMD_HELP 319
#define CMD_WATCH 320
#define CMD_DISK 321
#define CMD_QUIT 322
#define CMD_CHDIR 323
#define CMD_BANK 324
#define CMD_LOAD_LABELS 325
#define CMD_SAVE_LABELS 326
#define CMD_ADD_LABEL 327
#define CMD_DEL_LABEL 328
#define CMD_SHOW_LABELS 329
#define CMD_CLEAR_LABELS 330
#define CMD_RECORD 331
#define CMD_MON_STOP 332
#define CMD_PLAYBACK 333
#define CMD_CHAR_DISPLAY 334
#define CMD_SPRITE_DISPLAY 335
#define CMD_TEXT_DISPLAY 336
#define CMD_SCREENCODE_DISPLAY 337
#define CMD_ENTER_DATA 338
#define CMD_ENTER_BIN_DATA 339
#define CMD_KEYBUF 340
#define CMD_BLOAD 341
#define CMD_BSAVE 342
#define CMD_SCREEN 343
#define CMD_UNTIL 344
#define CMD_CPU 345
#define CMD_YYDEBUG 346
#define CMD_BACKTRACE 347
#define CMD_SCREENSHOT 348
#define CMD_PWD 349
#define CMD_DIR 350
#define CMD_MKDIR 351
#define CMD_RMDIR 352
#define CMD_RESOURCE_GET 353
#define CMD_RESOURCE_SET 354
#define CMD_LOAD_RESOURCES 355
#define CMD_SAVE_RESOURCES 356
#define CMD_ATTACH 357
#define CMD_DETACH 358
#define CMD_MON_RESET 359
#define CMD_TAPECTRL 360
#define CMD_CARTFREEZE 361
#define CMD_CPUHISTORY 362
#define CMD_MEMMAPZAP 363
#define CMD_MEMMAPSHOW 364
#define CMD_MEMMAPSAVE 365
#define CMD_COMMENT 366
#define CMD_LIST 367
#define CMD_STOPWATCH 368
#define RESET 369
#define CMD_EXPORT 370
#define CMD_AUTOSTART 371
#define CMD_AUTOLOAD 372
#define CMD_MAINCPU_TRACE 373
#define CMD_LABEL_ASGN 374
#define L_PAREN 375
#define R_PAREN 376
#define ARG_IMMEDIATE 377
#define REG_A 378
#define REG_X 379
#define REG_Y 380
#define COMMA 381
#define INST_SEP 382
#define L_BRACKET 383
#define R_BRACKET 384
#define LESS_THAN 385
#define REG_U 386
#define REG_S 387
#define REG_PC 388
#define REG_PCR 389
#define REG_B 390
#define REG_C 391
#define REG_D 392
#define REG_E 393
#define REG_H 394
#define REG_L 395
#define REG_AF 396
#define REG_BC 397
#define REG_DE 398
#define REG_HL 399
#define REG_IX 400
#define REG_IY 401
#define REG_SP 402
#define REG_IXH 403
#define REG_IXL 404
#define REG_IYH 405
#define REG_IYL 406
#define PLUS 407
#define MINUS 408
#define STRING 409
#define FILENAME 410
#define R_O_L 411
#define R_O_L_Q 412
#define OPCODE 413
#define LABEL 414
#define BANKNAME 415
#define CPUTYPE 416
#define MON_REGISTER 417
#define COND_OP 418
#define RADIX_TYPE 419
#define INPUT_SPEC 420
#define CMD_CHECKPT_ON 421
#define CMD_CHECKPT_OFF 422
#define TOGGLE 423
#define MASK 424
#define YYERRCODE 256
typedef short YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   33,   33,   35,   35,   35,   34,   34,
   34,   34,   34,   34,   34,   34,   34,   34,   34,   34,
   34,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   49,   49,   49,
   37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   52,   39,   39,   39,   39,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   40,   40,
   40,   40,   40,   40,   40,   40,   41,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   42,   42,   42,
   42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
   42,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   45,   45,   45,
   46,   46,   47,   22,   23,   23,   24,   27,   27,   12,
   12,   17,   17,   18,   18,   21,   21,   50,   50,   53,
   16,   16,    2,    2,    1,    1,    1,    4,    4,    3,
    3,    3,   48,   48,   13,   13,   13,   13,   13,   14,
   15,    9,    9,    9,    9,    9,    9,    9,    5,    5,
    6,    6,    6,    6,    6,    7,    7,    7,   25,   25,
   26,   26,   28,   28,   29,   29,   29,   19,   19,   10,
   10,   10,   10,   11,   11,   11,    8,    8,    8,    8,
    8,   54,   54,   54,   20,   51,   51,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   31,
   31,   31,   31,   32,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    3,    1,    2,    3,    3,
    5,    3,    5,    3,    5,    3,    5,    3,    2,    3,
    2,    4,    5,    0,    5,    3,    3,    2,    5,    5,
    5,    5,    5,    3,    2,    3,    2,    3,    2,    3,
    2,    3,    2,    2,    2,    4,    5,    5,    5,    2,
    3,    2,    5,    2,    5,    2,    3,    2,    3,    2,
    3,    5,    3,    2,    5,    5,    4,    3,    2,    3,
    2,    3,    2,    3,    3,    2,    3,    2,    2,    2,
    3,    3,    3,    2,    3,    3,    3,    3,    2,    3,
    2,    3,    3,    3,    5,    3,    4,    3,    3,    2,
    4,    4,    2,    3,    3,    2,    5,    5,    4,    5,
    3,    4,    5,    4,    5,    5,    4,    5,    5,    2,
    3,    4,    3,    3,    5,    3,    5,    3,    2,    3,
    4,    2,    2,    1,    1,    0,    1,    1,    1,    1,
    1,    2,    1,    1,    0,    1,    2,    3,    1,    3,
    1,    1,    1,    1,    3,    1,    3,    2,    0,    1,
    3,    1,    1,    0,    1,    1,    1,    1,    1,    1,
    1,    3,    3,    3,    3,    3,    3,    1,    2,    0,
    3,    3,    3,    3,    1,    1,    1,    4,    3,    1,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    3,    3,    2,    2,    1,    1,    2,    1,    3,
    3,    3,    3,    3,    5,    7,    5,    3,    3,    3,
    3,    3,    3,    5,    5,    5,    5,    0,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    3,    3,    4,
    3,    4,    2,    3,    3,    3,    3,    5,    5,    6,
    5,    6,    4,    5,    5,    5,    5,    3,    5,    1,
    1,    1,    1,    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    4,    9,   10,   11,   12,   13,   14,   15,   16,
   17,   18,   19,   20,   47,  247,  248,  249,  250,  246,
  245,  244,  205,  206,  207,  208,  209,  186,    0,  238,
    0,  251,    0,  218,  239,    8,    7,    6,    0,  113,
  179,  178,    0,    0,  109,    0,  111,   34,    0,    0,
  203,   41,    0,   43,    0,    0,    0,    0,    0,  192,
  240,  243,  242,  241,  191,    0,  196,  202,    0,    0,
  211,    0,  200,  210,    0,    0,    0,    0,   27,    0,
    0,   48,    0,  189,    0,  116,    0,  193,    0,    0,
   75,  183,    0,    0,   90,    0,   96,    0,   28,    0,
    0,    0,  120,    0,    0,  104,    0,    0,    0,    0,
   68,   39,    0,   37,    0,    0,    0,  174,    0,  124,
    0,   94,    0,  119,  177,    0,    0,    0,   22,    0,
    0,    0,    0,    0,    0,    0,    0,   59,    0,   61,
    0,  169,    0,    0,   77,    0,   79,    0,   81,    0,
   83,    0,  172,    0,    0,    0,    0,   45,    0,   92,
    0,   30,  173,  129,    0,  131,  175,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  140,    0,    0,  143,
   32,    0,   84,   85,    0,    0,    0,    0,  180,    0,
  160,    0,  146,  118,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  281,    0,  283,  284,  287,
  290,  291,  292,  293,  294,  295,  296,  285,  288,  286,
  289,    0,  255,    0,   98,    0,  100,    2,    5,    0,
    0,    0,    0,    0,  126,  187,  112,  114,  108,  110,
    0,    0,    0,    0,  181,    0,    0,    0,    0,    0,
  101,    0,    0,    0,    0,    0,    0,   26,    0,   49,
    0,    0,   50,  115,    0,   74,  182,    0,    0,   29,
    0,   35,   36,  103,    0,    0,    0,   66,    0,   67,
    0,    0,  123,  117,  125,    0,  122,  127,   24,   23,
    0,    0,   52,    0,   54,    0,   56,    0,   58,   60,
  168,  170,   76,   78,   80,   82,  232,  231,    0,  230,
  128,    0,    0,   46,   91,   31,  134,    0,  130,  132,
  133,  136,    0,  138,  139,    0,  163,    0,    0,    0,
    0,    0,  144,  161,  145,  164,    0,  166,    0,  121,
    0,    0,    0,    0,    0,    0,    0,    0,  258,    0,
  320,  321,  324,  323,    0,    0,  322,    0,    0,    0,
    0,    0,  297,    0,    0,    0,   97,   99,  217,  216,
    0,    0,  214,  215,    0,    0,    0,   42,   44,    0,
  152,    0,    0,  157,    0,    0,  237,  236,  235,    0,
  234,  195,  197,  201,    0,    0,  190,  188,    0,    0,
    0,    0,    0,    0,    0,    0,  225,  227,  226,  107,
    0,    0,    0,    0,   40,   38,    0,    0,    0,    0,
    0,    0,  171,    0,  149,    0,  154,    0,    0,  137,
  162,  141,  142,   33,    0,   86,    0,    0,    0,    0,
   62,  268,  269,  270,  271,  272,  273,    0,    0,  305,
    0,  301,    0,    0,    0,    0,    0,    0,    0,    0,
  304,  306,  260,  261,  262,  307,  263,  298,  158,  198,
  159,  147,  150,  155,  156,  102,  233,   72,   71,   69,
   73,    0,   89,   95,   70,    0,    0,    0,  105,  106,
    0,   65,    0,   93,   25,   51,   53,   55,   57,  229,
  148,  153,  135,   87,   88,  165,  167,   63,    0,    0,
    0,  302,  300,    0,    0,    0,  313,    0,    0,    0,
    0,    0,    0,  224,  223,    0,  222,  221,  253,  252,
  274,  267,  275,  276,  277,  265,    0,  315,    0,  311,
  309,    0,  314,  316,  317,  308,  319,  228,    0,  312,
  310,  266,
};
static const YYINT yydgoto[] = {                         99,
  188,  189,  190,  475,  501,  506,  507,  171,  131,  289,
  132,  290,  133,  173,  174,  166,  193,  194,  134,  100,
  135,  219,  268,  226,  409,  410,  143,  490,  491,  323,
  456,  457,  101,  102,  140,  103,  104,  105,  106,  107,
  108,  109,  110,  111,  112,  113,  114,  476,  115,  183,
  513,  379,  184,  514,
};
static const YYINT yysindex[] = {                      1450,
  182,    0,    0, -241, -206, -207, -195,  277,  182,  182,
  -13,  -13, -206, -206, -206, -206,  473, 1779, 1779, 1779,
 1405, -123, -138, 1153,  109,  109, 1405, 1779, -206, -206,
  277,  782,  473,  473, 1851,  687,  -13,  -13,  182,  622,
 -188,  109, -398,  277, -361,  148,  207,  207, 1851,  -34,
  710,  710, -206,  277, -206,  687,  687,  687,  687, 1851,
  277, -398, -206, -206, 1405,  687,  -88,  277,  277, -206,
  277, -306, -361, -361, -298, -292, -206, -206, -206,  182,
  -13, -247,  277,  -13,  277,  -13, -206, -306, 1003,  260,
  277, -206, -206, -278, -106, 1894,  782,  782,    0, -105,
 1594,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  182,    0,
  -22,    0, -242,    0,    0,    0,    0,    0,  277,    0,
    0,    0,  277,  277,    0,  277,    0,    0,  425,  425,
    0,    0,  182,    0,  182,  856, 1026,  856,  856,    0,
    0,    0,    0,    0,    0,  -13,    0,    0, -247, -247,
    0, -247,    0,    0, -247, -247,  277, -247,    0,  -96,
  -98,    0,  174,    0,  277,    0, -247,    0,  277, -247,
    0,    0,  -89, 1779,    0, 1779,    0,  277,    0, -247,
  277,  277,    0,    0,  277,    0,  -86, -244,  277,  277,
    0,    0,  182,    0,  182,  -22,  277,    0,  277,    0,
 1779,    0,  277,    0,    0,  277,  277,  -13,    0, -247,
  277, -247,  277, -247,  277, -247,  277,    0,  277,    0,
  277,    0,  277,  277,    0,  277,    0,  277,    0,  277,
    0,  255,    0,  277,  856,  856,  277,    0,  277,    0,
  277,    0,    0,    0,  -13,    0,    0,  277,  277,  277,
  277, -225,  277,  277,  182,  -22,    0,  182,  182,    0,
    0,  182,    0,    0,  182, -247,  277,    0,    0,  277,
    0,  277,    0,    0,  -13,  -13,  277, 1851,  652,  839,
 -194,  332, 1324,  839, -185,    0, -181,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -180,    0,  277,    0,  277,    0,    0,    0,   57,
  182,  182,  182,  182,    0,    0,    0,    0,    0,    0,
   33,  992,  -22,  -22,    0, -247,    0, 1572, -247, 1736,
    0,  182, -136, 1851, 1356,  255, 1851,    0,  839,    0,
  839,   45,    0,    0, 1779,    0,    0,  -83,  -83,    0,
 1851,    0,    0,    0, 1338,  277, -197,    0, -211,    0,
  -22,  -22,    0,    0,    0,  -83,    0,    0,    0,    0,
 -208, -206,    0, -206,    0, -201,    0, -200,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  -13,    0,
    0, 1761, 1717,    0,    0,    0,    0,  182,    0,    0,
    0,    0,  277,    0,    0,  -22,    0,  -22,  -22,  -22,
  737,  182,    0,    0,    0,    0,  839,    0,  839,    0,
  291, -161, -159, -158, -156, -152, -143, -357,    0,  165,
    0,    0,    0,    0,  406, -172,    0, -139,  417, -133,
 -132, -249,    0,  165,  165, 1922,    0,    0,    0,    0,
   78,   78,    0,    0,  277, 1851,  277,    0,    0,  277,
    0,  277,  277,    0,  277,  -22,    0,    0,    0, -150,
    0,    0,    0,    0,  -13,  277,    0,    0,  277, 1338,
  277,  277,  277, 1338, -163, -114,    0,    0,    0,    0,
  277, -125,  277, -122,    0,    0,  277,  277,  277,  277,
  277,  277,    0,  255,    0,  277,    0,  277,  -22,    0,
    0,    0,    0,    0,  277,    0,  -22,  277,  277,  277,
    0,    0,    0,    0,    0,    0,    0, -120, -371,    0,
  165,    0, -131,  165,  511, -370,  165,  165,  465, -113,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -134,    0,    0,    0, -245,  224,  319,    0,    0,
 -211,    0, -211,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   -2,  -91,
  -90,    0,    0,  -97,  165,  -95,    0, -311,  -74,  -72,
  -70,  -64,  -87,    0,    0, 1851,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -80,    0,  -62,    0,
    0,  -59,    0,    0,    0,    0,    0,    0,  -51,    0,
    0,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  232,  232,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1797, 1797,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  232,  232,    0,    0,
    0, 1797,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  330,    0,    0,    0,    0,    0,    0,    0,    0,
  232,  232,    0,  232,    0,  232,    0,  330,    0,    0,
    0,    0,    0,    0,    0, -112,    0,    0,    0,    0,
  333,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  232,    0,    0,  -67, 1869,
    0, 1366,    0,    0,  457, 1869,    0, 1376,    0,    0,
    0,    0,    0,    0,    0,    0, 1815,    0,    0, 1292,
    0,    0, 1833,    0,    0,    0,    0,    0,    0, 1869,
    0,    0,    0, 1022,    0,    0,    0,  -65,  -76,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -69,    0, -202,
    0, -202,    0,  -60,    0,  -60,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  232,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  232,    0, 1172,    0,    0,
    0,    0,    0,    0, 1376, 1376,    0,    0,    0,    0,
  -82,    0,    0,    0,  -10,    0,    2,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   21,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1427,    0,    0,    0,    0, 1427,  874,    0, 1427,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  342,  342,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  342,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  457,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   50,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  486,  664,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  457,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  376,    0,  386,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   87,    0,    0,
    0,    0,  125,    0,    0,    0,    0,    0,    0,  150,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  450,    0,    0,    0,    0,    0,    0,    0,    0,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
static const YYINT yygindex[] = {                         0,
   44,   35,   25, -191, -302, -445,    0,   56,   17,  193,
    0,  382,  -18, -276,    0,  570,    0,   77,    0, -372,
  -17,   15,  264,   67,    6, -119,  495,    0, -124,    0,
  418,  -92,    0,  290,  589,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   75,    0,    0,
    0,    0,   31,    0,
};
#define YYTABLESIZE 2310
static const YYINT yytable[] = {                        172,
  172,  172,  178,  180,  181,  172,  512,  610,  178,  172,
  624,  376,  218,  617,  136,  611,  178,  172,  548,  333,
  331,  217,  332,  549,  334,  149,  150,  228,  230,  232,
  178,  236,  237,  239,  137,  138,  618,  172,  172,  172,
  172,  178,  170,  170,  170,  177,  178,  172,  136,  141,
  225,  198,  170,  204,  582,  216,  130,  223,  586,  209,
  136,  169,  175,  176,  130,  130,  502,  136,  137,  138,
  210,  200,  641,  234,  333,  331,  254,  332,  494,  334,
  137,  138,  494,  517,  252,  153,  155,  137,  138,  257,
  244,  246,  248,  250,  130,  642,  276,  470,  333,  331,
  259,  332,  196,  334,  267,  136,  116,  117,  118,  119,
  271,  213,  215,  120,  121,  122,  272,  136,  221,  333,
  116,  117,  118,  119,  334,  137,  138,  120,  121,  122,
  625,  559,  136,  151,  560,  130,  151,  137,  138,  269,
  270,  136,  628,  278,  297,  330,  123,  124,  125,  126,
  127,  322,  137,  138,  480,  278,  279,  483,  282,  136,
  285,  137,  138,  278,  278,  341,  342,  136,  298,  343,
  328,  344,  588,  279,  336,  172,  361,  172,  367,  137,
  138,  139,  375,  423,  130,  500,  450,  137,  138,  204,
  204,  204,  204,  279,  279,  464,  204,  204,  204,  465,
  466,   96,  172,  142,  130,  130,  518,  204,  130,  165,
  130,  511,  521,  522,  542,  144,  543,  544,  629,  545,
  630,  129,  218,  546,  165,  165,  165,  146,  368,  381,
  369,  382,  547,  136,  553,  123,  124,  125,  126,  127,
  352,  554,  136,  353,  354,  280,  355,  557,  558,  356,
  357,  587,  359,  137,  138,  386,  591,  282,  487,  593,
  609,  365,  137,  138,  354,  280,  280,  623,  130,  278,
  130,  204,  487,  488,  371,  613,  259,  282,  282,  178,
  185,  626,  377,  588,  636,  637,  638,  488,  640,  165,
  165,  426,  647,  128,  428,  429,  259,  259,  430,  279,
  649,  431,  391,  588,  392,  303,  394,  408,  396,  643,
  398,  644,  469,  645,  123,  124,  125,  126,  127,  646,
  336,  650,  441,  178,  651,  303,  303,  261,  652,  172,
  130,  178,    1,  130,  130,  178,   64,  130,  178,  418,
  130,  204,  264,  204,  181,  204,  172,  471,  472,  473,
  474,  287,  178,  204,  448,  449,  204,  509,  462,  463,
  432,  495,  264,  264,  136,  577,  477,  151,  486,  437,
  439,  280,  170,  568,  485,  631,  192,  632,  492,  235,
  299,  496,  505,  282,  137,  138,  130,  130,  130,  130,
  329,  482,  498,  178,  172,  503,  633,  634,  635,  499,
  299,  299,  259,  136,  600,  318,    0,  130,  489,    0,
    0,  408,  172,  151,    0,    0,  497,  123,  124,  125,
  126,  127,  254,  137,  138,  318,  318,    0,    0,  136,
  508,  303,    0,    0,  529,    0,  526,  170,  116,  117,
  118,  119,  254,  254,    0,  120,  121,  122,  537,  137,
  138,  123,  124,  125,  126,  127,  528,  178,    0,    0,
    0,  128,  141,    0,  129,  535,  333,  331,  264,  332,
    0,  334,    0,  130,    0,    0,  123,  124,  125,  126,
  127,    0,  509,  524,    0,    0,  509,  130,  204,  204,
  204,  204,  538,    0,  539,  204,  204,  204,    0,    0,
  570,  204,  204,  204,  204,  204,  299,  156,  157,  158,
  159,  116,  117,  118,  119,  136,    0,    0,  120,  121,
  122,  567,    0,  201,  202,  212,  212,    0,  212,    0,
  212,  318,  136,    0,    0,  137,  138,  346,  348,  349,
  350,  231,  233,  451,  452,  489,  136,  241,  254,  243,
  453,  454,  137,  138,  362,  508,    0,  255,  256,  508,
    0,    0,  227,    0,  265,    0,  137,  138,  540,  524,
  509,  273,  274,  275,  627,  116,  117,  118,  119,  408,
    0,  286,  120,  121,  122,  176,  295,  296,  123,  124,
  125,  126,  127,    0,  145,  147,  148,  220,  128,  152,
  154,  205,  207,  208,    0,  176,  176,  178,    0,  179,
  182,  186,  191,  195,  197,  199,  142,  220,  220,  203,
  206,    0,    0,    0,  211,  212,  214,    0,  292,  220,
  222,  256,  224,    0,  229,    0,  412,  413,    0,  238,
  240,  257,  242,  508,  245,  247,  249,  251,  204,  253,
  648,  256,  256,  258,  260,  262,  263,  264,    0,  266,
    0,  257,  257,  407,    0,    0,  324,  326,    0,  277,
    0,  280,  281,  283,  284,    0,    0,  291,  293,  294,
    0,  116,  117,  118,  119,  325,  327,    0,  120,  121,
  122,    0,    0,  504,  123,  124,  125,  126,  127,    0,
    0,    0,    0,  213,  213,  219,  213,    0,  213,    0,
  451,  452,    0,  204,  204,  204,  204,  453,  454,  335,
  204,  204,  204,    0,    0,  219,  219,  337,  160,    0,
  161,  338,  339,    0,  340,  128,  162,  163,  164,  455,
    0,  212,  212,  212,  212,  212,    0,    0,  212,  212,
  212,  212,    0,    0,  351,  212,  212,  212,  212,  212,
    0,  212,  212,    0,    0,  358,    0,    0,  360,    0,
    0,  363,    0,  364,    0,    0,    0,  366,  333,  331,
    0,  332,    0,  334,  451,  452,  370,    0,    0,  372,
  373,  453,  454,  374,    0,  451,  452,  378,  380,    0,
    0,    0,  453,  454,  383,  384,    0,  385,    0,    0,
    0,  387,    0,  551,  388,  389,  390,    0,    0,  393,
    0,  395,    0,  397,  555,  399,    0,  400,    0,  401,
    0,  402,  403,    0,  404,    0,  405,    0,  406,    0,
    0,  128,  411,  451,  452,  414,    0,  415,    0,  416,
  453,  454,  621,  417,    0,    0,  419,  420,  421,  422,
    0,  424,  425,    0,  427,  204,  212,  550,    0,    0,
    0,    0,  552,  151,    0,  433,  556,    0,  434,    0,
  435,  561,  562,  436,  438,  440,  519,    0,  520,  451,
  452,  123,  124,  125,  126,  127,  453,  454,    0,  212,
    0,    0,  212,    0,    0,    0,    0,    0,  116,  117,
  118,  119,  467,    0,  468,  120,  121,  122,  615,  213,
  213,  213,  213,  213,    0,    0,  213,  213,  213,  213,
    0,  478,  479,  213,  213,  213,  213,  213,    0,  213,
  213,    0,  136,  116,  117,  118,  119,    0,    0,  167,
  120,  121,  122,    0,    0,    0,  123,  124,  125,  126,
  127,    0,  137,  138,  510,  136,    0,    0,  612,  515,
  516,  614,  616,    0,  619,  620,  622,    0,    0,  123,
  124,  125,  126,  127,    0,  137,  138,    0,    0,    0,
    0,    0,  136,  116,  117,  118,  119,  523,    0,  167,
  120,  121,  122,    0,    0,    0,  123,  124,  125,  126,
  127,  530,  137,  138,  531,    0,  532,  533,  534,  536,
    0,    8,    0,    0,    0,    0,    0,    0,    0,  541,
    0,    0,  639,  333,  331,    0,  332,  204,  334,  161,
    0,    0,    0,    0,  213,  162,  163,  164,  442,  443,
  444,  445,  446,  447,    0,    0,    0,  137,  138,    0,
    0,    0,    0,  569,    0,  571,    0,    0,  572,    0,
  573,  574,    0,  575,  576,    0,    0,  213,  578,    0,
  213,    0,    0,  579,  580,    0,    0,  581,    0,  583,
  584,  585,    0,    0,  589,  116,  117,  118,  119,  590,
  168,  592,  120,  121,  122,  594,  595,  596,  597,  598,
  599,  345,    0,  161,  601,    0,  602,  603,    0,  162,
  163,  164,    0,  604,    0,  605,  606,  607,  608,  181,
  181,  181,  181,  181,  151,    0,  181,  181,  181,  181,
  151,    0,    0,  181,  181,  181,  181,  181,    0,    0,
  168,    0,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,    8,    0,  151,  151,  151,  151,  151,    0,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
  151,  151,    0,  151,  151,  151,  151,  151,  116,  117,
  118,  119,    0,    0,    0,  120,  121,  122,  288,    0,
  161,  123,  124,  125,  126,  127,  162,  163,  164,    0,
    0,    0,    0,    0,    0,    0,    0,  192,  137,  138,
    0,  347,    8,  161,    0,    0,    0,  181,    8,  162,
  163,  164,    0,    0,  151,  151,    0,  192,  192,    0,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    0,
    0,    8,    8,    8,    8,    8,    0,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    0,    8,    8,    8,    8,    8,    0,    0,    0,    0,
    0,  505,    0,    0,    0,  168,    0,    0,  136,  116,
  117,  118,  119,    0,    0,  167,  120,  121,  122,    0,
    0,    0,  123,  124,  125,  126,  127,  181,  137,  138,
    0,    0,    8,    0,    0,    0,    0,    0,    8,    0,
    0,    0,    8,    8,    0,    0,    0,  181,  181,    0,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    0,
    0,    8,    8,    8,    8,    8,    0,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    0,    8,    8,    8,    8,    8,    0,  194,  204,  204,
  204,  204,    0,    0,    0,  204,  204,  204,    0,    0,
  194,  204,  204,  204,  204,  204,  168,  194,  194,    0,
    0,  187,    0,    0,    0,    0,    0,    0,    0,    0,
  116,  117,  118,  119,    0,    0,    0,  120,  121,  122,
    0,    0,    8,    8,  116,  117,  118,  119,    0,    0,
    0,  120,  121,  122,    0,    0,    0,  123,  124,  125,
  126,  127,  116,  117,  118,  119,    0,    0,  493,  120,
  121,  122,  204,  204,  204,  204,    0,    0,  204,  204,
  204,  204,  204,  204,  204,  204,    0,    0,    0,  204,
  204,  204,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  136,  116,  117,  118,  119,    0,    0,    0,  120,  121,
  122,    0,    0,    0,  123,  124,  125,  126,  127,    0,
  137,  138,  199,  204,  204,  204,  204,    0,    0,    0,
  204,  204,  204,    0,    0,    0,  204,  204,  204,  204,
  204,  458,  199,  199,  459,  204,    0,    0,    0,    0,
    1,    0,  504,  460,    0,  461,    2,    0,    0,    0,
    0,    0,    0,    0,    0,    3,    0,    0,    4,    5,
    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,    0,    0,   23,
   24,   25,   26,   27,  128,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,
   63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,   88,   89,   90,  168,   91,
   92,   93,   94,   95,    0,    0,    0,  481,  116,  117,
  118,  119,    0,    0,  167,  120,  121,  122,    0,    0,
  204,  123,  124,  125,  126,  127,    0,    0,    0,    0,
    0,    0,    0,    0,    1,    0,    0,    0,    0,    0,
    2,    0,   96,    0,    0,    0,    0,    0,    0,    0,
   97,   98,    4,    5,    6,    7,    8,    9,   10,   11,
   12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
   22,    0,    0,   23,   24,   25,   26,   27,    0,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
   59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
   89,   90,    0,   91,   92,   93,   94,   95,    0,    0,
    0,    0,  527,  116,  117,  118,  119,    0,    0,  167,
  120,  121,  122,    0,    0,  168,  123,  124,  125,  126,
  127,  484,  116,  117,  118,  119,    0,    0,    0,  120,
  121,  122,    0,    0,    0,  123,  124,  125,  126,  127,
    0,    0,    0,    0,   97,   98,  525,  116,  117,  118,
  119,    0,    0,    0,  120,  121,  122,    0,    0,    0,
  123,  124,  125,  126,  127,  116,  117,  118,  119,    0,
    0,  167,  120,  121,  122,    0,    0,    0,  123,  124,
  125,  126,  127,  185,  185,  185,  185,    0,    0,  185,
  185,  185,  185,    0,    0,    0,  185,  185,  185,  185,
  185,  204,  204,  204,  204,    0,    0,  204,  204,  204,
  204,    0,    0,    0,  204,  204,  204,  204,  204,  184,
  184,  184,  184,    0,    0,  184,  184,  184,  184,    0,
    0,    0,  184,  184,  184,  184,  184,  116,  117,  118,
  119,    0,    0,    0,  120,  121,  122,    0,    0,    0,
  123,  124,  125,  126,  127,  204,  204,  204,  204,    0,
  168,    0,  204,  204,  204,    0,    0,    0,  204,  204,
  204,  204,  204,    0,    0,    0,    0,    0,    0,  168,
  116,  117,  118,  119,    0,    0,    0,  120,  121,  122,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  116,  117,
  118,  119,    0,    0,    0,  120,  121,  122,    0,    0,
    0,    0,  168,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  185,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  204,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  184,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  299,    0,
  300,  301,    0,    0,  302,    0,  303,    0,  304,    0,
    0,    0,  204,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,
  563,  564,    0,    0,    0,    0,    0,  453,  565,  566,
};
static const YYINT yycheck[] = {                         18,
   19,   20,   21,   22,   22,   24,  379,  379,   27,   28,
  256,  256,  411,  384,  256,  387,   35,   36,  376,   42,
   43,   40,   45,  381,   47,    9,   10,   46,   47,   48,
   49,   50,   51,   52,  276,  277,  407,   56,   57,   58,
   59,   60,   18,   19,   20,   21,   65,   66,  256,  256,
  412,   27,   28,  256,  500,   39,    1,   43,  504,   35,
  256,   18,   19,   20,    9,   10,  369,  256,  276,  277,
   36,   28,  384,   49,   42,   43,   62,   45,  355,   47,
  276,  277,  359,  386,   60,   11,   12,  276,  277,   65,
   56,   57,   58,   59,   39,  407,   80,   41,   42,   43,
   66,   45,   26,   47,  411,  256,  257,  258,  259,  260,
  409,   37,   38,  264,  265,  266,  409,  256,   42,   42,
  257,  258,  259,  260,   47,  276,  277,  264,  265,  266,
  376,  381,  256,  381,  384,   80,  381,  276,  277,   73,
   74,  256,  588,  256,  423,  129,  270,  271,  272,  273,
  274,   96,  276,  277,  346,   81,   82,  349,   84,  256,
   86,  276,  277,  276,  277,  149,  150,  256,  275,  153,
  276,  155,  418,  256,  417,  194,  275,  196,  268,  276,
  277,  423,  269,  409,  129,  269,  381,  276,  277,  257,
  258,  259,  260,  276,  277,  381,  264,  265,  266,  381,
  381,  413,  221,  410,  149,  150,  415,  410,  153,   17,
  155,  409,  414,  414,  376,  423,  376,  376,  591,  376,
  593,   40,  411,  376,   32,   33,   34,  423,  194,  213,
  196,  215,  376,  256,  407,  270,  271,  272,  273,  274,
  166,  381,  256,  169,  170,  256,  172,  381,  381,  175,
  176,  415,  178,  276,  277,  221,  382,  256,  409,  382,
  381,  187,  276,  277,  190,  276,  277,  381,  213,  382,
  215,   40,  409,  424,  200,  407,  256,  276,  277,  298,
  419,   58,  208,  418,  376,  376,  384,  424,  384,   97,
   98,  275,  380,  417,  278,  279,  276,  277,  282,  382,
  381,  285,  228,  418,  230,  256,  232,  252,  234,  384,
  236,  384,  256,  384,  270,  271,  272,  273,  274,  384,
  417,  384,  298,  342,  384,  276,  277,  416,  380,  348,
  275,  350,    0,  278,  279,  354,  413,  282,  357,  265,
  285,  409,  256,  409,  362,  415,  365,  331,  332,  333,
  334,   88,  371,  414,  299,  300,  424,  375,  303,  304,
  286,  356,  276,  277,  256,  490,  342,  381,  352,  295,
  296,  382,  348,  466,  350,  378,  268,  380,  354,  414,
  256,  357,   64,  382,  276,  277,  331,  332,  333,  334,
  101,  348,  362,  412,  413,  371,  399,  400,  401,  365,
  276,  277,  382,  256,  524,  256,   -1,  352,  353,   -1,
   -1,  356,  431,  381,   -1,   -1,  361,  270,  271,  272,
  273,  274,  256,  276,  277,  276,  277,   -1,   -1,  256,
  375,  382,   -1,   -1,  418,   -1,  412,  413,  257,  258,
  259,  260,  276,  277,   -1,  264,  265,  266,  432,  276,
  277,  270,  271,  272,  273,  274,  413,  476,   -1,   -1,
   -1,  417,  256,   -1,   40,  431,   42,   43,  382,   45,
   -1,   47,   -1,  418,   -1,   -1,  270,  271,  272,  273,
  274,   -1,  500,  409,   -1,   -1,  504,  432,  257,  258,
  259,  260,  437,   -1,  439,  264,  265,  266,   -1,   -1,
  476,  270,  271,  272,  273,  274,  382,   13,   14,   15,
   16,  257,  258,  259,  260,  256,   -1,   -1,  264,  265,
  266,  466,   -1,   29,   30,   40,   41,   -1,   43,   -1,
   45,  382,  256,   -1,   -1,  276,  277,  156,  157,  158,
  159,   47,   48,  379,  380,  490,  256,   53,  382,   55,
  386,  387,  276,  277,  381,  500,   -1,   63,   64,  504,
   -1,   -1,  415,   -1,   70,   -1,  276,  277,  278,  495,
  588,   77,   78,   79,  256,  257,  258,  259,  260,  524,
   -1,   87,  264,  265,  266,  256,   92,   93,  270,  271,
  272,  273,  274,   -1,    6,    7,    8,  256,  417,   11,
   12,   32,   33,   34,   -1,  276,  277,  626,   -1,   21,
   22,   23,   24,   25,   26,   27,  410,  276,  277,   31,
   32,   -1,   -1,   -1,   36,   37,   38,   -1,  369,   41,
   42,  256,   44,   -1,   46,   -1,  255,  256,   -1,   51,
   52,  256,   54,  588,   56,   57,   58,   59,  417,   61,
  626,  276,  277,   65,   66,   67,   68,   69,   -1,   71,
   -1,  276,  277,  409,   -1,   -1,   97,   98,   -1,   81,
   -1,   83,   84,   85,   86,   -1,   -1,   89,   90,   91,
   -1,  257,  258,  259,  260,   97,   98,   -1,  264,  265,
  266,   -1,   -1,  375,  270,  271,  272,  273,  274,   -1,
   -1,   -1,   -1,   40,   41,  256,   43,   -1,   45,   -1,
  379,  380,   -1,  257,  258,  259,  260,  386,  387,  131,
  264,  265,  266,   -1,   -1,  276,  277,  139,  256,   -1,
  258,  143,  144,   -1,  146,  417,  264,  265,  266,  408,
   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,   -1,   -1,  166,  270,  271,  272,  273,  274,
   -1,  276,  277,   -1,   -1,  177,   -1,   -1,  180,   -1,
   -1,  183,   -1,  185,   -1,   -1,   -1,  189,   42,   43,
   -1,   45,   -1,   47,  379,  380,  198,   -1,   -1,  201,
  202,  386,  387,  205,   -1,  379,  380,  209,  210,   -1,
   -1,   -1,  386,  387,  216,  217,   -1,  219,   -1,   -1,
   -1,  223,   -1,  408,  226,  227,  228,   -1,   -1,  231,
   -1,  233,   -1,  235,  408,  237,   -1,  239,   -1,  241,
   -1,  243,  244,   -1,  246,   -1,  248,   -1,  250,   -1,
   -1,  417,  254,  379,  380,  257,   -1,  259,   -1,  261,
  386,  387,  388,  265,   -1,   -1,  268,  269,  270,  271,
   -1,  273,  274,   -1,  276,  409,  381,  450,   -1,   -1,
   -1,   -1,  455,    0,   -1,  287,  459,   -1,  290,   -1,
  292,  464,  465,  295,  296,  297,  392,   -1,  394,  379,
  380,  270,  271,  272,  273,  274,  386,  387,   -1,  414,
   -1,   -1,  417,   -1,   -1,   -1,   -1,   -1,  257,  258,
  259,  260,  324,   -1,  326,  264,  265,  266,  408,  256,
  257,  258,  259,  260,   -1,   -1,  263,  264,  265,  266,
   -1,  343,  344,  270,  271,  272,  273,  274,   -1,  276,
  277,   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,   -1,  276,  277,  376,  256,   -1,   -1,  551,  381,
  382,  554,  555,   -1,  557,  558,  559,   -1,   -1,  270,
  271,  272,  273,  274,   -1,  276,  277,   -1,   -1,   -1,
   -1,   -1,  256,  257,  258,  259,  260,  409,   -1,  263,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  423,  276,  277,  426,   -1,  428,  429,  430,  431,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  441,
   -1,   -1,  615,   42,   43,   -1,   45,  256,   47,  258,
   -1,   -1,   -1,   -1,  381,  264,  265,  266,  397,  398,
  399,  400,  401,  402,   -1,   -1,   -1,  276,  277,   -1,
   -1,   -1,   -1,  475,   -1,  477,   -1,   -1,  480,   -1,
  482,  483,   -1,  485,  486,   -1,   -1,  414,  490,   -1,
  417,   -1,   -1,  495,  496,   -1,   -1,  499,   -1,  501,
  502,  503,   -1,   -1,  506,  257,  258,  259,  260,  511,
  414,  513,  264,  265,  266,  517,  518,  519,  520,  521,
  522,  256,   -1,  258,  526,   -1,  528,  529,   -1,  264,
  265,  266,   -1,  535,   -1,  537,  538,  539,  540,  256,
  257,  258,  259,  260,  261,   -1,  263,  264,  265,  266,
  267,   -1,   -1,  270,  271,  272,  273,  274,   -1,   -1,
  414,   -1,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,    0,   -1,  300,  301,  302,  303,  304,   -1,  306,
  307,  308,  309,  310,  311,  312,  313,  314,  315,  316,
  317,  318,  319,  320,  321,  322,  323,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,
  337,  338,  339,  340,  341,  342,  343,  344,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,   -1,  370,  371,  372,  373,  374,  257,  258,
  259,  260,   -1,   -1,   -1,  264,  265,  266,  256,   -1,
  258,  270,  271,  272,  273,  274,  264,  265,  266,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  276,  277,
   -1,  256,  261,  258,   -1,   -1,   -1,  414,  267,  264,
  265,  266,   -1,   -1,  421,  422,   -1,  276,  277,   -1,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,   -1,
   -1,  300,  301,  302,  303,  304,   -1,  306,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
   -1,  370,  371,  372,  373,  374,   -1,   -1,   -1,   -1,
   -1,   64,   -1,   -1,   -1,  414,   -1,   -1,  256,  257,
  258,  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,  256,  276,  277,
   -1,   -1,  261,   -1,   -1,   -1,   -1,   -1,  267,   -1,
   -1,   -1,  421,  422,   -1,   -1,   -1,  276,  277,   -1,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,   -1,
   -1,  300,  301,  302,  303,  304,   -1,  306,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
   -1,  370,  371,  372,  373,  374,   -1,  256,  257,  258,
  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,
  269,  270,  271,  272,  273,  274,  414,  276,  277,   -1,
   -1,  419,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,  421,  422,  257,  258,  259,  260,   -1,   -1,
   -1,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,
  276,  277,  256,  257,  258,  259,  260,   -1,   -1,   -1,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  378,  276,  277,  381,  414,   -1,   -1,   -1,   -1,
  261,   -1,  375,  390,   -1,  392,  267,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  276,   -1,   -1,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,   -1,   -1,  300,
  301,  302,  303,  304,  417,  306,  307,  308,  309,  310,
  311,  312,  313,  314,  315,  316,  317,  318,  319,  320,
  321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,  336,  337,  338,  339,  340,
  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  414,  370,
  371,  372,  373,  374,   -1,   -1,   -1,  256,  257,  258,
  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,
  414,  270,  271,  272,  273,  274,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,   -1,
  267,   -1,  413,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  421,  422,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,   -1,   -1,  300,  301,  302,  303,  304,   -1,  306,
  307,  308,  309,  310,  311,  312,  313,  314,  315,  316,
  317,  318,  319,  320,  321,  322,  323,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,
  337,  338,  339,  340,  341,  342,  343,  344,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,   -1,  370,  371,  372,  373,  374,   -1,   -1,
   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,   -1,  414,  270,  271,  272,  273,
  274,  256,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,
   -1,   -1,   -1,   -1,  421,  422,  256,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  257,  258,  259,  260,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  257,  258,  259,  260,   -1,   -1,  263,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,  257,
  258,  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  257,  258,  259,  260,   -1,
  414,   -1,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,   -1,   -1,   -1,   -1,   -1,   -1,  414,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  414,   -1,   -1,   -1,  257,  258,
  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,
   -1,   -1,  414,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  414,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  414,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  414,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  414,   -1,   -1,   -1,  375,   -1,
  377,  378,   -1,   -1,  381,   -1,  383,   -1,  385,   -1,
   -1,   -1,  414,  390,  391,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  379,  380,   -1,   -1,   -1,   -1,   -1,  386,  387,  388,
};
#define YYFINAL 99
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 424
#define YYUNDFTOKEN 481
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,"':'",0,
0,0,0,0,"'@'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_LOG","CMD_LOGNAME",
"CMD_SIDEFX","CMD_DUMMY","CMD_RETURN","CMD_BLOCK_READ","CMD_BLOCK_WRITE",
"CMD_UP","CMD_DOWN","CMD_LOAD","CMD_SAVE","CMD_VERIFY","CMD_BVERIFY",
"CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO","CMD_REGISTERS",
"CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY","CMD_BREAK",
"CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP","CMD_UNDUMP",
"CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND","CMD_ASSEMBLE",
"CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE","CMD_HELP",
"CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK","CMD_LOAD_LABELS",
"CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL","CMD_SHOW_LABELS",
"CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_MKDIR","CMD_RMDIR",
"CMD_RESOURCE_GET","CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES",
"CMD_ATTACH","CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_CARTFREEZE",
"CMD_CPUHISTORY","CMD_MEMMAPZAP","CMD_MEMMAPSHOW","CMD_MEMMAPSAVE",
"CMD_COMMENT","CMD_LIST","CMD_STOPWATCH","RESET","CMD_EXPORT","CMD_AUTOSTART",
"CMD_AUTOLOAD","CMD_MAINCPU_TRACE","CMD_LABEL_ASGN","L_PAREN","R_PAREN",
"ARG_IMMEDIATE","REG_A","REG_X","REG_Y","COMMA","INST_SEP","L_BRACKET",
"R_BRACKET","LESS_THAN","REG_U","REG_S","REG_PC","REG_PCR","REG_B","REG_C",
"REG_D","REG_E","REG_H","REG_L","REG_AF","REG_BC","REG_DE","REG_HL","REG_IX",
"REG_IY","REG_SP","REG_IXH","REG_IXL","REG_IYH","REG_IYL","PLUS","MINUS",
"STRING","FILENAME","R_O_L","R_O_L_Q","OPCODE","LABEL","BANKNAME","CPUTYPE",
"MON_REGISTER","COND_OP","RADIX_TYPE","INPUT_SPEC","CMD_CHECKPT_ON",
"CMD_CHECKPT_OFF","TOGGLE","MASK",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep expression end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : CMD_SCREEN address end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_DUMMY TOGGLE end_cmd",
"monitor_state_rules : CMD_DUMMY end_cmd",
"monitor_state_rules : CMD_LOG TOGGLE end_cmd",
"monitor_state_rules : CMD_LOG end_cmd",
"monitor_state_rules : CMD_LOGNAME filename end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE TOGGLE end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_MKDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_RMDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num address end_cmd",
"disk_rules : CMD_BLOAD filename device_num error",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num opt_address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"rest_of_line_or_quoted : R_O_L_Q",
"filename : FILENAME",
"filename : error",
"device_num : d_number",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COND_OP cond_expr",
"cond_expr : cond_expr COND_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : cond_operand",
"cond_operand : register",
"cond_operand : number",
"cond_operand : '@' BANKNAME ':' address",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"guess_default : B_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"number : H_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : B_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1110 "mon_parse.y"

int parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COND_OP:
           mon_out("Conditional operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();

   return rc;
}

static int yyerror(char *s)
{
#if 0
   fprintf(stderr, "ERR:%s\n", s);
#endif
   return 0;
}

static int resolve_datatype(unsigned guess_type, const char *num)
{
   /* FIXME: Handle cases when default type is non-numerical */
   if (default_radix == e_hexadecimal) {
       return (int)strtol(num, NULL, 16);
   }

   if ((guess_type == D_NUMBER) || (default_radix == e_decimal)) {
       return (int)strtol(num, NULL, 10);
   }

   if ((guess_type == O_NUMBER) || (default_radix == e_octal)) {
       return (int)strtol(num, NULL, 8);
   }

   return (int)strtol(num, NULL, 2);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = (int)new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = (int)new_addr(memspace, sa);
    return 0;
}
#line 1708 "mon_parse.c"

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yym = 0;
    yyn = 0;
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        yychar = YYLEX;
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);

    switch (yyn)
    {
case 1:
#line 199 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 2:
#line 200 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 3:
#line 201 "mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
break;
case 8:
#line 210 "mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
break;
case 21:
#line 225 "mon_parse.y"
	{ return ERR_BAD_CMD; }
break;
case 22:
#line 229 "mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
break;
case 23:
#line 231 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
break;
case 24:
#line 233 "mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
break;
case 25:
#line 235 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 26:
#line 237 "mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
break;
case 27:
#line 239 "mon_parse.y"
	{ mon_go(); }
break;
case 28:
#line 241 "mon_parse.y"
	{ mon_display_io_regs(0); }
break;
case 29:
#line 243 "mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
break;
case 30:
#line 245 "mon_parse.y"
	{ monitor_cpu_type_set(""); }
break;
case 31:
#line 247 "mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
break;
case 32:
#line 249 "mon_parse.y"
	{ mon_cpuhistory(-1); }
break;
case 33:
#line 251 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i); }
break;
case 34:
#line 253 "mon_parse.y"
	{ mon_instruction_return(); }
break;
case 35:
#line 255 "mon_parse.y"
	{ mon_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
break;
case 36:
#line 257 "mon_parse.y"
	{ mon_read_snapshot(yystack.l_mark[-1].str, 0); }
break;
case 37:
#line 259 "mon_parse.y"
	{ mon_instructions_step(-1); }
break;
case 38:
#line 261 "mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
break;
case 39:
#line 263 "mon_parse.y"
	{ mon_instructions_next(-1); }
break;
case 40:
#line 265 "mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
break;
case 41:
#line 267 "mon_parse.y"
	{ mon_stack_up(-1); }
break;
case 42:
#line 269 "mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
break;
case 43:
#line 271 "mon_parse.y"
	{ mon_stack_down(-1); }
break;
case 44:
#line 273 "mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
break;
case 45:
#line 275 "mon_parse.y"
	{ mon_display_screen(-1); }
break;
case 46:
#line 277 "mon_parse.y"
	{ mon_display_screen(yystack.l_mark[-1].a); }
break;
case 48:
#line 282 "mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
break;
case 49:
#line 284 "mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
break;
case 51:
#line 289 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str);
                    }
break;
case 52:
#line 294 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str);
                    }
break;
case 53:
#line 299 "mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 54:
#line 301 "mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
break;
case 55:
#line 303 "mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
break;
case 56:
#line 305 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
break;
case 57:
#line 307 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 58:
#line 309 "mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
break;
case 59:
#line 311 "mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
break;
case 60:
#line 313 "mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
break;
case 61:
#line 315 "mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
break;
case 62:
#line 317 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
break;
case 63:
#line 321 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
break;
case 64:
#line 327 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
break;
case 65:
#line 328 "mon_parse.y"
	{ }
break;
case 66:
#line 330 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
break;
case 67:
#line 332 "mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
break;
case 68:
#line 334 "mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
break;
case 69:
#line 338 "mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 70:
#line 340 "mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 71:
#line 342 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 72:
#line 344 "mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 73:
#line 346 "mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 74:
#line 348 "mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 75:
#line 350 "mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 76:
#line 352 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
break;
case 77:
#line 354 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
break;
case 78:
#line 356 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
break;
case 79:
#line 358 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
break;
case 80:
#line 360 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 81:
#line 362 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 82:
#line 364 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
break;
case 83:
#line 366 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
break;
case 84:
#line 368 "mon_parse.y"
	{ mon_memmap_zap(); }
break;
case 85:
#line 370 "mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
break;
case 86:
#line 372 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
break;
case 87:
#line 374 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
break;
case 88:
#line 376 "mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 89:
#line 380 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 90:
#line 389 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 91:
#line 392 "mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE, TRUE);
                  }
break;
case 92:
#line 396 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 93:
#line 399 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 94:
#line 408 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 95:
#line 411 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_exec | e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 96:
#line 420 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 97:
#line 425 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
break;
case 98:
#line 427 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
break;
case 99:
#line 429 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
break;
case 100:
#line 431 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
break;
case 101:
#line 433 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
break;
case 102:
#line 435 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
break;
case 103:
#line 437 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
break;
case 104:
#line 439 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
break;
case 105:
#line 441 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
break;
case 106:
#line 443 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 107:
#line 445 "mon_parse.y"
	{ return ERR_EXPECT_STRING; }
break;
case 108:
#line 449 "mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
break;
case 109:
#line 451 "mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
break;
case 110:
#line 456 "mon_parse.y"
	{ 
                         break_on_dummy_access = ((yystack.l_mark[-1].action == e_TOGGLE) ? (break_on_dummy_access ^ 1) : yystack.l_mark[-1].action); 
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
break;
case 111:
#line 463 "mon_parse.y"
	{
                         mon_out("Checkpoints will %strigger on dummy accesses.\n",
                                   break_on_dummy_access ? "" : "not ");
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
break;
case 112:
#line 471 "mon_parse.y"
	{ 
                        int logenabled;
                        resources_get_int("MonitorLogEnabled", &logenabled);
                        logenabled = ((yystack.l_mark[-1].action == e_TOGGLE) ? (logenabled ^ 1) : yystack.l_mark[-1].action);
                        resources_set_int("MonitorLogEnabled", logenabled);
                     }
break;
case 113:
#line 478 "mon_parse.y"
	{
                         int logenabled;
                         const char *logfilename;
                         resources_get_int("MonitorLogEnabled", &logenabled);
                         resources_get_string("MonitorLogFileName", &logfilename);
                         if (logenabled) {
                            mon_out("Logging to '%s' is enabled.\n", logfilename);
                         } else {
                            mon_out("Logging is disabled.\n");
                         }
                     }
break;
case 114:
#line 490 "mon_parse.y"
	{ 
                        resources_set_string("MonitorLogFileName", yystack.l_mark[-1].str);
                     }
break;
case 115:
#line 494 "mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
break;
case 116:
#line 496 "mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
break;
case 117:
#line 514 "mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
break;
case 118:
#line 516 "mon_parse.y"
	{ mon_export(); }
break;
case 119:
#line 518 "mon_parse.y"
	{ mon_quit(); YYACCEPT; }
break;
case 120:
#line 520 "mon_parse.y"
	{ mon_exit(); YYACCEPT; }
break;
case 121:
#line 522 "mon_parse.y"
	{ mon_maincpu_toggle_trace(yystack.l_mark[-1].action); }
break;
case 122:
#line 526 "mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
break;
case 123:
#line 528 "mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
break;
case 124:
#line 530 "mon_parse.y"
	{ mon_command_print_help(NULL); }
break;
case 125:
#line 532 "mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
break;
case 126:
#line 534 "mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
break;
case 127:
#line 536 "mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
break;
case 128:
#line 538 "mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
break;
case 129:
#line 540 "mon_parse.y"
	{ mon_backtrace(); }
break;
case 130:
#line 542 "mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
break;
case 131:
#line 544 "mon_parse.y"
	{ mon_show_pwd(); }
break;
case 132:
#line 546 "mon_parse.y"
	{ mon_make_dir(yystack.l_mark[-1].str); }
break;
case 133:
#line 548 "mon_parse.y"
	{ mon_remove_dir(yystack.l_mark[-1].str); }
break;
case 134:
#line 550 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
break;
case 135:
#line 552 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 136:
#line 554 "mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
break;
case 137:
#line 556 "mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
break;
case 138:
#line 558 "mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
break;
case 139:
#line 560 "mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
break;
case 140:
#line 562 "mon_parse.y"
	{ mon_reset_machine(-1); }
break;
case 141:
#line 564 "mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
break;
case 142:
#line 566 "mon_parse.y"
	{ mon_tape_ctrl(yystack.l_mark[-1].i); }
break;
case 143:
#line 568 "mon_parse.y"
	{ mon_cart_freeze(); }
break;
case 144:
#line 570 "mon_parse.y"
	{ }
break;
case 145:
#line 572 "mon_parse.y"
	{ mon_stopwatch_reset(); }
break;
case 146:
#line 574 "mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
break;
case 147:
#line 578 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE); }
break;
case 148:
#line 580 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE); }
break;
case 149:
#line 582 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 150:
#line 584 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
break;
case 151:
#line 586 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 152:
#line 588 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 153:
#line 590 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
break;
case 154:
#line 592 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 155:
#line 594 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,FALSE); }
break;
case 156:
#line 596 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,TRUE); }
break;
case 157:
#line 598 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 158:
#line 600 "mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 159:
#line 602 "mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 160:
#line 604 "mon_parse.y"
	{ mon_drive_list(-1); }
break;
case 161:
#line 606 "mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
break;
case 162:
#line 608 "mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
break;
case 163:
#line 610 "mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
break;
case 164:
#line 612 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
break;
case 165:
#line 614 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
break;
case 166:
#line 616 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
break;
case 167:
#line 618 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
break;
case 168:
#line 622 "mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
break;
case 169:
#line 624 "mon_parse.y"
	{ mon_end_recording(); }
break;
case 170:
#line 626 "mon_parse.y"
	{ mon_playback_commands(yystack.l_mark[-1].str); }
break;
case 171:
#line 630 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
break;
case 172:
#line 632 "mon_parse.y"
	{ printf("Not yet.\n"); }
break;
case 173:
#line 636 "mon_parse.y"
	{ yydebug = 1; }
break;
case 174:
#line 639 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 175:
#line 642 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 176:
#line 643 "mon_parse.y"
	{ yyval.str = NULL; }
break;
case 177:
#line 646 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 179:
#line 650 "mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
break;
case 181:
#line 654 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 182:
#line 657 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
break;
case 183:
#line 658 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 184:
#line 661 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 185:
#line 662 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 186:
#line 665 "mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
break;
case 187:
#line 671 "mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
break;
case 190:
#line 684 "mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (uint16_t) yystack.l_mark[0].i); }
break;
case 191:
#line 687 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 192:
#line 688 "mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
break;
case 194:
#line 692 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
break;
case 195:
#line 695 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
break;
case 196:
#line 697 "mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 197:
#line 699 "mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 198:
#line 702 "mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
break;
case 199:
#line 703 "mon_parse.y"
	{ yyval.a = BAD_ADDR; }
break;
case 200:
#line 707 "mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 201:
#line 712 "mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 202:
#line 717 "mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
break;
case 205:
#line 730 "mon_parse.y"
	{ yyval.i = e_comp_space; }
break;
case 206:
#line 731 "mon_parse.y"
	{ yyval.i = e_disk8_space; }
break;
case 207:
#line 732 "mon_parse.y"
	{ yyval.i = e_disk9_space; }
break;
case 208:
#line 733 "mon_parse.y"
	{ yyval.i = e_disk10_space; }
break;
case 209:
#line 734 "mon_parse.y"
	{ yyval.i = e_disk11_space; }
break;
case 210:
#line 737 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
break;
case 211:
#line 739 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 212:
#line 741 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
break;
case 213:
#line 742 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
break;
case 214:
#line 743 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
break;
case 215:
#line 744 "mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
break;
case 216:
#line 745 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
break;
case 217:
#line 746 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 218:
#line 747 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 219:
#line 750 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 220:
#line 751 "mon_parse.y"
	{ yyval.cond_node = 0; }
break;
case 221:
#line 754 "mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
break;
case 222:
#line 759 "mon_parse.y"
	{ return ERR_INCOMPLETE_COND_OP; }
break;
case 223:
#line 761 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
break;
case 224:
#line 763 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 225:
#line 765 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 226:
#line 768 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 227:
#line 774 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 228:
#line 780 "mon_parse.y"
	{yyval.cond_node=new_cond;
                            yyval.cond_node->operation=e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-2].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = yystack.l_mark[0].a; yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;  
                        }
break;
case 231:
#line 796 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 232:
#line 797 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 235:
#line 804 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 236:
#line 805 "mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
break;
case 237:
#line 806 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 238:
#line 809 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 239:
#line 810 "mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
break;
case 240:
#line 813 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 241:
#line 814 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 242:
#line 815 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 243:
#line 816 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 244:
#line 819 "mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
break;
case 245:
#line 820 "mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
break;
case 246:
#line 821 "mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
break;
case 247:
#line 824 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 248:
#line 825 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 249:
#line 826 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 250:
#line 827 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 251:
#line 828 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 255:
#line 836 "mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
break;
case 257:
#line 847 "mon_parse.y"
	{ asm_mode = 0; }
break;
case 258:
#line 850 "mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
break;
case 259:
#line 857 "mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
break;
case 260:
#line 868 "mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 261:
#line 879 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 262:
#line 887 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
break;
case 263:
#line 906 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
break;
case 264:
#line 912 "mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
break;
case 265:
#line 920 "mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
break;
case 266:
#line 929 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
break;
case 267:
#line 931 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 268:
#line 932 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
break;
case 269:
#line 933 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
break;
case 270:
#line 934 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
break;
case 271:
#line 935 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
break;
case 272:
#line 936 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
break;
case 273:
#line 937 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
break;
case 274:
#line 939 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 275:
#line 941 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 276:
#line 943 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 277:
#line 945 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 278:
#line 946 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
break;
case 279:
#line 947 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
break;
case 280:
#line 948 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
break;
case 281:
#line 949 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
break;
case 282:
#line 950 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
break;
case 283:
#line 951 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
break;
case 284:
#line 952 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
break;
case 285:
#line 953 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
break;
case 286:
#line 954 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
break;
case 287:
#line 955 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
break;
case 288:
#line 956 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
break;
case 289:
#line 957 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
break;
case 290:
#line 958 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
break;
case 291:
#line 959 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
break;
case 292:
#line 960 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
break;
case 293:
#line 961 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
break;
case 294:
#line 962 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
break;
case 295:
#line 963 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
break;
case 296:
#line 964 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
break;
case 297:
#line 966 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
break;
case 298:
#line 967 "mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 299:
#line 982 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 300:
#line 986 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 301:
#line 990 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 302:
#line 994 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 303:
#line 998 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 304:
#line 1002 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 305:
#line 1006 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 306:
#line 1010 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 307:
#line 1014 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 308:
#line 1026 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 309:
#line 1041 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 310:
#line 1045 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 311:
#line 1049 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 312:
#line 1053 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 313:
#line 1057 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 314:
#line 1061 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 315:
#line 1065 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 316:
#line 1069 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 317:
#line 1073 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 318:
#line 1085 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
break;
case 319:
#line 1090 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
break;
case 320:
#line 1098 "mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
break;
case 321:
#line 1099 "mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
break;
case 322:
#line 1100 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 323:
#line 1101 "mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
break;
case 324:
#line 1105 "mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
break;
#line 3377 "mon_parse.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            yychar = YYLEX;
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
