
/*
 * LIB/MSGID.C
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

Prototype char *MsgId(const char *s);

/*
 * MsgId() - the message id must begin with a '<', end with a '>', 
 *	     and not contain any embedded '<' or TAB.
 */

char *
MsgId(const char *s)
{
    int i;
    static char *LMsgId;

    if (LMsgId) {
	zfree(&SysMemPool, LMsgId, strlen(LMsgId) + 1);
	LMsgId = NULL;
    }

    if (s == NULL)
	return("<>");
    while (*s && (*s == ' ' || *s == '\t'))
	++s;
    if (*s != '<')
	return("<>");

    for (i = 1; s[i] && s[i] != '>'; ++i) {
	if (s[i] == '<' || s[i] == '\t' || s[i] == ' ')
	    return("<>");
    }

    if (s[i] != '>')
	return("<>");
    ++i;
    if (i >= MAXMSGIDLEN)
	return("<>");
    LMsgId = zalloc(&SysMemPool, i + 1);
    bcopy(s, LMsgId, i);
    LMsgId[i] = 0;
    return(LMsgId);
}

