#!/bin/sh
#modified based on suggestions from Darren Evans <darren@kedemel.demon.co.uk>

BINDIR=/usr/local/bin
MANPATH=/usr/local/man/man1
WXSHARE=/usr/local/share/wxftp
TAR=/bin/tar

if [ ! -e wxftp ] ; then
  echo "This is not a binary WXftp archive."
  exit 0
fi

if [ ! -d "$BINDIR" ] ; then
  if ! /bin/mkdir -p "$BINDIR" ; then
    echo "You don't have permissions to install WXftp"
    echo "Installation failed"
    exit 1
  fi
fi

/bin/rm -f "$BINDIR/wxftp"

if ! /bin/cp -f wxftp "$BINDIR" ; then
  echo "You don't have permissions to install WXftp"
  echo "Installation failed"
  exit 1
fi
  

if [ ! -d "$MANPATH" ] ; then
  if ! /bin/mkdir -p "$MANPATH" ; then
    /bin/rm -f $BINDIR/wxftp
    echo "You don't have permissions to install WXftp"
    echo "Installation failed"
    exit 1
  fi
fi
/bin/rm -rf $MANPATH/wxftp.*
if ! /bin/cp -f wxftp.1X $MANPATH ; then
  /bin/rm -f $BINDIR/wxftp
  /bin/rm -f $MANPATH/wxftp.*
  echo "You don't have permissions to install WXftp"
  echo "Installation failed"
  exit 1
fi

if [ ! -d "$WXSHARE" ] ; then
  if ! /bin/mkdir -p "$WXSHARE" ; then
    /bin/rm -f $BINDIR/wxftp
    /bin/rm -f $MANPATH/wxftp.*
    echo "You don't have permissions to install WXftp"
    echo "Installation failed"
    exit 1
  fi
fi

if ! (DIR=`pwd`; \
cd $WXSHARE ; \
/bin/rm -rf help; \
/bin/tar xf $DIR/help.tar) ; then
  /bin/rm -f $BINDIR/wxftp
  /bin/rm -f $MANPATH/wxftp.*
  /bin/rm -rf $WXSHARE/help
  echo "You don't have permissions to install WXftp"
  echo "Installation failed"
  exit 1
fi


echo "WXftp installed!"

