/*
 * Copyright(c) 1995,1996,1997 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *      
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: smtp.c,v 2.2 1997/11/27 16:23:51 gena Exp $
 */

#include <fmail.h>
#include <umail.h>

static char response[255];
static int smtpsock = -1;
static int smtpcap = 0;
#define	SMTP_ESMTP	0x01	/* ESMTP server     */
#define	SMTP_DSN	0x02	/* DSN is supported */
FILE *smtp_in = NULL;
FILE *smtp_out = NULL;

int
smtp_command(fmt, a, b, c, d)
char   *fmt,
       *a,
       *b,
       *c,
       *d;
{
int res, ehlo = 0;
char buf[255];

 if (fmt) {
 (void)sprintf(response, fmt, a, b, c, d);

 if (logging & LOG_SMTP)
  display_msg(MSG_LOG, "smtp", "-> %-.127s", response);
 if (putline(response, smtp_out) == -1)
	return -1;
	  }

 if (!strncmp(response, "EHLO ", 5))
	ehlo = 1;

 response[0] = '\0';
 response[3] = '-';

 while (response[3] == '-') {
  if (getline(response, sizeof(response), smtp_in) == NULL)
	return -1;

  if (ehlo)	{
     if (response[3] != '-')
	break;
     sscanf(response, "%d-%s", &res, buf);
     if (res != 250)
	continue;

     if (!strncasecmp(buf, "DSN", 3))
	smtpcap |= SMTP_DSN;
		}
			    }

 if (logging & LOG_SMTP)
  display_msg(MSG_LOG, "smtp", "<- %-.127s", response);

 res = -1;
 sscanf(response, "%d%s", &res, buf);
 
 if (res == -1) {
	display_msg(MSG_WARN, "smtp", "%-.127s", response);
	return -1;
		}

 return res;
}

void
smtp_close()
{

 host_disconnect(&smtpsock);

 if (smtp_in != NULL)
        fclose(smtp_in);

 smtp_in = NULL;
 smtp_out = NULL;
}

void
smtp_end()
{
if (smtp_command("QUIT") != 221)
	display_msg(MSG_WARN, "smtp", "%-.127s", response);

smtp_close();
}


int 
smtp_init()
{
char buf[255];

 if (smtpsock != -1) {
	display_msg(MSG_WARN, "smtp", "SMTP busy");
	return -1;
		     }

 strcpy(buf, b_getcfg_str(conf_name, "smtphost", "127.0.0.1"));

 smtpsock = host_connect(buf, b_getcfg_str(conf_name, "smtport", "25"), NULL);
    
 if (smtpsock == -1)
        return -2;

 if ((smtp_in = fdopen(smtpsock, "r+")) == NULL) {
        display_msg(MSG_WARN, "smtp", "fdopen failed");
        smtp_close();
        return -1;
        }

 smtp_out = smtp_in;

 if (smtp_command(NULL) != 220) {
        display_msg(MSG_WARN, "smtp", "%-.127s", response);
        smtp_close();
        return -1; }

 smtpcap = 0;
 if (smtp_command("EHLO %s", getmyhostname() ) != 250) 	 {
  if (smtp_command("HELO %s", getmyhostname() ) != 250)	{
        display_msg(MSG_WARN, "smtp", "%-.127s", response);
        smtp_close();
        return -1;					}
							 }
 else
   smtpcap |= SMTP_ESMTP;

 return 0;
}

int
send_rcpt_to(addr, usedsn)
struct _mail_addr *addr;
int usedsn;
{
 if (usedsn)	{
   if (smtp_command("RCPT TO: <%s> NOTIFY=SUCCESS,FAILURE,DELAY ORCPT=rfc822;%s",
	addr->addr, addr->addr) != 250) {
       	display_msg(MSG_WARN, "smtp", "%-.127s", response);
	return -1;		        }
		}
 else	{
   if (smtp_command("RCPT TO: <%s>", addr->addr) != 250) {
       	display_msg(MSG_WARN, "smtp", "%-.127s", response);
	return -1;				         }
	}

 return 0;
}

int
smtp_send_message(msg)
struct _mail_msg *msg;
{
struct _mail_addr *addr;
struct _head_field *hf;
time_t lt = time(NULL);
int usedsn = 0;
char id[32], buf[100], *envid;

 switch (smtp_init())	{
   case -1:
	return -1;
   break;

   case -2:
	return -2;
   break;
			}

 if ((smtpcap & SMTP_ESMTP) &&
	(smtpcap & SMTP_DSN) &&
	((hf = find_field(msg, "Return-Receipt-To")) != NULL) &&
	b_getcfg_int(conf_name, "smtpdsn", 0))		{
	usedsn = 1;
	delete_all_fields(msg, "X-DSN-Envid");
	delete_all_fields(msg, "Return-Receipt-To");	}

 if (usedsn) {
  if ((hf = find_field(msg, "Message-ID")) == NULL)	{
   strftime(id, 31, "%y%m%d%H%M%S", localtime(&lt));
   sprintf(buf, "<XFMail-DSN.%s.%-.32s>", id, msg->header->From->addr);
   add_field(msg, "Message-ID", buf);
   envid = buf;
							}
  envid = hf->f_line;

  if (smtp_command("MAIL FROM: <%s> RET=HDRS ENVID=%s",
	msg->header->From->addr, envid) != 250) {
        display_msg(MSG_WARN, "smtp", "%-.127s", response);
        smtp_end();
        return -1;				}
	     }
 else	{
  if (smtp_command("MAIL FROM: <%s>", msg->header->From->addr ) != 250) {
        display_msg(MSG_WARN, "smtp", "%-.127s", response);
        smtp_end();
        return -1;							}
	}

 addr = msg->header->To;
 while (addr)			{
	if (send_rcpt_to(addr, usedsn) == -1) {
		smtp_end();
		return -1;		      }
        addr = addr->next_addr; }

 addr = msg->header->Cc;
 while (addr)			{
	if (send_rcpt_to(addr, usedsn) == -1) {
		smtp_end();
		return -1;		      }
        addr = addr->next_addr; }

 addr = msg->header->Bcc;
 while (addr)			{
	if (send_rcpt_to(addr, usedsn) == -1) {
		smtp_end();
		return -1;		      }
        addr = addr->next_addr; }

 if (smtp_command("DATA") != 354) {
       	display_msg(MSG_WARN, "smtp", "%-.127s", response);
	smtp_end();
	return -1;		  }

 if (smtp_message(msg, smtp_out) == -1) {
	smtp_end();
	return -1;		  	}

 if (smtp_command(".") != 250)	{
       	display_msg(MSG_WARN, "smtp", "%-.127s", response);
	smtp_end();
	return -1;		}

 smtp_end();
 return 0;
}

int
smtp_news_addr(addr, str, file)
struct _news_addr *addr;
char *str;
FILE* file;
{
char buf[255];
int alen = 0, i = 0;

 if (!file)
	return -1;

 *buf = '\0';

 if (str)       {
   sprintf(buf, "%s: ", str);
   alen += (strlen(str) + 2);
                }

 while (addr)           {
  if (i && (alen + strlen(addr->name) > 78)) {
        strcat(buf, ",");
	if (putline(buf, file) == -1)
		return -1;
	strcpy(buf, " ");
        alen = 1;                            }
  else
  if (i)                {
        strcat(buf, ", ");
        alen += 2;      }

  strcat(buf, addr->name);
  alen += strlen(addr->name);

  i++;
  addr = addr->next;    }

 if (alen)		{
   if (putline(buf, file) == -1)
	return -1;	}

 return 0;
}

int
smtp_addr(addr, str, file, charset)
mail_addr *addr;
char *str;
FILE* file;
int charset;
{
u_int st, st1;
u_int alen, quote;
int len;
char buf[255], acomm[255];
char *p, *p1, *p2;

if (!addr)
        return -1;

if (file == NULL)
        return -1;

st = st1 = 0;

if (addr->name && strpbrk(addr->name, ".,;\'\"()<>") &&
  (*addr->name != '\'') && (*addr->name != '\"'))
	quote = 1;
else
	quote = 0;

if (charset >= -1) {
 if ((p = rfc1522_encode(addr->comment, charset, -1)) != addr->comment) {
	strcpy(acomm, p);
	p = acomm;						  }
 else
	p = NULL;

 if ((p1 = rfc1522_encode(addr->name, charset, -1)) == addr->name)
	p1 = NULL;
 else
	quote = 0;
		  }
else	{
 p = NULL;
 p1 = NULL;
	}

if (addr->name && addr->comment)
        sprintf(buf, "%s: %s%s%s <%s> (%s)%s", str, quote ? "\"" : "" , p1 ? p1 : addr->name , quote ? "\"" : "", addr->addr, p ? p : addr->comment, addr->next_addr ? "," : "");
else
if (!addr->name && !addr->comment)
        sprintf(buf, "%s: %s%s", str, addr->addr, addr->next_addr ? "," : "");
else
if (addr->name)
        sprintf(buf, "%s: %s%s%s <%s>%s", str, quote ? "\"" : "", p1 ? p1 : addr->name, quote ? "\"" : "", addr->addr, addr->next_addr ? "," : "");
else
        sprintf(buf, "%s: (%s) <%s>%s", str, p ? p : addr->comment, addr->addr, addr->next_addr ? "," : "");

p = NULL;

if (putline(buf, file) == -1)
	return -1;

if (!addr->next_addr)
	return 0;

st1 += strlen(buf);

addr =  addr->next_addr;

p2 = buf;

while(addr) {

 if (addr->name && strpbrk(addr->name, ".,;\'\"()<>") &&
  (*addr->name != '\'') && (*addr->name != '\"'))
	quote = 1;
 else
	quote = 0;

if (charset >= -1) {
 if ((p = rfc1522_encode(addr->comment, -1, -1)) != addr->comment) {
	strcpy(acomm, p);
	p = acomm;						  }
 else
	p = NULL;

if ((p1 = rfc1522_encode(addr->name, -1, -1)) == addr->name)
	p1 = NULL;
else
	quote = 0;
		  }
else	{
 p = NULL;
 p1 = NULL;
	}

  alen = strlen(addr->addr);
  if (addr->name)
        alen += (strlen(p1 ? p1 : addr->name) + 4);

  if (addr->comment)
        alen += (strlen(p ? p : addr->comment) + 4);

  if (quote)
	alen += 2;

  if ((st1 - st + alen) > 80) {
        st = st1;
	if (putline(buf, file) == -1) {
		if (p)
			free(p);
		return -1; }
	p2 = buf;
	*p2 = '\t';
	p2++;
	*p2 = '\0';
	st1 += 3;
                        }
  else {
	*p2 = ' ';
	p2++;
	*p2 = '\0';
	st1 += 2;
	}

  if (!addr->name && !addr->comment)
	sprintf(p2, "%s%s", addr->addr, addr->next_addr ? "," : "");
  else
  if (addr->name && (p ? p : addr->comment))
        sprintf(p2, "%s%s%s <%s> (%s)%s", quote ? "\"" : "", p1 ? p1 : addr->name, quote ? "\"" : "", addr->addr, p ? p : addr->comment, addr->next_addr ? "," : "");
  else
  if (addr->name)
        sprintf(p2, "%s%s%s <%s>%s", quote ? "\"" : "", p1 ? p1 : addr->name, quote ? "\"" : "", addr->addr, addr->next_addr ? "," : "");
  else
        sprintf(p2, "(%s) <%s>%s", p ? p : addr->comment, addr->addr, addr->next_addr ? "," : "");

  len = strlen(p2);
  st1 += len;
  p2 += len;

  p = NULL;

  addr = addr->next_addr;
           }

return putline(buf, file);
}

int
smtp_header_field(fld, file)
head_field *fld;
FILE *file;
{
char buf[255];
char *p, *p1, c;
int nlen;

  sprintf(buf, "%s: ", fld->f_name);
  p = rfc1522_encode(fld->f_line, -1 , -1);
  nlen = FLD_BREAK - (strlen(fld->f_name) + 2);

  while(strlen(p) > nlen)       {
        c = p[nlen];
        p[nlen] = '\0';
        if ( (p1 = strstr(p, "; ")) ||
                (p1 = strstr(p, ", ")) ||
                   (p1 = strrchr(p, ' ')) ) {
         p[nlen] = c;
         if (*p1 != ' ')
                p1++;

         nlen = (p1 - p);
	 if (nlen >= (sizeof(buf) - strlen(buf)))
		nlen = sizeof(buf) - strlen(buf) - 1;
	 if (nlen <= 0)
		nlen = 1;
         if ((nlen < (FLD_BREAK / 8)) ||
                ((strlen(p) - nlen) < (FLD_BREAK / 8))   )      {
		strncat(buf, p, nlen);
                p += nlen;
                nlen = FLD_BREAK;
                continue;
                                        			}

	 strncat(buf, p, nlen);
	 if (putline(buf, file) == -1)
		return -1;

	 strcpy(buf, " ");

         p1++;
         p = p1;
         nlen = FLD_BREAK - 1;
                                        }
        else    {
         p[nlen] = c;
	 strncat(buf, p, nlen);
         p += nlen;
         nlen = FLD_BREAK;
                }
                                }

  nlen = sizeof(buf) - strlen(buf) - 1;
  if (nlen <= 0)
	return 0;

  if ((strlen(buf) + strlen(p)) >= sizeof(buf))	{
	strncat(buf, p, nlen);
	buf[sizeof(buf) - 1] = '\0';		}
  else
	strcat(buf, p);

  return putline(buf, file);
}

int
smtp_message(msg, m_out)  
struct _mail_msg *msg;
FILE *m_out;
{
head_field *hf;
struct _mime_msg *mime;
char buf[512];
FILE *mfd;
int charset, i;

if (!msg || !m_out)
        return -1;

if (!b_getcfg_int(conf_name, "encheader", 1))
 charset = -2;
else	{
 charset = -1;
 if ((mime = get_text_part(msg)) != NULL) {
 i = 0;
 while (supp_charsets[i].charset_code != CHAR_UNKNOWN)  {
	if (mime->charset->charset_code == supp_charsets[i].charset_code) {
		charset = i;
		break;							  }
        i++;
                                                        }
					  }
	}

if (msg->header) {
        hf = msg->header->other_fields;
        while(hf) {
	  if (!strip_when_send(hf))
	    if (smtp_header_field(hf, m_out) == -1)
		return -1;
          hf = hf->next_head_field;
                }

	smtp_addr(msg->header->Sender, "Sender", m_out, charset);
        smtp_addr(msg->header->From, "From", m_out, charset);
        smtp_addr(msg->header->To, "To", m_out, charset);
	if (msg->header->News)
		smtp_news_addr(msg->header->News, "Newsgroups", m_out);

        if (msg->header->Subject) {
                sprintf(buf, "Subject: %s", (charset >= -1) ? rfc1522_encode(msg->header->Subject, charset, -1) : msg->header->Subject);
	  	if (putline(buf, m_out) == -1)
			return -1;
				  }

        smtp_addr(msg->header->Cc, "Cc", m_out, charset);
        smtp_addr(msg->header->Bcc, "Bcc", m_out, charset);

                }

if (putline("", m_out) == -1)
	return -1;

if ((mfd = fopen(msg->get_file(msg), "r")) == NULL) 	{
	display_msg(MSG_WARN, "smtp", "Can not open %s", msg->get_file(msg));
	return -1;
							}

if (fseek(mfd, msg->header->header_len, SEEK_SET) == -1) {
	display_msg(MSG_WARN, "smtp", "Can not access message body");
	fclose(mfd);
	return -1;
						}

while (fgets(buf, 255, mfd)) 	{
	strip_newline(buf);
	if (strcmp(buf, "."))
		putline(buf, m_out);
	else
		putline(">.", m_out);
				}

if (ferror(mfd) && !feof(mfd)) 	{
	display_msg(MSG_WARN, "smtp", "Error reading mesage body");
	fclose(mfd);
	return -1;
				}

fclose(mfd);
return 0;
}

