#!/bin/sh
# Copyright (C) 1997  TCX DataKonsult AB & Monty Program KB & Detron HB
# For a more info consult the file COPYRIGHT distributed with this file

# This scripts creates the privilige tables db, host, user in mysql
# It should be run from the top level installation directory
#
# All arguments to this script is passed to safe_mysqld

if test ! -x @bindir@/mysqladmin
then
  echo "Can't execute @bindir@/mysqladmin"
  if test "@localstatedir@" = "./data"
  then
    echo "You should be in the distribution directory when executing this script"
  else
    echo "You should do a 'make install' before executing this script"
  fi
  exit 1
fi
if test ! -d "./data"
then
  echo "You should be in the distribution directory when executing this script"
  exit 1
fi

if test -f @localstatedir@/mysql/db.ISM
then
  echo "mysql privilege databases already installed. If you want to recreate all"
  echo "privilege tables, execute 'rm -i @localstatedir@/mysql/*.IS?'"
  echo "and run this script again"
  echo
  echo "You can now start the new mysql server with:"
  echo "@scriptdir@/safe_mysqld -l &"
  echo
  echo "Plese report any problems with the @scriptdir@/mysqlbug script"
  exit 1
fi

# On IRIX hostname is in /usr/bsd so add this to the path
PATH=$PATH:/usr/bsd

hostname=`hostname`		# Install this too in the user table

# create database mysql & test
#
if test ! -d @localstatedir@ ; then mkdir @localstatedir@ ; fi
if test ! -d @localstatedir@/mysql ; then mkdir @localstatedir@/mysql ; fi
if test ! -d @localstatedir@/test ; then mkdir @localstatedir@/test ; fi

@bindir@/mysqladmin ver > /dev/null 2>&1
if test $? -eq 0
then
  echo "The mysqld demon is already running. Stop it with"
  echo  "'@bindir@/mysqladmin shutdown' and try again."
  exit 1;
else 
  echo "Starting mysql server"
  @scriptdir@/safe_mysqld -Sg -l $* &
  while true
  do
    sleep 1			# This should be enough
    @bindir@/mysqladmin ver > /dev/null 2>&1
    if test $? -eq 0 ; then break; fi
    sleep 5			# This must be enough
    @bindir@/mysqladmin ver > /dev/null 2>&1
    if test $? -eq 0 ; then break; fi
    echo "System may be under load. Waiting for mysqld to start..."
    sleep 30                    # Better safe than sorry
    @bindir@/mysqladmin ver > /dev/null 2>&1 
    if test $? -eq 0 ; then break; fi 
    echo "mysqld demon is not responding. Please try to start it manually with"
    echo "@libexecdir@/mysqld --skip-grant --log"
    echo
    echo "You can find some information about why it didn't start by examining"
    echo "the log file in the @localstatedir@ directory."
    echo
    echo "Remember to include the last few lines from the log file if you"
    echo "post a bug report about this. Please report bugs and ask questions"
    echo "with the @scriptdir@/mysqlbug script!"
    echo "Before posting you should first check the reference manual,"
    echo "section 'Problems with mysql_install_db' and then the MySQL"
    echo "mail archive if this is a common problem on your platform!"
    echo
    exit 1;
  done
fi

# copy the definition files
#
if test "@localstatedir@" != "./data"
then
  cp -p ./data/mysql/*.frm @localstatedir@/mysql
fi

@bindir@/mysql mysql <<END_OF_DATA
# Create tables from the .frm files
#
delete from db ;
delete from host;
delete from user; 
delete from func;

#
# Dumping data for table 'db'
#

INSERT INTO db VALUES ('%','test','','Y','Y','Y','Y','Y','Y');
INSERT INTO db VALUES ('%','test\_%','','Y','Y','Y','Y','Y','Y');

#
# Dumping data for table 'host'
#

INSERT INTO host VALUES ('localhost','%','Y','Y','Y','Y','Y','Y');
INSERT INTO host VALUES ('$hostname','%','Y','Y','Y','Y','Y','Y');

#
# Dumping data for table 'user'
#

INSERT INTO user VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
INSERT INTO user VALUES ('localhost','','','N','N','N','N','N','N','N','N','N','N');
INSERT INTO user VALUES ('$hostname','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
INSERT INTO user VALUES ('$hostname','','','N','N','N','N','N','N','N','N','N','N');
END_OF_DATA

if test $? -eq 0
then 
  @bindir@/mysqladmin reload
  echo "mysqld demon is running and mysql grant tables are installed."
  echo
  echo "PLEASE REMEMBER TO SET A PASSWORD FOR THE MySQL root USER !"
  echo
  echo "You can test the MySQL demon with the benchmarks in the 'bench'"
  echo "directory:"
  echo "cd bench ; run-all-tests"
  echo
  echo "You can also try the mysql command line tool with:"
  echo "@bindir@/mysql test"
  echo
  echo "Plese report any problems with the @scriptdir@/mysqlbug script!"
  echo "The latest information about MySQL is available on the web at http://www.tcx.se"
  echo
  echo "Have fun and at least consider supporting MySQL if you find it useful :)"
else
  echo "The grant tables was not installed. You should examine the log"
  echo "in @localstatedir@ for more information. You can also try to start"
  echo "the mysqld demon with --skip-grant and use the command line tool"
  echo "@bindir@/mysql to connect to the mysql database and look at the"
  echo "grant tables:"
  echo
  echo "shell> @bindir@/mysql -u root mysql"
  echo "mysql> show tables"
  echo
  echo "Starting mysqld with --help gives some information if you have problems"
  echo "with paths. Using --log gives you a log that may be helpful."
  echo
  echo "Plese report any problems with the @scriptdir@/mysqlbug script!"
  echo "The latest information about MySQL is available on the web at http://www.tcx.se"
fi
