/*
 * defines for low level memory management routines
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: chunk.h,v 1.45 1997/12/05 21:09:37 gray Exp $
 */

#ifndef __CHUNK_H__
#define __CHUNK_H__

/* some argument defines */
#define CHUNK_PNT_EXACT		BIT_FLAG(0)	/* pointer must be on block */
#define CHUNK_PNT_LOOSE		BIT_FLAG(1)	/* looser checking */
#define CHUNK_PNT_NULL		BIT_FLAG(2)	/* watch for null char */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/*
 * the unknown file pointer.  did not use DMALLOC_UNKNOWN_FILE everywhere else
 * the pointers would be different.
 */
extern
char		*_dmalloc_unknown_file;

extern
long			_calloc_count;	/* # callocs, done in alloc */

/*
 * Startup the low level malloc routines
 */
extern
int	_chunk_startup(void);

/*
 * Display a bad pointer with FILE and LINE information
 */
extern
char	*_chunk_display_where(const char *file, const unsigned int line);

/*
 * Run extensive tests on the entire heap
 */
extern
int	_chunk_check(void);

/*
 * Run extensive tests on PNT from FUNC. test PNT HOW_MUCH of MIN_SIZE
 * (or 0 if unknown).  CHECK is flags for types of checking (see
 * chunk.h).  returns [NO]ERROR
 */
extern
int	_chunk_pnt_check(const char *func, const void *pnt,
			 const int check, const int min_size);

/*
 * return some information associated with PNT, returns [NO]ERROR
 */
extern
int	_chunk_read_info(const void *pnt, unsigned int *size_p,
			 unsigned int *alloc_size_p, char **file_p,
			 unsigned int *line_p, void **ret_attr_p,
			 const char *where, int **seen_cp);

/*
 * Log the heap structure plus information on the blocks if necessary
 */
extern
void	_chunk_log_heap_map(void);

/*
 * Get a SIZE chunk of memory for FILE at LINE
 */
extern
void	*_chunk_malloc(const char *file, const unsigned int line,
		       const unsigned int size);

/*
 * Frees PNT from the heap, returns FREE_ERROR or FREE_NOERROR
 */
extern
int	_chunk_free(const char *file, const unsigned int line, void *pnt);

/*
 * Reallocate a section of memory
 */
extern
void	*_chunk_realloc(const char *file, const unsigned int line,
			void *old_p, unsigned int new_size);

/*
 * Log present free and used lists
 */
extern
void	_chunk_list_count(void);

/*
 * Log statistics on the heap
 */
extern
void	_chunk_stats(void);

/*
 * Dump the unfreed memory, logs the unfreed information to logger
 */
extern
void	_chunk_dump_unfreed(void);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __CHUNK_H__ */
