package biss.awt;

import java.awt.Event;

/**
 * auxiliary class with keyboard constants
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Key
{
	final public static int Backspace = 8;
	final public static int CursorDown = 1005;
	final public static int CursorLeft = 1006;
	final public static int CursorRight = 1007;
	final public static int CursorUp = 1004;
	final public static int Delete = 127;
	final public static int End = 1001;
	final public static int Escape = 27;
	final public static int Home = 1000;
	final public static int Newline = 10;
	final public static int PageDown = 1003;
	final public static int PageUp = 1002;
	final public static int Tab = 9;
	final public static int F1 = 1008;
	final public static int F2 = 1009;
	final public static int F3 = 1010;
	final public static int F4 = 1011;
	final public static int F5 = 1012;
	final public static int F6 = 1013;
	final public static int F7 = 1014;
	final public static int F8 = 1015;
	final public static int F9 = 1016;
	final public static int F10 = 1017;
	final public static int F11 = 1018;
	final public static int F12 = 1019;
	public static int ActiveKey = 0;

public static boolean isAlphaNumKey ( int key) {
	if ( (key >= 32) && (key <=126) )
		return true;
	if ( (key >= 192) && (key <= 255) )
		return true;
	return false;
}

public static boolean isAltDown ( int mod) {
	return (( mod & Event.META_MASK) != 0);
}

public static boolean isCtrlDown ( int mod) {
	return (( mod & Event.CTRL_MASK) != 0);
}

public static boolean isLoneKey ( int mod) {
	return ( mod == 0);
}

public static boolean isShiftDown ( int mod) {
	return (( mod & Event.SHIFT_MASK) != 0);
}
}
