/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1995, 1996, 1997
 * Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the key surfaces of the Microsoft "Natural"
 * keyboard with spanish layout.
 * 
 * Created by Eduardo Perez <eduperez@redestb.es> from pc102es-caps.h
 * 
 */

static const struct key_strings ms105es_caps [] = {

  /* Row 0 */

  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"Impr", "Pant", 0},
  {"Bloq", "Despl", 0},
  {"Pausa", "", 0},

  /* Row 2 */

  {"\252", "\272 \\", 0},
  {"!", "1 |", 0},
  {"\"", "2 @", 0},
  {"\267", "3 #", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"&", "6 \254", 0},
  {"/", "7", 0},
  {"(", "8", 0},
  {")", "9", 0},
  {"=", "0", 0},
  {"?", "'", 0},
  {"\241", "\277", 0},
  {"Retroceso", 0},
  {"Insert", 0},
  {"Inicio", 0},
  {"Re", "Pag", 0},
  {"Bloq", "Num", 0},
  {"/", 0},
  {"*", 0},
  {"-", 0},

  /* Row 3 */

  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Y", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"^", "` [", 0},
  {"*", "+ ]", 0},
  {"Intro", 0},
  {"Supr", 0},
  {"Fin", 0},
  {"Av", "Pag", 0},
  {"7", "Inicio", 0},
  {"8", "UpArrow", 0},
  {"9", "Re Pag", 0},
  {"+", 0},

  /* Row 4 */

  {"Bloq", "Mayus", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {"\321", 0},
  {"\250", "' {", 0},
  {"\307", "  }", 0},
  {"4", "LeftArrow", 0},
  {"5", 0},
  {"6", "RightArrow", 0},

  /* Row 5 */

  {"UpArrow",0},
  {">", "<", 0},
  {"Z", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {";", ",", 0},
  {":", ".", 0},
  {"_", "-", 0},
  {"UpArrow", 0},
  {"UpArrow", 0},
  {"1", "Fin", 0},
  {"2", "DownArrow", 0},
  {"3", "Av Pag", 0},
  {"Intro", 0},

  /* Row 6 */

  {"Ctrl", 0},
  {"=/+/", 0},
  {"Alt", 0},
  {" ", 0},
  {"Alt Gr", 0},
  {"=/+/", 0},
  {"##", 0},
  {"Ctrl", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", "Ins", 0},
  {".", "Supr", 0}
};
