

/*
 * WindowMaker defaults DB writer
 */

#include "../src/wconfig.h"

#include <stdlib.h>
#include <stdio.h>

#include <proplist.h>

#include "../src/generic/wwmlib.h"

char *ProgName;

void wAbort()
{
    exit(0);
}

void help()
{
    printf("Syntax:\n%s <domain> <option> <value>\n", ProgName);
    exit(1);
}


int main(int argc, char **argv)
{
    char path[256];
    proplist_t dom, key, value, dict;
    char *gsdir;
    
    ProgName = argv[0];

    if (argc<4) {
	help();
    }
    
    dom = PLMakeString(argv[1]);
    key = PLMakeString(argv[2]);
    value = PLGetProplistWithDescription(argv[3]);
    if (!value) {
	wFatal("syntax error in value \"%s\"", argv[3]);
	exit(1);
    }
    gsdir = getenv("GNUSTEP_USER_ROOT");
    if (gsdir) {
	strcpy(path, gsdir);
    } else {
	strcpy(path, gethomedir());
	strcat(path, "/GNUstep");
    }
    strcat(path, "/");
    strcat(path, DEFAULTS_DIR);
    strcat(path, "/");
    strcat(path, argv[1]);

    dict = PLGetProplistWithPath(path);
    if (!dict) {
	dict = PLMakeDictionaryFromEntries(key, value, NULL);
	PLSetFilename(dict, PLMakeString(path));
    } else {
	PLRemoveDictionaryEntry(dict, key);
	PLInsertDictionaryEntry(dict, key, value);
    }
    
    PLSave(dict, YES);
	
    return 0;
}


