/***************************************
  $Header: /home/amb/wwwoffle/RCS/errors.h 2.3 1997/12/13 11:12:48 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.0.
  Error logging header file.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef ERRORS_H
#define ERRORS_H    /*+ To stop multiple inclusions. +*/

typedef enum _ErrorLevel
{
 Debug,                         /*+ For debugging, only if DEBUG is defined (not in syslog). +*/
 Inform,                        /*+ General information (not in syslog). +*/
 Important,                     /*+ Important information (notice in syslog). +*/
 Warning,                       /*+ A warning (warning in syslog). +*/
 Fatal                          /*+ A fatal error (err in syslog). +*/
}
ErrorLevel;

/* In errors.c */

void  InitErrorHandler(char *name,int syslogable,int stderrable);
char *PrintMessage(ErrorLevel errlev,const char* fmt, ...);

#endif /* ERRORS_H */
