/*
 * dsock.c - SunOS (Solaris 1.x and 2.x) socket processing functions for lsof
 */



/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.7 98/03/06 08:38:39 abe Exp $";
#endif


#include "lsof.h"


#if	defined(solaris)
/*
 * print_tcptpi() - print TCP/TPI info
 */

void
print_tcptpi(nl)
	int nl;				/* 1 == '\n' required */
{
	char *cp = (char *)NULL;
	char  sbuf[128];
	int i, t;
	int ps = 0;
	unsigned int u;

	if (Ftcptpi & TCPTPI_STATE) {
	    switch ((t = Lf->lts.type)) {
	    case 0:				/* TCP */
		switch ((i = Lf->lts.state.i)) {
		case TCPS_CLOSED:
		    cp = "CLOSED";
		    break;
		case TCPS_IDLE:
		    cp = "IDLE";
		    break;
		case TCPS_BOUND:
		    cp = "BOUND";
		    break;
		case TCPS_LISTEN:
		    cp = "LISTEN";
		    break;
		case TCPS_SYN_SENT:
		    cp = "SYN_SENT";
		    break;
		case TCPS_SYN_RCVD:
		    cp = "SYN_RCVD";
		    break;
		case TCPS_ESTABLISHED:
		    cp = "ESTABLISHED";
		    break;
		case TCPS_CLOSE_WAIT:
		    cp = "CLOSE_WAIT";
		    break;
		case TCPS_FIN_WAIT_1:
		    cp = "FIN_WAIT_1";
		    break;
		case TCPS_CLOSING:
		    cp = "CLOSING";
		    break;
		case TCPS_LAST_ACK:
		    cp = "LAST_ACK";
		    break;
		case TCPS_FIN_WAIT_2:
		    cp = "FIN_WAIT_2";
		    break;
		case TCPS_TIME_WAIT:
		    cp = "TIME_WAIT";
		    break;
		default:
		    (void) sprintf(sbuf, "UknownState_%d", i);
		    cp = sbuf;
		}
		break;
	    case 1:				/* TPI */
		switch ((u = Lf->lts.state.u)) {
		case TS_UNBND:
		    cp = "Unbound";
		    break;
		case TS_WACK_BREQ:
		    cp = "Wait_BIND_REQ_Ack";
		    break;
		case TS_WACK_UREQ:
		    cp = "Wait_UNBIND_REQ_Ack";
		    break;
		case TS_IDLE:
		    cp = "Idle";
		    break;
		case TS_WACK_OPTREQ:
		    cp = "Wait_OPT_REQ_Ack";
		    break;
		case TS_WACK_CREQ:
		    cp = "Wait_CONN_REQ_Ack";
		    break;
		case TS_WCON_CREQ:
		    cp = "Wait_CONN_REQ_Confirm";
		    break;
		case TS_WRES_CIND:
		    cp = "Wait_CONN_IND_Response";
		    break;
		case TS_WACK_CRES:
		    cp = "Wait_CONN_RES_Ack";
		    break;
		case TS_DATA_XFER:
		    cp = "Wait_Data_Xfr";
		    break;
		case TS_WIND_ORDREL:
		    cp = "Wait_Read_Release";
		    break;
		case TS_WREQ_ORDREL:
		    cp = "Wait_Write_Release";
		    break;
		case TS_WACK_DREQ6:
		case TS_WACK_DREQ7:
		case TS_WACK_DREQ9:
		case TS_WACK_DREQ10:
		case TS_WACK_DREQ11:
		    cp = "Wait_DISCON_REQ_Ack";
		    break;
		default:
		    (void) sprintf(sbuf, "UNKNOWN_TPI_STATE_%u", u);
		    cp = sbuf;
		}
	    }
	    if (Ffield)
		(void) printf("%cST=%s%c", LSOF_FID_TCPTPI, cp, Terminator);
	    else {
		putchar('(');
		(void) fputs(cp, stdout);
	    }
	    ps++;
	}

# if	defined(HASTCPTPIQ)
	if (Ftcptpi & TCPTPI_QUEUES) {
	    if (Lf->lts.rqs) {
		if (Ffield)
			putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("QR=%lu", Lf->lts.rq);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	    if (Lf->lts.sqs) {
		if (Ffield)
			putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("QS=%lu", Lf->lts.sq);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	}
# endif	/* defined(HASTCPTPIQ) */

# if	defined(HASTCPTPIW)
	if (Ftcptpi & TCPTPI_WINDOWS) {
	    if (Lf->lts.rws) {
		if (Ffield)
			putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("WR=%lu", Lf->lts.rw);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	    if (Lf->lts.wws) {
		if (Ffield)
			putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("WW=%lu", Lf->lts.ww);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	}
# endif	/* defined(HASTCPTPIW) */

	if (Ftcptpi && !Ffield && ps)
	    putchar(')');
	if (nl)
	    putchar('\n');
}


/*
 * process_socket() - process Solaris socket
 */

void
process_socket(sa, ty)
	KA_T sa;			/* stream's data address in kernel */
	char *ty;			/* socket type name */
{
	struct in_addr *fa = (struct in_addr *)NULL;
	int fp = 0;
	int i, lp;
	struct ipc_s ic;
	int ics = 0;
	struct in_addr *la = (struct in_addr *)NULL;
	struct module_info mi;
	KA_T ka, qp;
	u_short p;
	KA_T pcb = (KA_T)NULL;
	struct queue q;
	struct qinit qi;
	u_short *s;
	struct stdata sd;
	char tbuf[32];

# if	solaris<20600
	struct tcp_s {			/* should come from kernel source
					 * file ../uts/common/inet/tcp.c */

#  if	solaris>=20400
	    struct tcp_s *d1[8];
#  endif	/* solaris>=20400 */

#  if	defined(P101318) && P101318>=32
	    struct tcp_s *d1[6];
#  endif	/* defined(P101318) && P101318>=32 */

	    int tcp_state;
	    queue_t *d3[2];
	    mblk_t *d4[2];
	    u_long d5;
	    mblk_t *d6;
	    u_long d7;
	    u_long tcp_snxt;	/* Senders next seq num */
	    u_long tcp_suna;	/* Sender unacknowledged */
	    u_long tcp_swnd;	/* Senders window (relative to suna) */
	    u_long d8[5];
	    int tcp_hdr_len;	/* combined TCP/IP header length */
	    tcph_t *tcp_tcph;	/* pointer to combined header */
	    int d9;
	    unsigned int d10;
	    int d11;
	    mblk_t *d12;
	    long d13;
	    mblk_t *d14;
	    u_long d15;

#  if	solaris<20400 && (!defined(P101318) || P101318<32)
	    mblk_t *d16;
#  endif	/* solaris<20400 && (!defined(P101318) || P101318<32) */

	    unsigned int d17;
	    u_long tcp_rnxt;	/* Seq we expect to recv next */
	    u_long tcp_rwnd;	/* Current receive window */
	    u_long d18;
	    long d19[2];
	    mblk_t *d20[4];
	    u_long d21[5];
	    long d22[3];

#  if	solaris<20500
	    u_long d23[2];
	    u_long tcp_rack;	/* Seq # we have acked */
#  else	/* solaris>=20500 */
	    u_long d23[3];
#  endif	/* solaris<20500 */

#  if	solaris<20400
	    u_long d24[28];
#  else	/* solaris>=20400 */
#   if	solaris<20500
	    u_long d24[67];
#   else	/* solaris>=20500 */
	    u_long d25[8];
	    u_long tcp_rack;	/* Seq # we have acked */
	    u_long d26[58];
#   endif	/* solaris<20500 */
#  endif	/* solaris<20400 */

	    iph_t tcp_iph;
	} tc;
# else	/* solaris>=20600 */
	struct tcp_s tc;
# endif	/* solaris<20600 */

	int tcs = 0;
	tcph_t th;
	struct ud_s {			/* should come from kernel source
					 * file ../uts/common/inet/udp.c */
	    uint udp_state;
	    u8 dummy2[2];
	    u8 udp_port[2];		/* port bound to this stream */
	    u8 udp_src[4];		/* source address of this stream */
	} uc;
	int ucs = 0;

	if (Fnet)
	    Lf->sf |= SELNET;
	(void) strcpy(Lf->type, "inet");
	Lf->inp_ty = 2;
/*
 * Convert type to upper case protocol name.
 */
	if (ty) {
	    for (i = 0; ty[i] != '\0' && i < IPROTOL; i++) {
		if (islower((unsigned char)ty[i]))
		    Lf->iproto[i] = toupper((unsigned char)ty[i]);
		else
		    Lf->iproto[i] = ty[i];
	    }
	} else
	    i = 0;
	Lf->iproto[i] = '\0';
/*
 * Read stream queue entries to obtain private IP, TCP, and UDP structures.
 */
	if (!sa || readstdata(sa, &sd))
	    qp = (KA_T)NULL;
	else
	    qp = (KA_T)sd.sd_wrq;
	for (i = 0; qp && i < 20; i++, qp = (KA_T)q.q_next) {
	    if (kread(qp, (char *)&q, sizeof(q)))
		break;
	    if ((ka = (KA_T)q.q_qinfo) == (KA_T)NULL
	    ||  kread(ka, (char *)&qi, sizeof(qi)))
		continue;
	    if ((ka = (KA_T)qi.qi_minfo) == (KA_T)NULL
	    ||  kread(ka, (char *)&mi, sizeof(mi))
	    ||  (ka = (KA_T)mi.mi_idname) == (KA_T)NULL)
		continue;
	    if (kread(ka, (char *)&tbuf, sizeof(tbuf) - 1))
		continue;
	    if ((pcb = (KA_T)q.q_ptr) == (KA_T)NULL)
		continue;
	    if (strncasecmp(tbuf, "IP",  2) == 0) {
		if (kread(pcb, (char *)&ic, sizeof(ic)) == 0)
		    ics = 1;
		continue;
	    }
	    if (strncasecmp(tbuf, "TCP", 3) == 0) {
		if (kread((KA_T)q.q_ptr, (char *)&tc, sizeof(tc)) == 0)
		    tcs = 1;
		continue;
	    }
	    if (strncasecmp(tbuf, "UDP", 3) == 0) {
		if (kread((KA_T)q.q_ptr, (char *)&uc, sizeof(uc)) == 0)
		    ucs = 1;
		continue;
	    }
	}
	if (ics) {

	/*
	 * Print stream head's q_ptr address as protocol control block address.
	 */
	    if (pcb)
		enter_dev_ch(print_kptr(pcb, (char *)NULL));
	    if (strcmp(Lf->iproto, "UDP") == 0) {

	/*
	 * Save UDP address and TPI state.
	 */

# if	solaris<20600
		la = (struct in_addr *)&ic.ipc_udp_addr;
		p = (u_short)ic.ipc_udp_port;
# else	/* solaris>=20600 */
		la = (struct in_addr *)&ic.ipc_faddr;
		p = (u_short)ic.ipc_fport;
# endif	/* solaris<20600 */

		if (la->s_addr == INADDR_ANY && p == 0 && ucs) {

		/*
		 * If the ipc_s structure has no local address, read
		 * the ud_s structure for the stream one back.
		 */
		    s = (u_short *)&uc.udp_port[0];
		    p = *s;
		}
		(void) ent_inaddr(la,(int)ntohs(p),(struct in_addr *)NULL,-1);
		if (!Fsize)
		    Lf->off_def = 1;
		if (ucs) {
		    Lf->lts.type = 1;
		    Lf->lts.state.u = (unsigned int)uc.udp_state;
		}
	    } else if (strcmp(Lf->iproto, "TCP") == 0) {

	    /*
	     * Save TCP address.
	     */

# if	solaris<20400
		la = (struct in_addr *)&ic.ipc_tcp_addr[0];
		p = (u_short)ic.ipc_tcp_addr[5];
# else	/* solaris>=20400 */
#  if	solaris<20600
		la = (struct in_addr *)&ic.ipc_tcp_laddr;
		p = (u_short)((short *)&ic.ipc_tcp_ports)[1];
#  else	/* solaris>=20600 */
		la = (struct in_addr *)&ic.ipc_laddr;
		p = (u_short)ic.ipc_lport;
#  endif	/* solaris<20600 */
# endif	/* solaris<20400 */

		if (la->s_addr == INADDR_ANY && p == 0 && tcs) {

		/*
		 * If the ipc_s structure has no local address, use the local
		 * address in its tcp_iph structure (except for Solaris 2.4),
		 * and the port number in its tcph structure.
		 */

# if	solaris!=20400
		    la = (struct in_addr *)&tc.tcp_iph.iph_src[0];
# endif	/* solaris!=20400 */

		    if (tc.tcp_hdr_len && tc.tcp_tcph
		    &&  !kread((KA_T)tc.tcp_tcph, (char *)&th, sizeof(th))) {
			s = (u_short *)&th.th_lport[0];
			p = *s;
		    }
		}
		lp = (int)ntohs(p);

# if	solaris<20400
		if ((int)ic.ipc_tcp_addr[2] != INADDR_ANY
		|| ic.ipc_tcp_addr[4] != 0) {
		    fa = (struct in_addr *)&ic.ipc_tcp_addr[2];
		    fp = (int)ntohs(ic.ipc_tcp_addr[4]);
		}
# else	/* solaris>=20400 */
#  if	solaris<20600
		if ((int)ic.ipc_tcp_faddr != INADDR_ANY
		|| ((u_short *) &ic.ipc_tcp_ports)[0] != 0)
		{
		    fa = (struct in_addr *)&ic.ipc_tcp_faddr;
		    fp = (int)ntohs(((u_short *)&ic.ipc_tcp_ports)[0]);
		}
#  else	/* solaris>=20600 */
		if ((int)ic.ipc_faddr != INADDR_ANY || ((u_short)ic.ipc_fport))
		{
		    fa = (struct in_addr *)&ic.ipc_faddr;
		    fp = (int)ntohs(((u_short)ic.ipc_fport));
		}
#  endif	/* solaris<20600 */
# endif	/* solaris <20400 */

		if (fa || la)
		    (void) ent_inaddr(la, lp, fa, fp);
	    /*
	     * Save TCP state information.
	     */
		if (tcs) {
		    Lf->lts.type = 0;
		    Lf->lts.state.i = (int)tc.tcp_state;
		}
	    /*
	     * Save TCP size information.
	     */

# if	defined(HASTCPTPIQ) || defined(HASTCPTPIW)
		if (tcs) {

		    int rq, sq;

#  if	defined(HASTCPTPIW)
		    Lf->lts.rw = (int)tc.tcp_rwnd;
		    Lf->lts.ww = (int)tc.tcp_swnd;
		    Lf->lts.rws = Lf->lts.wws = 1;
#  endif	/* defined(HASTCPTPIW) */

		    if ((rq = (int)tc.tcp_rnxt - (int)tc.tcp_rack) < 0)
			rq = 0;
		    if ((sq = (int)tc.tcp_snxt - (int)tc.tcp_suna - 1) < 0)
			sq  = 0;

#  if	defined(HASTCPTPIQ)
		    Lf->lts.rq = (unsigned long)rq;
		    Lf->lts.sq = (unsigned long)sq;
		    Lf->lts.rqs = Lf->lts.sqs = 1;
#  endif	/* defined(HASTCPTPIQ) */

		    if (Fsize) {
			if (Lf->access == 'r')
			    Lf->sz = (SZOFFTYPE)rq;
			else if (Lf->access == 'w')
			    Lf->sz = (SZOFFTYPE)sq;
			else
			    Lf->sz = (SZOFFTYPE)(rq + sq);
			Lf->sz_def = 1;
		    } else
			Lf->off_def = 1;
		}
# else	/* !defined(HASTCPTPIQ) && !defined(HASTCPTPIW) */
		Lf->off_def = 1;
# endif	/* defined(HASTCPTPIQ) || defined(HASTCPTPIW) */

	    } else {
		if (!Fsize)
		    Lf->off_def = 1;
	    }
	} else
	    (void) strcat(Namech, "no TCP/UDP/IP information available");
/*
 * Enter name charcters if there are some.
 */
	if (Namech[0])
	    enter_nm(Namech);
}
#else	/* !solaris */


/*
 * process_socket() - process non-Solaris socket
 */

void
process_socket(sa)
	KA_T sa;			/* socket address in kernel */
{
	struct domain d;
	struct in_addr *fa = (struct in_addr *)NULL;
	int fam;
	int fp, lp;
	struct inpcb inp;
	struct in_addr *la = (struct in_addr *)NULL;
	struct mbuf mb;
	struct protosw p;
	struct rawcb raw;
	struct socket s;
	struct tcpcb t;
	struct unpcb uc, unp;
	struct sockaddr_un *ua = NULL;
	struct sockaddr_un un;

	(void) strcpy(Lf->type, "sock");
	Lf->inp_ty = 2;
/*
 * Read socket, protocol, and domain structures.
 */
	if (!sa) {
	    enter_nm("no socket address");
	    return;
	}
	if (kread(sa, (char *) &s, sizeof(s))) {
	    (void) sprintf(Namech, "can't read socket struct from %s",
		print_kptr(sa, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
	if (!s.so_type) {
	    enter_nm("no socket type");
	    return;
	}
	if (s.so_proto == NULL
	||  kread((KA_T) s.so_proto, (char *) &p, sizeof(p))) {
	    enter_nm("no protocol switch");
	    return;
	}
	if (kread((KA_T) p.pr_domain, (char *) &d, sizeof(d))) {
	    (void) sprintf(Namech, "can't read domain struct from %s",
		print_kptr((KA_T)p.pr_domain, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
/*
 * Save size information.
 */
	if (Fsize) {
	    if (Lf->access == 'r')
		Lf->sz = (SZOFFTYPE)s.so_rcv.sb_cc;
	    else if (Lf->access == 'w')
		Lf->sz = (SZOFFTYPE)s.so_snd.sb_cc;
	    else
		Lf->sz = (SZOFFTYPE)(s.so_rcv.sb_cc + s.so_snd.sb_cc);
	    Lf->sz_def = 1;
	} else
	    Lf->off_def = 1;

# if	defined(HASTCPTPIQ)
	Lf->lts.rq = s.so_rcv.sb_cc;
	Lf->lts.sq = s.so_snd.sb_cc;
	Lf->lts.rqs = Lf->lts.sqs = 1;
# endif	/* defined(HASTCPTPIQ) */

/*
 * Process socket by the associated domain family.
 */
	switch ((fam = d.dom_family)) {
/*
 * Process an Internet domain socket.
 */
	case AF_INET:
	    if (Fnet)
		Lf->sf |= SELNET;
	    (void) strcpy(Lf->type, "inet");
	    printiproto(p.pr_protocol);
	/*
	 * Read protocol control block.
	 */
	    if (!s.so_pcb) {
		enter_nm("no protocol control block");
		return;
	    }
	    if (s.so_type == SOCK_RAW) {

	    /*
	     * Print raw socket information.
	     */
		if (kread((KA_T) s.so_pcb, (char *)&raw, sizeof(raw))
		||  (struct socket *)sa != raw.rcb_socket) {
		    (void) sprintf(Namech, "can't read rawcb at %s",
			print_kptr((KA_T)s.so_pcb, (char *)NULL));
		    enter_nm(Namech);
		    return;
		}
		enter_dev_ch(print_kptr((KA_T)(raw.rcb_pcb ? raw.rcb_pcb
							   : s.so_pcb),
					(char *)NULL));
		if (raw.rcb_laddr.sa_family == AF_INET)
		    la = (struct in_addr *)&raw.rcb_laddr.sa_data[2];
		else if (raw.rcb_laddr.sa_family)
		    printrawaddr(&raw.rcb_laddr);
		if (raw.rcb_faddr.sa_family == AF_INET)
		    fa = (struct in_addr *)&raw.rcb_faddr.sa_data[2];
		else if (raw.rcb_faddr.sa_family) {
		    (void) strcat(endnm(), "->");
		    printrawaddr(&raw.rcb_faddr);
		}
		if (fa || la)
		    (void) ent_inaddr(la, -1, fa, -1);
	    } else {

	    /*
	     * Save Internet socket information.
	     */
		if (kread((KA_T)s.so_pcb, (char *) &inp, sizeof(inp))
		||  (struct socket *)sa != inp.inp_socket) {
		    (void) sprintf(Namech, "can't read inpcb at %s",
			print_kptr((KA_T)s.so_pcb, (char *)NULL));
		    enter_nm(Namech);
		    return;
		}
		enter_dev_ch(print_kptr((KA_T)(inp.inp_ppcb ? inp.inp_ppcb
							    : s.so_pcb),
					(char *)NULL));
		la = &inp.inp_laddr;
		lp = (int)ntohs(inp.inp_lport);
		if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport != 0) {
		    fa = &inp.inp_faddr;
		    fp = (int)ntohs(inp.inp_fport);
		}
		if (fa || la)
		    (void) ent_inaddr(la, lp, fa, fp);
		if (p.pr_protocol == IPPROTO_TCP
		&&  inp.inp_ppcb
		&&  kread((KA_T)inp.inp_ppcb, (char *)&t, sizeof(t)) == 0) {
		    Lf->lts.type = 0;
		    Lf->lts.state.i = (int)t.t_state;
		}
	    }
	    break;
/*
 * Process a Unix domain socket.
 */
	case AF_UNIX:
	    if (Funix)
		Lf->sf |= SELUNX;
	    (void) strcpy(Lf->type, "unix");
	/*
	 * Read Unix protocol control block and the Unix address structure.
	 */
	    enter_dev_ch(print_kptr(sa, (char *)NULL));
	    if (kread((KA_T) s.so_pcb, (char *) &unp, sizeof(unp))) {
		(void) sprintf(Namech, "can't read unpcb at %s",
		    print_kptr((KA_T)s.so_pcb, (char *)NULL));
		break;
	    }
	    if ((struct socket *)sa != unp.unp_socket) {
		(void) sprintf(Namech, "unp_socket (%s) mismatch",
		    print_kptr((KA_T)unp.unp_socket, (char *)NULL));
		break;
	    }
	    if (unp.unp_addr) {
		if (kread((KA_T)unp.unp_addr, (char *) &mb, sizeof(mb))) {
		    (void) sprintf(Namech, "can't read unp_addr at %s",
			print_kptr((KA_T)unp.unp_addr, (char *)NULL));
		    break;
		}
		ua = (struct sockaddr_un *)(((char *)&mb) + mb.m_off);
	    }
	    if (!ua) {
		ua = &un;
		(void) bzero((char *)ua, sizeof(un));
		ua->sun_family = AF_UNSPEC;
	    }
	/*
	 * Print information on Unix socket that has no address bound
	 * to it, although it may be connected to another Unix domain
	 * socket as a pipe.
	 */
	    if (ua->sun_family != AF_UNIX) {
		if (ua->sun_family == AF_UNSPEC) {
		    if (unp.unp_conn) {
			if (kread((KA_T)unp.unp_conn,(char *)&uc,sizeof(uc))) {
			    (void) sprintf(Namech, "can't read unp_conn at %#x",
				print_kptr((KA_T)unp.unp_conn, (char *)NULL));
			} else
			    (void) sprintf(Namech, "->%s",
				print_kptr((KA_T)uc.unp_socket, (char *)NULL));
		    } else
			(void) strcpy(Namech, "->(none)");
		} else
		    (void) sprintf(Namech, "unknown sun_family (%d)",
			ua->sun_family);
		break;
	    }
	    if (ua->sun_path[0]) {
		if (mb.m_len >= sizeof(struct sockaddr_un))
		    mb.m_len = sizeof(struct sockaddr_un) - 1;
		*((char *)ua + mb.m_len) = '\0';
		if (Sfile && is_file_named(ua->sun_path, Ntype, VSOCK, 0))
		    Lf->sf |= SELNM;
		(void) strcpy(Namech, ua->sun_path);
	    } else
		(void) strcpy(Namech, "no address");
	    break;
	default:
	    printunkaf(fam);
	}
	if (Namech[0])
	    enter_nm(Namech);
}
#endif	/* solaris */
