/*
 * dmnt.c - SCO OpenServer mount support functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.4 98/03/06 08:25:33 abe Exp $";
#endif


#include "lsof.h"


/*
 * readmnt() - read mount table
 */

int
readmnt()

{
	int br, fd;
	int bx = sizeof(struct mnttab);
	char *cp;
	char dvnm[MAXPATHLEN], fsnm[MAXPATHLEN];
 	MALLOC_S dvnml, fsnml;
	int err = 0;
	MALLOC_S len;
	char *ln = (char *)NULL;
	struct mnttab m;
	struct mounts *mtp;
	struct stat sb;
/*
 * Open access to the mount table.
 */
	if ((fd = open(MNTTAB, O_RDONLY, 0)) < 0) {
	    (void) fprintf(stderr, "%s: can't open %s\n", Pn, MNTTAB);
	    return(0);
	}
/*
 * Read the first mount table entry.
 */
	br = read(fd, (char *)&m, bx);
	dvnml = fsnml = 0;
/*
 * Process the next complete mount table entry.
 */
	while (br == bx) {
	    if (!dvnml) {

	    /*
	     * Start the device and file system name assemblies.
	     */
		dvnml = strlen(m.mt_dev);
		if (dvnml >= MAXPATHLEN)
		    dvnml = MAXPATHLEN - 1;
		(void) strncpy(dvnm, m.mt_dev, dvnml);
		dvnm[dvnml] = '\0';
		fsnml = strlen(m.mt_filsys);
		if (fsnml >= MAXPATHLEN)
		    fsnml = MAXPATHLEN - 1;
		(void) strncpy(fsnm, m.mt_filsys, fsnml);
		fsnm[fsnml] = '\0';
	    }
	    while ((br = read(fd, (char *)&m, bx)) == bx
	    &&      strcmp(m.mt_filsys, "nothing") == 0
	    &&	    strcmp(m.mt_dev,    "nowhere") == 0) {

	    /*
	     * Add the "nothing/nowhere" extensions to the assemblies.
	     */
		len = strlen(&m.mt_dev[8]);
		if (len >= (MAXPATHLEN - dvnml))
		    len = MAXPATHLEN - dvnml - 1;
		if (len) {
		    (void) strncpy(&dvnm[dvnml], &m.mt_dev[8], len);
		    dvnml += len;
		    dvnm[dvnml] = '\0';
		}
		len = strlen(&m.mt_filsys[8]);
		if (len >= (MAXPATHLEN - fsnml))
		    len = MAXPATHLEN - fsnml - 1;
		if (len) {
		    (void) strncpy(&fsnm[fsnml], &m.mt_filsys[8], len);
		    fsnml += len;
		    fsnm[fsnml] = '\0';
		}
	    }
	/*
	 * Skip automount place markers.
	 */
	    if ((cp = strrchr(dvnm, ':')) && strncmp(cp, ":(pid", 5) == 0) {
		dvnml = fsnml = 0;
		continue;
	    }
	/*
	 * Interpolate a possible symbolic directory link.
	 */
	    if (ln) {
		(void) free((FREE_P *)ln);
		ln = (char *)NULL;
	    }
	    if (!(ln = Readlink(fsnm))) {
		if (!Fwarn){
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		}
		err = 2;
		dvnml = fsnml = 0;
		continue;
	    }
	    if (ln == fsnm) {

	    /*
	     * Allocate space for a copy of the file system name.
	     */
		if (!(ln = mkstrcpy(fsnm, (MALLOC_S *)NULL))) {
		    err = 1;
		    break;
		}
	    }
	/*
	 * Stat() the directory.
	 */
	    if (statsafely(ln, &sb)) {
		if (!Fwarn) {
		    (void) fprintf(stderr,
			"%s: WARNING: can't stat() file system: ", Pn);
		    safestrprt(fsnm, stderr, 1);
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		}
		err = 2;
		dvnml = fsnml = 0;
		continue;
	    }
	/*
	 * Allocate and fill a local mount structure.
	 */
	    if (!(mtp = (struct mounts *)malloc(sizeof(struct mounts)))) {
		err = 1;
		break;
	    }
	    mtp->dir = ln;
	    ln = (char *)NULL;
	    mtp->next = Mtab;
	    mtp->dev = sb.st_dev;
	    mtp->rdev = sb.st_rdev;
	    mtp->inode = sb.st_ino;
	    mtp->mode = sb.st_mode;
	/*
	 * Interpolate a possible file system (mounted-on) device name link
	 */
	    if (!(cp = mkstrcpy(dvnm, (MALLOC_S *)NULL))) {
		err = 1;
		break;
	    }
	    mtp->fsname = cp;
	    ln = Readlink(cp);
	/*
	 * Stat() the file system (mounted-on) name and add file system
	 * information to the local mount table entry.
	 */
	    if (statsafely(ln, &sb))
		sb.st_mode = 0;
	    mtp->fsnmres = ln;
	    ln = (char *)NULL;
	    mtp->fs_mode = sb.st_mode;
	    Mtab = mtp;
	    dvnml = fsnml = 0;
	}
	(void) close(fd);
/*
 * Clean up and handle errors.
 */
	if (ln)
	    (void) free((FREE_P *)ln);
	switch (err) {
	case 1:
	    (void) fprintf(stderr, "%s: no space for mount at ", Pn);
	    safestrprt(fsnm, stderr, 0);
	    (void) fprintf(stderr, " (");
	    safestrprt(dvnm, stderr, 0);
	    (void) fprintf(stderr, ")\n");
	    return(0);
	case 2:
	    return(1);
	}
	return(1);
}
