/* ----------------------------------------------------------------------- *
 *   
 *  mount.c - Abstract mount code used by modules for an unexpected
 *            filesystem type
 *
 *   Copyright 1997 Transmeta Corporation - All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
 *   USA; either version 2 of the License, or (at your option) any later
 *   version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 * ----------------------------------------------------------------------- */

#include <syslog.h>
#include <stdlib.h>
#include "automount.h"

/* These filesystems are known not to work with the "generic" module */
static char *not_generic[] = { "nfs", "smbfs", "ncpfs", "userfs",
			       "autofs", NULL };

int do_mount(char *root, char *name, int name_len, char *what, char *fstype,
	     char *options)
{
  struct mount_mod *mod;
  char **ngp, *modstr;
  int rv;

  mod = open_mount(modstr = fstype, NULL);
  if ( !mod ) {
    for ( ngp = not_generic ; *ngp ; ngp++ ) {
      if ( !strcmp(fstype, *ngp) ) break;
    }
    if ( ! *ngp )
      mod = open_mount(modstr = "generic", NULL);
    if ( !mod ) {
      syslog(LOG_ERR, "cannot find mount method for filesystem %s", fstype);
      return -1;
    }
  }
  syslog(LOG_DEBUG, "do_mount %s %s/%s type %s options %s using module %s",
	 what, root, name, fstype, options, modstr);

  rv = mod->mount_mount(root,name,name_len,what,fstype,options,mod->context);
  close_mount(mod);

  return rv;
}
