/* $Id: ukdate.cc,v 1.2 1997/03/31 23:39:20 dps Exp $ */
/* Date formatter for the UK */
#include <time.h>
#include <string.h>
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

char *uk_date(time_t when)
{
    static const char *months[]=
    {
	"Janurary", "Februrary", "March", "April",
	"May", "June", "July", "August",
	"September", "October", "November", "December",
    };

    struct tm *tim;
    char date_buf[200];
    const char *postfix;
    
    tim=localtime(&when);
    switch (tim->tm_mday % 10)
    {
    case 1:
	postfix="st";
	break;

    case 2:
	postfix="nd";
	break;

    case 3:
	postfix="rd";
	break;

    default:
	postfix="th";
	break;
    }

    sprintf(date_buf, "%d%s %s, %d", tim->tm_mday, postfix,
	    months[tim->tm_mon], 1900+tim->tm_year);
    
    return strdup(date_buf);
}


    
