/*  
 *  This file is part of abc2ps, Copyright (C) 1996,1997  Michael Methfessel
 *  See file abc2ps.c for details.
 */

/*  subroutines connected with parsing the input file  */

/* ----- sytax: print message for syntax errror -------- */
void syntax (msg, q)
char msg[];
char *q;
{
  int i,n,len,m1,m2,pp,qq,maxcol=65;
  
  if (verbose<=2) printf ("\n");  
  qq=q-p0+1;
  if (qq<0) qq=0;
  printf ("++++ %s in line %d.%d \n", msg, linenum, qq);
  m1=0;
  m2=len=strlen(p0);
  n=q-p0;
  if (m2>maxcol) {
    if (n<maxcol) 
      m2=maxcol;
    else {
      m1=n-10;
      m2=m1+maxcol;
      if (m2>len) m2=len;
    }
  }

  printf ("%4d ", linenum);
  pp=5;
  if (m1>0) { printf ("..."); pp+=3; }
  for (i=m1;i<m2;i++) printf ("%c", p0[i]);
  if (m2<len) printf ("...");
  printf ("\n"); 

  if (n>=0 && n<200) {
    for (i=0;i<n+pp-m1;i++) printf(" ");
    printf ("^\n"); 
  }
}

/* ----- isnote: checks char for valid note symbol ----- */
int isnote (c)
char c;
{
  if (c == '\0') return 0;
  if (strchr("CDEFGABcdefgab^=_",c)) return 1;
  return 0;
}

/* ----- zero_sym: init global zero SYMBOL struct ----- */
void zero_sym ()
{
  int j;
  zsym.type      = 0;
  zsym.npitch    = 0;
  zsym.word_st   = 0;
  zsym.word_end  = 0;
  zsym.slur_st   = 0;
  zsym.slur_end  = 0;
  zsym.len       = 0;
  zsym.yadd      = 0;
  zsym.xs        = 0;
  zsym.ys        = 0;
  zsym.stem      = 0;
  zsym.eoln      = 0;
  zsym.ylo       = 12;
  zsym.yhi       = 12;
  zsym.u         = 0;
  zsym.v         = 0;
  zsym.w         = 0;
  zsym.t         = 0;
  zsym.q         = 0;
  zsym.invis     = 0;
  zsym.z         = 0;
  zsym.wl        = 0;
  zsym.wr        = 0;
  zsym.pr        = 0;
  zsym.pl        = 0;
  zsym.p_plet    = 0;
  zsym.q_plet    = 0;
  zsym.r_plet    = 0;
  zsym.gchy      = 0;
  zsym.gr.n      = 0;
  zsym.dc.n      = 0;
  zsym.dc.top    = 0;
  strcpy (zsym.text, "");
  for (j=0;j<MAXHD;j++) zsym.sl1[j]=zsym.sl2[j]=0;

  for (j=0;j<NWLINE;j++) zsym.wordp[j] = 0;
}

/* ----- add_sym: returns index for new symbol at end of list ---- */
int add_sym (type)
int type;
{
  int k;

  if (nsym>=MAXSYMS) bug("Internal dimension MAXSYMS too small", 1);

  k=nsym;
  nsym++;
  sym[k]=zsym;
  sym[k].type = type;
  return k;
}

/* ----- insert_sym: returns index for new symbol inserted at k --- */
int insert_sym (type,k)
int type,k;
{
  int i;

  if (nsym>=MAXSYMS) bug("Internal dimension MAXSYMS too small", 1);

  for (i=nsym;i>k;i--) sym[i]=sym[i-1];
  nsym++;
  sym[k]=zsym;
  sym[k].type = type;
  return k;
}

/* ----- get_xref: get xref from string ----- */
int get_xref (str)
char str[];
{
  
  int a,ok;
  char *q;

  if (strlen(str)==0) {
    wng ("xref string is empty", "");
    return 0;
  }
  q=str;
  ok=1;
  while (*q != '\0') {
    if (!isdig(*q)) ok=0;
    q++;
  }
  if (!ok) {
    wng ("xref string has invalid symbols: ", str);
    return 0;
  }

  sscanf (str, "%d", &a);

  return a;
}

/* ----- set_meter: set meter from string ---- */
void set_meter (str)
char str[];
{

  int m1,m2,m1a,m1b,m1c,d,l;
  char *q;

  l=strlen(str);
  if (l==0) { wng("Empty meter string", ""); return; }
  if (str[0]=='C') {
    if (str[1]=='|') {
      meter1=2;
      meter2=4;
      dlen=EIGHTH;
      mflag=2;
      strcpy(meter_top,"C");
    }
    else {
      meter1=4;
      meter2=4;
      dlen=EIGHTH;
      mflag=1;
      strcpy(meter_top,"C");
    }
  }
  else {
    m1=m2=m1a=m1b=m1c=0;
    strcpy (meter_top, str);
    q=strchr(meter_top,'/');
    if (!q) {
      wng("Cannot identify meter, missing /: ", str); 
      m1=m2=1;
      return;
    }
    *q='\0';
    if (strchr(meter_top,'+')) {
      sscanf(str,"%d+%d+%d/", &m1a, &m1b, &m1c);
      m1=m1a+m1b+m1c;
    }
    else {
      sscanf(str,"%d %d %d/", &m1a, &m1b, &m1c);
      m1=m1a; if (m1b>m1) m1=m1b; if (m1c>m1) m1=m1c;
      if (m1>30) {            /* handle things like 78/8 */
        m1a=m1/100;
        m1c=m1-100*m1a;
        m1b=m1c/10;
        m1c=m1c-10*m1b;
        m1=m1a; if (m1b>m1) m1=m1b; if (m1c>m1) m1=m1c;
      }
    }

    q++;
    sscanf (q, "%d", &m2);

    if (m1*m2 == 0) { 
      wng("Cannot identify meter: ", str); 
      m1=m2=1;
      return; 
    }

    d=BASE/m2;
    if (d*m2 != BASE) { 
      wng("Meter not recognized: ", str);
      return;
    }
    meter1=m1;
    meter2=m2;
    dlen=EIGHTH;
    if (4*meter1 < 3*meter2) dlen=SIXTEENTH;
    mflag=0;
  }
  
  /* handle old-style change of default length */
  lflag=0;
  if (str[l-1]=='s') { dlen=dlen*2; lflag=1; }
  if (str[l-1]=='l') { dlen=dlen/2; lflag=-1; }

  if (verbose>=4) 
    printf ("Meter <%s> is %d over %d with default length 1/%d\n", 
            str, meter1, meter2, BASE/dlen);
}


/* ----- get_sharps_flats: set sharps and flats from string ------ */
/* This part was adapted from abc2mtex by Chris Walshaw */
/* updated 03 Oct 1997 Wil Macaulay - support all modes */
void get_sharps_flats(s,sh_fl,ktype)
char s[];
int *sh_fl,*ktype;
{
  int c,sf,j,ok;
  char w[81];

  /* check for "treble" "bass" "alto" with no other information */
  *ktype=TREBLE;
  y_add=0;
  if (!strcmp(s,"bass")) {
    *ktype=BASS;
    y_add=-6;
    return;
  }
  if (!strcmp(s,"treble")) {
    *ktype=TREBLE;
    y_add=0;
    return;
  }
  if (!strcmp(s,"alto")) {
    *ktype=ALTO;
    y_add=-3;
    return;
  }

  c=0;
  bagpipe=0;
  switch (s[c]) {
  case 'F':
    sf = -1;
    break;
  case 'C':
    sf = 0;
    break;
  case 'G':
    sf = 1;
    break;
  case 'D':
    sf = 2;
    break;
  case 'A':
    sf = 3;
    break;
  case 'E':
    sf = 4;
    break;
  case 'B':
    sf = 5;
    break;
  case 'H':
    bagpipe=1;
    c++;
    if      (s[c] == 'P') sf=0;
    else if (s[c] == 'p') sf=2;
    else wng("unknown bagpipe-like key: ",s);
    break;
  default:
    wng ("Using C because key not recognised: ", s);
    sharps_flats=transpose;
    return;
  }
  c++;
  if (s[c] == '#') {
    sf += 7;
    c += 1;
  } else if (s[c] == 'b') {
    sf -= 7;
    c += 1;
  }

  /* get the next token in lower case */
  while (s[c] == ' ') c++;
  j=0;
  while ((s[c]!=' ') && (s[c]!='\0')) { w[j]=tolower(s[c]); c++; j++; }
  w[j]='\0';
  
  ok=0;
  if ((strncmp(w,"mix",3)) == 0) {
    sf -= 1;
    ok = 1;
  /* dorian mode on the second note (D in C scale) */
  } else if ((strncmp(w,"dor",3)) == 0) {
    sf -= 2;
    ok = 1;
  /* phrygian mode on the third note (E in C scale) */
  } else if ((strncmp(w,"phr",3)) == 0) {
    sf -= 4;
    ok = 1;
  /* lydian mode on the fourth note (F in C scale) */
  } else if ((strncmp(w,"lyd",3)) == 0) {
    sf += 1;
    ok = 1;
  /* locrian mode on the seventh note (B in C scale) */
  } else if ((strncmp(w,"loc",3)) == 0) {
    sf -= 5;
    ok = 1;
  /* major and ionian are the same keysig */
  } else if ((strncmp(w,"maj",3)) == 0) {
    ok = 1;
  } else if ((strncmp(w,"ion",3)) == 0) {
    ok = 1;
  /* aeolian, m, and minor are the same keysig - sixth note (A in C scale) */
  } else if ((strncmp(w,"aeo",3)) == 0) {
    sf -= 3;
    ok = 1;
  } else if ((strncmp(w,"min",3)) == 0) {
    sf -= 3;
    ok = 1;
  } else if ((strcmp(w,"m")) == 0) {
    sf -= 3;
    ok = 1;
  } 

  /* if valid mode was found, get next token */
  if (ok) {
    while (s[c] == ' ') c++;
    j=0;
    while ((s[c]!=' ') && (s[c]!='\0')) { w[j]=s[c]; c++; j++; }
    w[j]='\0';
  }


  /* check for following "bass" "treble" "alto" */
  if (strlen(w)>0) {
  
    if (!strcmp(w,"bass")) {
      *ktype=BASS;
      y_add=-6;
    }
    else if (!strcmp(w,"treble")) {
      *ktype=TREBLE;
      y_add=0;
    }
    else if (!strcmp(w,"alto")) {
      *ktype=ALTO;
      y_add=-3;
    }
    else wng("Unknown token in key specifier: ",w);
  }


  if (verbose>=4) printf ("Key   <%s> gives sharpsflats %d, type %d\n", 
                          s, sf, *ktype);

  *sh_fl=sf;

}


/* ----- set_dlen: set default length from string ---- */
void set_dlen (str)
char str[];
{
  int l1,l2,d;

  l1=0;
  l2=1;
  sscanf(str,"%d/%d ", &l1, &l2);
  if (l1 == 0) return;       /* empty string.. don't change default length */
  else {
    d=BASE/l2;
    if (d*l2 != BASE) {
      wng("Length incompatible with BASE, using 1/8: ",str);
      dlen=BASE/8;
    }
    else 
      dlen = d*l1;
  }
  if (verbose>=4)
    printf ("Dlen  <%s> sets default note length to %d/%d = 1/%d\n", 
            str, dlen, BASE, BASE/dlen); 
  
}

/* ----- append_meter: add meter to list of symbols -------- */
void append_meter ()
{
  int kk;

  if ((nsym>0) && (sym[nsym-1].type==TIMESIG)) 
    kk=nsym-1;
  else
    kk=add_sym(TIMESIG);
  sym[kk].u=meter1;
  sym[kk].v=meter2;
  sym[kk].w=mflag;
  strcpy(sym[kk].text,meter_top);
/*  if (vb>=30) printf ("append_meter <%s> %d %d %d\n",
                      meter_top,meter1,meter2,mflag); */
  
}

/* ----- append_keysig: append key signature to list of symbols ---- */
void append_keysig ()
{
  int kk,type,num;

  type=A_SH;
  if (sharps_flats<0) type=A_FT;
  num=sharps_flats;
  if (num<0) num=-num;
  
  if (sym[nsym-1].type == KEYSIG) 
    kk=nsym-1;
  else 
    kk=add_sym(KEYSIG); 

  sym[kk].u=1;
  sym[kk].v=num;
  sym[kk].w=100;
  sym[kk].t=type;
  sym[kk].z=sharps_flats;    /* save current keysig with symbol */
  sym[kk].q=keytype;  

}

/* ----- append_space: add some space to list of symbols -------- */
void append_space (u,v,w)
int u,v,w;
{
  int kk;

  kk=add_sym(INVISIBLE); 
  sym[kk].u=u;
  sym[kk].v=v;
  sym[kk].w=w; 
}

/* ----- init_parse_params: initialize variables for parsing --- */
void init_parse_params ()
{
  
  insert_btype=0;
  slur=0;
  end_slur_next_note=0;
  end_slur_next_note=0;
  nwpool=nwline=0;
  ntinext=0;

}

/* ----- add_text ---- */
void add_text (str,type)
char str[];
int type;
{
  if (do_mode!=DO_OUTPUT) return;
  if (ntext>=NTEXT) {
    wng ("No more room for text line <%s>", str);
    return;
  }
  strcpy (text[ntext], str);
  text_type[ntext]=type;
  ntext++;
}

/* ----- reset_info ---- */
void reset_info (inf)
struct ISTRUCT *inf;
{

  /* reset all info fields except info.xref */

  strcpy(inf->parts,  "");   
  strcpy(inf->area,   "");   
  strcpy(inf->book,   "");   
  inf->ncomp=0;
  strcpy(inf->disc,   "");   
  strcpy(inf->group,  "");  
  strcpy(inf->hist,   "");   
  strcpy(inf->info,   "");   
  strcpy(inf->key,    "C");    
  strcpy(inf->meter,  "4/4");  
  strcpy(inf->notes,  "");  
  strcpy(inf->orig,   "");   
  strcpy(inf->rhyth,  "");  
  strcpy(inf->src,    "");    
/*  strcpy(inf->title,  "(untitled)");  */
  strcpy(inf->title,  "");  
  strcpy(inf->title2, "");  
  strcpy(inf->title3, "");  
  strcpy(inf->trans,  "");  
} 

/* ----- get_default_info: set info to default, except xref field --- */
void get_default_info ()
{
  char savestr[STRL];

  strcpy (savestr, info.xref);
  info=default_info;
  strcpy (info.xref, savestr);
  
}

/* ----- is_info_field: identify any type of info field ---- */
int is_info_field (str)
char str[];
{
  if (strlen(str)<2) return 0;
  if (str[1]!=':')   return 0;
  if (str[0]=='|')   return 0;   /* |: at start of music line */
  return 1;
}

/* ----- is_end_line: identify eof ----- */
int is_end_line (str)
char str[];
{
  if (strlen(str)<3) return 0;
  if (str[0]=='E' && str[1]=='N' && str[2]=='D') return 1;
  return 0;
}

/* ----- is_pseudocomment ----- */
int is_pseudocomment (str)
char str[];
{
  if (strlen(str)<2) return 0;
  if ((str[0]=='%')&&(str[1]=='%'))  return 1;
  return 0;
}

/* ----- is_comment ----- */
int is_comment (str)
char str[];
{
  if (strlen(str)<1) return 0;
  if (str[0]=='%')  return 1;
  if (str[0]=='\\') return 1;
  return 0;
}


/* ----- trim_title: move trailing "The" to front ------------ */
void trim_title (s,s0)
char s[],s0[];
{
  char *q;
  char rest[81],str[301];
  int done;
  
  strcpy (str, s0);
  done=0;

  if ((q=strchr(str,','))) {
    if (*q != '\0') {
      strip (rest,q+1);
      if (!strcmp(rest,"The")) {
        strcpy (s, rest);
        *q = '\0';
        strcat (s, " ");
        strcat (s, str);
        done=1;
      }
    }
  }
  
  if (!done) strcpy (s,s0);

}


/* ----- info_field: identify info line, store in proper place  ---- */
/* switch within_block: either goes to default_info or info.
   Only xref ALWAYS goes to info. */
int info_field (str)
char str[];
{
  char t[STRL];
  struct ISTRUCT *inf;
  int i;

  for (i=0;i<strlen(str);i++) if (str[i]=='%') str[i]='\0';

  if (within_block) {
    inf=&info;
  }
  else {
    inf=&default_info;
  }

  if (strlen(str)<2) return 0;
  if (str[1]!=':')   return 0;
  if (str[0]=='|')   return 0;   /* |: at start of music line */
  
  if (str[0]=='X') {
    strip (info.xref,   &str[2]);
    xrefnum=get_xref(info.xref);
    return XREF;
  }

  else if (str[0]=='A') strip (inf->area,   &str[2]);
  else if (str[0]=='B') strip (inf->book,   &str[2]);
  else if (str[0]=='C') {
    if (inf->ncomp>=NCOMP) 
      wng("Too many composer lines","");
    else {
      strip (inf->comp[inf->ncomp],&str[2]);
      inf->ncomp++;
    }
  }
  else if (str[0]=='D') {
    strip (inf->disc,   &str[2]);
    add_text (&str[2], TEXT_D);
  }

  else if (str[0]=='G') strip (inf->group,  &str[2]);
  else if (str[0]=='H') {
    strip (inf->hist,   &str[2]);
    add_text (&str[2], TEXT_H);
    return HISTORY;
  }
  else if (str[0]=='W') {
    add_text (&str[2], TEXT_W);
    return WORDS;
  }
  else if (str[0]=='I') strip (inf->info,   &str[2]);
  else if (str[0]=='K') {
    strip (inf->key,    &str[2]);
    return KEY;
  }
  else if (str[0]=='L') {
    strip (inf->len,    &str[2]);
    return DLEN;
  }
  else if (str[0]=='M') {
    strip (inf->meter,  &str[2]);
    return METER;
  }
  else if (str[0]=='N') {
    strip (inf->notes,  &str[2]);
    add_text (&str[2], TEXT_N);
  }
  else if (str[0]=='O') strip (inf->orig,   &str[2]);
  else if (str[0]=='R') strip (inf->rhyth,  &str[2]);
  else if (str[0]=='P') {
    strip (inf->parts,  &str[2]);
    return PARTS;
  }
  else if (str[0]=='S') strip (inf->src,    &str[2]);
  else if (str[0]=='T') {
    strip (t, &str[2]);
    numtitle++;
    if (numtitle>3) numtitle=3;
    if (numtitle==1)      trim_title (inf->title,  t);
    else if (numtitle==2) trim_title (inf->title2, t);
    else if (numtitle==3) trim_title (inf->title3, t);
    return TITLE;
  }
  else if (str[0]=='Z') {
    strip (inf->trans,  &str[2]);
    add_text (&str[2], TEXT_Z);
  }
  else if (str[0]=='Q') ;
  else if (str[0]=='E') ;
  
  else {
    return 0;
  }

  return INFO;
}


/* ----- numeric_pitch ------ */
/* taken from abc2mtex by Chris Walshaw */
int numeric_pitch(note)
char note;
{

  if (note=='z') 
    return 14;
  if (note >= 'C' && note <= 'G')
    return(note-'C'+16);
  else if (note >= 'A' && note <= 'B')
    return(note-'A'+21);
  else if (note >= 'c' && note <= 'g')
    return(note-'c'+23);
  else if (note >= 'a' && note <= 'b')
    return(note-'a'+28);
  printf ("numeric_pitch: cannot identify <%c>\n", note);
  return(0);
}

/* ----- append_meter_change ------ */
void append_meter_change()
{
  int m1,m2,f1,l1;
  
  m1=meter1;
  m2=meter2;
  f1=mflag;
  l1=lflag;

  set_meter (info.meter);

  /* if meter symbol was changed, write the meter symbol */
  if ((meter1!=m1) || (meter2!=m2) || (mflag!=f1)) {
    if (vb>=30) printf ("append_meter_change case 1 %d %d %d\n",
                        meter1,meter2,mflag);
    append_meter(); 
  }

  /* if meter symbol unchanged, write if not used to change default length */
  if ((meter1==m1) || (meter2==m2) || (mflag==f1)) {
    if (vb>=30) printf ("append_meter_change case 2 %d %d %d\n",
                        meter1,meter2,mflag);
    if (lflag==l1) append_meter(); 
  }
}

/* ----- append_key_change ------ */
void append_key_change()
{
  int n1,n2,t1,t2,kk,kt;

  n1=sharps_flats; t1=A_SH;      /* get type and sym number for old key */
  kt=keytype;
  if (n1<0) { n1=-n1; t1=A_FT; }
  get_sharps_flats(info.key, &sharps_flats, &keytype);
  n2=sharps_flats;
  t2=A_SH;                       /* get type and sym number for new key */
  
  if (keytype != kt) {
    kk=add_sym(CLEF);
    sym[kk].u=keytype;
    sym[kk].v=1;
  }

  if (n2<0) { n2=-n2; t2=A_FT; }
  if (t1==t2) {              /* here if old and new have same type */
    if (n2>n1) {                 /* more new symbols ..*/
      kk=add_sym(KEYSIG);        /* draw all of them */
      sym[kk].u=1;
      sym[kk].v=n2;
      sym[kk].w=100;
      sym[kk].t=t1;
    }
    else if (n2<n1) {            /* less new symbols .. */
      kk=add_sym(KEYSIG);          /* draw all new symbols and neutrals */
      sym[kk].u=1;
      sym[kk].v=n1;
      sym[kk].w=n2+1;
      sym[kk].t=t2;
    }
    else return;
  }
  else {                     /* here for change s->f or f->s */
    kk=add_sym(KEYSIG);          /* neutralize all old symbols */
    sym[kk].u=1;
    sym[kk].v=n1;
    sym[kk].w=1;
    sym[kk].t=t1;
    kk=add_sym(KEYSIG);          /* add all new symbols */
    sym[kk].u=1;
    sym[kk].v=n2;
    sym[kk].w=100;
    sym[kk].t=t2;
  }
  sym[kk].z=sharps_flats;        /* save current keysig with symbol*/

}


/* ----- init_music_line: init sym list with clef, meter, key ------ */
void init_music_line ()
{

  int kk,n,t;

  if (verbose>11) 
    printf ("init_music_line: nsym=%d, s_f=%d, i_m=%d, i_b=%d\n",
            nsym,sharps_flats,insert_meter,insert_btype);
                         
  /* add clef */
  kk=add_sym(CLEF); 
  sym[kk].u=keytype;
  sym[kk].v=0;

  /* add keysig */
  kk=add_sym(KEYSIG); 
  n=sharps_flats;

  t=A_SH;
  if (n<0) { n=-n; t=A_FT; }
  sym[kk].u=1;
  sym[kk].v=n;
  sym[kk].w=100;
  sym[kk].t=t;
  sym[kk].z=sharps_flats;

  /* add time signature if needed */
  if (insert_meter) append_meter(); 
  insert_meter=0;

  /* add bar if needed */
  if (insert_btype) {
    if (db>3) printf ("insert bar, type %d\n", insert_btype);
    kk=add_sym(BAR);
    sym[kk].u=insert_btype;
    sym[kk].v=insert_num;
  } 
  insert_btype=insert_num=0;

}


/* ----- handle_escape_sequence ------ */
void handle_escape_sequence()
{
  int type;

  if (db>3) printf ("Handle escape sequence <%s>\n", escseq); 

  type=info_field (escseq);
  if (type==0) syntax ("Unknown escape sequence", p-1);

  if (type==METER) {
    set_meter(info.meter);
    append_meter ();
  }
  
  else if (type==KEY) {
    append_key_change();
  }

}

/* ----- parse_uint: parse for unsigned integer ----- */
int parse_uint ()
{
  int number,ndig;
  char num[21];
  
  if (!isdig(*p)) return 0;
  ndig=0;
  while (isdig(*p)) {                
    num[ndig]=*p; 
    ndig++; 
    num[ndig]=0;
    p++;
  }
  sscanf (num, "%d", &number);
  if (db>3) printf ("  parsed unsigned int %d\n", number);
  return number;

}
  
/* ----- parse_bar: parse for some kind of bar ---- */
int parse_bar ()
{
  int k;
  
  /* special cases: [1 or [2 without a preceeding bar, [| */
  if (*p=='[') {
    if ((*(p+1)=='1') || (*(p+1)=='2')) {
      k=add_sym (BAR);
      sym[k].u=B_INVIS;
      sym[k].v=1;
      if (*(p+1)=='2') sym[k].v=2;
      p=p+2;
      return 1;
    }
  }
  
  /* identify valid standard bar types */
  if (*p == '|') {
    p++;
    if (*p == '|') { 
      k=add_sym (BAR);
      sym[k].u=B_DBL;
      p++;
    }
    else if (*p == ':') { 
      k=add_sym(BAR);
      sym[k].u=B_LREP;
      p++; 
    }
    else if (*p==']') {                  /* code |] for fat end bar */
      k=add_sym(BAR);
      sym[k].u=B_FAT2;
      p=p+1;
    }
    else {
      k=add_sym(BAR);
      sym[k].u=B_SNGL;
    }
  }
  else if (*p == ':') {
    p++;
    if (*p == '|') { 
      k=add_sym(BAR);
      sym[k].u=B_RREP;
      p++; 
    }
    else if (*p == ':') {
      k=add_sym(BAR);
      sym[k].u=B_DREP;
      p++; }
    else {
      syntax ("Syntax error parsing bar", p-1);
      return 0;
    }
  }
  else if ((*p=='[') && (*(p+1)=='|')) {  /* code [| for thick-thin bar */
    k=add_sym(BAR);
    sym[k].u=B_FAT1;
    p=p+2;
  }

  else return 0;

  /* see if valid bar is followed by specifier for first or second ending */
  if (*p=='1')      { sym[k].v=1; p++; }
  else if (*p=='2') { sym[k].v=2; p++; }
  else if ((*p=='[') && (*(p+1)=='1')) { sym[k].v=1; p=p+2; }
  else if ((*p=='[') && (*(p+1)=='2')) { sym[k].v=2; p=p+2; }
  else if ((*p==' ') && (*(p+1)=='[') && (*(p+2)=='1')) { sym[k].v=1; p=p+3; }
  else if ((*p==' ') && (*(p+1)=='[') && (*(p+2)=='2')) { sym[k].v=2; p=p+3; }
    

/*  if (db>3) printf ("  parsed bar, type %d, end %d\n",sym[k].u,sym[k].v);  */

  return 1;
}
  
/* ----- parse_space: parse for whitespace ---- */
int parse_space ()
{
  int rc;

  rc=0;
  while (*p == ' ') {
    rc=1;
    p++;
  }
  if (db>3) if (rc) printf ("  parsed whitespace\n"); 
  return rc;
}

/* ----- parse_esc: parse for escape sequence ----- */
int parse_esc ()
{
  
  int nseq;
  char *pp;
  
  if (*p == '\\') {                     /* try for \...\ sequence */
    p++;
    nseq=0;
    while ((*p!='\\') && (*p!=0)) {
      escseq[nseq]=*p;
      nseq++;
      p++;
    }
    if (*p == '\\') {
      p++;
      escseq[nseq]=0;
      if (db>3) printf ("  parsed esc sequence <%s>\n", escseq);  
      return ESCSEQ;
    }
    else {
      if (cfmt.breakall) return DUMMY;
      if (db>3) printf ("  parsed esc to EOL.. continuation\n");  
    }
    return CONTINUE;
  }

  /* next, try for [..] sequence */
  if ((*p=='[') && (*(p+1)>='A') && (*(p+1)<='Z') && (*(p+2)==':')) {  
    pp=p;
    p++;
    nseq=0;
    while ((*p!=']') && (*p!=0)) {
      escseq[nseq]=*p;
      nseq++;
      p++;
    }           
    if (*p == ']') {
      p++;
      escseq[nseq]=0;
      if (db>3) printf ("  parsed esc sequence <%s>\n", escseq);  
      return ESCSEQ;
    }
    syntax ("Escape sequence [..] not closed", pp);
    return ESCSEQ;
  }
  return 0;
}


/* ----- parse_nl: parse for newline ----- */
int parse_nl ()
{
  
  if ((*p == '\\')&&(*(p+1)=='\\')) {
    p+=2;
    return 1;
  }
  else
    return 0;
}

/* ----- parse_gchord: parse guitar chord, save in buffer ----- */
int parse_gchord ()
{
  char *q;
  int n;
  
  if (*p != '"') return 0;
  
  q=p;
  p++;
  n=strlen(gch);
  if (n > 0) syntax ("Overwrite unused guitar chord", q);
  
  while ((*p != '"') && (*p != 0)) {
    gch[n]=*p;
    n++;
    if (n >= 200) {
      syntax ("String for guitar chord too long", q);
      return 1;
    }
    p++;
  }
  if (*p == 0) {
    syntax ("EOL reached while parsing guitar chord", q);
    return 1;
  }
  p++;
  gch[n]=0;
  if (db>3) printf("  parse guitar chord <%s>\n", gch);
  return 1;
}


/* ----- parse_deco: parse for decoration on note ----- */
int parse_deco (dtype)
int dtype[10];
{
  int deco,n;
  
  n=0;
  
  for (;;) {
    deco=0;
    if (*p == '~')  {
      if (DECO_IS_ROLL) deco=D_ROLL;
      else              deco=D_GRACE;
    }
    if (*p == '.')  deco=D_STACC;
    if (*p == 'J')  deco=D_SLIDE;
    if (*p == 'M')  deco=D_EMBAR;
    if (*p == 'H')  deco=D_HOLD;
    if (*p == 'R')  deco=D_ROLL;
    if (*p == 'T')  deco=D_TRILL;
    if (*p == 'u')  deco=D_UPBOW;
    if (*p == 'v')  deco=D_DOWNBOW;
    
    if (deco) {
      p++;
      dtype[n]=deco;
      n++;
    }
    else 
      break;
  }

  return n;
}


/* ----- parse_length: parse length specifer for note or rest --- */
int parse_length ()
{
  int len,fac;

  len=dlen;                        /* start with default length */
  
  if (isdig(*p)) {                 /* multiply note length */
    fac=parse_uint ();
    if (fac==0) fac=1;
    len *= fac;
  }

  if (*p=='/') {                   /* divide note length */
    while (*p=='/') {
      p++;
      if (isdig(*p)) 
        fac=parse_uint();
      else 
        fac=2;
      if (len%fac) {
        syntax ("Bad length divisor", p-1);
        return len; 
      }
      len=len/fac;
    }
  }
  
  return len;

}

/* ----- parse_grace_sequence --------- */
int parse_grace_sequence (pgr,agr)
int pgr[],agr[];
{

  char *p0;
  int n,len;
  
  p0=p;
  if (*p != '{') return 0;
  p++;
  
  n=0;
  while (*p != '}') {
    if (*p == '\0') {
      syntax ("Unbalanced grace note sequence", p0);
      return 0;
    }
    if (!isnote(*p)) {
      syntax ("Unexpected symbol in grace note sequence", p);
      p++;
    }
    agr[n]=0;  
    if (*p == '^') agr[n]=A_SH;
    if (*p == '=') agr[n]=A_NT;
    if (*p == '_') agr[n]=A_FT;
    if (agr[n]) p++;
    pgr[n] = numeric_pitch(*p);
    p++;
    while (*p == '\'') { pgr[n] += 7; p++; }
    while (*p == ',') {  pgr[n] -= 7; p++; }
    len=parse_length ();      /* ignore any length specifier */
    n++;
  }
  
  p++;
  return n;
}

/* ----- identify_note: set head type, dots, flags for note --- */
void identify_note (s,q)
struct SYMBOL *s;
char *q;
{
  int head,base,len,flags,dots;

  if (s->len==0) s->len=s->lens[0];
  len=s->len;

  base=WHOLE;
  if (len>=WHOLE)              base=WHOLE;
  else if (len>=HALF)          base=HALF;
  else if (len>=QUARTER)       base=QUARTER;
  else if (len>=EIGHTH)        base=EIGHTH;
  else if (len>=SIXTEENTH)     base=SIXTEENTH;
  else if (len>=THIRTYSECOND)  base=THIRTYSECOND;
  else if (len>=SIXTYFOURTH)   base=SIXTYFOURTH;
  else syntax("Cannot identify head for note",q);
      
  if (base==WHOLE)     head=H_OVAL;
  else if (base==HALF) head=H_EMPTY;
  else                 head=H_FULL;
      
  if (base==SIXTYFOURTH)        flags=4;
  else if (base==THIRTYSECOND)  flags=3;
  else if (base==SIXTEENTH)     flags=2;
  else if (base==EIGHTH)        flags=1;
  else                          flags=0;
  
  dots=0;
  if (len==base)            dots=0;
  else if (2*len==3*base)   dots=1;
  else if (4*len==7*base)   dots=2;
  else if (8*len==15*base)  dots=3;
  else syntax("Cannot handle note length for note",q);
  
/*  printf ("identify_note: length %d gives head %d, dots %d, flags %d\n",
          len,head,dots,flags);  */

  s->head=head;
  s->dots=dots;
  s->flags=flags;
}


/* ----- double_note: change note length for > or < char --- */
/* Note: if sym[i] is a chord, the length shifted to the following
   note is taken from the first note head. Problem: the crazy syntax 
   permits different lengths within a chord. */
void double_note (i,num,sign,q)
int i,num,sign;
char *q;
{
  int m,shift,j,len;

  if ((sym[i].type!=NOTE) && (sym[i].type!=REST)) 
    bug("sym is not NOTE or REST in double_note", 1);
  
  shift=0;
  len=sym[i].lens[0];
  for (j=0;j<num;j++) {
    len=len/2;
    shift -= sign*len;
    sym[i].len += sign*len;
    for (m=0;m<sym[i].npitch;m++) sym[i].lens[m] += sign*len;
  }
  identify_note (&sym[i],q);
  carryover += shift;
}

/* ----- parse_basic_note: parse note or rest with pitch and length --*/
int parse_basic_note (pitch,length,accidental)
int *pitch,*length,*accidental;
{
  int pit,len,acc;
  
  acc=pit=0;             
  if (*p == '^') acc=A_SH;        /* look for accidental sign */
  if (*p == '=') acc=A_NT;
  if (*p == '_') acc=A_FT;
  if (acc) {
    p++;
    if (!strchr("CDEFGABcdefgab",*p)) {
      syntax("Missing note after accidental", p-1);
      return 0;
    }
  }
  if (!isnote(*p)) {
    syntax ("Expecting note", p);
    p++;
    return 0;
  }
  
  pit= numeric_pitch(*p);             /* basic pitch */
  p++;
  
  while (*p == '\'') {                /* eat up following ' chars */
    pit += 7;
    p++;
  }
  
  while (*p == ',') {                 /* eat up following , chars */
    pit -= 7;
    p++;
  }
  
  len=parse_length();

  *pitch=pit;
  *length=len;
  *accidental=acc;

  if (db>3) printf ("  parsed basic note,"
                    "length %d/%d = 1/%d, pitch %d\n", 
                    len,BASE,BASE/len,pit);
  
  return 1;
  
}


/* ----- parse_note: parse for one note or rest with all trimmings --- */
int parse_note ()
{
  int k,deco,i,chord,m,type,rc,sl1,sl2,j;
  int pitch,length,accidental,invis;
  int ngr,pgr[30],agr[30],dtype[30];
  char *q,*q0;
  
  ngr=parse_grace_sequence(pgr,agr);   /* grace notes */

  parse_gchord();                      /* permit chord after graces */
  
  deco=parse_deco(dtype);              /* decorations */

  parse_gchord();                      /* permit chord after deco */

  chord=0;                             /* determine if chord */
  q=p;
  if ((*p=='+') || (*p=='[')) { chord=1; p++; }

  type=invis=0;
  if (isnote(*p)) type=NOTE;
  if (chord && (*p=='(')) type=NOTE;
  if (chord && (*p==')')) type=NOTE;   /* this just for better error msg */
  if ((*p=='z')||(*p=='Z')) type=REST;
  if ((*p=='x')||(*p=='X')) {type=REST; invis=1; }
  if (!type) return 0;

  k=add_sym(type);                     /* add new symbol to list */

  sym[k].dc.n=deco;                    /* copy over pre-parsed stuff */
  for (i=0;i<deco;i++) 
    sym[k].dc.t[i]=dtype[i];
  sym[k].gr.n=ngr;
  for (i=0;i<ngr;i++) {
    sym[k].gr.p[i]=pgr[i];
    sym[k].gr.a[i]=agr[i];
  }
  if (strlen(gch)>0) {
    strcpy (sym[k].text, gch);
    strcpy (gch, "");
  }

  q0=p;
  if (type==REST) {
    p++;
    sym[k].lens[0] = parse_length();
    sym[k].npitch=1;
    sym[k].invis=invis;
    if (db>3) printf ("  parsed rest, length %d/%d = 1/%d\n", 
                      sym[k].lens[0],BASE,BASE/sym[k].lens[0]); 
  }
  else {
    m=0;                                 /* get pitch and length */
    sl1=sl2=0;
    for (;;) {
      if (chord && (*p=='(')) {
        sl1++;
        sym[k].sl1[m]=sl1;
        p++;
      }
      deco=parse_deco(dtype);     /* for extra decorations within chord */
      for (i=0;i<deco;i++) sym[k].dc.t[i+sym[k].dc.n]=dtype[i];
      sym[k].dc.n += deco;

      rc=parse_basic_note (&pitch,&length,&accidental);
      if (rc==0) { nsym--; return 0; }
      sym[k].pits[m] = pitch;
      sym[k].lens[m] = length;
      sym[k].accs[m] = accidental;
      sym[k].ti1[m]  = sym[k].ti2[m] = 0;
      for (j=0;j<ntinext;j++) 
        if (tinext[j]==sym[k].pits[m]) sym[k].ti2[m]=1;

      if (chord && (*p=='-')) {sym[k].ti1[m]=1; p++;}

      if (chord && (*p==')')) {
        sl2++;
        sym[k].sl2[m]=sl2;
        p++;
      }

      if (chord && (*p=='-')) {sym[k].ti1[m]=1; p++;}

      m++;

      if (!chord) break;
      if ((*p=='+')||(*p==']')) {
        p++;
        break;
      }
      if (*p=='\0') {
        if (chord) syntax ("Chord not closed", q); 
        return type;
      }
    }
    ntinext=0;
    for (j=0;j<m;j++)
      if (sym[k].ti1[j]) {
        tinext[ntinext]=sym[k].pits[j];
        ntinext++;
      }
    sym[k].npitch=m;
  }
  
  for (m=0;m<sym[k].npitch;m++) {   /* add carryover from previous > or < */
    if (sym[k].lens[m]+carryover<=0)
      syntax("> leads to zero or negative note length",q0);
    else
      sym[k].lens[m] += carryover;
  }
  carryover=0;

  if (db>3) printf ("  parsed note, decos %d, text <%s>\n",
                    sym[k].dc.n, sym[k].text);
  sym[k].yadd=y_add;
  identify_note (&sym[k],q0); 
  return type;
}


/* ----- parse_sym: parse a symbol and return its type -------- */
int parse_sym ()
{
  int i;

  if (parse_gchord())   return GCHORD;
  if (parse_bar())      return BAR;
  if (parse_space())    return SPACE;
  if (parse_nl())       return NEWLINE;
  if ((i=parse_esc()))  return i;
  if ((i=parse_note())) return i;
  if (parse_nl())       return NEWLINE;
  return 0;
}

/* ----- add_wd ----- */
char *add_wd(str)
char str[];
{
  char *rp;
  int l;

  l=strlen(str);
  if (l==0) return 0;
  if (nwpool+l+1>NWPOOL) 
    rx ("Overflow while parsing vocals; increase NWPOOL and recompile.","");
  
  strcpy(wpool+nwpool, str);
  rp=wpool+nwpool;
  nwpool=nwpool+l+1;
  return rp;
}

/* ----- parse_vocals: parse words below a line of music ----- */
/* Use '^' to mark a '-' between syllables - hope nobody needs '^' ! */
int parse_vocals (line)
char line[];
{
  int isym;
  char *c,*c1,*w;
  char word[81];

  if ((line[0]!='w') || (line[1]!=':')) return 0;
  p0=line;

  isym=nsym0-1;
  c=line+2;
  for (;;) {
    while(*c==' ') c++;
    if (*c=='\0') break;
    c1=c;
    if ((*c=='_') || (*c=='*') || (*c=='|') || (*c=='-')) {
      word[0]=*c; 
      if (*c=='-') word[0]='^';
      word[1]='\0';
      c++;
    }
    else {
      w=word;
      *w='\0';
      while ((*c!=' ') && (*c!='\0')) { 
        if ((*c=='_') || (*c=='*') || (*c=='|')) break;
        if (*c=='-') {
          if (*(c-1) != '\\') break;
          w--;
          *w='-';
        }
        *w=*c; w++; c++; 
      }
      if (*c=='-') { *w='^' ; w++; c++; }
      *w='\0';
    }

    /* now word contains a word, possibly with trailing '^',
       or one of the special characters * | _ -               */

    if (!strcmp(word,"|")) {               /* skip forward to next bar */
      isym++;
      while ((sym[isym].type!=BAR) && (isym<nsym)) isym++; 
      if (isym>=nsym) { syntax("Not enough bar lines for |",c1); break; }
    } 
    
    else {                                 /* store word in next note */
      w=word;                            
      while (*w!='\0') {                   /* replace * and ~ by space */
        if ((*w=='*') || (*w=='~')) *w=' ';
        w++;
      }
      isym++;
      while ((sym[isym].type!=NOTE) && (isym<nsym)) isym++; 
      if (isym>=nsym) { syntax ("Not enough notes for words",c1); break; }
      sym[isym].wordp[nwline]=add_wd(word);
    }

    if (*c=='\0') break;
  }

  nwline++;
  return 1;
}


/* ----- parse_music_line: parse a music line into symbols ----- */
int parse_music_line (line)
char line[];
{
  int type,num,nbr;
  char msg[81];
  char *p1,*pmx;

  if (nsym==0) init_music_line ();
  nwline=0;                  
  nsym0=nsym;
  nbr=0;
  p=p0=line;
  pmx=p+strlen(p);

  while (*p != 0) {
    if (p>pmx) break;                /* emergency exit */
    type=parse_sym();
    if ((db>4) && type)  
      printf ("   sym[%d] code (%d,%d)\n",
              nsym-1,sym[nsym-1].type,sym[nsym-1].u);
    
    if (type==NEWLINE) {
      if ((nsym>0) && !cfmt.continueall && !cfmt.barsperstaff) {
        sym[nsym-1].eoln=1;
        if (word) {
          sym[last_note].word_end=1;
          word=0;
        }
      }
    }
    
    if (type==ESCSEQ) {
      handle_escape_sequence ();
    }

    if (type==REST) {
      if (pplet) {                   /* n-plet can start on rest */
        sym[nsym-1].p_plet=pplet;
        sym[nsym-1].q_plet=qplet;
        sym[nsym-1].r_plet=rplet;
        pplet=0;
      }
      last_note=nsym-1;              /* need this so > and < work */
      p1=p;
    }

    if (type==NOTE) {
      if (!word) {
        sym[nsym-1].word_st=1;
        word=1;
      }
      sym[nsym-1].slur_st+=nbr;
      nbr=0;
      if (end_slur_next_note) sym[nsym-1].slur_end++;
      end_slur_next_note=0;

      if (pplet) {                   /* start of n-plet */
        sym[nsym-1].p_plet=pplet;
        sym[nsym-1].q_plet=qplet;
        sym[nsym-1].r_plet=rplet;
        pplet=0;
      }
      last_note=last_real_note=nsym-1;
      p1=p;
    }
    
    if (word && ((type==BAR)||(type==SPACE))) {
      if (last_real_note>0) sym[last_real_note].word_end=1;
      word=0;
    }

    if (!type) {

      if (*p == '-') {                  /* a-b tie */
        sym[last_note].slur_st++;
        end_slur_next_note=1;
        p++;
      }                              

      else if (*p == '(') {
        p++;
        if (isdig(*p)) {
          pplet=*p-'0'; qplet=0; rplet=pplet;
          p++;
          if (*p == ':') {
            p++;
            if (isdig(*p)) { qplet=*p-'0';  p++; }
            if (*p == ':') {
              p++;
              if (isdig(*p)) { rplet=*p-'0';  p++; }
            }
          }
        }
        else {
          nbr++;
        }
      }
      else if (*p == ')') {
        if (last_note>0) 
          sym[last_note].slur_end++;
        else
          syntax ("Unexpected symbol",p);
        p++;
      }
      else if (*p == '>') {
        num=1;
        p++;
        while (*p == '>') { num++; p++; }
        if (last_note<0) 
          syntax ("No note before > sign", p);
        else 
          double_note (last_note, num, 1, p1);
      }
      else if (*p == '<') {
        num=1;
        p++;
        while (*p == '<') { num++; p++; }
        if (last_note<0) 
          syntax ("No note before < sign", p);
        else 
          double_note (last_note, num, -1, p1);
      }
      else if (*p == '*')     /* ignore stars for now  */
        p++;
      else if (*p == '!')     /* ditto for '!' */
        p++;
      else {
        if (*p != '\0') 
          sprintf (msg, "Unexpected symbol \'%c\'", *p);
        else 
          sprintf (msg, "Unexpected end of line");
        syntax (msg, p);
        p++;
      }
    }
  }

  /* maybe set end-of-line marker, if symbols were added */
  if (nsym>nsym0) {        
    sym[nsym-1].eoln=1;
    if (type==CONTINUE)     sym[nsym-1].eoln=0;
    if (cfmt.barsperstaff)  sym[nsym-1].eoln=0;
    if (cfmt.continueall)   sym[nsym-1].eoln=0;
  }

  /* break words at end of line */
  if (word && (sym[nsym-1].eoln==1)) {
    sym[last_note].word_end=1;
    word=0;
  }

  return TO_BE_CONTINUED;

}

/* ----- is_selected: check selection for current info fields ---- */
int is_selected (xref_str,npat,pat,select_all,search_field)
int npat,select_all,search_field;
char xref_str[],pat[][STRL1];
{
  int i,a,b,m;

  /* true if select_all or if no selectors given */
  if (select_all) return 1;        
  if (isblank(xref_str) && (npat==0)) return 1;    

  for (i=0;i<npat;i++) {             /*patterns */
    if (search_field==S_COMPOSER) 
      m=match(info.comp,pat[i]);
    else if (search_field==S_SOURCE) 
      m=match(info.src,pat[i]);
    else if (search_field==S_RHYTHM) 
      m=match(info.rhyth,pat[i]);
    else {
      m=match(info.title,pat[i]);
      if ((!m) && (numtitle>=2)) m=match(info.title2,pat[i]);
      if ((!m) && (numtitle>=3)) m=match(info.title3,pat[i]);
    }
    if (m) return 1;
  }

  /* check xref against string of numbers */
  p=xref_str;                        
  while (*p != 0) {
    parse_space();
    a=parse_uint();
    if (!a) return 0;          /* can happen if invalid chars in string */
    parse_space();
    if (*p == '-') {
      p++;
      parse_space();
      b=parse_uint();
      if (!b) {
        if (xrefnum>=a) return 1;
      }
      else
        for (i=a;i<=b;i++) if (xrefnum==i) return 1;
    }
    else {
      if (xrefnum==a) return 1;
    }
    if (*p == ',') p++;
  }
  
  return 0;

}

/* ----- rehash_selectors: split selectors into patterns and xrefs -- */
int rehash_selectors (sel_str, xref_str, pat)
char sel_str[], xref_str[];
char pat[][STRL1];
{
  char *q;
  char arg[501];
  int i,npat;

  npat=0;
  strcpy (xref_str, "");
  q=sel_str;
  
  i=0;
  while (1) {
    if ((*q==' ') || (*q=='\0')) {
      arg[i]='\0';
      i=0;
      if (!isblank(arg)) {
        if (arg[0]=='-')               /* skip any flags */
          ;
        else if (is_xrefstr(arg)) {
          strcat(xref_str, arg);
          strcat(xref_str, " ");
        }
        else {                         /* pattern with * or + */
          if ((strchr(arg,'*')) || (strchr(arg,'+'))) {
            strcpy(pat[npat],arg);
          }
          else {                       /* simple pattern */
            strcpy(pat[npat],"*");
            strcat(pat[npat],arg);
            strcat(pat[npat],"*");
          }
          npat++;
        }
      }
    }
    else {
      arg[i]=*q;
      i++;
    }
    if (*q=='\0') break;
    q++;
  }
  return npat;
}


/* ----- decomment_line: cut off after % ----- */
void decomment_line (ln)
char ln[];
{
  int i;

  for (i=0;i<strlen(ln);i++) if (ln[i]=='%') ln[i]='\0';

}


/* ----- get_line: read line, do first operations on it ----- */
int get_line (fp,ln)
FILE *fp;
char ln[];
{
  int l;
  
  strcpy (ln, "");
  if (feof(fp)) return 0;

  fgets(ln, BSIZE, fp);
  linenum++;
  l=strlen(ln);
  if (l>STRL) {
    if (verbose<=2) printf ("\n"); 
    printf ("++++ Line %d too long, truncate from %d to %d chars\n",
            linenum, l, STRL);
    l=STRL-1;
    ln[l]='\0';
  }
  if (is_end_line(ln))  return 0;
  if (ln[l-1]=='\n') ln[l-1]='\0';

  if ((verbose>=5) || (vb>=10) ) printf ("%3d  %s \n", linenum, ln);

  return 1;

}

/* ----- read_line: returns type of line scanned --- */
int read_line (fp,do_music,line)
FILE *fp;
int do_music;
char line[BSIZE];
{
  int type,s0;
  
  if (!get_line(fp,line)) return E_O_F;

  if (isblank(line))           return BLANK;
  if (is_pseudocomment(line))  return PSCOMMENT;
  if (is_comment(line))        return COMMENT;
  decomment_line (line);

  if ((type=info_field(line))) {
    /* skip after history field. Nightmarish syntax, that. */
    if (type != HISTORY) 
      return type;
    else {          
      for (;;) {
        if (! get_line(fp,line)) return E_O_F;
        if (isblank(line)) return BLANK;
        if (is_info_field(line)) break;
        add_text (line, TEXT_H);
      }
      type=info_field (line);
      return type;
    }
  }
  
  if (!do_music) return COMMENT;

  if (parse_vocals(line)) return MWORDS;

  s0=nsym;
  type=parse_music_line (line);
  if (db>1) printf ("  parsed music symbols %d to %d\n", s0, nsym);

  return type;
  
}

/* ----- do_index: print index of abc file ------ */
void do_index(fp,xref_str,npat,pat,select_all,search_field)
FILE *fp; 
int npat,select_all,search_field;
char xref_str[],pat[][STRL1];
{
  int type,within_tune;
  char line[BSIZE];

  linenum=0;
  verbose=vb;
  numtitle=0;
  write_history=0;
  within_tune=within_block=do_this_tune=0;
  reset_info (&default_info);
  info=default_info;
  
  for (;;) {
    if (!get_line(fp,line)) break;
    if (is_comment(line)) continue;
    decomment_line (line);
    type=info_field (line);

    switch (type) {
        
    case XREF:
      if (within_block) 
        printf ("++++ Tune %d not closed properly \n", xrefnum);
      numtitle=0;
      within_tune=0;
      within_block=1;
      ntext=0;
      break;
      
    case KEY:
      if (!within_block) break;
      if (!within_tune) {
        tnum2++;
        if (is_selected (xref_str,npat,pat,select_all,search_field)) {
          get_sharps_flats(info.key, &sharps_flats, &keytype); 
          set_meter (info.meter); 
          set_dlen (info.len);
          printf ("  %-4d %-5s %-4s", xrefnum, info.key, info.meter);
          if      (search_field==S_SOURCE)   printf ("  %-15s", info.src);
          else if (search_field==S_RHYTHM)   printf ("  %-8s",  info.rhyth);
          else if (search_field==S_COMPOSER) printf ("  %-15s", info.comp[0]);
          if (numtitle==3) 
            printf ("  %s - %s - %s", info.title,info.title2,info.title3);
          if (numtitle==2) printf ("  %s - %s", info.title, info.title2);
          if (numtitle==1) printf ("  %s", info.title);
          
          printf ("\n");
          tnum1++;
        }
        within_tune=1;
      }  
      break;

    }
    
    if (isblank(line)) {
      if (within_block && !within_tune) 
        printf ("++++ Header not closed in tune %d\n", xrefnum);
      within_tune=0;
      within_block=0;
      info=default_info;
    }
  }
  if (within_block && !within_tune) 
    printf ("++++ Header not closed in for tune %d\n", xrefnum);

}



