#include "kiss.h"

int dohelp (Stringstack s)
{
    if (s.nstr > 1)
	printf ("Context-sensitive help not present, just run the command "
				    "that you need help\n"
		"about with the \"-h\" flag. Most commands will then show "
				    "info.\n");

    printf ("Relevant environment, only maintained with absence of -E flag:\n"
	    "          HOME - home directory\n"
	    "           PWD - current working directory\n"
	    "         SHELL - this shell interpreter\n"
	    "         SHLVL - shell level, initially 1\n"
	    "           TTY - name of ttyfile in interactive processes\n"
	    "           UID - numerical user ID\n"
	    "          USER - user name\n"
	    "Inspected environment:\n"
	    "        PROMPT - interactive prompt, use:\n"
	    "                 %%p for current dir, %%u for username, %%n for\n"
	    "                 newline, other chars: literally; default: "
						    "[%%u] %%p >\n"
	    "Startup files, auto-loaded when in interactive mode:\n"
	    "  /etc/kiss.rc - system-wide startup file\n"
	    " $HOME/kiss.rc - user-owned statup file\n"
	    "Built-in commands (commands with * can't be re-aliased):\n"
	    "             ! - recall a command from history list\n"
	    "         alias - define an alias or list aliases (*)\n"
	    "           cat - copy a file to stdout\n"
	    "            cd - change working directory (*)\n"
	    "         chgrp - change group id in file ownership\n"
	    "         chmod - change modebits in file ownership\n"
	    "         chown - change user id in file ownership\n"
	    "            cp - copy file(s), including 'holes'\n"
	    "          exec - execute program in place of %s (*)\n"
	    "          exit - terminate %s (*)\n"
	    "          grep - grep for strings in files\n"
	    "          help - this text\n"
	    "       history - show history of entered commands\n"
	    "          kill - kill or signal processes\n"
	    "            ln - create a hard or symbolic link\n"
	    "            ls - directory listing\n"
	    "         mkdir - make directories\n"
	    "         mknod - make pipe or character or block device\n"
	    "          more - show a file pagewise\n"
	    "         mount - mount a filesystem\n"
	    "            mv - rename files\n"
	    "      printenv - print environment table\n"
	    "           pwd - print working directory\n"
	    "          read - read value of a variable from stdin (*)\n"
	    "            rm - remove files or directories\n"
	    "         rmdir - remove empty directories\n"
	    "        setenv - set environment variable (also VAR=value) (*)\n"
	    "         sleep - wait some seconds\n"
	    "        source - read commands from file (*)\n"
	    "         touch - reset file's timestamp\n"
	    "        umount - unmount a filesystem\n"
	    "      unsetenv - remove a variable from the environment "
				"(also VAR=) (*)\n"
	    "           ver  - print version number\n"
	    "            wc  - count lines, words, chars in files\n"
	    "         where  - where does a program reside on the PATH\n"
	   , progname, progname);
    return (0);
}
