'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH netdb n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
netdb \- Access the local network databases.
.BE

.SH DESCRIPTION
The \fBnetdb\fR command provides access to network information that is
stored in configuration files, the Network Information Service (NIS)
or in the Domain Name System (DNS). The results of the \fBnetdb\fR
command usually depend on the local configuration of your operating
system.

.SH NETDB COMMAND
.TP 
\fBnetdb hosts\fR
.ns
.TP 
\fBnetdb hosts name \fIaddress\fR
.ns
.TP
\fBnetdb hosts address \fIname\fR
The first version of the \fBnetdb hosts\fR command returns a list of
all locally known hosts. Each element of this list contains a host
name and its IP address. The result is an empty list on many systems
that are configured to use the DNS for hostname lookups.  The second
version of the \fBnetdb hosts\fR command converts an IP \fIaddress\fR
into a host name and the third version of the \fBnetdb hosts\fR
command converts a host \fIname\fR into an IP address.
.TP 
\fBnetdb networks\fR
.ns
.TP 
\fBnetdb networks name \fIaddress\fR
.ns
.TP
\fBnetdb networks address \fIname\fR
The first version of the \fBnetdb networks\fR command returns a list
of all locally known networks. Each element of this list contains a
network name and the IP network address. The second version of the
\fBnetdb networks\fR command returns the network name that belongs to
the IP network \fIaddress\fR and the third version of the \fBnetdb
networks\fR command returns the network address that belongs to a
given network
\fIname\fR.
.TP 
\fBnetdb protocols\fR
.ns
.TP 
\fBnetdb protocols name \fInumber\fR
.ns
.TP
\fBnetdb protocols number \fIname\fR
The first version of the \fBnetdb protocols\fR command returns a list
of all locally known Internet protocols. Each element of this list
contains a protocol name and its protocol number. The second version
of the \fBnetdb protocols\fR command returns the protocol name that
belongs to \fInumber\fR and the third version of the \fBnetdb
protocols\fR command returns the protocol number that belongs to a
protocol \fIname\fR.
.TP
\fBnetdb services\fR
.ns
.TP
\fBnetdb services name \fInumber\fR \fIprotocol\fR
.ns
.TP
\fBnetdb services number \fIname\fR \fIprotocol\fR
The first version of the \fBnetdb services\fR command returns the list
of all locally known services. Each element of this list contains a
service name, the service number and the transport protocol. The
second version of the \fBnetdb services\fR command returns the service
name for the service described by \fInumber\fR and \fIprotocol\fR. The
third version of the \fBnetdb services\fR command returns the protocol
number for the service described by \fIname\fR and \fIprotocol\fR.
.TP 
\fBnetdb sunrpcs\fR
.ns
.TP 
\fBnetdb sunrpcs name \fInumber\fR
.ns
.TP
\fBnetdb sunrpcs number \fIname\fR
The first version of the \fBnetdb sunrpcs\fR command lists all locally
known Sun RPCs. Each element of this list contains a RPC name and its
registration number. The second version of the \fBnetdb sunrpcs\fR
command returns the RPC name for a given RPC \fInumber\fR and the
third version of the \fBnetdb sunrpcs\fR command returns the RPC
number for a given RPC \fIname\fR.
.TP
\fBnetdb ip class \fIaddress\fR
.ns
.TP
\fBnetdb ip range \fIaddress mask\fR
The first version of the \fBnetdb ip\fR command returns the IP class
of the given address. The following classes are recognized: A, B, C, D
and loopback. The second version of the \fBnetdb ip\fR command returns
the list of IP addresses in the address range given by \fIaddress\fR
and \fImask\fR.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
