dnl $Id: aclocal.m4,v 1.1 1997/04/13 02:12:03 meem Exp meem $

dnl
dnl tests to see if syslog() works.  some versions of ultrix have syslog(),
dnl but it is not full-featured.
dnl

AC_DEFUN(RLPR_SYSLOG_USABLE,
  [AC_MSG_CHECKING(whether syslog() is usable)
   AC_CACHE_VAL(rlpr_cv_header_syslog_usable,
     [AC_EGREP_CPP(yes,
       [#include <syslog.h>
        #ifdef LOG_LPR
        yes
        #endif],
     rlpr_cv_header_syslog_usable=yes,
     rlpr_cv_header_syslog_usable=no)])
   if test "$rlpr_cv_header_syslog_usable" = "yes"; then
     AC_MSG_RESULT(yes)
     AC_DEFINE(SYSLOG_USABLE)
   else
     AC_MSG_RESULT(no)
   fi])

dnl
dnl tests to see if MAXHOSTNAMELEN is defined in the wrong place
dnl

AC_DEFUN(RLPR_MAXHOSTNAMELEN_BROKEN,
  [AC_MSG_CHECKING(whether MAXHOSTNAMELEN is incorrectly in netdb.h)
   AC_CACHE_VAL(rlpr_cv_header_MAXHOSTNAMELEN_broken,
     [AC_EGREP_CPP(yes,
        [#include <netdb.h>
         #ifdef MAXHOSTNAMELEN
         yes
         #endif],
     rlpr_cv_header_MAXHOSTNAMELEN_broken=yes,
     rlpr_cv_header_MAXHOSTNAMELEN_broken=no)])
   if test "$rlpr_cv_header_MAXHOSTNAMELEN_broken" = "yes"; then
     AC_MSG_RESULT(yes)
     AC_DEFINE(MAXHOSTNAMELEN_BROKEN)
   else
     AC_MSG_RESULT(no)
   fi])

dnl
dnl tests to see if setresuid, setreuid or seteuid are supported
dnl

AC_DEFUN(RLPR_SETRESUID,
  [AC_MSG_CHECKING(for setresuid)
   AC_CACHE_VAL(rlpr_cv_func_setresuid,
     [AC_EGREP_HEADER(setresuid, unistd.h,
      rlpr_cv_func_setresuid=yes,
      rlpr_cv_func_setresuid=no)])
   if test "$rlpr_cv_func_setresuid" = "yes"; then
     AC_MSG_RESULT(yes)
     AC_DEFINE(HAVE_SETRESUID)
  else
     AC_MSG_RESULT(no)
fi])

dnl
dnl tests to see if off_t is a `long long'
dnl

AC_DEFUN(RLPR_OFF_T_LONG_LONG,
   [AC_MSG_CHECKING(whether off_t is a long long)
    AC_CACHE_VAL(rlpr_cv_type_off_t_long_long,
      [AC_TRY_RUN(
        [#include <sys/types.h>
         int main() { return sizeof(long) == sizeof(off_t); }],
       rlpr_cv_type_off_t_long_long=yes,
       rlpr_cv_type_off_t_long_long=no)])
   if test "$rlpr_cv_type_off_t_long_long" = "yes"; then
     AC_MSG_RESULT(yes)
     AC_DEFINE(OFF_T_LONG_LONG)
   else
     AC_MSG_RESULT(no)
   fi])
