/*
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#ifndef GLOBALS_H
#define GLOBALS_H 1

#include <sys/param.h>
#include <sys/cdefs.h>
#include <netdb.h>  /* this isn't header-protected under ultrix */
#include <atalk/afp.h>

/* test for inline */
#ifndef __inline__
#define __inline__
#endif

/* another ultrix bleah */
#ifdef ultrix
extern char *strdup __P((const char *));
#endif

/* a couple of these options could get stuck in unions to save
 * space. */
struct afp_options {
  int connections, port, authbits, transports;
  unsigned char debug, uservolfirst, passwdbits;
  char hostname[MAXHOSTNAMELEN + 1], *server, *address, *configfile;
  char *pidfile, *defaultvol, *systemvol;
  char *guest, *loginmesg, *passwdfile;
};

typedef struct AFPObj {
  int proto;
  void *handle;
  struct afp_options options;
  char *Obj, *Type, *Zone;
  void (*exit)(int);
  int (*reply)(void *, int);
} AFPObj;

extern int		afp_version;
extern unsigned char	nologin;
extern char		*username;
extern struct vol	*volumes;
extern struct dir	*curdir;
extern char		getwdbuf[];

extern void afp_options_init __P((struct afp_options *));
extern int afp_options_parse __P((int, char **, struct afp_options *));
extern int afp_options_parseline __P((char *, struct afp_options *));
extern void afp_options_free __P((struct afp_options *, 
				  const struct afp_options *));
extern void setmessage __P((const char *));

#endif /* globals.h */
