# options.tcl --
#
# This file contains defaults for all the options. These are just the
# built in defaults.
#
#
#  TkRat software and its included text is Copyright 1996,1997,1998
#  by Martin Forssn
#
#  The full text of the legal notice is contained in the file called
#  COPYRIGHT, included with this distribution.


# OptionsInit --
#
# Initialize the options to their default values
#
# Arguments:

proc OptionsInit {} {
    global env option tkrat_version

    # Last run version
    set option(last_version) ""

    # The date of the last version used
    set option(last_version_date) 0

    # Want information about changes?
    set option(info_changes) 1

    # UI language
    set option(language) en

    # Search path for global configuration files
    set option(global_config_path) $env(CONFIG_DIR)

    # Personal config directory
    set option(ratatosk_dir) ~/.ratatosk

    # Database directory
    set option(dbase_dir) ~/.ratatosk/db

    # Directory to backup database messages to
    set option(dbase_backup) ~/.ratatosk/backup

    # Directory to store outgoing messages
    set option(send_cache) ~/.ratatosk/send

    # Delivery mode
    set option(delivery_mode) direct

    # How long to wait between expiring the database (in days)
    set option(expire_interval) 7

    # Directory for message hold
    set option(hold_dir) ~/.ratatosk/hold

    # Userprocedures file
    set option(userproc) ~/.ratatosk/userproc

    # Main window name
    set option(main_window_name) "TkRat v$tkrat_version"

    # Main window geometry
    set option(main_geometry) +0+50

    # Icon name
    set option(icon_name) "TkRat v$tkrat_version"

    # Command to get default folder
    set option(default_folder) "INBOX file {} /var/spool/mail/$env(USER)"

    # Format of list of messages
    set option(list_format) "%4S %6d  %-24n %4B %s"

    # How many headers we should show
    set option(show_header) selected

    # Which the selected headers are:
    set option(show_header_selection) {From Subject Date To CC Reply-To}

    # How many old directories we should remember
    set option(prev_dir) 10

    # Default permissions mask
    set option(permissions) 0600

    # Geometry of compose window
    set option(compose_geometry) +0+50

    # Which headers to compose
    set option(compose_headers) {To Subject Cc}

    # Which editor to use (%s will be expanded to a filename)
    set option(editor) "emacs %s"

    # Which domain we should pretend we are from
    set option(masquerade_as) {}

    # Which domain we are in
    set option(domain) {}

    # List of SMTP hosts
    set option(smtp_hosts) {localhost}

    # Default sening protocol
    set option(sendprot) smtp

    # Default sending program
    set option(sendprog) /usr/lib/sendmail

    # Can the sending program handle eightbit data
    set option(sendprog_8bit) false

    # Default character set for tcl
    set option(charset) iso-8859-1

    # Leader string for replies
    set option(reply_lead) {>}

    # Width of listboxes in vfolderdef window
    set option(vfoldername_width) 15

    # True (1) if we should show the watcher
    set option(watcher_enable) 1

    # Time between checking for new mail in different folders
    set option(watcher_time) {{std 30} {dbase 0}}

    # Geometry of watcher
    set option(watcher_geometry) -140+0

    # Watcher window name
    set option(watcher_name) Watcher

    # Watcher max height
    set option(watcher_max_height) 10

    # Font in watcher
    set option(watcher_font) 5x7

    # How many messages the watcher shall show
    set option(watcher_show) new

    # How many times the bell should be run when new messages arive
    set option(watcher_bell) 2

    # Format of list of messages in watcher
    set option(watcher_format) "%4S %-24n %s"

    # Print command
    set option(print_command) "lpr %s"

    # Headers to print
    set option(print_header) selected

    # Directory for temporary files
    set option(tmp) /tmp

    # Subject for replies to messages without subject
    set option(no_subject) "Re: (no subject)"

    # Default signature file
    set option(signature) ~/.signature

    # Default folder sort method
    set option(folder_sort) folder

    # Message attribution
    set option(attribution) "On %d, %n wrote:"

    # Forwarded tag
    set option(forwarded_message) "------ Forwarded message ------"

    # File typing
    set option(typetable) { {*text* text/plain}
			    {*GIF* image/gif}
			    {*JPEG* image/jpeg}
			    {*JPG* image/jpeg}
			    {"*8-bit u-law*" audio/basic}
			    {*PostScript* application/postscript}
			    {*data* application/octet-stream}}

    # True if we want to see ALL messages from c-client (including babble)
    set option(see_bable) 0

    # True if we have looked for alias files
    set option(scan_aliases) 0

    # Number of messages to remember
    set option(num_messages) 10

    # True if we should lookup usernames in the local passwd-list
    set option(lookup_name) true

    # Default database expiration type
    set option(def_extype) remove

    # Default database expiration time
    set option(def_exdate) +365

    # How many messages are required for one chunk (in dbase backup)
    set option(chunksize) 100

    # Where we should store dsn files
    set option(dsn_directory) ~/.ratatosk/DSN

    # If we should default to request DSN
    set option(dsn_request) 0

    # If we should remove delivery reports from folders
    set option(dsn_snarf_reports) 0

    # How many days each DSN entry should be kept in the list
    set option(dsn_expiration) 7

    # How verbose we should be when recieving DSN's
    set option(dsn_verbose) {{failed notify} {delayed status} {delivered status} {relayed status} {expanded none}}

    # Which message we should select when a folder is opened
    set option(start_selection) first_new

    # How long log messages should show (in ms)
    set option(log_timeout) 3

    # The default reply_to address
    set option(reply_to) ""

    # The font size we user
    set option(fontsize) 12

    # Folder window key combination
    set option(folder_key_compose) <Key-m>
    set option(folder_key_quit) <Control-Key-c>
    set option(folder_key_nextu) <Key-Tab>
    set option(folder_key_sync) <Control-Key-s>
    set option(folder_key_update) <Control-Key-u>
    set option(folder_key_delete) <Key-d>
    set option(folder_key_undelete) <Key-u>
    set option(folder_key_flag) <Key-g>
    set option(folder_key_next) {<Key-Right> <Shift-Key-Down> <Key-n>}
    set option(folder_key_prev) {<Key-Left> <Shift-Key-Up> <Key-p>}
    set option(folder_key_replya) <Key-R>
    set option(folder_key_replys) <Key-r>
    set option(folder_key_forward_i) <Key-f>
    set option(folder_key_forward_a) <Key-F>
    set option(folder_key_home) {<Key-0> <Key-F27>}
    set option(folder_key_bottom) {<Key-F33> <Key-End>}
    set option(folder_key_pagedown) {<Key-space> <Key-F35> <Key-z>}
    set option(folder_key_pageup) {<Key-BackSpace> <Key-F29> <Control-b>}
    set option(folder_key_linedown) {<Key-Down>}
    set option(folder_key_lineup) {<Key-Up>}
    set option(folder_key_cycle_header) <Key-h>
    set option(folder_key_find) <Key-l>

    # Compose window key combinations
    set option(compose_key_send) <Control-s>
    set option(compose_key_abort) <Control-c>
    set option(compose_key_editor) <Control-o>
    set option(compose_key_undo) <Control-u>
    set option(compose_key_cut) <Control-w>
    set option(compose_key_cut_all) <Control-Shift-w>
    set option(compose_key_paste) <Control-y>

    # If we should check for stolen mail
    set option(mail_steal) 1

    # Data for netscape inbox
    set option(ms_netscape_pref_file) $env(HOME)/.netscape/preferences
    set option(ms_netscape_mtime) 0

    # True if we should remember the window positions
    set option(keep_pos) 1

    # The default From: address (may be empty)
    set option(from) {}

    # True if we should let the user specify from address.
    set option(use_from) 1

    # The level of verboseness we should use when talking SMTP
    set option(smtp_verbose) 1

    # If we should try to send multiple letters though one channel
    set option(smtp_reuse) 1

    # The color set
    set option(color_set) {gray85 black}

    # Which icon to set
    set option(icon) normal

    # The default expression mode
    set option(expression_mode) basic

    # If we should start up in iconic mode
    set option(iconic) 0

    # If the compose editor should warn about cutting all text etc
    set option(compose_warn) 1

    # Length of message list
    set option(message_llength) 14

    # Mailcap path
    set option(mailcap_path) {~/.mailcap:/etc/mailcap:/usr/etc/mailcap:/usr/local/etc/mailcap}

    # Terminal command
    set option(terminal) "xterm -e sh -c"

    # Imap port
    set option(imap_port) 143

    # SMTP timeout
    set option(smtp_timeout) 120

    # Should we sent even though we have a bad hostname?
    set option(force_send) 0

    # Should we skip the signature of the message we are replying to
    set option(skip_sig) true

    # Are we PGP capable?
    if [info exists env(PGPPATH)] {
	set pgpdir $env(PGPPATH)
    } else {
	set pgpdir ~/.pgp
    }
    if {0 < [string length "$env(PGP)"] &&
	    1 == [file readable $pgpdir/pubring.pgp] &&
	    1 == [file readable $pgpdir/secring.pgp]} {
	set option(pgp_enable) 1
    } else {
	set option(pgp_enable) 0
    }

    # Path to pgp program
    set option(pgp_prog) $env(PGP)

    # Extra pgp options
    set option(pgp_args) {}

    # If we should make a copy of attached files
    set option(copy_attached) 1

    # If we should sign outgoing letters
    set option(pgp_sign) 0

    # If we should encrypt outgoing letters
    set option(pgp_encrypt) 0

    # Default url viewer
    set option(url_viewer) netscape

    # Name (and path) of netscape executable
    set option(netscape) netscape

    # Extra arguments for netscape
    set option(netscape_args) -install

    # Color of URL
    set option(url_color) blue

    # System wide aliases
    set option(system_aliases) "System tkrat $env(CONFIG_DIR)/aliases"
    set option(use_system_aliases) 1

    # Personal alias lists
    set option(addrbooks) {{Personal tkrat ~/.ratatosk/aliases}}

    # Default alias book
    set option(default_book) Personal

    # Default browse mode
    set option(browse) folder

    # Caching data
    set option(cache_pgp) 1
    set option(cache_pgp_timeout) 300
    set option(cache_passwd) 1
    set option(cache_passwd_timeout) 300
    set option(cache_conn) 1
    set option(cache_conn_timeout) 10

    # URL protocols
    set option(urlprot) {http shttp ftp news telnet}

    # Balloon help
    set option(show_balhelp) 1

    # Balloon help delay
    set option(balhelp_delay) 500

    # Message finding fields
    set option(msgfind_format) "%s%n%b%D"

    # Should we warn about tk version 8.0
    set option(warn_tk80) 1

    # Automatically expunge on folder close
    set option(expunge_on_close) 1
}

# OptionsRead --
#
# Searches the filesystem for ratatoskrc files
#
# Arguments:

proc OptionsRead {} {
    global option globalOption env

    # Read global files
    foreach dir $option(global_config_path) {
	if [file readable $dir/ratatoskrc] {
	    source $dir/ratatoskrc
	}
    }
    # Take copy of global options
    foreach name [array names option] {
	set globalOption($name) $option($name)
    }
    # Read local modifications
    if [file readable $option(ratatosk_dir)/ratatoskrc] {
	source $option(ratatosk_dir)/ratatoskrc
    }
}

# SaveOptions --
#
# Saves the users changes to the global options to disk.
#
# Arguments:

proc SaveOptions {} {
    global option globalOption

    # Warning message
    set message {#
# BEWARE of making changes to this file. It is automatically generated.
# You can change the values in this file via the preferences window. 
# This file can only contain "set option(<optname>) <value>" lines,
# everything else will be destroyed when the file is regenerated.
}

    set fh [open $option(ratatosk_dir)/ratatoskrc w]
    puts $fh $message
    foreach name [array names globalOption] {
	if [string compare $option($name) $globalOption($name)] {
	    puts $fh "set option($name) [list $option($name)]"
	}
    }
    close $fh
}

# ReadUserproc --
#
# Source the users userproc file with some caution
#
# Arguments:

proc ReadUserproc {} {
    global option t
    if [file readable $option(userproc)] {
	if [catch "source $option(userproc)" message] {
	    Popup "$t(error_in_userproc): $message"
	}
    }
}

# InitFonts --
#
# Initializes the default fonts
#
# These initializations can be overridden in the local configuration files.
# See the ../CONFIGURATION file for details.
#
# Arguments:

proc InitFonts {} {
    AddFont iso-8859-1 8 {} *-courier-medium-r-normal-*-8-*-iso8859-1
    AddFont iso-8859-1 8 {bold} *-courier-bold-r-normal-*-8-*-iso8859-1
    AddFont iso-8859-1 8 {italic} *-courier-medium-o-normal-*-8-*-iso8859-1
    AddFont iso-8859-1 8 {bold italic} *-courier-bold-o-normal-*-8-*-iso8859-1
    AddFont iso-8859-1 10 {} *-courier-medium-r-normal-*-10-*-iso8859-1
    AddFont iso-8859-1 10 {bold} *-courier-bold-r-normal-*-10-*-iso8859-1
    AddFont iso-8859-1 10 {italic} *-courier-medium-o-normal-*-10-*-iso8859-1
    AddFont iso-8859-1 10 {bold italic} *-courier-bold-o-normal-*-10-*-iso8859-1
    AddFont iso-8859-1 12 {} *-courier-medium-r-normal-*-12-*-iso8859-1
    AddFont iso-8859-1 12 {bold} *-courier-bold-r-normal-*-12-*-iso8859-1
    AddFont iso-8859-1 12 {italic} *-courier-medium-o-normal-*-12-*-iso8859-1
    AddFont iso-8859-1 12 {bold italic} *-courier-bold-o-normal-*-12-*-iso8859-1
    AddFont iso-8859-1 14 {} *-courier-medium-r-normal-*-14-*-iso8859-1
    AddFont iso-8859-1 14 {bold} *-courier-bold-r-normal-*-14-*-iso8859-1
    AddFont iso-8859-1 14 {italic} *-courier-medium-o-normal-*-14-*-iso8859-1
    AddFont iso-8859-1 14 {bold italic} *-courier-bold-o-normal-*-14-*-iso8859-1
    AddFont iso-8859-1 18 {} *-courier-medium-r-normal-*-18-*-iso8859-1
    AddFont iso-8859-1 18 {bold} *-courier-bold-r-normal-*-18-*-iso8859-1
    AddFont iso-8859-1 18 {italic} *-courier-medium-o-normal-*-18-*-iso8859-1
    AddFont iso-8859-1 18 {bold italic} *-courier-bold-o-normal-*-18-*-iso8859-1
    AddFont iso-8859-1 24 {} *-courier-medium-r-normal-*-24-*-iso8859-1
    AddFont iso-8859-1 24 {bold} *-courier-bold-r-normal-*-24-*-iso8859-1
    AddFont iso-8859-1 24 {italic} *-courier-medium-o-normal-*-24-*-iso8859-1
    AddFont iso-8859-1 24 {bold italic} *-courier-bold-o-normal-*-24-*-iso8859-1
}

# InitCharsetAliases
#
# Initialize the aliases of charcter sets
#
# Arguments:

proc InitCharsetAliases {} {
    global charsetAlias option

    # These are predefined (remember to only use lowercase letters)
    set charsetAlias(bar) iso-8859-1

    # Read global files
    foreach dir $option(global_config_path) {
	if [file readable $dir/charsetAliases] {
	    source $dir/charsetAliases
	}
    }
    # Read local modifications
    if [file readable $option(ratatosk_dir)/charsetAliases] {
	source $option(ratatosk_dir)/charsetAliases
    }
}
