'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Stripchart widget created by Sani Nassif and George Howlett.
'\"
.so man.macros
.HS stripchart BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
stripchart \-  2D strip chart for plotting x and y coordinate data.
.SH SYNOPSIS
\fBstripchart\fI \fIpathName \fR?\fIoption value\fR?...
.BE
.SH DESCRIPTION
The \fBstripchart\fR command creates a strip chart for plotting
two-dimensional data (x,y coordinates). It has many configurable
components: coordinate axes, elements, legend, grid lines, cross
hairs, etc.  They allow you to customize the look and feel of the
strip chart.
.PP
The \fBstripchart\fR is essentially the same as the \fBgraph\fR
widget.  It works almost exactly the very same way.  
.PP
The use of a strip chart differs in that the X-axis typically refers
to time points.  Data values are added at intervals.  The strip chart
lets you automatically maintain a view of the most recent time points.
The axis options \fB\-shiftby\fR and \fB\-autorange\fR control this.
You can specify different line styles for data points (see the 
\fB\-styles\fR option).  
.SH INTRODUCTION
The \fBstripchart\fR command creates a new window for plotting
two-dimensional data (x,y coordinates).  Data points are plotted in a
box displayed in the center of the new window.  This is the
\fIplotting area\fR.  The coordinate axes are displayed in the
margins around the plotting area.  By default, the legend is displayed
in the right margin.  The title is displayed in top margin.
.PP
A strip chart is composed of several components: coordinate axes, data
elements, legend, grid, cross hairs, pens, postscript, and annotation
markers. 
.TP 1i
\fCaxis\fR 
The stripchart widget can display up to four coordinate axes (two
X-coordinate and two Y-coordinate axes), but you can create and use
any number of axes. Axes control what region of data is displayed and
how the data is scaled. Each axis consists of the axis line, title,
major and minor ticks, and tick labels. Tick labels display the value
of each major tick.
.TP 1i
\fCcrosshairs\fR
Cross hairs are used to finely position the mouse pointer in relation
to the coordinate axes. Two perpendicular lines are drawn across the
plotting area, intersecting at the current location of the mouse
pointer.
.TP 1i
\fCelement\fR 
An element represents a set of data points. Elements can be plotted 
with a symbol at each data point and lines connecting the points. 
The appearance of the element, such as its symbol, line width, and 
color is configurable.
.TP 1i
\fCgrid\fR
Extends the major and minor ticks of the X\-axis and/or Y\-axis across the 
plotting area. 
.TP 1i
\fClegend\fR 
The legend displays the name and symbol of each data element. 
The legend can be drawn in any margin or in the plotting area.
.TP 1i
\fCmarker\fR
Markers are used annotate or highlight areas of the graph. For 
example, you could use a polygon marker to fill an area under a 
curve, or a text marker to label a particular data point. Markers 
come in various forms: text strings, bitmaps, connected line 
segments, images, polygons, or embedded widgets.
.TP 1i
\fCpen\fR 
Pens define attributes (both symbol and line style) for elements. 
Data elements use pens to specify how they should be drawn.  A data 
element may use many pens at once.  Here, the particular pen 
used for a data point is determined from each element's weight 
vector (see the element's \fB\-weight\fR and \fB\-style\fR options).  
.TP 1i
\fCpostscript\fR
The widget can generate encapsulated PostScript output. This component
has several options to configure how the PostScript is generated.
.SH SYNTAX
.DS C
\fBstripchart \fIpathName \fR?\fIoption value\fR?...
.DE
The \fBstripchart\fR command creates a new window \fIpathName\fR and makes
it into a \fBstripchart\fR widget.  At the time this command is invoked, there
must not exist a window named \fIpathName\fR, but \fIpathName\fR's
parent must exist.  Additional options may may be specified on the
command line or in the option database to configure aspects of the
strip chart such as its colors and font.  See the \fBconfigure\fR operation
below for the exact details as to what \fIoption\fR and \fIvalue\fR
pairs are valid.
.PP
If successful, \fBstripchart\fR returns the path name of the widget.  It
also creates a new Tcl command by the same name.  You can use this
command to perform various operations that query or modify the graph.
The general form is:
.DS C
\fIpathName \fIoperation\fR \fR?\fIarg\fR?...
.DE
Both \fIoperation\fR and its arguments determine the exact behavior of
the command.  The operations available for the strip chart are described in 
the 
.SB "STRIPCHART OPERATIONS"
section.
.PP
The command can also be used to access components of the strip chart.
.DS
\fIpathName component operation\fR ?\fIarg\fR?...
.DE
The operation, now located after the name of the component, is the
function to be performed on that component. Each component has its own
set of operations that manipulate that component.  They will be
described below in their own sections.
.SH EXAMPLE
The \fBstripchart\fR command creates a new strip chart.  
.DS
# Create a new strip chart.  Plotting area is black.
stripchart .s -plotbackground black
.DE
A new Tcl command \fC.s\fR is also created.  This command can be used
to query and modify the strip chart.  For example, to change the title of
the strip chart to "My Plot", you use the new command and the widget's
\fBconfigure\fR operation.
.DS
# Change the title.
\&.s configure \-title "My Plot"
.DE
A strip chart has several components. To access a particular component you
use the component's name. For example, to add data elements, you use 
the new command and the \fBelement\fR component.
.DS
# Create a new element named "line1"
\&.s element create line1 \\
	\-xdata { 0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 } \\
	\-ydata { 26.18 50.46 72.85 93.31 111.86 128.47 143.14 
		155.85 166.60 175.38 }
.DE
The element's X and Y coordinates are specified using lists of
numbers.  Alternately, BLT vectors could be used to hold the X\-Y
coordinates.
.DS
# Create two vectors and add them to the strip chart.
vector xVec yVec
xVec set { 0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 }
yVec set { 26.18 50.46 72.85 93.31 111.86 128.47 143.14 155.85 
	166.60 175.38 }
\&.s element create line1 \-xdata xVec \-ydata yVec
.DE
The advantage of using vectors is that when you modify one, the graph
is automatically redrawn to display the new values.
.DS
# Change the X\-Y coordinates of the first point.
set xVec(0) 0.18
set yVec(0) 25.18
.DE
An element named \fCline1\fR is now created in \fC.s\fR.  By
default, the element's label in the legend will be also \fCline1\fR.
You can change the label, or specify no legend entry, again using the
element's \fBconfigure\fR operation.
.DS
# Don't display "line1" in the legend.
\&.s element configure line1 -label ""
.DE
You can configure more than just the element's label.  An element has
many attributes such as symbol type and size, dashed or solid lines,
colors, line width, etc.
.DS
\&.s element configure line1 -symbol square -color red \\
	-dashes { 2 4 2 } -linewidth 2 -pixels 2c
.DE
Four coordinate axes are automatically created: \fCx\fR, \fCx2\fR,
\fCy\fR, and \fCy2\fR.  And by default, elements are mapped onto the
axes \fCx\fR and \fCy\fR.  This can be changed with the \fB\-mapx\fR
and \fB\-mapy\fR options.
.DS
# Map "line1" on the alternate Y-axis "y2".
\&.s element configure line1 -mapy y2
.DE
Axes can be configured in many ways too.  For example, you change the
scale of the Y-axis from linear to log using the \fBaxis\fR operation.
.DS
# Y-axis is log scale.
\&.s axis configure y -logscale yes
.DE
Axis limits are reset by simply specifying new axis
limits using the \fB\-min\fR and \fB\-max\fR configuration options.
.DS
\&.s axis configure x -min 1.0 -max 1.5
\&.s axis configure y -min 12.0 -max 55.15
.DE
By default, the limits of the axis are determined from data values.
To reset back to the default limits, set the \fB\-min\fR and
\fB\-max\fR options to the empty value.
.DS
# Reset the axes to autoscale again.
\&.s axis configure x -min {} -max {}
\&.s axis configure y -min {} -max {}
.DE
It's common with strip charts to automatically maintain a view of
the most recent time points.  You can do this my setting the 
\fB\-autorange\fR option.
.DS
\&.s axis configure x -autorange 20.0
.DE
If the time points are added in X-coordinates 1.0 unit, only the last
twenty time points will be displayed.  As more data
is added, the view will march along.
.PP
Sometimes the rate of data is so high that changing the axis limits
with each additional time point is prohibitive.  You can use the
\fB\-shiftby\fR option to define an increment to shift the view
when needed.  
.DS
\&.s axis configure x -shiftby 15.0
.DE
When the view is shifted, it will allow a range of 15
new time points to be added until the axis limits are recomputed.
.PP
By default, the legend is displayed in the right margin.  You can
change this or any other legend configuration options using the
\fBlegend\fR component.
.DS
# Configure the legend font, color, and relief
\&.s legend configure -position left -relief raised \\
	-font fixed -fg blue
.DE
To prevent the legend from being displayed, turn on the \fB\-hide\fR
option.
.DS
# Don't display the legend.
\&.s legend configure -hide yes\fR
.DE
The \fBstripchart\fR widget has simple drawing procedures called markers.
They can be used to highlight or annotate data in the strip chart. The types
of markers available are bitmaps, images, polygons, lines, or windows.
Markers can be used, for example, to mark or brush points.  Here 
is a text marker which labels the data first point.  Markers
are created using the \fBmarker\fR operation.
.DS
# Create a label for the first data point of "line1".
\&.s marker create text \-name first_marker \-coords { 0.2 26.18 } \\
	\-text "start" \-anchor se \-xoffset -10 \-yoffset -10
.DE
This creates a text marker named \fCfirst_marker\fR.  It will display
the text "start" near the coordinates of the first data point.  The
\fB\-anchor\fR, \fB\-xoffset\fR, and \fB\-yoffset\fR options are used
to display the marker above and to the left of the data point, so that
the actual data point isn't covered by the marker.  By default,
markers are drawn last, on top of data.  You can change this with the
\fB\-under\fR option.
.DS
# Draw the label before elements are drawn.
\&.s marker configure first_marker -under yes
.DE
You can add cross hairs or grid lines using the \fBcrosshairs\fR and
\fBgrid\fR operations.
.DS
# Display both cross hairs and grid lines.
\&.s crosshairs configure \-hide no \-color red
\&.s grid configure \-hide no \-dashes { 2 2 }
.DE
Finally, to get hardcopy of the strip chart, use the \fBpostscript\fR
operation.
.DS
# Print the strip chart into file "file.ps"
\&.s postscript output file.ps \-maxpect yes \-decorations no
.DE
This generates a file \fCfile.ps\fR containing the encapsulated
PostScript of the strip chart.  The option \fB\-maxpect\fR says to scale the
plot to the size of the page.  Turning off the \fB\-decorations\fR
option indicates that no borders or color backgrounds should be
displayed (i.e. the background of the margins, legend, and plotting
area will be white).
.SH "STRIPCHART OPERATIONS"
.TP
\fIpathName \fBaxis \fIoperation\fR ?\fIarg\fR?...
See the 
.SB "AXIS COMPONENTS"
section.
.TP
\fIpathName \fBbar \fIelemName \fR?\fIoption value\fR?...
Creates a new barchart element \fIelemName\fR.  It's an
error if an element \fIelemName\fR already exists.  
See the manual for \fBbarchart\fR for details about
what \fIoption\fR and \fIvalue\fR pairs are valid.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the stripchart configuration option given by
\fIoption\fR.  \fIOption\fR may be any option described
below for the \fBconfigure\fR operation.
.TP
\fIpathName \fBconfigure \fR?\fIoption value\fR?...
Queries or modifies the configuration options of the strip chart.  If
\fIoption\fR isn't specified, a list describing all of the current
options for \fIpathName\fR is returned.  If \fIoption\fR is specified,
but not \fIvalue\fR, then a list describing \fIoption\fR is returned.
If one or more \fIoption\fR and \fIvalue\fR pairs are specified, then
for each pair, the stripchart option \fIoption\fR is set to \fIvalue\fR.
The following options are valid for the stripchart.
.RS
.TP
\fB\-background \fIcolor\fR
Sets the background color. This includes the margins and
legend, but not the plotting area.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the widget.  The
\fB\-relief\fR option determines if the border is to be drawn.  The
default is \fC2\fR.
.TP
\fB\-bottommargin \fIpixels\fR
Specifies the size of the margin below the X\-coordinate axis.  If
\fIpixels\fR is \fC0\fR, the size of the margin is selected automatically.
The default is \fC0\fR.
.TP
\fB\-bufferelements \fIboolean\fR
Indicates whether an internal pixmap to buffer the display of data
elements should be used.  If \fIboolean\fR is true, data elements are
drawn to an internal pixmap.  This option is especially useful when
the strip chart is redrawn frequently while the remains data unchanged (for
example, moving a marker across the plot).  See the
.SB "SPEED TIPS"
section.
The default is \fC1\fR.
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default
cursor is \fCcrosshair\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the title font. The default is
\fC*-Helvetica-Bold-R-Normal-*-18-180-*\fR.
.TP
\fB\-halo \fIpixels\fR 
Specifies a maximum distance to consider when searching for the
closest data point (see the element's \fBclosest\fR operation below).
Data points further than \fIpixels\fR away are ignored.  The default is
\fC0.5i\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the requested height of widget.  The default is
\fC4i\fR.
.TP
\fB\-invertxy \fIboolean\fR
Indicates whether the placement X\-axis and Y\-axis should be inverted.  If
\fIboolean\fR is true, the X and Y axes are swapped.  The default is
\fC0\fR.
.TP
\fB\-justify \fIjustify\fR
Specifies how the title should be justified.  This matters only when
the title contains more than one line of text. \fIJustify\fR must be
\fCleft\fR, \fCright\fR, or \fCcenter\fR.  The default is
\fCcenter\fR.
.TP
\fB\-leftmargin \fIpixels\fR
Sets the size of the margin from the left edge of the window to 
the Y\-coordinate axis.  If \fIpixels\fR is \fC0\fR, the size is
calculated automatically.  The default is \fC0\fR.
.TP
\fB\-plotbackground \fIcolor\fR
Specifies the background color of the plotting area.  The default is
\fCwhite\fR.
.TP
\fB\-plotborderwidth \fIpixels\fR
Sets the width of the 3-D border around the plotting area.  The
\fB\-plotrelief\fR option determines if a border is drawn.  The
default is \fC2\fR.
.TP
\fB\-plotpadx \fIpad\fR
Sets the amount of padding to be added to the left and right sides of
the plotting area.  \fIPad\fR can be a list of one or two screen
distances.  If \fIpad\fR has two elements, the left side of the
plotting area entry is padded by the first distance and the right side
by the second.  If \fIpad\fR is just one distance, both the left and
right sides are padded evenly.  The default is \fC8\fR.
.TP
\fB\-plotpady \fIpad\fR
Sets the amount of padding to be added to the top and bottom of the
plotting area.  \fIPad\fR can be a list of one or two screen
distances.  If \fIpad\fR has two elements, the top of the plotting
area is padded by the first distance and the bottom by the second.  If
\fIpad\fR is just one distance, both the top and bottom are padded
evenly.  The default is \fC8\fR.
.TP
\fB\-plotrelief \fIrelief\fR
Specifies the 3-D effect for the plotting area.  \fIRelief\fR
indicates how the interior of the plotting area should appear relative
to rest of the strip chart; for example, \fCraised\fR means the plot should
appear to protrude from the strip chart, relative to the surface of the
strip chart.  The default is \fCsunken\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the widget.  \fIRelief\fR
indicates how the strip chart should appear relative to widget it is packed
into; for example, \fCraised\fR means the strip chart should
appear to protrude.  The default is \fCflat\fR.
.TP
\fB\-rightmargin \fIpixels\fR
Sets the size of margin from the plotting area to the right edge of
the window.  By default, the legend is displayed in this margin.  If
\fIpixels\fR is than 1, the margin size is selected automatically.
.TP
\fB\-takefocus\fR \fIfocus\fR 
Provides information used when moving the focus from window to window
via keyboard traversal (e.g., Tab and Shift-Tab).  If \fIfocus\fR is
\fC0\fR, this means that this window should be skipped entirely during
keyboard traversal.  \fC1\fR means that the this window should always
receive the input focus.  An empty value means that the traversal
scripts make the decision whether to focus on the window.
The default is \fC""\fR.
.TP
\fB\-tile \fIimage\fR 
Specifies a tiled background.  If \fIimage\fR isn't
\fC""\fR, the background is tiled using \fIimage\fR.
Otherwise, the normal background color is drawn (see the
\fB\-background\fR option).  \fIImage\fR must be an image created
using the Tk \fBimage\fR command.  The default is \fC""\fR.
.TP
\fB\-title \fItext\fR 
Sets the title to \fItext\fR. If \fItext\fR is \fC""\fR,
no title will be displayed.
.TP
\fB\-topmargin \fIpixels\fR
Specifies the size of the margin above the x2 axis.  If \fIpixels\fR
is \fC0\fR, the margin size is calculated automatically.
.TP
\fB\-width \fIpixels\fR
Specifies the requested width of the widget.  The default is
\fC5i\fR.
.RE
.TP
\fIpathName \fBcrosshairs \fIoperation \fR?\fIarg\fR?
See the 
.SB "CROSSHAIRS COMPONENT"
section.
.TP
\fIpathName \fBelement \fIoperation \fR?\fIarg\fR?...
See the 
.SB "ELEMENT COMPONENTS"
section.
.TP
\fIpathName \fBextents \fIitem\fR 
Returns the size of a particular item in the strip chart.  \fIItem\fR must
be either \fCleftmargin\fR, \fCrightmargin\fR, \fCtopmargin\fR,
\fCbottommargin\fR, \fCplotwidth\fR, or \fCplotheight\fR.
.TP
\fIpathName \fBgrid \fIoperation \fR?\fIarg\fR?...
See the 
.SB "GRID COMPONENT"
section.
.TP
\fIpathName \fBinvtransform \fIwinX winY\fR 
Performs an inverse coordinate transformation, mapping window
coordinates back to graph coordinates, using the standard X\-axis and Y\-axis.
Returns a list of containing the graph coordinates.
.TP
\fIpathName \fBlegend \fIoperation \fR?\fIarg\fR?...
See the 
.SB "LEGEND COMPONENT"
section.
.TP
\fIpathName \fBline \fIelemName\fR ?\fIoption value\fR?...
The operation is the same as \fBelement\fR.
.TP
\fIpathName \fBmarker \fIoperation \fR?\fIarg\fR?...
See the 
.SB "MARKER COMPONENTS"
section.
.TP
\fIpathName \fBpostscript \fIoperation \fR?\fIarg\fR?...
See the 
.SB "POSTSCRIPT COMPONENT"
section.
.TP
\fIpathName \fBsnap \fIphotoName\fR
Takes a snapshot of the strip chart and stores the contents in the photo
image \fIphotoName\fR.  \fIPhotoName\fR is the name of a Tk photo
image that must already exist.
.TP
\fIpathName \fBtransform \fIx y\fR 
Performs a coordinate transformation, mapping graph coordinates to
window coordinates, using the standard X\-axis and Y\-axis.
Returns a list containing the X\-Y screen coordinates.
.TP
\fIpathName \fBxaxis \fIoperation\fR ?\fIarg\fR?...
.TP
\fIpathName \fBx2axis \fIoperation\fR ?\fIarg\fR?... 
.TP
\fIpathName \fByaxis \fIoperation\fR ?\fIarg\fR?... 
.TP
\fIpathName \fBy2axis \fIoperation\fR ?\fIarg\fR?... 
See the 
.SB "AXIS COMPONENTS"
section.
.SH "STRIPCHART COMPONENTS"
A strip chart is composed of several components: coordinate axes, data
elements, legend, grid, cross hairs, postscript, and annotation
markers. Instead of one big set of configuration options and
operations, the strip chart is partitioned, where each component has its own
configuration options and operations that specifically control that
aspect or part of the strip chart. 
.SS "AXIS COMPONENTS"
Four coordinate axes are automatically created: two X\-coordinate axes
(\fCx\fR and \fCx2\fR) and two Y\-coordinate axes (\fCy\fR, and
\fCy2\fR).  By default, the axis \fCx\fR is located in the bottom
margin, \fCy\f in the left margin, \fCx2\fR in the top margin, and
\fCy2\fR in the right margin.
.PP
An axis consists of the axis line, title, major and minor ticks, and
tick labels.  Major ticks are drawn at uniform intervals along the
axis.  Each tick is labeled with its coordinate value.  Minor ticks
are drawn at uniform intervals within major ticks.  
.PP
The range of the axis controls what region of data is plotted.
Data points outside the minimum and maximum limits of the axis are
not plotted.  By default, the minimum and maximum limits are
determined from the data, but you can reset either limit.
.PP
You can create and use several axes. To create an axis, invoke
the axis component and its create operation.
.DS
# Create a new axis called "temperature"
\&.s axis create temperature
.DE
You map data elements to an axis using the element's \-mapy and \-mapx
configuration options. They specify the coordinate axes an element
is mapped onto.
.DS
# Now map the temperature data to this axis.
\&.s element create "temp" \-xdata $x \-ydata $tempData \\
    \-mapy temperature
.DE
While you can have many axes, only four axes can be displayed
simultaneously.  They are drawn in each of the margins surrounding the
plotting area.  The axes x and y are drawn in the bottom and left
margins. The axes x2 and y2 are drawn in top and right margins.
Only x and y are shown by default. Note that the axes can have
different scales.
.PP
To display a different axis, you invoke one of the following
components: \fBxaxis\fR, \fByaxis\fR, \fBx2axis\fR, and \fBy2axis\fR.
The \fBuse\fR operation designates the axis to be drawn in the
corresponding margin: \fBxaxis\fR in the bottom, \fByaxis\fR in the left, 
\fBx2axis\fR in the top, and \fBy2axis\fR in the right.
.DS
# Display the axis temperature in the left margin.
\&.s yaxis use temperature
.DE
.PP
You can configure axes in many ways. The axis scale can be linear or
logarithmic.  The values along the axis can either monotonically
increase or decrease.  If you need custom tick labels, you can specify
a Tcl procedure to format the label as you wish.  You can
control how ticks are drawn, by changing the major tick interval
or the number of minor ticks.  You can define non-uniform tick intervals,
such as for time-series plots.
.PP
.TP
\fIpathName \fBaxis \fBcget \fIaxisName \fIoption\fR
Returns the current value of the option given by \fIoption\fR for
\fIaxisName\fR.  \fIOption\fR may be any option described below
for the axis \fBconfigure\fR operation.
.TP
\fIpathName \fBaxis \fBconfigure \fIaxisName \fR?\fIoption value\fR?...
Queries or modifies the configuration options of \fIaxisName\fR.  If
\fIoption\fR isn't specified, a list describing all the current
options for \fIaxisName\fR is returned.  If \fIoption\fR is specified, but
not \fIvalue\fR, then a list describing \fIoption\fR is
returned.  If one or more \fIoption\fR and \fIvalue\fR pairs are
specified, then for each pair, the axis option \fIoption\fR is set to
\fIvalue\fR.  
The following options are valid for axes.
.RS
.TP
\fB\-autorange \fIrange\fR 
Sets the range of values for the axis to \fIrange\fR.  The axis limits
are automatically reset  to display the most recent data points in this range.  
If \fIrange\fR is 0.0, the range is
determined from the limits of the data.  If \fB\-min\fR or \fB-max\fR
are specified, they override this option.  The default is \fC0.0\fR.
.TP
\fB\-color \fIcolor\fR
Sets the color of the axis and tick labels.
The default is \fCblack\fR.
.TP
\fB\-command \fIprefix\fR
Specifies a Tcl command to be invoked when formatting the axis tick
labels. \fIPrefix\fR is a string containing the name of a Tcl proc and
any extra arguments for the procedure.  This command is invoked for each
major tick on the axis.  Two additional arguments are passed to the
procedure: the pathname of the widget and the current the numeric
value of the tick.  The procedure returns the formatted tick label.  If
\fC""\fR is returned, no label will appear next to the tick.  You can
get the standard tick labels again by setting \fIprefix\fR to
\fC""\fR.  The default is \fC""\fR.
.sp 1
Please note that this procedure is invoked while the strip chart is redrawn.
You may query the configuration options.  But do not reset them, because 
this can have unexpected results.
.TP
\fB\-descending \fIboolean\fR 
Indicates whether the values along the axis are monotonically increasing or
decreasing.  If \fIboolean\fR is true, the axis values will be
decreasing.  The default is \fC0\fR.
.TP
\fB\-hide \fIboolean\fR
Indicates whether the axis is displayed. 
.TP
\fB\-justify \fIjustify\fR
Specifies how the axis title should be justified.  This matters only
when the axis title contains more than one line of text. \fIJustify\fR
must be \fCleft\fR, \fCright\fR, or \fCcenter\fR.  The default is
\fCcenter\fR.
.TP
\fB\-limits \fIformatStr\fR
Specifies a printf-like description to format the minimum and maximum
limits of the axis.  The limits are displayed at the top/bottom or
left/right sides of the plotting area.  \fIFormatStr\fR is a list of
one or two format descriptions.  If one description is supplied, both
the minimum and maximum limits are formatted in the same way.  If two,
the first designates the format for the minimum limit, the second for
the maximum.  If \fC""\fR is given as either description, then 
the that limit will not be displayed.  The default is \fC""\fR.
.TP
\fB\-linewidth \fIpixels\fR
Sets the width of the axis and tick lines.  The default is \fC1\fR
pixel.
.TP
\fB\-logscale \fIboolean\fR
Indicates whether the scale of the axis is logarithmic or linear.  If
\fIboolean\fR is true, the axis is logarithmic.  The default scale is
linear.
.TP
\fB\-loose \fIboolean\fR
Indicates whether the limits of the axis should fit the data points tightly,
at the outermost data points, or loosely, at the outer tick intervals.
This is relevant only when the axis limit is automatically calculated.
If \fIboolean\fR is true, the axis range is "loose".
The default is \fC0\fR.
.TP
\fB\-majorticks \fImajorList\fR
Specifies where to display major axis ticks.  You can use this option
to display ticks at non-uniform intervals.  \fIMajorList\fR is a list
of axis coordinates designating the location of major ticks.  No
minor ticks are drawn.  If \fImajorList\fR is \fC""\fR, 
major ticks will be automatically computed. The default is \fC""\fR.
.TP
\fB\-max \fIvalue\fR
Sets the maximum limit of \fIaxisName\fR.  Any data point greater 
than \fIvalue\fR is not displayed.  If \fIvalue\fR is \fC""\fR, 
the maximum limit is calculated using the largest data value.
The default is \fC""\fR.
.TP
\fB\-min \fIvalue\fR
Sets the minimum limit of \fIaxisName\fR. Any data point less than 
\fIvalue\fR is not displayed.  If \fIvalue\fR is \fC""\fR,
the minimum limit is calculated using the smallest data value.
The default is \fC""\fR.
.TP
\fB\-minorticks \fIminorList\fR
Specifies where to display minor axis ticks.  You can use this option
to display minor ticks at non-uniform intervals. \fIMinorList\fR is a
list of real values, ranging from 0.0 to 1.0, designating the placement of
a minor tick.  No minor ticks are drawn if the \fB\-majortick\fR
option is also set.  If \fIminorList\fR is \fC""\fR, minor ticks will
be automatically computed. The default is \fC""\fR.
.TP
\fB\-rotate \fItheta\fR
Specifies the how many degrees to rotate the axis tick labels.
\fITheta\fR is a real value representing the number of degrees
to rotate the tick labels.  The default is \fC0.0\fR degrees.
.TP
\fB\-shiftby \fIvalue\fR
Specifies how much to automatically shift the range of the axis.
When the new data exceeds the current axis maximum, the maximum
is increased in increments of \fIvalue\fR.  You can use this
option to prevent the axis limits from being recomputed
at each new time point. If \fIvalue\fR is 0.0, then no automatic
shifting is down. The default is \fC0.0\fR.
.TP
\fB\-showticks \fIboolean\fR
Indicates whether axis ticks should be drawn. If \fIboolean\fR is
true, ticks are drawn.  If false, only the
axis line is drawn. The default is \fC1\fR.
.TP
\fB\-stepsize \fIvalue\fR
Specifies the interval between major axis ticks.  If \fIvalue\fR isn't
a valid interval (must be less than the axis range), 
the request is ignored and the step size is automatically calculated.
.TP
\fB\-subdivisions \fInumber\fR 
Indicates how many minor axis ticks are
to be drawn.  For example, if \fInumber\fR is two, only one minor
tick is drawn.  If \fInumber\fR is one, no minor ticks are
displayed.  The default is \fC2\fR.
.TP
\fB\-tickfont \fIfontName\fR 
Specifies the font for axis tick labels. The default is
\fC*-Courier-Bold-R-Normal-*-100-*\fR.
.TP
\fB\-ticklength \fIpixels\fR
Sets the length of major and minor ticks (minor ticks are half the
length of major ticks). If \fIpixels\fR is less than zero, the axis
will be inverted with ticks drawn pointing towards the plot.  The
default is \fC0.1i\fR.
.TP
\fB\-title \fItext\fR
Sets the title of the axis. If \fItext\fR is 
\fC""\fR, no axis title will be displayed.  
.TP
\fB\-titlecolor \fIcolor\fR
Sets the color of the axis title. The default is \fCblack\fR.
.TP
\fB\-titlefont \fIfontName\fR 
Specifies the font for axis title. The default is
\fC*-Helvetica-Bold-R-Normal-*-14-140-*\fR.
.PP
Axis configuration options may be also be set by the \fBoption\fR
command.  The resource class is \fCAxis\fR.  The resource names
are the names of the axes (such as \fCx\fR or \fCx2\fR).
.DS
option add *Stripchart.Axis.Color  blue
option add *Stripchart.x.LogScale  true
option add *Stripchart.x2.LogScale false
.DE
.RE
.TP
\fIpathName \fBaxis \fBcreate \fIaxisName \fR?\fIoption value\fR?...
Creates a new axis by the name \fIaxisName\fR.  No axis by the same
name can already exist. \fIOption\fR and \fIvalue\fR are described 
in above in the axis \fBconfigure\fR operation.
.TP
\fIpathName \fBaxis \fBdelete \fR?\fIaxisName\fR?...
Deletes the named axes. An axis is not really
deleted until it is not longer in use, so it's safe to delete
axes mapped to elements.
.TP
\fIpathName \fBaxis invtransform \fIaxisName value\fR
Performs the inverse transformation, changing the screen coordinate
\fIvalue\fR to a graph coordinate, mapping the value mapped to
\fIaxisName\fR.  Returns the graph coordinate.
.TP
\fIpathName \fBaxis limits \fIaxisName\fR
Returns a list of the minimum and maximum limits for \fIaxisName\fR.  The order
of the list is \fCmin max\fR.
.TP
\fIpathName \fBaxis names \fR?\fIpattern\fR?...
Returns a list of axes matching zero or more patterns.  If no
\fIpattern\fR argument is give, the names of all axes are returned.
.TP
\fIpathName \fBaxis transform \fIaxisName value\fR
Transforms the coordinate \fIvalue\fR to a screen coordinate by mapping
the it to \fIaxisName\fR.  Returns the transformed screen coordinate.
.PP
Only four axes can be displayed simultaneously.  By default, they are
\fCx\fR, \fCy\fR, \fCx2\fR, and \fCy2\fR.  You can swap in a different
axis with \fBuse\fR operation of the special axis components:
\fBxaxis\fR, \fBx2axis\fR, \fByaxis\fR, and \fBy2axis\fR.
.DS
\&.g create axis temp
\&.g create axis time
\&...
\&.g xaxis use temp
\&.g yaxis use time
.DE
Only the axes specified for use are displayed on the screen.
.PP
The \fBxaxis\fR, \fBx2axis\fR, \fByaxis\fR, and \fBy2axis\fR
components operate on an axis location rather than a specific axis
like the more general \fBaxis\fR component does.  The \fBxaxis\fR
component manages the X-axis located in the bottom margin (whatever
axis that happens to be).  Likewise, \fByaxis\fR uses the Y-axis in
the left margin, \fBx2axis\fR the top X-axis, and \fBy2axis\fR the
right Y-axis.
.PP
They implicitly control the axis that is currently using to that
location.  By default, \fBxaxis\fR uses the \fCx\fR axis, \fByaxis\fR
uses \fCy\fR, \fBx2axis\fR uses \fCx2\fR, and \fBy2axis\fR uses
\fCy2\fR.  These components can be more convenient to use than always
determining what axes are current being displayed by the graph.
.PP
The following operations are available for axes. They mirror exactly
the operations of the \fBaxis\fR component.  The \fIaxis\fR argument
must be \fBxaxis\fR, \fBx2axis\fR, \fByaxis\fR, or \fBy2axis\fR.
.TP
\fIpathName \fIaxis \fBcget \fIoption\fR
.TP
\fIpathName \fIaxis \fBconfigure \fR?\fIoption value\fR?...
.TP
\fIpathName \fIaxis\fB invtransform \fIvalue\fR
.TP
\fIpathName \fIaxis \fBlimits\fR
.TP
\fIpathName \fIaxis\fB transform \fIvalue\fR
.TP
\fIpathName \fIaxis\fB use \fR?\fIaxisName\fR?  
Designates the axis \fIaxisName\fR is to be displayed at this
location.  \fIAxisName\fR can not be already in use at another location.  
This command returns the name of the axis currently using this location.
.SS "CROSSHAIRS COMPONENT"
Cross hairs consist of two intersecting lines (one vertical and one horizontal)
drawn completely across the plotting area.  They are used to position
the mouse in relation to the coordinate axes.  Cross hairs differ from line
markers in that they are implemented using XOR drawing primitives.
This means that they can be quickly drawn and erased without redrawing
the entire strip chart.
.PP
The following operations are available for cross hairs:
.TP
\fIpathName \fBcrosshairs cget \fIoption\fR
Returns the current value of the cross hairs configuration option
given by \fIoption\fR.  \fIOption\fR may be any option
described below for the cross hairs \fBconfigure\fR operation.
.TP
\fIpathName \fBcrosshairs configure \fR?\fIoption value\fR?...  
Queries or modifies the configuration options of the cross hairs.  If
\fIoption\fR isn't specified, a list describing all the current
options for the cross hairs is returned.  If \fIoption\fR is specified,
but not \fIvalue\fR, then a list describing \fIoption\fR is returned.
If one or more \fIoption\fR and \fIvalue\fR pairs are specified, then
for each pair, the cross hairs option \fIoption\fR is set to
\fIvalue\fR.
The following options are available for cross hairs.
.RS
.TP
\fB\-color \fIcolor\fR 
Sets the color of the cross hairs.  The default is \fCblack\fR.
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of the cross hairs. \fIDashList\fR is a list of up
to 11 numbers that alternately represent the lengths of the dashes
and gaps on the cross hair lines.  Each number must be between 1 and
255.  If \fIdashList\fR is \fC""\fR, the cross hairs will be solid
lines.
.TP
\fB\-hide \fIboolean\fR
Indicates whether cross hairs are drawn. If \fIboolean\fR is true,
cross hairs are not drawn.  The default is \fCyes\fR.
.TP
\fB\-linewidth \fIpixels\fR
Set the width of the cross hair lines.  The default is \fC1\fR.
.TP
\fB\-position \fIpos\fR 
Specifies the screen position where the cross hairs intersect.
\fIPos\fR must be in the form "\fI@x,y\fR", where \fIx\fR and \fIy\fR
are the window coordinates of the intersection.
.PP
Cross hairs configuration options may be also be set by the
\fBoption\fR command.  The resource name and class are
\fCcrosshairs\fR and \fCCrosshairs\fR respectively.
.DS
option add *Stripchart.Crosshairs.LineWidth 2
option add *Stripchart.Crosshairs.Color     red
.DE
.RE
.TP
\fIpathName \fBcrosshairs off\fR
Turns of the cross hairs. 
.TP
\fIpathName \fBcrosshairs on\fR
Turns on the display of the cross hairs.
.TP
\fIpathName \fBcrosshairs toggle\fR 
Toggles the current state of the cross hairs, alternately mapping and
unmapping the cross hairs.
.SS "ELEMENT COMPONENTS"
A data element represents a set of data.  It contains x and y vectors
containing the coordinates of the data points.  Elements can be
displayed with a symbol at each data point and lines connecting the
points.  Elements also control the appearance of the data, such as the
symbol type, line width, color etc.
.PP
When new data elements are created, they are automatically added to a
list of displayed elements.   The display list controls what elements
are drawn and in what order.  
.PP
The following operations are available for elements.
.TP
\fIpathName \fBelement activate \fIelemName \fR?\fIindex\fR?...
Specifies the data points of element \fIelemName\fR to be drawn
using active foreground and background colors.  \fIElemName\fR is the
name of the element and \fIindex\fR is a number representing the index
of the data point. If no indices are present then all data points
become active.
.TP
\fIpathName \fBelement cget \fIelemName \fIoption\fR
Returns the current value of the element configuration option given by 
\fIoption\fR.  \fIOption\fR may be any option described below
for the element \fBconfigure\fR operation.
.TP
\fIpathName \fBelement closest \fIx y\fR \fIvarName\fR ?\fIoption value\fR?... ?\fIelemName\fR?...
Finds the data point closest to the window coordinates \fIx\fR and
\fIy\fR in the element \fIelemName\fR.  \fIElemName\fR is the name of
an element, that must not be hidden.  If no elements are specified,
then all visible elements are searched.  It returns via the array
variable \fIvarName\fR the name of the closest element, the index of
its closest point, and the graph coordinates of the point. Returns
\fC0\fR, if no data point within the threshold distance can be found,
otherwise \fC1\fR is returned.  The following
\fIoption\fR\-\fIvalue\fR pairs are available.
.RS
.TP
\fB\-halo \fIpixels\fR
Specifies a threshold distance where selected data points are ignored.
\fIPixels\fR is a valid screen distance, such as \fC2\fR or \fC1.2i\fR.
If this option isn't specified, then it defaults to the value of the
stripchart's \fB\-halo\fR option.
.TP
\fB\-interpolate \fIboolean\fR
Indicates that both the data points and interpolated points along
the line segment formed should be considered.  If \fIboolean\fR 
is true, the closest line segment will be selected instead of the
closest point. If this option isn't specified, \fIboolean\fR defaults 
to \fC0\fR.
.RE
.TP
\fIpathName \fBelement configure \fIelemName \fR?\fIoption value\fR?...
Queries or modifies the configuration options for elements.  If
\fIoption\fR isn't specified, a list describing all the current
options for \fIelemName\fR is returned.  If \fIoption\fR is specified,
but not \fIvalue\fR, then a list describing the option \fIoption\fR is
returned.  If one or more \fIoption\fR and \fIvalue\fR pairs are
specified, then for each pair, the element option \fIoption\fR is set
to \fIvalue\fR.  The following options are valid for elements.
.RS
.TP
\fB\-activepen \fIpenName\fR
Specifies pen to use to draw active element.  If \fIpenName\fR is
\fC""\fR, no active elements will be drawn.  The default is 
\fCactiveLine\fR.
.TP
\fB\-color \fIcolor\fR 
Sets the color of the traces connecting the data points.  
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of element line. \fIDashList\fR is a list of up to
11 numbers that alternately represent the lengths of the dashes and
gaps on the element line.  Each number must be between 1 and 255.  If
\fIdashList\fR is \fC""\fR, the lines will be solid.
.TP
\fB\-data \fIcoordList\fR
Specifies the X\-Y coordinates of the data.  \fICoordList\fR is a
list of numeric expressions representing the X\-Y coordinate pairs
of each data point.
.TP
\fB\-fill \fIcolor\fR 
Sets the interior color of symbols.  If \fIcolor\fR is \fC""\fR, then
the interior of the symbol is transparent.  If \fIcolor\fR is
\fCdefcolor\fR, then the color will be the same as the \fB\-color\fR
option.  The default is \fCdefcolor\fR.
.TP
\fB\-hide \fIboolean\fR
Indicates whether the element is displayed.  The default is \fCno\fR.
.TP
\fB\-label \fItext\fR
Sets the element's label in the legend.  If \fItext\fR
is \fC""\fR, the element will have no entry in the legend.
The default label is the element's name.
.TP
\fB\-linewidth \fIpixels\fR 
Sets the width of the connecting lines between data points.  If
\fIpixels\fR is \fC0\fR, no connecting lines will be drawn between
symbols.  The default is \fC0\fR.
.TP
\fB\-mapx \fIxAxis\fR
Selects the X\-axis to map the element's X\-coordinates onto.
\fIXAxis\fR must be the name of an axis.  The default is \fCx\fR.
.TP
\fB\-mapy \fIyAxis\fR
Selects the Y\-axis to map the element's Y\-coordinates onto.
\fIYAxis\fR must be the name of an axis. The default is \fCy\fR.
.TP
\fB\-offdash \fIcolor\fR
Sets the color of the stripes when traces are dashed (see the
\fB\-dashes\fR option).  If \fIcolor\fR is \fC""\fR, then the "off"
pixels will represent gaps instead of stripes.  If \fIcolor\fR is
\fCdefcolor\fR, then the color will be the same as the \fB\-color\fR
option.  The default is \fCdefcolor\fR.
.TP
\fB\-outline \fIcolor\fR 
Sets the color or the outline around each symbol.  If \fIcolor\fR is
\fC""\fR, then no outline is drawn. If \fIcolor\fR is \fCdefcolor\fR,
then the color will be the same as the \fB\-color\fR option.  The
default is \fCdefcolor\fR.
.TP
\fB\-outlinewidth \fIpixels\fR 
Sets the width of the outline bordering each symbol.  If \fIpixels\fR
is \fC0\fR, no outline will be drawn. The default is \fC1\fR.
.TP
\fB\-pixels \fIpixels\fR
Sets the size of symbols.  If \fIpixels\fR is \fC0\fR, no symbols will
be drawn.  The default is \fC0.125i\fR.
.TP
\fB\-scalesymbols \fIboolean\fR 
If \fIboolean\fR is true, the size of the symbols
drawn for \fIelemName\fR will change with scale of the X\-axis and Y\-axis.
At the time this option is set, the current ranges of the axes are
saved as the normalized scales (i.e scale factor is 1.0) and the
element is drawn at its designated size (see the \fB\-pixels\fR
option).  As the scale of the axes change, the symbol will be scaled
according to the smaller of the X\-axis and Y\-axis scales.  If \fIboolean\fR
is false, the element's symbols are drawn at the designated size,
regardless of axis scales.  The default is \fC0\fR.
.TP
\fB\-smooth \fIsmooth\fR 
Specifies how connecting line segments are drawn between data points.
\fISmooth\fR can be either \fClinear\fR, \fCstep\fR, \fCnatural\fR, or
\fCquadratic\fR.  If \fIsmooth\fR is \fClinear\fR, a single line
segment is drawn, connecting both data points. When \fIsmooth\fR is
\fCstep\fR, two line segments are drawn. The first is a horizontal
line segment which steps the next x-coordinate.  The second is a
vertical line, moving to the next y-coordinate.  Both \fInatural\fR and
\fIquadratic\fR generate multiple segments between data points.  If
\fInatural\fR, the segments are generated using a cubic spline.  If
\fIquadratic\fR, a quadratic spline is used.  The default is
\fIlinear\fR.
.TP
\fB\-styles \fIstyleList\fR 
Specifies what pen to use based upon the range of weights given.
\fIStyleList\fR is a list of style specifications. Each style
specification, in turn, is a list consisting of a pen name, and
optionally a minimum and maximum range.  Data points whose weight (see
the \fB\-weight\fR option) falls in this range, are drawn with this
pen.  If no range is specified it defaults to the number of the pen in
the list. 
.TP
\fB\-symbol \fIsymbol\fR 
Specifies the symbol for data points.  \fISymbol\fR can be either
\fCsquare\fR, \fCcircle\fR, \fCdiamond\fR, \fCplus\fR, \fCcross\fR,
\fCsplus\fR, \fCscross\fR, \fCtriangle\fR, \fC""\fR (where no symbol
is drawn), or a bitmap.  Bitmaps are specified as "\fIsource\fR
?\fImask\fR?", where \fIsource\fR is the name of the bitmap, and
\fImask\fR is the bitmap's optional mask.  The default is
\fCcircle\fR.
.TP
\fB\-weights \fIwVec\fR 
Specifies the weights of the individual data points.  This, in
conjunction with the list pen styles (see the \fB\-styles\fR option)
controls how data points are drawn.  \fIWVec\fR is the name of a BLT
vector or a list of numeric expressions representing the weights for
each data point.
.TP
\fB\-xdata \fIxVec\fR 
Specifies the x-coordinates of the data.  \fIXVec\fR is the name of
a BLT vector or a list of numeric expressions.
.TP
\fB\-ydata \fIyVec\fR 
Specifies the y-coordinates of the data.  \fIYVec\fR is the name of
a BLT vector or a list of numeric expressions.
.PP
Element configuration options may also be set by the \fBoption\fR
command.  The resource class is \fCElement\fR. The resource name is
the name of the element.
.DS
option add *Stripchart.Element.symbol line
option add *Stripchart.e1.symbol line
.DE
.RE
.TP
\fIpathName \fBelement create \fIelemName\fR ?\fIoption value\fR?...
Creates a new element \fIelemName\fR.  It's an error is
an element \fIelemName\fR already exists.  If
additional arguments are present, they specify options valid for 
element \fBconfigure\fR operation.
.TP
\fIpathName \fBelement deactivate \fIelemName\fR ?\fIelemName\fR?...
Deactivates all the elements matching \fIpattern\fR.
Elements whose names match any of the patterns given are redrawn using
their normal colors.
.TP
\fIpathName \fBelement delete\fR ?\fIelemName\fR?...
Deletes all the named elements.  The graph is automatically redrawn.
.TP
\fIpathName \fBelement exists \fIelemName\fR
Returns \fC1\fR if an element \fIelemName\fR currently exists and \fC0\fR otherwise.
.TP
\fIpathName \fBelement names \fR?\fIpattern\fR?...  
Returns the elements matching one or more pattern.  If no
\fIpattern\fR is given, the names of all elements is returned.
.TP
\fIpathName \fBelement show\fR ?\fInameList\fR?  
Queries or modifies the element display list.  The element display
list designates the elements drawn and in what
order. \fINameList\fR is a list of elements to be displayed in the
order they are named.  If there is no \fInameList\fR argument,
the current display list is returned.
.TP
\fIpathName \fBelement type\fR \fIelemName\fR
Returns the type of \fIelemName\fR. 
If the element is a bar element, the commands returns the string
\fC"bar"\fR, otherwise it returns \fC"line"\fR.
.DE
.SS "GRID COMPONENT"
Grid lines extend from the major and minor ticks of each axis
horizontally or vertically across the plotting area.  The following
operations are available for grid lines.
.TP
\fIpathName \fBgrid cget \fIoption\fR
Returns the current value of the grid line configuration option given by 
\fIoption\fR.  \fIOption\fR may be any option described below
for the grid \fBconfigure\fR operation.
.TP
\fIpathName \fBgrid configure\fR ?\fIoption value\fR?...
Queries or modifies the configuration options for grid lines.  If
\fIoption\fR isn't specified, a list describing all the current
grid options for \fIpathName\fR is returned.  If \fIoption\fR is specified,
but not \fIvalue\fR, then a list describing \fIoption\fR is
returned.  If one or more \fIoption\fR and \fIvalue\fR pairs are
specified, then for each pair, the grid line option \fIoption\fR is set to
\fIvalue\fR.  The following options are valid for grid lines.
.RS
.TP
\fB\-color \fIcolor\fR 
Sets the color of the grid lines.  The default is \fCblack\fR.
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of the grid lines. \fIDashList\fR is a list of up
to 11 numbers that alternately represent the lengths of the dashes
and gaps on the grid lines.  Each number must be between 1 and 255.
If \fIdashList\fR is \fC""\fR, the grid will be solid lines.
.TP
\fB\-hide \fIboolean\fR
Indicates whether the grid should be drawn. If \fIboolean\fR
is true, grid lines are not shown. The default is \fCyes\fR.
.TP
\fB\-linewidth \fIpixels\fR
Sets the width of grid lines.  The default width is \fC1\fR.
.TP
\fB\-mapx \fIxAxis\fR
Specifies the X\-axis to display grid lines.  \fIXAxis\fR
must be the name of an axis.  The default is \fCx\fR.
.TP
\fB\-mapy \fIyAxis\fR
Specifies the Y\-axis to display grid lines.  \fIYAxis\fR
must be the name of an axis. The default is \fCy\fR.
.TP
\fB\-minor \fIboolean\fR
Indicates whether the grid lines should be drawn for minor ticks. 
If \fIboolean\fR is true, the lines will appear at
minor tick intervals.  The default is \fC1\fR.
.PP
Grid configuration options may also be set by the 
\fBoption\fR command.  The resource name and class are \fCgrid\fR and 
\fCGrid\fR respectively. 
.DS
option add *Stripchart.grid.LineWidth 2
option add *Stripchart.Grid.Color     black
.DE
.RE
.TP
\fIpathName \fBgrid off\fR
Turns off the display the grid lines.
.TP
\fIpathName \fBgrid on\fR
Turns on the display the grid lines.
.TP
\fIpathName \fBgrid toggle\fR
Toggles the display of the grid.  
.SS "LEGEND COMPONENT"
The legend displays a list of the data elements.  Each entry consists
of the element's symbol and label.  The legend can appear in any
margin (the default location is in the right margin).  It
can also be positioned anywhere within the plotting area.
.PP
The following operations are valid for the legend.
.TP
\fIpathName \fBlegend activate \fIpattern\fR...
Selects legend entries to be drawn using the active legend colors and relief.
All entries whose element names match \fIpattern\fR  are selected.  To
be selected, the element name must match only one \fIpattern\fR. 
.TP
\fIpathName \fBlegend cget \fIoption\fR
Returns the current value of a legend configuration option.
\fIOption\fR may be any option described below in the
legend \fBconfigure\fR operation.
.TP
\fIpathName \fBlegend configure \fR?\fIoption value\fR?...
Queries or modifies the configuration options for the legend.  If
\fIoption\fR isn't specified, a list describing the current
legend options for \fIpathName\fR is returned.  If \fIoption\fR is
specified, but not \fIvalue\fR, then a list describing \fIoption\fR is
returned.  If one or more \fIoption\fR and \fIvalue\fR pairs are
specified, then for each pair, the legend option \fIoption\fR is set
to \fIvalue\fR.  The following options are valid for the legend.
.RS
.TP
\fB\-activebackground \fIcolor\fR
Sets the background color for active legend entries.  All legend
entries marked active (see the legend \fBactivate\fR operation) are
drawn using this background color.
.TP
\fB\-activeborderwidth \fIpixels\fR
Sets the width of the 3-D border around the outside edge of the active legend
entries.  The default is \fC2\fR.
.TP
\fB\-activeforeground \fIcolor\fR
Sets the foreground color for active legend entries.  All legend
entries marked as active (see the legend \fBactivate\fR operation) are
drawn using this foreground color.
.TP
\fB\-activerelief \fIrelief\fR 
Specifies the 3-D effect desired for active legend entries.
\fIRelief\fR denotes how the interior of the entry should appear
relative to the legend; for example, \fCraised\fR means the entry
should appear to protrude from the legend, relative to the surface of
the legend.  The default is \fCflat\fR.
.TP
\fB\-anchor \fIanchor\fR
Tells how to position the legend relative to the positioning point for
the legend.  This is dependent on the value of the \fB\-position\fR
option.  The default is \fCcenter\fR.
.RS
.TP 1.25i
\fCleft\fR or \fCright\fR
The anchor describes how to position the legend vertically.  
.TP
\fCtop\fR or \fCbottom\fR
The anchor describes how to position the legend horizontally.  
.TP
\fC@x,y\fR
The anchor specifies how to position the legend relative to the
positioning point. For example, if \fIanchor\fR is \fCcenter\fR then
the legend is centered on the point; if \fIanchor\fR is \fCn\fR then
the legend will be drawn such that the top center point of the
rectangular region occupied by the legend will be at the positioning
point.
.TP
\fCplotarea\fR
The anchor specifies how to position the legend relative to the
plotting area. For example, if \fIanchor\fR is \fCcenter\fR then the
legend is centered in the plotting area; if \fIanchor\fR is \fCne\fR
then the legend will be drawn such that occupies the upper right
corner of the plotting area.
.RE
.TP
\fB\-background \fIcolor\fR
Sets the background color of the legend. If \fIcolor\fR is \fC""\fR,
the legend background with be transparent.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3-D border around the outside edge of the legend (if
such border is being drawn; the \fBrelief\fR option determines this).
The default is \fC2\fR pixels.
.TP
\fB\-font \fIfontName\fR 
\fIFontName\fR specifies a font to use when drawing the labels of each
element into the legend.  The default is
\fC*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the foreground color of the text drawn for the element's label.
The default is \fCblack\fR.
.TP
\fB\-hide \fIboolean\fR
Indicates whether the legend should be displayed. If \fIboolean\fR is
true, the legend will not be draw.  The default is \fCno\fR.
.TP
\fB\-ipadx \fIpad\fR 
Sets the amount of internal padding to be added to the width of each
legend entry.  \fIPad\fR can be a list of one or two screen distances.  If
\fIpad\fR has two elements, the left side of the legend entry is
padded by the first distance and the right side by the second.  If
\fIpad\fR is just one distance, both the left and right sides are padded
evenly.  The default is \fC2\fR.
.TP
\fB\-ipady \fIpad\fR
Sets an amount of internal padding to be added to the height of each
legend entry.  \fIPad\fR can be a list of one or two screen distances.  If
\fIpad\fR has two elements, the top of the entry is padded by the
first distance and the bottom by the second.  If \fIpad\fR is just
one distance, both the top and bottom of the entry are padded evenly.
The default is \fC2\fR.
.TP
\fB\-padx \fIpad\fR
Sets the padding to the left and right exteriors of the legend.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the legend is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default is \fC4\fR.
.TP
\fB\-pady \fIpad\fR
Sets the padding above and below the legend.  \fIPad\fR can be a list
of one or two screen distances.  If \fIpad\fR has two elements, the area above
the legend is padded by the first distance and the area below by the
second.  If \fIpad\fR is just one distance, both the top and
bottom areas are padded evenly.  The default is \fC0\fR.
.TP
\fB\-position \fIpos\fR
Specifies where the legend is drawn. The
\fB\-anchor\fR option also affects where the legend is positioned.  If
\fIpos\fR is \fCleft\fR, \fCleft\fR, \fCtop\fR, or \fCbottom\fR, the
legend is drawn in the specified margin.  If \fIpos\fR is
\fCplotarea\fR, then the legend is drawn inside the plotting area at a
particular anchor.  If \fIpos\fR is in the form "\fI@x,y\fR", where
\fIx\fR and \fIy\fR are the window coordinates, the legend is drawn in
the plotting area at the specified coordinates.  The default is
\fCright\fR.
.TP
\fB\-raised \fIboolean\fR
Indicates whether the legend is above or below the data elements.  This
matters only if the legend is in the plotting area.  If \fIboolean\fR
is true, the legend will be drawn on top of any elements that may
overlap it. The default is \fCno\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the border around the legend.
\fIRelief\fR specifies how the interior of the legend should appear
relative to the strip chart; for example, \fCraised\fR means the legend
should appear to protrude from the strip chart, relative to the surface of
the strip chart.  The default is \fCsunken\fR.
.PP
Legend configuration options may also be set by the \fBoption\fR
command.  The resource name and class are \fClegend\fR and
\fCLegend\fR respectively.
.DS
option add *Stripchart.legend.Foreground blue
option add *Stripchart.Legend.Relief     raised
.DE
.RE
.TP
\fIpathName \fBlegend deactivate \fIpattern\fR...
Selects legend entries to be drawn using the normal legend colors and
relief.  All entries whose element names match \fIpattern\fR are
selected.  To be selected, the element name must match only one
\fIpattern\fR.
.TP
\fIpathName \fBlegend get \fIpos\fR
Returns the name of the element whose entry is at the screen position
\fIpos\fR in the legend.  \fIPos\fR must be in the form "\fI@x,y\fR",
where \fIx\fR and \fIy\fR are window coordinates.  If the given
coordinates do not lie over a legend entry, \fC""\fR is returned.
.SS "PEN COMPONENTS"
Pens define attributes (both symbol and line style) for elements.
Pens mirror the configuration options of data elements that pertain to
how symbols and lines are drawn.  Data elements use pens to determine
how they are drawn.  A data element may use several pens at once.  In
this case, the pen used for a particular data point is determined from
each element's weight vector (see the element's \fB\-weight\fR and
\fB\-style\fR options).
.PP
One pen, called \fCactiveLine\fR, is automatically created.
It's used as the default active pen for elements. So you can change
the active attributes for all elements by simply reconfiguring this
pen.
.DS
\&.s pen configure "activeLine" -color green
.DE
You can create and use any number of pens. To create a pen, invoke
the pen component and its create operation.
.DS
\&.s pen create myPen
.DE
You map pens to a data element using either the element's 
\fB\-pen\fR or \fB\-activepen\fR options.
.DS
\&.s element create "line1" -xdata $x -ydata $tempData \\
    -pen myPen
.DE
An element can use several pens at once. This is done by specifying
the name of the pen in the element's style list (see the
\fB\-styles\fR option).
.DS
\&.s element configure "line1" -styles { myPen 2.0 3.0 }
.DE
This says that any data point with a weight between 2.0 and 3.0
is to be drawn using the pen \fCmyPen\fR.  All other points
are drawn with the element's default attributes.
.PP
The following operations are available for pen components.
.PP
.TP
\fIpathName \fBpen \fBcget \fIpenName \fIoption\fR
Returns the current value of the option given by \fIoption\fR for
\fIpenName\fR.  \fIOption\fR may be any option described below
for the pen \fBconfigure\fR operation.
.TP
\fIpathName \fBpen \fBconfigure \fIpenName \fR?\fIoption value\fR?...
Queries or modifies the configuration options of \fIpenName\fR.  If
\fIoption\fR isn't specified, a list describing the current
options for \fIpenName\fR is returned.  If \fIoption\fR is specified, but
not \fIvalue\fR, then a list describing \fIoption\fR is
returned.  If one or more \fIoption\fR and \fIvalue\fR pairs are
specified, then for each pair, the pen option \fIoption\fR is set to
\fIvalue\fR.  
The following options are valid for pens.
.RS
.TP
\fB\-color \fIcolor\fR 
Sets the color of the traces connecting the data points.  
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of element line. \fIDashList\fR is a list of up to
11 numbers that alternately represent the lengths of the dashes and
gaps on the element line.  Each number must be between 1 and 255.  If
\fIdashList\fR is \fC""\fR, the lines will be solid.
.TP
\fB\-fill \fIcolor\fR 
Sets the interior color of symbols.  If \fIcolor\fR is \fC""\fR, then
the interior of the symbol is transparent.  If \fIcolor\fR is
\fCdefcolor\fR, then the color will be the same as the \fB\-color\fR
option.  The default is \fCdefcolor\fR.
.TP
\fB\-linewidth \fIpixels\fR 
Sets the width of the connecting lines between data points.  If
\fIpixels\fR is \fC0\fR, no connecting lines will be drawn between
symbols.  The default is \fC0\fR.
.TP
\fB\-offdash \fIcolor\fR
Sets the color of the stripes when traces are dashed (see the
\fB\-dashes\fR option).  If \fIcolor\fR is \fC""\fR, then the "off"
pixels will represent gaps instead of stripes.  If \fIcolor\fR is
\fCdefcolor\fR, then the color will be the same as the \fB\-color\fR
option.  The default is \fCdefcolor\fR.
.TP
\fB\-outline \fIcolor\fR 
Sets the color or the outline around each symbol.  If \fIcolor\fR is
\fC""\fR, then no outline is drawn. If \fIcolor\fR is \fCdefcolor\fR,
then the color will be the same as the \fB\-color\fR option.  The
default is \fCdefcolor\fR.
.TP
\fB\-outlinewidth \fIpixels\fR 
Sets the width of the outline bordering each symbol.  If \fIpixels\fR
is \fC0\fR, no outline will be drawn. The default is \fC1\fR.
.TP
\fB\-pixels \fIpixels\fR
Sets the size of symbols.  If \fIpixels\fR is \fC0\fR, no symbols will
be drawn.  The default is \fC0.125i\fR.
.TP
\fB\-symbol \fIsymbol\fR 
Specifies the symbol for data points.  \fISymbol\fR can be either
\fCsquare\fR, \fCcircle\fR, \fCdiamond\fR, \fCplus\fR, \fCcross\fR,
\fCsplus\fR, \fCscross\fR, \fCtriangle\fR, \fC""\fR (where no symbol
is drawn), or a bitmap.  Bitmaps are specified as "\fIsource\fR
?\fImask\fR?", where \fIsource\fR is the name of the bitmap, and
\fImask\fR is the bitmap's optional mask.  The default is
\fCcircle\fR.
.TP
\fB\-type \fIelemType\fR 
Specifies the type of element the pen is to be used with.
This option should only be employed when creating the pen.  This
is for those that wish to mix different types of elements (bars and
lines) on the same graph.  The default type is "line".
.PP
Pen configuration options may be also be set by the \fBoption\fR
command.  The resource class is \fCPen\fR.  The resource names
are the names of the pens.
.DS
option add *Stripchart.Pen.Color  blue
option add *Stripchart.activeLine.color  green
.DE
.RE
.TP
\fIpathName \fBpen \fBcreate \fIpenName \fR?\fIoption value\fR?...
Creates a new pen by the name \fIpenName\fR.  No pen by the same
name can already exist. \fIOption\fR and \fIvalue\fR are described 
in above in the pen \fBconfigure\fR operation.
.TP
\fIpathName \fBpen \fBdelete \fR?\fIpenName\fR?...
Deletes the named pens. A pen is not really
deleted until it is not longer in use, so it's safe to delete
pens mapped to elements.
.TP
\fIpathName \fBpen names \fR?\fIpattern\fR?...
Returns a list of pens matching zero or more patterns.  If no
\fIpattern\fR argument is give, the names of all pens are returned.
.SS "POSTSCRIPT COMPONENT"
The strip chart can generate encapsulated PostScript output.  There
are several configuration options you can specify to control how the
plot is generated.  You can change the page dimensions and
borders.  The plot itself can be scaled, centered, or rotated to
landscape.  The PostScript output can be written directly to a file or
returned through the interpreter.
.PP
The following postscript operations are available.
.TP
\fIpathName \fBpostscript cget \fIoption\fR 
Returns the current value of the postscript option given by
\fIoption\fR.  \fIOption\fR may be any option described
below for the postscript \fBconfigure\fR operation.
.TP
\fIpathName \fBpostscript configure \fR?\fIoption value\fR?...
Queries or modifies the configuration options for PostScript
generation.  If \fIoption\fR isn't specified, a list describing 
the current postscript options for \fIpathName\fR is returned.  If
\fIoption\fR is specified, but not \fIvalue\fR, then a list describing
\fIoption\fR is returned.  If one or more \fIoption\fR and \fIvalue\fR
pairs are specified, then for each pair, the postscript option
\fIoption\fR is set to \fIvalue\fR.  The following postscript options
are available.
.RS
.TP
\fB\-center \fIboolean\fR
Indicates whether the plot should be centered on the PostScript page.  If
\fIboolean\fR is false, the plot will be placed in the upper left
corner of the page.  The default is \fC1\fR.
.TP
\fB\-colormap \fIvarName\fR
\fIVarName\fR must be the name of a global array variable that
specifies a color mapping from the X color name to PostScript.  Each
element of \fIvarName\fR must consist of PostScript code to set a
particular color value (e.g. ``\fC1.0 1.0 0.0 setrgbcolor\fR'').  When
outputting color information in PostScript, the array variable \fIvarName\fR 
is checked to see if an element of the name of the color exists. If so, 
it uses the value of the element as the PostScript
command to set the color.  If this option hasn't been specified, or if
there isn't an entry in \fIvarName\fR for a given color, then it uses
the red, green, and blue intensities from the X color.
.TP
\fB\-colormode \fImode\fR
Specifies how to output color information.  \fIMode\fR must be either
\fCcolor\fR (for full color output), \fCgray\fR (convert all colors to
their gray-scale equivalents) or \fCmono\fR (convert foreground colors
to black and background colors to white).  The default mode is
\fCcolor\fR. 
.TP
\fB\-fontmap \fIvarName\fR
\fIVarName\fR must be the name of a global array variable that
specifies a font mapping from the X font name to PostScript.  Each
element of \fIvarName\fR must consist of a Tcl list with one or two
elements, which are the name and point size of a PostScript font.
When outputting PostScript commands for a particular font, the 
array variable \fIvarName\fR is checked to see an element of the specified 
font exists.  If there is such an element, then the font
information contained in that element is used in the PostScript
output.  (If the point size is omitted from the list, the point size
of the X font is used).  Otherwise the X font is examined in an
attempt to guess what PostScript font to use.  This works only for
fonts whose foundry property is \fIAdobe\fR (such as Times, Helvetica,
Courier, etc.).  If all of this fails then the font defaults to
\fCHelvetica-Bold\fR.
.TP
\fB\-decorations \fIboolean\fR
Indicates if PostScript commands to generate color backgrounds and 3-D
borders should be output.  If \fIboolean\fR is false, the background will 
be white and no 3-D borders will be generated. The
default is \fC1\fR.
.TP
\fB\-height \fIpixels\fR
Sets the height of the plot.  This lets you plot the stripchart with a
height different from the one displayed on the screen.  If
\fIpixels\fR is 0, the height is the same as the displayed height.
The default is \fC0\fR.
.TP
\fB\-landscape \fIboolean\fR
If \fIboolean\fR is true, this specifies the printed area is to be
rotated 90 degrees.  In non-rotated output the X-axis of the printed
area runs along the short dimension of the page (``portrait''
orientation); in rotated output the X-axis runs along the long
dimension of the page (``landscape'' orientation).  Defaults to
\fC0\fR.
.TP
\fB\-maxpect \fIboolean\fR
Indicates to scale the the plot so that it fills the PostScript page.
The aspect ratio of the strip chart is still retained.  The default is
\fC0\fR.
.TP
\fB\-padx \fIpad\fR
Sets the horizontal padding for the left and right page borders.  The
borders are exterior to the plot.  \fIPad\fR can be a list of one or
two screen distances.  If \fIpad\fR has two elements, the left border is padded
by the first distance and the right border by the second.  If
\fIpad\fR has just one distance, both the left and right borders are
padded evenly.  The default is \fC1i\fR.
.TP
\fB\-pady \fIpad\fR 
Sets the vertical padding for the top and bottom page borders. The
borders are exterior to the plot.  \fIPad\fR can be a list of one or
two screen distances.  If \fIpad\fR has two elements, the top border is padded
by the first distance and the bottom border by the second.  If
\fIpad\fR has just one distance, both the top and bottom borders are
padded evenly.  The default is \fC1i\fR.
.TP
\fB\-paperheight \fIpixels\fR
Sets the height of the postscript page.  This can be used to select
between different page sizes (letter, A4, etc).  The default height is
\fC11.0i\fR.
.TP
\fB\-paperwidth \fIpixels\fR
Sets the width of the postscript page.  This can be used to select
between different page sizes (letter, A4, etc).  The default width is
\fC8.5i\fR.
.TP
\fB\-width \fIpixels\fR
Sets the width of the plot.  This lets you plot the strip chart with a
width different from the one drawn on the screen.  If \fIpixels\fR
is 0, the width is the same as the widget's width.  The default is
\fC0\fR.
.PP
Postscript configuration options may be also be set by the
\fBoption\fR command.  The resource name and class are
\fCpostscript\fR and \fCPostscript\fR respectively.
.DS
option add *Stripchart.postscript.Decorations false
option add *Stripchart.Postscript.Landscape   true
.DE
.RE
.TP
\fIpathName \fBpostscript output \fR?\fIfileName\fR? ?\fIoption value\fR?...
Outputs a file of encapsulated PostScript.  If a
\fIfileName\fR argument isn't present, the command returns the
PostScript. If any \fIoption-value\fR pairs are present, they set
configuration options controlling how the PostScript is generated.
\fIOption\fR and \fIvalue\fR can be anything accepted by the
postscript \fBconfigure\fR operation above.
.SS "MARKER COMPONENTS"
Markers are simple drawing procedures used to annotate or highlight
areas of the strip chart.  Markers have various types: text strings,
bitmaps, images, connected lines, windows, or polygons.  They can be
associated with a particular element, so that when the element is
hidden or un-hidden, so is the marker.  By default, markers are the
last items drawn, so that data elements will appear in
behind them.  You can change this by configuring the \fB\-under\fR
option.
.PP
Markers, in contrast to elements, don't affect the scaling of the
coordinate axes.  They can also have \fIelastic\fR coordinates
(specified by \fC-Inf\fR and \fCInf\fR respectively) that translate
into the minimum or maximum limit of the axis.  For example, you can
place a marker so it always remains in the lower left corner of the
plotting area, by using the coordinates \fC-Inf\fR,\fC-Inf\fR.
.PP
The following operations are available for markers.
.TP
\fIpathName \fBmarker after \fImarkerId\fR ?\fIafterId\fR?
Changes the order of the markers, drawing the first
marker after the second.  If no second \fIafterId\fR argument is
specified, the marker is placed at the end of the display list.  This
command can be used to control how markers are displayed since markers
are drawn in the order of this display list.
.TP
\fIpathName \fBmarker before \fImarkerId\fR ?\fIbeforeId\fR?
Changes the order of the markers, drawing the first
marker before the second.  If no second \fIbeforeId\fR argument is
specified, the marker is placed at the beginning of the display list.
This command can be used to control how markers are displayed since
markers are drawn in the order of this display list.
.TP
\fIpathName \fBmarker cget \fIoption\fR
Returns the current value of the marker configuration option given by
\fIoption\fR.  \fIOption\fR may be any option described
below in the \fBconfigure\fR operation.
.TP
\fIpathName \fBmarker configure \fImarkerId\fR ?\fIoption value\fR?...
Queries or modifies the configuration options for markers.  If
\fIoption\fR isn't specified, a list describing the current
options for \fImarkerId\fR is returned.  If \fIoption\fR is specified,
but not \fIvalue\fR, then a list describing \fIoption\fR is returned.
If one or more \fIoption\fR and \fIvalue\fR pairs are specified, then
for each pair, the marker option \fIoption\fR is set to \fIvalue\fR.
.sp
The following options are valid for all markers.
Each type of marker also has its own type-specific options.  
They are described in the sections below.
.RS
.TP
\fB\-coords \fIcoordList\fR
Specifies the coordinates of the marker.  \fICoordList\fR is 
a list of graph coordinates.  The number of coordinates required
is dependent on the type of marker.  Text, image, and window markers
need only two coordinates (an X\-Y coordinate).   Bitmap markers
can take either two or four coordinates (if four, they represent the
corners of the bitmap). Line markers
need at least four coordinates, polygons at least six.
If \fIcoordList\fR is \fC""\fR, the marker will not be displayed.
The default is \fC""\fR.
.TP
\fB\-element \fIelemName\fR
Links the marker with the element \fIelemName\fR.  The marker is
drawn only if the element is also currently displayed (see the
element's \fBshow\fR operation).  If \fIelemName\fR is \fC""\fR, the
marker is always drawn.  The default is \fC""\fR.
.TP
\fB\-hide \fIboolean\fR 
Indicates whether the marker is drawn. If \fIboolean\fR is true,
the marker is not drawn.  The default is \fCno\fR.
.TP
\fB\-mapx \fIxAxis\fR 
Specifies the X\-axis to map the marker's X\-coordinates onto.
\fIXAxis\fR must the name of an axis.  The default is \fCx\fR.
.TP
\fB\-mapy \fIyAxis\fR
Specifies the Y\-axis to map the marker's Y\-coordinates onto.
\fIYAxis\fR must the name of an axis.  The default is \fCy\fR.
.TP
\fB\-name \fImarkerId\fR
Changes the identifier for the marker.  The identifier \fImarkerId\fR 
can not already be used by another marker.  If this option
isn't specified, the marker's name is uniquely generated.
.TP
\fB\-under \fIboolean\fR
Indicates whether the marker is drawn below/above data
elements.  If \fIboolean\fR is true, the marker is be drawn
underneath the data element symbols and lines.  Otherwise, the marker is
drawn on top of the element.  The default is \fC0\fR.
.TP
\fB\-xoffset \fIpixels\fR
Specifies a screen distance to offset the marker horizontally. 
\fIPixels\fR is a valid screen distance, such as \fC2\fR or \fC1.2i\fR.
The default is \fC0\fR.
.TP
\fB\-yoffset \fIpixels\fR
Specifies a screen distance to offset the markers vertically.
\fIPixels\fR is a valid screen distance, such as \fC2\fR or \fC1.2i\fR.
The default is \fC0\fR.
.PP
Marker configuration options may also be set by the \fBoption\fR command.
The resource class is either \fCBitmapMarker\fR,  \fCImageMarker\fR, 
\fCLineMarker\fR, \fCPolygonMarker\fR, \fCTextMarker\fR, or \fCWindowMarker\fR,
depending on the type of marker.  The resource name is the name of the
marker.
.DS
option add *Stripchart.TextMarker.Foreground white
option add *Stripchart.BitmapMarker.Foreground white
option add *Stripchart.m1.Background     blue
.DE
.RE
.TP
\fIpathName \fBmarker create \fItype\fR ?\fIoption value\fR?...
Creates a marker of the selected type. \fIType\fR may be either
\fCtext\fR, \fCline\fR, \fCbitmap\fR, \fCimage\fR, \fCpolygon\fR, or
\fCwindow\fR.  This command returns the marker identifier, 
used as the \fImarkerId\fR argument in the other marker-related
commands.  If the \fB\-name\fR option is used, this overrides the
normal marker identifier.  If the name provided is already used for
another marker, the new marker will replace the old.
.TP
\fIpathName \fBmarker delete\fR ?\fIpattern\fR?...
Removes the markers with identifiers matching \fIpattern\fR.  
.TP
\fIpathName \fBmarker exists \fImarkerId\fR 
Returns \fC1\fR if the marker \fImarkerId\fR exists and \fC0\fR
otherwise.
.TP
\fIpathName \fBmarker ids\fR ?\fIpattern\fR? 
Returns a list of IDs of markers created.  If \fIpattern\fR is
supplied, only those markers whose IDs matching it will be returned.
.TP
\fIpathName \fBmarker type \fImarkerId\fR 
Returns the type of the marker given by \fImarkerId\fR, such as
\fCline\fR or \fCtext\fR.  If \fImarkerId\fR is not a valid a marker
identifier, \fC""\fR is returned.
.SS "BITMAP MARKERS"
A bitmap marker displays a bitmap.  The size of the
bitmap is controlled by the number of coordinates specified.  If two
coordinates, they specify the position of the top-left corner of the
bitmap.  The bitmap retains its normal width and height.  If four
coordinates, the first and second pairs of coordinates represent the
corners of the bitmap.  The bitmap will be stretched or reduced as
necessary to fit into the bounding rectangle.
.PP
Bitmap markers are created with the marker's \fBcreate\fR operation in
the form:
.DS
\fIpathName \fBmarker create bitmap \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR pairs, each 
sets a configuration options for the marker.  These
same \fIoption\fR\-\fIvalue\fR pairs may be used with the marker's
\fBconfigure\fR operation.
.PP
The following options are specific to bitmap markers:
.TP
\fB\-background \fIcolor\fR
Sets the background color of the bitmap.  If \fIcolor\fR is \fC""\fR,
the background color will be transparent.  The default background
color is \fCwhite\fR.
.TP
\fB\-bitmap \fIbitmap\fR
Specifies the bitmap to be displayed.  If \fIbitmap\fR is \fC""\fR,
the marker will not be displayed.  The default is \fC""\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the foreground color of the bitmap.  The default foreground color
is \fCblack\fR.
.TP
\fB\-mask \fImask\fR
Specifies a mask for the bitmap to be displayed. This mask is a bitmap
itself, denoting the pixels that are transparent.  If \fImask\fR is
\fC""\fR, all pixels of the bitmap will be drawn.  The default is
\fC""\fR.
.TP
\fB\-rotate \fItheta\fR
Sets the rotation of the bitmap.  \fITheta\fR is a real number
representing the angle of rotation in degrees.  The marker is first
rotated and then placed according to its anchor position.  The default
rotation is \fC0.0\fR.
.SS "IMAGE MARKERS"
A image marker displays an image.  Image markers are
created with the marker's \fBcreate\fR operation in the form:
.DS
\fIpathName \fBmarker create image \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR
pairs, each sets a configuration option
for the marker.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used with the marker's \fBconfigure\fR operation.
.PP
The following options are specific to image markers:
.TP
\fB\-anchor \fIanchor\fR
\fIAnchor\fR tells how to position the image relative to the
positioning point for the image. For example, if \fIanchor\fR
is \fCcenter\fR then the image is centered on the point;  if
\fIanchor\fR is \fCn\fR then the image will be drawn such that
the top center point of the rectangular region occupied by the
image will be at the positioning point.
This option defaults to \fCcenter\fR.
.TP
\fB\-image \fIimage\fR
Specifies the image to be drawn.
If \fIimage\fR is \fC""\fR, the marker will not be
drawn.  The default is \fC""\fR.
.SS "LINE MARKERS"
A line marker displays one or more connected line segments.
Line markers are created with marker's \fBcreate\fR operation in the form:
.DS
\fIpathName \fBmarker create line \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR
pairs, each sets a configuration option
for the marker.  These same \fIoption\fR-\fIvalue\fR pairs may be
used with the marker's \fBconfigure\fR operation.
.PP
The following options are specific to line markers:
.TP
\fB\-background \fIcolor\fR
Sets the background color of the line.
The option is affects the line color only when the \fB\-stipple\fR option 
is set.  
If this option isn't specified then it defaults to \fCwhite\fR.
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of the line. \fIDashList\fR is a list of up to 11
numbers that alternately represent the lengths of the dashes and gaps
on the line.  Each number must be between 1 and 255.  If
\fIdashList\fR is \fC""\fR, the marker line will be solid.
.TP
\fB\-foreground \fIcolor\fR
Sets the foreground color.  The default foreground color is \fCblack\fR.
.TP
\fB\-linewidth \fIpixels\fR
Sets the width of the lines.
The default width is \fC0\fR.
.TP
\fB\-stipple \fIbitmap\fR
Specifies a stipple pattern used to draw the line, rather than
a solid line.
\fIBitmap\fR specifies a bitmap to use as the stipple
pattern.  If \fIbitmap\fR is \fC""\fR, then the
line is drawn in a solid fashion. The default is \fC""\fR.
.SS "POLYGON MARKERS"
A polygon marker displays a closed region described as two or more
connected line segments.  It is assumed the first and
last points are connected.  Polygon markers are created using the
marker \fBcreate\fR operation in the form:
.DS
\fIpathName \fBmarker create polygon \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR
pairs, each sets a configuration option
for the marker.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used with the \fBmarker configure\fR command to change the marker's
configuration.
The following options are supported for polygon markers:
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of the outline of the polygon. \fIDashList\fR is a
list of up to 11 numbers that alternately represent the lengths of
the dashes and gaps on the outline.  Each number must be between 1 and
255. If \fIdashList\fR is \fC""\fR, the outline will be a solid line.
.TP
\fB\-fill \fIcolor\fR
Sets the fill color of the polygon.  If \fIcolor\fR is \fC""\fR, then
the interior of the polygon is transparent.
The default is \fCwhite\fR.
.TP
\fB\-linewidth \fIpixels\fR
Sets the width of the outline of the polygon. If \fIpixels\fR is zero, 
no outline is drawn. The default is \fC0\fR.
.TP
\fB\-outline \fIcolor\fR
Sets the color of the outline of the polygon.  If the polygon is
stippled (see the \fB\-stipple\fR option), then this represents the
foreground color of the stipple.  The default is \fCblack\fR.
.TP
\fB\-stipple \fIbitmap\fR
Specifies that the polygon should be drawn with a stippled pattern
rather than a solid color. \fIBitmap\fR specifies a bitmap to use as
the stipple pattern.  If \fIbitmap\fR is \fC""\fR, then the polygon is
filled with a solid color (if the \fB\-fill\fR option is set).  The
default is \fC""\fR.
.SS "TEXT MARKERS"
A text marker displays a string of characters on one or more lines of
text.  Embedded newlines cause line breaks.  They may be used to
annotate regions of the strip chart.  Text markers are created with the
\fBcreate\fR operation in the form:
.DS
\fIpathName \fBmarker create text \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR pairs, 
each sets a configuration option for the text marker.  
These same \fIoption\fR\-\fIvalue\fR pairs may be used with the 
marker's \fBconfigure\fR operation.  
.PP
The following options are specific to text markers:
.TP
\fB\-anchor \fIanchor\fR
\fIAnchor\fR tells how to position the text relative to the
positioning point for the text. For example, if \fIanchor\fR is
\fCcenter\fR then the text is centered on the point; if
\fIanchor\fR is \fCn\fR then the text will be drawn such that the
top center point of the rectangular region occupied by the text will
be at the positioning point.  This default is \fCcenter\fR.
.TP
\fB\-background \fIcolor\fR
Sets the background color of the text string.  If \fIcolor\fR is
\fC""\fR, the background will be transparent.  The default is
\fCwhite\fR.
.TP
\fB\-font \fIfontName\fR
Specifies the font of the text.  The default is
\fC*-Helvetica-Bold-R-Normal-*-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR
Sets the foreground color of the text.  The default is \fCblack\fR.
.TP
\fB\-justify \fIjustify\fR
Specifies how the text should be justified.  This matters only when
the marker contains more than one line of text. \fIJustify\fR must be
\fCleft\fR, \fCright\fR, or \fCcenter\fR.  The default is
\fCcenter\fR.
.TP
\fB\-padx \fIpad\fR
Sets the padding to the left and right exteriors of the text.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the text is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default is \fC4\fR.
.TP
\fB\-pady \fIpad\fR
Sets the padding above and below the text.  \fIPad\fR can be a list of
one or two screen distances.  If \fIpad\fR has two elements, the area above the
text is padded by the first distance and the area below by the second.
If \fIpad\fR is just one distance, both the top and bottom areas
are padded evenly.  The default is \fC4\fR.
.TP
\fB\-rotate \fItheta\fR
Specifies the number of degrees to rotate the text.  \fITheta\fR is a
real number representing the angle of rotation.  The marker is first
rotated along its center and is then drawn according to its anchor
position. The default is \fC0.0\fR.
.TP
\fB\-text \fItext\fR
Specifies the text of the marker.  The exact way the text is
displayed may be affected by other options such as \fB\-anchor\fR or
\fB\-rotate\fR.
.SS "WINDOW MARKERS"
A window marker displays a widget at a given position.
Window markers are created with the marker's \fBcreate\fR operation in
the form:
.DS
\fIpathName \fBmarker create window \fR?\fIoption value\fR?...
.DE
There may be many \fIoption\fR-\fIvalue\fR
pairs, each sets a configuration option
for the marker.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used with the marker's \fBconfigure\fR command.
.PP
The following options are specific to window markers:
.TP
\fB\-anchor \fIanchor\fR
\fIAnchor\fR tells how to position the widget relative to the
positioning point for the widget. For example, if \fIanchor\fR is
\fCcenter\fR then the widget is centered on the point; if \fIanchor\fR
is \fCn\fR then the widget will be displayed such that the top center
point of the rectangular region occupied by the widget will be at the
positioning point.  This option defaults to \fCcenter\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the height to assign to the marker's window.  If this option
isn't specified, or if it is specified as \fC""\fR, then the window is
given whatever height the widget requests internally.
.TP
\fB\-width \fIpixels\fR
Specifies the width to assign to the marker's window.  If this option
isn't specified, or if it is specified as \fC""\fR, then the window is
given whatever width the widget requests internally.
.TP
\fB\-window \fIpathName\fR
Specifies the widget to be managed.  \fIPathName\fR must
be a child of the \fBstripchart\fR widget.
.SH "C LANGUAGE API"
You can manipulate data elements from the C language.  There
may be situations where it is too expensive to translate the data
values from ASCII strings.  Or you might want to read data in a
special file format.
.PP
Data can manipulated from the C language using BLT vectors.
You specify the x and y data coordinates of an element as vectors and
manipulate the vector from C.  The strip chart will be redrawn automatically
after the vectors are updated.
.PP
From Tcl, create the vectors and configure the element to use them.
.DS
vector X Y
\&.s element configure line1 -xdata X -ydata Y
.DE
To set data points from C, you pass the values as arrays of doubles
using the \fBBlt_ResetVector\fR call.  The vector is reset with the
new data and at the next idle point (when Tk re-enters its event
loop), the strip chart will be redrawn automatically.
.DS
#include <tcl.h>
#include <blt.h>

register int i;
Blt_Vector *xVec, *yVec;
double x[50], y[50];

/* Get the BLT vectors "X" and "Y" (created above from Tcl) */
if ((Blt_GetVector(interp, "X", 50, &xVec) != TCL_OK) ||
    (Blt_GetVector(interp, "Y", 50, &yVec) != TCL_OK)) {
    return TCL_ERROR;
}

for (i = 0; i < 50; i++) {
    x[i] = i * 0.02;
    y[i] = sin(x[i]);
}	

/* Put the data into BLT vectors */
if ((Blt_ResetVector(xVec, x, 50, 50, TCL_VOLATILE) != TCL_OK) ||
    (Blt_ResetVector(yVec, y, 50, 50, TCL_VOLATILE) != TCL_OK)) {
   return TCL_ERROR;
}
.DE
See the \fBvector\fR manual page for more details.
.SH SPEED TIPS
There may be cases where the strip chart needs to be drawn and updated as
quickly as possible.  If drawing speed becomes a big
problem, here are a few tips to speed up displays.
.TP 2
\(bu 
Try to minimize the number of data points.  The more data points
the looked at, the more work the strip chart must do.
.TP 2
\(bu 
If your data is generated as floating point values, the time required
to convert the data values to and from ASCII strings can be
significant, especially when there any many data points.  You can
avoid the redundant string-to-decimal conversions using the C API to
BLT vectors.
.TP 2
\(bu
Data elements without symbols are drawn faster than with symbols.
Set the data element's \fB\-symbol\fR option to \fCnone\fR.  If you need to
draw symbols, try using the simple symbols such as \fCsplus\fR and
\fCscross\fR.
.TP 2
\(bu
Don't stipple or dash the element.  Solid lines are much faster.
.TP 2
\(bu 
If you update data elements frequently, try turning off the
widget's \fB\-bufferelements\fR option.  When the strip chart is first
displayed, it draws data elements into an internal pixmap.  The pixmap
acts as a cache, so that when the strip chart needs to be redrawn again, and
the data elements or coordinate axes haven't changed, the pixmap is
simply copied to the screen.  This is especially useful when you are
using markers to highlight points and regions on the strip chart.  But if
the strip chart is updated frequently, changing either the element data or
coordinate axes, the buffering becomes redundant.
.SH LIMITATIONS
Auto-scale routines do not use requested min/max limits as boundaries
when the axis is logarithmically scaled.
.PP
The PostScript output generated for polygons with more than 1500
points may exceed the limits of some printers (See PostScript Language
Reference Manual, page 568).  The work-around is to break the polygon
into separate pieces.
.SH "FUTURE INCOMPATIBILITY"
The \fB\-mapped\fR options are obsoleted and will be removed.  You can
achieve the same results using the \fB\-hide\fR option instead.
.DS
# Works for now.
\&.s legend configure -mapped no

# Instead use this.
\&.s legend configure -hide yes    
.DE 
.SH KEYWORDS
stripchart, graph, widget
