// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Path.h

  Stephane Rehel
  April 15 1997
*/

#ifndef __Path_h
#define __Path_h

#ifndef __IBOOL_h
#include "IBOOL.h"
#endif

#ifndef __OString_h
#include "OString.h"
#endif

/////////////////////////////////////////////////////////////////////////////

class Path
{
protected:
  OString path; // always finish by a "/"
                // current = "./"

public:
  static const char separator;

public:
  Path(); // initialed by "./"

  Path( const Path& p );

  Path( const OString& fullname );

  virtual ~Path()
    {}

  const OString& get() const
    {
    return path;
    }

  Path& operator = ( const OString& fullname );

  IBOOL isAbsolute() const;
  IBOOL isCurrent() const;

  // if error, return FALSE
  IBOOL operator == ( const Path& path2 ) const;

  Path& operator += ( const OString& p );

  static OString checkPathSeparators( const OString& filename );
  static OString Path::toUnixPathSeparators( const OString& filename );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __Path_h

