// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoFunctions.C

  Stephane Rehel

  October 25 1997
*/

#include "graphics/KeyCodes.h"

#include "interface/MLFunctions.h"

#include "PhotoFunctions.h"
#include "PhotoModule.h"

#include "functions/PhotoFSelect.h"
#include "functions/PhotoFPan.h"
#include "functions/PhotoFZoom.h"
#include "functions/PhotoFRectZoom.h"

/////////////////////////////////////////////////////////////////////////////

// static
void PhotoFunctions::init( PhotoModule* photo )
{
  if( photo == 0 )
    return;

  MLFunctions* functions= photo->getFunctions();

  if( functions == 0 )
    return;

#define add(id,function,key) functions->add( id, Key(key), new function(photo) )

  add( SELECT,   PhotoFSelect,   ' ' );
  add( PAN,      PhotoFPan,      'z' );
  add( ZOOM,     PhotoFZoom,     'p' );
  add( RECTZOOM, PhotoFRectZoom, KeyCodes::CTRL_Z );

#undef add
}

/////////////////////////////////////////////////////////////////////////////
