// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLPackagedIO.h

  Stephane Rehel

  December 17 1997
*/

#ifndef __MLPackagedIO_h
#define __MLPackagedIO_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

class MLWFileBlock;
class MLRFileBlock;
class MLIOProgress;

class ModelModule;

/////////////////////////////////////////////////////////////////////////////

class MLPackagedIO
{
protected:
  ModelModule* model;

public:
  static const unsigned int signature;

  enum {
       PKG_FIRST              = 0,
       PKG_DRIVER_VERSION     = 1,
       PKG_FILE_INFO          = 2,
       PKG_SCENE_INFO         = 3,
       PKG_GEOMETRIES         = 4,
       PKG_HIERARCHIES        = 5,
       PKG_SCENE              = 6,
       PKG_MATERIALS          = 7,
       PKG_PROJECT            = 8,
       PKG_LAST
       };

public:
  MLPackagedIO( ModelModule* _model );

  virtual ~MLPackagedIO();

  IBOOL write( const OString& filename );

  IBOOL read( const OString& filename );

private:
  // in MLPackaged_1_0.C
  IBOOL read_1_0( MLRFileBlock& mainBlock, MLIOProgress* progress );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLPackagedIO_h
