// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  KBDOpen.C

  Stephane Rehel

  October 25 1997
*/

#include <string.h>
#include <stdlib.h>

#include "kw/KWFileDialogManager.h"
#include "kw/KWDialog.h"

#include "kbuilder/KBModule.h"

#include "KBDOpen.h"
#include "KBOpenDlg.h"

#include "kbuilder/appcore/Canvas.h"

/////////////////////////////////////////////////////////////////////////////

KBDOpen::KBDOpen( KBModule* _kb ):
  MLGlobalDialog(_kb)
{
  kb= _kb;

  manager= new KWFileDialogManager;
}

/////////////////////////////////////////////////////////////////////////////

KBDOpen::~KBDOpen()
{
  kb= 0;

  delete manager; manager= 0;
}

/////////////////////////////////////////////////////////////////////////////

IBOOL KBDOpen::run()
{
  if( ! MLGlobalDialog::create(KBOpenDlg::data) )
    return IFALSE;

  manager->init( kwDialog,
                 KBOpenDlg::directories,
                 KBOpenDlg::files,
                 KBOpenDlg::location,
                 KBOpenDlg::selection,
                 KBOpenDlg::ok,
                 KBOpenDlg::cancel );

  static char* currentPath= 0;

  if( currentPath == 0 )
    currentPath= strdup("~");

  manager->setPattern("*"+Canvas::canvasExtension);

  manager->setPath(currentPath);

  manager->updateDirectories();

  kwDialog->focus(KBOpenDlg::selection);

  int outcome= kwDialog->run();

  free( (void*) currentPath );
  currentPath= strdup( kwDialog->getText(KBOpenDlg::location).get() );

  MLGlobalDialog::close();

  if( outcome == KWDialog::VALIDATE && manager != 0 )
    {
    OString filename= manager->getFilename();

    Canvas* canvas= kb->getBuilderCanvas();
    canvas->readCanvas(filename);

    return ITRUE;
    }

  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////

IBOOL KBDOpen::kwCallback( KWEvent& event )
{
  if( manager != 0 )
    if( manager->handleKWEvent(event) )
      return ITRUE;

  return MLGlobalDialog::kwCallback(event);
}

/////////////////////////////////////////////////////////////////////////////
