#line 17 "errors.nw"
static char rcsid[] = "$Id: errors.nw,v 2.10 1997/09/13 19:59:15 nr Exp nr $";
static char rcsname[] = "$Name: v2_8a $";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "errors.h"

#line 35 "errors.nw"
enum errorlevel errorlevel = Normal;
int finalstage = 0;
char *progname = NULL;
#line 45 "errors.nw"
void nowebexit(char *msg) {
  if (!finalstage && errorlevel > Normal)
    printf("@fatal %s %s\n", progname != NULL ? progname : "a-noweb-filter",
	   msg != NULL ? msg : "an unspecified error occurred");
  exit(errorlevel);
}
#line 60 "errors.nw"
void errormsg(enum errorlevel level, char *s,...) {     
    va_list args;                       /* see K&R, page 174 */
    va_start(args,s);
    
#line 83 "errors.nw"
if (level > errorlevel)
    errorlevel = level;
vfprintf(stderr, s, args);
fprintf(stderr,"\n");
#line 64 "errors.nw"
    va_end(args);
    if (level >= Fatal)
        nowebexit(s);
}
#line 72 "errors.nw"
void errorat(char *filename, int lineno, enum errorlevel level, char *s, ...) {     
    va_list args;                       /* see K&R, page 174 */
    va_start(args,s);
    fprintf(stderr, "%s:%d: ", filename, lineno);
    
#line 83 "errors.nw"
if (level > errorlevel)
    errorlevel = level;
vfprintf(stderr, s, args);
fprintf(stderr,"\n");
#line 77 "errors.nw"
    va_end(args);
    if (level >= Fatal)
        nowebexit(s);
}
