
/*  A Bison parser, made from ilu.bison
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse iluparseparse
#define yylex iluparselex
#define yyerror iluparseerror
#define yylval iluparselval
#define yychar iluparsechar
#define yydebug iluparsedebug
#define yynerrs iluparsenerrs
#define	K_INTERFACE	258
#define	K_EXCEPTION	259
#define	K_TYPE	260
#define	K_CONSTANT	261
#define	K_IMPORTS	262
#define	K_FROM	263
#define	K_END	264
#define	K_BRAND	265
#define	K_FIXEDPOINT	266
#define	K_INTEGER	267
#define	K_CARDINAL	268
#define	K_STRING	269
#define	K_CHARACTER	270
#define	K_BYTE	271
#define	K_EXTENSIBLE	272
#define	K_FIXED	273
#define	K_REAL	274
#define	K_LONG	275
#define	K_SHORT	276
#define	K_BOOLEAN	277
#define	K_FALSE	278
#define	K_TRUE	279
#define	K_UNICODE	280
#define	K_LATIN1	281
#define	K_CHARSET	282
#define	K_EQUALS	283
#define	K_COLON	284
#define	K_LEFTPAREN	285
#define	K_RIGHTPAREN	286
#define	K_SEMICOLON	287
#define	K_COMMA	288
#define	K_IN	289
#define	K_OUT	290
#define	K_INOUT	291
#define	K_RECORD	292
#define	K_UNION	293
#define	K_ARRAY	294
#define	K_OF	295
#define	K_ENUMERATION	296
#define	K_SEQUENCE	297
#define	K_OPTIONAL	298
#define	K_PICKLE	299
#define	K_DEFAULT	300
#define	K_OBJECT	301
#define	K_SUPERCLASS	302
#define	K_SUPERTYPES	303
#define	K_AUTHENTICATION	304
#define	K_FUNCTIONAL	305
#define	K_ASYNCH	306
#define	K_DOCUMENTATION	307
#define	K_METHODS	308
#define	K_RAISES	309
#define	K_SIBLING	310
#define	K_SINGLETON	311
#define	K_COLLECTIBLE	312
#define	K_SOURCE	313
#define	K_SINK	314
#define	K_TYPEID	315
#define	T_STRING	316
#define	T_NUMBER	317
#define	K_EXPONENT	318
#define	K_PERIOD	319
#define	K_HYPHEN	320
#define	K_PLUS	321
#define	K_LIMIT	322
#define	K_OTHERS	323
#define	K_ALLOWS	324

#line 1 "ilu.bison"

/*
Copyright (c) 1991-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilu.bison,v 1.180 1997/11/15 00:45:29 janssen Exp $
*/

/*
 * portability warnings:  this code is highly dependent upon the list
 * data type for storing lists of data.  This code makes the assumption
 * that a pointer and integer are the same size, as it does list_insert()
 * of integers at numerous points in the code, as part of the bison
 * actions associated with grammar productions.
 *
 * The list data type should eventually be updated to use a more general
 * (and portable) union mechanism;  For now casts have been added to coerce
 * integers into pointers of the appropriate type for the corresponding
 * call.
 */
#include <stdio.h>

#include "iluptype.h"

#if ((defined(WIN32) || defined(WIN16)) && defined(_WINIO))
#include <winiodef.h>
#endif /* ((defined(WIN32) || defined(WIN16)) && defined(_WINIO)) */

#include <ctype.h>		/* for isgraph() */
#include <stdlib.h>
#include <string.h>

#if (!((defined(WIN32) || defined(WIN16)) && defined(_WINIO)))
#include <errno.h>		/* for errno, ERANGE */
#include <limits.h>		/* for ULONG_MAX */
#endif /* (!((defined(WIN32) || defined(WIN16)) && defined(_WINIO))) */

#if (defined(WIN32) || defined(WIN16))
#include <malloc.h>	/* needed because of include of alloca */
#endif

#ifdef _IS_POSIX
#include <unistd.h>
#endif


#if defined( macintosh )
#define yyparse iluparseparse
#define yylex iluparselex
#define yyerror iluparseerror
#define yylval iluparselval
#define yychar iluparsechar
#define yydebug iluparsedebug
#define yynerrs iluparsenerrs

#include	"alloca.h"

#endif

/*
#ifndef __GNUC__
extern void * alloca(unsigned long);
#endif
*/

#define AND		&&
#define OR		||
#define NOT		!

#define KEYWORD(x)	static char x[1]

#define YYSTYPE	refany

#define NEWLINE	'\n'

#define AlphaNumChars "abcdefghijklmnopqrstuvwxyz" "ABCDEFGHIJKLMNOPQRSTUVWXYZ" "0123456789"

#ifdef ADD_DIRECT_OMG_IDL_SUPPORT
extern list ParseIDLFile (struct idl_parse*);
#endif /* ADD_DIRECT_OMG_IDL_SUPPORT */

#ifndef DEFAULT_INTERFACE_PATH

#if (defined(WIN32) || defined(WIN16))
#define DEFAULT_INTERFACE_PATH	"."
#define ILU_INTERFACE_HOME	ILUHOME "\interfaces"
#elif defined( macintosh )
#define DEFAULT_INTERFACE_PATH	""
#define ILU_INTERFACE_HOME	ILUHOME ":interfaces"
#else
#define DEFAULT_INTERFACE_PATH	"."
#define ILU_INTERFACE_HOME	ILUHOME "/interfaces"
#endif /* if (def... */

#else

#endif /* ndef DEFAULT_INTERFACE_PATH */

#include "version.h"	/* defines ILU_VERSION */

static const char * _ilu_id = "$" "Id: ILU version " ILU_VERSION_STRING ".  Copyright 1990-1997 Xerox Corporation.  All Rights Reserved. $" ;

#define YYDEBUG 1

static void ilutokenprint (FILE *, int, YYSTYPE);

#define YYPRINT ilutokenprint

KEYWORD(o_Brand);
KEYWORD(o_Singleton);
KEYWORD(o_Superclasses);
KEYWORD(o_Collectible);
KEYWORD(o_Authentication);
KEYWORD(o_RepositoryID);
KEYWORD(o_Optional);
KEYWORD(o_Methods);
KEYWORD(o_Documentation);
KEYWORD(m_Functional);
KEYWORD(m_Asynchronous);

typedef struct keyword_s {
  char * keyword;
  refany value;
} Attribute;

static Attribute O_Brand = { o_Brand, 0 };
static Attribute O_Singleton = { o_Singleton, 0 };
static Attribute O_Superclasses = { o_Superclasses, 0 };
static Attribute O_Collectible = { o_Collectible, 0 };
static Attribute O_Optional = { o_Optional, 0 };
static Attribute O_Authentication = { o_Authentication, 0};
static Attribute O_RepositoryID = { o_RepositoryID, 0};
static Attribute O_Methods = { o_Methods, 0 };
static Attribute O_Documentation = { o_Documentation, 0 };

static const char IDLScopeNamingSeparator[] = "-iluIDLNamingScope-";

extern int iluparsedebug;

int iluparseparse(void);
static int iluparselex (refany *lvalp);
extern void FigureTypeUID(Type t);

struct parse_s {
  list interfaces;
  Interface interface;
  FILE *input;
  string filename;
  cardinal line;
  struct parse_s *next;
};

static struct parse_s *CurrentParse = NULL;

static list ActiveInterfaces = NULL;	/* list of interfaces currently being "fixed up" */

static struct list_s iluparser_DefaultUnionArm = { NULL, NULL, 0 };

static long int ilu_atoi (string s)
{
  cardinal base = 10;
  int sign = 1;

  if (*s == '-')
    {
      s++;
      sign = -1;
    }
  else if (*s == '+')
    {
      s++;
    }

  if (*s == '0')
    {
      switch (*++s)
	{
	case 'b':
	case 'B':
	  ++s;
	  base = 2;
	  break;

	case 'x':
	case 'X':
	  ++s;
	  base = 16;
	  break;

	case 'd':
	case 'D':
	  ++s;
	  base = 10;
	  break;

	case 'o':
	case 'O':
	  ++s;
	  base = 8;
	  break;

	default:
	  --s;
	}
    }

  return (sign * strtol(s, NULL, base));
}  

static boolean ilu_strtoul (string input, int *sign, unsigned long *immed, boolean *good)
{
  cardinal base = 10;
  char *finalp = NULL;
  char *s = input;

  if (*s == '-')
    {
      s++;
      *sign = -1;
    }
  else if (*s == '+')
    {
      s++;
      *sign = 1;
    }
  else
    *sign = 1;

  if (((*s == '0') || (*s == '#')) && (strlen(s) > 1))
    {
      switch (*++s)
	{
	case 'b':
	case 'B':
	  ++s;
	  base = 2;
	  break;

	case 'x':
	case 'X':
	  ++s;
	  base = 16;
	  break;

	case 'd':
	case 'D':
	  ++s;
	  base = 10;
	  break;

	case 'o':
	case 'O':
	  ++s;
	  base = 8;
	  break;

	default:
	  return FALSE;
	}
    }

  *immed = strtoul (s, &finalp, base);
  *good = ((finalp != NULL) && (*finalp == 0));
  return ((finalp != NULL) && ((*finalp == 0) || isxdigit(*finalp)));
}  

char *ilu_strdup(char *src)
{
  char *dst=(char *) iluparser_Malloc(strlen(src)+1);

  strcpy(dst,src);
  return dst;
}

char *ilu_strndup(char *src, cardinal len)
{
  char *dst=(char *) iluparser_Malloc(len + 1);

  strncpy(dst,src,len);
  dst[len] = '\0';
  return dst;
}

/* a strcasecmp(), since we don't have one with ANSI */
int ilu_strcasecmp (char *a, char *b)
{
  register unsigned char *p1 = ( unsigned char *) a;
  register unsigned char *p2 = ( unsigned char *) b;
  unsigned char c1, c2;

  if (p1 == p2)
    return 0;

  do
    {
      c1 = tolower (*p1++);
      c2 = tolower (*p2++);
      if (c1 == '\0')
        break;
    }
  while (c1 == c2);

  return c1 - c2;
}

typedef struct {
  string          name;
  string          interface;
}               matchname_s;

static boolean matchTypeName (Type type, matchname_s *name)
{
  return ((strcmp(type_name(type), name->name) == 0) AND
	  (((name->interface == NULL) && (type->importInterfaceName == NULL)) OR
	   (name->interface != NULL AND type->interface != NULL AND
	    type->importInterfaceName == NULL AND
	    strcmp(name->interface, name_base_name(type->interface->name)) == 0)));
}

string constant_name (Constant c)
{
  return (name_base_name(c->name));
}

static boolean matchConstantName (Constant constant, matchname_s *name)
{
  return (strcmp(constant_name(constant), name->name) == 0 AND
	  ((name->interface == NULL AND constant->importInterfaceName == NULL) OR
	   (name->interface != NULL AND constant->importInterfaceName != NULL AND
	    strcmp(name->interface, constant->importInterfaceName) == 0)));
}
    
static boolean matchExceptionName (Exception exception, matchname_s *e)
{
  return (strcmp(exception_name(exception), e->name) == 0 AND
	  ((e->interface == NULL AND exception->importInterfaceName == NULL) OR
	   (e->interface != NULL AND exception->importInterfaceName != NULL AND
	    strcmp(e->interface, exception->importInterfaceName) == 0)));
}

/***********************************************************************
	List functions
***********************************************************************/

#ifdef new_list
#undef new_list
#endif

list iluparser_new_list (void)
{
  list ptr;

  ptr = (list) iluparser_Malloc (sizeof(struct list_s));
  ptr->head = NULL;
  ptr->tail = NULL;
  ptr->count = 0;
  return (ptr);
}

#define new_list iluparser_new_list

void list_insert (list l, refany element)
{
  listElement *new;

  if (l == NULL)
    return;

  new = (listElement *) iluparser_Malloc (sizeof(listElement));

  new->data = element;
  new->next = NULL;
  if (l->tail != NULL)
    l->tail->next = new;
  l->tail = new;
  if (l->head == NULL)
    l->head = new;
  l->count += 1;
}

void list_insert1(refany element,refany l)
{
  list_insert(l,element);
}

void list_push (list l, refany element)
{
  listElement *new;

  if (l == NULL)
    return;

  new = (listElement *) iluparser_Malloc (sizeof(listElement));

  new->data = element;
  new->next = l->head;
  l->head = new;
  if (l->tail == NULL)
    l->tail = new;
  l->count += 1;
}

boolean list_remove (list l, refany element)
{
  listElement *next, *last;
  boolean wasThere = FALSE;

  if (l == NULL)
    return (FALSE);

  for (next = l->head, last = NULL;  next != NULL;  last = next, next = next->next)
    {
      if (next->data == element)
	{
	  wasThere = TRUE;
	  if (last == NULL)
	    l->head = next->next;
	  else
	    last->next = next->next;
	  if (next == l->tail)
	    l->tail = last;
	  next->next = NULL;
	  iluparser_Free (next);
	  l->count -= 1;
	  next = last;
	  if (next == NULL)
	    break;
	}
    }
  return (wasThere);
}

void list_clear (list l, boolean freeElements)
{
  listElement *p, *last;

  for (p = l->head, last = NULL;  p != NULL;  p = last)
    {
      last = p->next;
      if (freeElements && p->data != NULL)
	iluparser_Free(p->data);
      p->data = NULL;
      p->next = NULL;
      iluparser_Free(p);
    }
  l->head = NULL;
  l->tail = NULL;
  l->count = 0;
}

void list_enumerate (list l, iluparser_EnumProc proc, refany rock)
{
  listElement *ptr;

  if (l == NULL || l->count < 1)
    return;

  for (ptr = l->head;  ptr != NULL;  ptr = ptr->next)
    (*proc)(ptr->data, rock);
}

refany list_find (list l, iluparser_FindProc proc, refany rock)
{
  listElement *ptr;

  if (l == NULL)
    return (NULL);

  for (ptr = l->head;  ptr != NULL;  ptr = ptr->next)
    if ((*proc)(ptr->data, rock))
      return (ptr->data);
  return (NULL);
}

cardinal list_size (list l)
{
  if (l == NULL)
    return (0);

  return (l->count);
}

refany list_ref (list l, cardinal index)
{
  listElement *ptr;
  cardinal i;

  if (l == NULL)
    return (NULL);

  for (ptr = l->head, i = 0;  ptr != NULL && i <= index;  ptr = ptr->next, i++)
    if (i == index)
      return (ptr->data);
  return (NULL);
}

list list_cdr (list l)
{
  list ptr;

  if (l == NULL || l->count < 1)
    return (NULL);
      
  ptr = (list) iluparser_Malloc (sizeof(struct list_s));
  ptr->head = l->head->next;
  ptr->tail = l->tail;
  ptr->count = l->count - 1;
  return (ptr);
}

refany list_car (list l)
{
  if (l == NULL || l->count == 0)
    return (NULL);
  else
    return (l->head->data);      
}

void list_sort (list l, iluparser_CompareProc fn)
{
  listElement *current, *next, *prev;
  int count = list_size(l);
  int index;
  boolean stable = FALSE;

  /* bubblesort list */
  while (!stable && count > 1)
    {
      for (stable = TRUE, prev = NULL, current = NULL, next = l->head, index = 0;
	   next != NULL && index < count;
	   prev = current, current = next, next = current->next, index++)
	{
	  if (current != NULL)
	    {
	      if ((*fn)(current->data, next->data))
		{
		  if (prev == NULL)
		    l->head = next;
		  else
		    prev->next = next;
		  current->next = next->next;
		  next->next = current;
		  current = next;
		  next = next->next;
		  stable = FALSE;
		}
	    }
	}
    }
}

/**********************************************************************
	Name methods
**********************************************************************/

static Name new_Name(void)
{
  Name new = (Name) iluparser_Malloc (sizeof(struct name_s));
  new->base_name = NULL;
  new->langnames = (set) new_list();
  return (new);
}

string name_base_name (Name n)
{
  if (n == NULL)
    return (NULL);
  return (n->base_name);
}

string name_remove_idl_scoping (string n)
{
  string source, p;
  string newname;

  newname = iluparser_Malloc(strlen(n) + 1);
  newname[0] = '\0';
  source = n;
  while ((p = strstr(source, IDLScopeNamingSeparator)) != NULL) {
    strncat (newname, source, (p - source));
    strncat (newname, "_", 1);
    source = p + strlen(IDLScopeNamingSeparator);
  };
  strcat (newname, source);
  return newname;
}

void name_set_base_name (Name n, string name)
{
  char *source = name;
  char *p;

  if (n == NULL)
    return;
  if (n->base_name != NULL)
    iluparser_Free (n->base_name);
  n->base_name = ilu_strdup(name);
}

static boolean MatchNameLang (usagename u, string lang)
{
  return (u != NULL && strcmp (u->lang, lang) == 0);
}

string name_lang_name (Name n, string lang)
{
  usagename p;

  if (n == NULL)
    return (NULL);
  p = (usagename) list_find (n->langnames, (boolean (*)(refany, refany)) MatchNameLang, lang);
  if (p != NULL)
    return (p->name);
  else
    return (NULL);
}

void name_set_lang_name (Name n, string lang, string name)
{
  usagename new;

  if (n == NULL)
    return;
  
  if ((new = (usagename) list_find (n->langnames, (boolean (*)(refany, refany)) MatchNameLang, lang)) != NULL)
    {
      iluparser_Free (new->name);
      new->name = ilu_strdup (name);
    }
  else
    {
      new = (usagename) iluparser_Malloc (sizeof(struct usagename_s));
      new->lang = ilu_strdup(lang);
      new->name = ilu_strdup(name);
      list_insert (n->langnames, new);
    }
}

void iluparser_set_scoping (list scopes, char *interfacename, char *elementname)
{
  char *source = elementname;
  char *p;

  list_insert(scopes, ilu_strdup(interfacename));
  while ((p = strstr(source, IDLScopeNamingSeparator)) != NULL) {
    list_insert(scopes, ilu_strndup(source, (p - source)));
    source = p + strlen(IDLScopeNamingSeparator);
  }
  list_insert(scopes, ilu_strdup(source));
}

/**********************************************************************
	Type constructors
**********************************************************************/

static Type new_Type(void)
{
  Type new = (Type) iluparser_Malloc (sizeof(struct ilu_type_s));
  new->scoping = new_list();
  new->name = (Name) new_Name();
  new->description = NULL;
  new->supertype = NULL;
  new->refs = new_list();
  new->def = 0;
  new->builtIn = FALSE;
  new->importInterfaceName = NULL;
  new->interface = NULL;
  new->cached_des = NULL;
  new->marked = FALSE;
  new->uid = NULL;
  return (new);
}

string type_name (Type t)
{
  if (t == NULL || t->name == NULL)
    return ((string) "void");
  else
    return (name_base_name(t->name));
}

Type ur_type (Type t)
{
  Type            p;
  if (t == NULL)
    return t;
  /*
   * The following circumlocution is better for setting breakpoints
   * than the straightfoward formulation.
   */
  for (p = t; 1; p = p->supertype)
    if (p->supertype == NULL)
      return p;
}

Type under_type (Type t)
{
  Type            ans = t;
  if (ans->supertype != NULL) {
    ans = ans->supertype;
    if (ans->importInterfaceName != NULL)
      ans = ans->supertype;
  }
  return ans;
}

TypeDescription type_description (Type t)
{
  Type p;

  if (t == NULL)
    return (NULL);
  if (t->cached_des == NULL)
    {
      for (p = t;  p->description == NULL; )
	{
	  if (p->supertype != NULL)
	    p = p->supertype;
	  else
	    return (NULL);
	}
      t->cached_des = p->description;
    }
  return (t->cached_des);
}

TypeKind type_kind (Type t)
{
  TypeDescription td;

  if (t == NULL)
    return (void_Type);
  if (t->supertype != NULL)
    return (alias_Type);
  td = type_description(t);
  if (td == NULL)
    return (invalid_Type);
  return (td->type);
}

TypeKind type_basic_type (Type t)
{
  return type_kind(t);
}

TypeKind type_ur_kind(Type t)
{
  Type            u = ur_type(t);
  return type_kind(u);
}

typedef struct {
  void (*action)(Type, refany);
  refany actionrock;
} typeRecurseData;

static void recurseRecordFields (Argument field, typeRecurseData *data)
{
  if (field->type != NULL AND NOT field->type->marked)
    type_recurse (field->type, data->action, data->actionrock);
}

void type_recurse (Type t, void (*action) (Type, refany),
		   refany actionrock)
{
  TypeKind        tk;
  if (t == NULL OR t->marked)
    return;
  t->marked = TRUE;
  tk = type_kind(t);

  /* check types that contain other types */
  if (tk == alias_Type)
    type_recurse(t->supertype, action, actionrock);
  else if (tk == record_Type) {
    typeRecurseData data;

    data.action = action;
    data.actionrock = actionrock;

    list_enumerate(type_description(t)->structuredDes.record.fields,
		   (void (*) (refany, refany)) recurseRecordFields,
		   &data);
    if (type_description(t)->structuredDes.record.supertype != NULL)
      type_recurse(type_description(t)->structuredDes.record.supertype,
		   action, actionrock);
  } else if (tk == optional_Type) {
    type_recurse(type_description(t)->structuredDes.optional,
		 action, actionrock);
  } else if (tk == sequence_Type) {
    type_recurse(type_description(t)->structuredDes.sequence.type,
		 action, actionrock);
  } else if (tk == array_Type) {
    type_recurse(type_description(t)->structuredDes.array.type,
		 action, actionrock);
  } else if (tk == union_Type) {
    typeRecurseData data;

    data.action = action;
    data.actionrock = actionrock;

    list_enumerate(type_description(t)->structuredDes.uniond.types,
		   (void (*) (refany, refany)) recurseRecordFields,
		   &data);
  }
  (*action) (t, actionrock);
  t->marked = FALSE;
}

Interface type_interface (Type type)
{
  Type t;

  for (t = type;  t->importInterfaceName != NULL;  t = t->supertype)
    ;
  return (t->interface);
}

static Argument new_Argument(void)
{
  Argument new = (Argument) iluparser_Malloc (sizeof(struct ilu_argument_s));
  new->name = new_Name();
  new->type = NULL;
  new->values = NULL;
  new->def = 0;
  new->sibling = FALSE;
  new->direction = In;
  return (new);
}

string argument_name (Argument a)
{
  if (a == NULL)
    return (NULL);
  return (name_base_name(a->name));
}

static Exception new_Exception(void)
{
  Exception new = (Exception) iluparser_Malloc (sizeof(struct ilu_exception_s));
  new->name = new_Name();
  new->scoping = new_list();
  new->type = NULL;
  new->valueOptional = FALSE;
  new->refs = new_list();
  new->def = 0;
  new->id = 0;
  new->builtIn = FALSE;
  new->interface = NULL;
  new->importInterfaceName = NULL;
  new->import = NULL;
  new->marked = FALSE;
  new->corba_rep_id = NULL;
  new->doc_string = NULL;
  return (new);
}

string exception_name (Exception e)
{
  if (e == NULL)
    return (NULL);
  return (name_base_name(e->name));
}

Type exception_type (Exception e)
{
  Exception ep = e;

  while (ep->import != NULL)
    ep = ep->import;
  return (ep->type);
}

static Procedure new_Procedure(void)
{
  Procedure new = (Procedure) iluparser_Malloc (sizeof(struct ilu_proc_s));
  new->name = new_Name();
  new->object = NULL;
  new->arguments = NULL;
  new->returnType = NULL;
  new->returnOptional = FALSE;
  new->functional = FALSE;
  new->asynch = FALSE;
  new->exceptions = NULL;
  new->def = 0;
  new->id = -1;
  new->interface = NULL;
  new->marked = FALSE;
  return (new);
}

string procedure_name (Procedure p)
{
  return (name_base_name(p->name));
}

static void SetObjectSlotOfMethod (refany element, refany rock)
{
  Procedure m = (Procedure) element;
  Type o = (Type) rock;
  if (m != NULL)
    m->object = o;
}

static TypeDescription new_TypeDescription(void)
{
  TypeDescription new = (TypeDescription) iluparser_Malloc(sizeof(struct ilu_typedes_s));
  new->type = invalid_Type;
  memset((char *) new, 0, sizeof(struct ilu_typedes_s));
  return (new);
}

static boolean FindInterfaceName (string name, string *interfacename, string *typename)
{
  string p;

  if ((p = strchr(name, '.')) == NULL)
    return (FALSE);
  name = ilu_strdup(name);
  p = strchr(name, '.');
  *p = (char) 0;
  *interfacename = name;
  *typename = p + 1;
  return (TRUE);
}

static Type find_or_create_type (list l, char *name, Interface interface)
{
  Type hit;
  matchname_s stype;
  char *stubname;

  stubname = name_remove_idl_scoping(name);


/*
  printf ("%s, %u:  finding type \"%s\"...\n",
	  (CurrentParse == NULL) ? "" : CurrentParse->filename,
	  (CurrentParse == NULL) ? 0 : CurrentParse->line, stubname);
*/

  stype.name = NULL;
  stype.interface = NULL;
  FindInterfaceName (stubname, &stype.interface, &stype.name);
  if (stype.name == NULL) stype.name = stubname;

  hit = (Type) list_find (l, (iluparser_FindProc) matchTypeName, &stype);

  if (hit == NULL)
    {
      hit = new_Type();
      hit->interface = interface;
      hit->importInterfaceName = stype.interface;
      name_set_base_name(hit->name, ilu_strdup(stype.name));
      list_push (l, hit);
      iluparser_set_scoping(hit->scoping, interface_name(interface), name);
      if (stype.interface != NULL AND interface != NULL
	  AND strcmp(stype.interface, name_base_name(interface->name)) != 0)
	{
	  name_set_lang_name(hit->name, "import", stype.name);
	}
/*
      printf ("added type <%s> to interface <%s>\n", stubname, (interface == NULL) ? "*" : name_base_name(interface->name));
*/
    }
  free(stubname);
  return (hit);
}

#define FIND_OR_CREATE_TYPE(name) (find_or_create_type (CurrentParse->interface->types, (name), CurrentParse->interface))

static Exception find_or_create_exception (list l, char *name, Interface interface)
{
  string typename = NULL, interfacename = NULL;
  matchname_s e;
  Exception hit;
  char *stubname;

  stubname = name_remove_idl_scoping(name);

  FindInterfaceName(stubname, &interfacename, &typename);

  if (typename == NULL)
    typename = stubname;

  e.name = typename;
  e.interface = interfacename;
  hit = (Exception) list_find (l, (boolean (*)(refany, refany)) matchExceptionName, &e);

  if (hit == NULL)
    {
      hit = new_Exception();
      hit->interface = interface;
      name_set_base_name(hit->name, ilu_strdup(typename));
      list_insert (l, hit);
      hit->importInterfaceName = interfacename;
      iluparser_set_scoping(hit->scoping, interface_name(interface), name);
      if (interfacename != NULL)
	name_set_lang_name (hit->name, "import", typename);
    }
  free(stubname);
  return (hit);
}

#define FIND_OR_CREATE_EXCEPTION(name) (find_or_create_exception (CurrentParse->interface->exceptions, (name), CurrentParse->interface))

static Constant find_or_create_constant (list l, char *name, Interface interface)
{
  string typename = NULL, interfacename = NULL;
  Constant hit;
  matchname_s ndata;
  char *stubname;

  stubname = name_remove_idl_scoping(name);

  FindInterfaceName(stubname, &interfacename, &typename);

  if (typename == NULL)
    typename = stubname;

  ndata.name = typename;
  ndata.interface = interfacename;
  hit = (Constant) list_find (l, (boolean (*)(refany, refany)) matchConstantName, &ndata);

  if (hit == NULL)
    {
      hit = (Constant) iluparser_Malloc(sizeof(struct ilu_constant_s));
      hit->scoping = new_list();
      hit->type = NULL;
      hit->def = 0;
      hit->value = NULL;
      hit->name = new_Name();
      hit->interface = interface;
      hit->import = NULL;
      hit->importInterfaceName = interfacename;
      name_set_base_name(hit->name, ilu_strdup(typename));
      iluparser_set_scoping(hit->scoping, interface_name(interface), name);
      if (interfacename != NULL)
	name_set_lang_name (hit->name, "import", typename);
      list_insert (l, hit);
    }
  free(stubname);
  return (hit);
}

#define FIND_OR_CREATE_CONSTANT(name) (find_or_create_constant (CurrentParse->interface->constants, (name), CurrentParse->interface))

#define ADD_PRIMITIVE_TYPE(l,i,n,t) {Type new = find_or_create_type((l),(n),(i));if(new->description==NULL){TypeDescription d = new_TypeDescription();d->type=(t);new->description=d;new->builtIn=TRUE;};}

static void AddPredefinedTypes (list l, Interface i)
{
  ADD_PRIMITIVE_TYPE (l, i, "integer", integer_Type);
  ADD_PRIMITIVE_TYPE (l, i, "cardinal", cardinal_Type);
  ADD_PRIMITIVE_TYPE (l, i, "real", real_Type);
  ADD_PRIMITIVE_TYPE (l, i, "shortinteger", shortinteger_Type);
  ADD_PRIMITIVE_TYPE (l, i, "shortcardinal", shortcardinal_Type);
  ADD_PRIMITIVE_TYPE (l, i, "shortreal", shortreal_Type);
  ADD_PRIMITIVE_TYPE (l, i, "longinteger", longinteger_Type);
  ADD_PRIMITIVE_TYPE (l, i, "longcardinal", longcardinal_Type);
  ADD_PRIMITIVE_TYPE (l, i, "longreal", longreal_Type);
  ADD_PRIMITIVE_TYPE (l, i, "byte", byte_Type);
  ADD_PRIMITIVE_TYPE (l, i, "boolean", boolean_Type);
  ADD_PRIMITIVE_TYPE (l, i, "character", character_Type);
  ADD_PRIMITIVE_TYPE (l, i, "shortcharacter", shortcharacter_Type);
  ADD_PRIMITIVE_TYPE (l, i, "pickle", pickle_Type);
}

static list KnownInterfaces = NULL;

static void ClearExcnMark (Exception e, void *junk)
{
  e->marked = FALSE;
}

static void ClearProcMark (Procedure p, void *junk)
{
  p->marked = FALSE;
  if (p->exceptions != NULL)
    list_enumerate (p->exceptions, (iluparser_EnumProc) ClearExcnMark, NULL);
}

static void ClearTypeMarks (Type t, void *unused)
{
  t->marked = FALSE;
  if (type_ur_kind(t) == object_Type)
    {
      Class c = class_object(t);
      if (c->methods != NULL)
	list_enumerate (c->methods, (iluparser_EnumProc) ClearProcMark, NULL);
    }
}

static void ClearInterfaceMarks(Interface s, void *unused)
{
  list_enumerate (s->types, (iluparser_EnumProc) ClearTypeMarks, NULL);
  list_enumerate (s->exceptions, (iluparser_EnumProc) ClearExcnMark, NULL);
}

void iluparser_ClearMarks (void)
{
  list_enumerate (KnownInterfaces, (iluparser_EnumProc) ClearInterfaceMarks, NULL);
}

static boolean FindNamedInterface (Interface s, string name)
{
  return (strcmp (interface_name(s), name) == 0);
}

static Exception FindExceptionInInterface (string interfacename, string ename)
{
  Interface s;
  Exception e;
  matchname_s edata;

  if (KnownInterfaces == NULL)
    return (NULL);
  if ((s = (Interface) list_find (KnownInterfaces, (boolean (*)(refany, refany)) FindNamedInterface, interfacename)) == NULL)
    return (NULL);
  edata.name = ename;
  edata.interface = NULL;
  if ((e = (Exception) list_find (s->exceptions, (boolean (*)(refany, refany)) matchExceptionName, &edata)) == NULL)
    return (NULL);
  return (e);
}

static Type FindTypeInInterface (string interfacename, string tname)
{
  Interface s;
  Type t;
  matchname_s stype;

  if (KnownInterfaces == NULL
      || ((s = (Interface) list_find (KnownInterfaces, (boolean (*)(refany, refany)) FindNamedInterface, interfacename)) == NULL))
    {
      fprintf (stderr, "(FindTypeInInterface):  Can't find interface \"%s\".\n", interfacename);
      return (NULL);
    }
  stype.name = tname;
  stype.interface = interfacename;
  if ((t = (Type) list_find (s->types, (iluparser_FindProc) matchTypeName, &stype)) == NULL)
    {
      fprintf (stderr, "(FindTypeInInterface):  Interface \"%s\" doesn't seem to contain a type \"%s\".\n",
	       interfacename, tname);
      return (NULL);
    }
  return (t);
}

static Imported new_Imported(string name, string filename);

static Interface new_Interface (string name)
{
  Interface new = (Interface) iluparser_Malloc (sizeof(struct ilu_interface_s));
  new->name = new_Name();
  name_set_base_name(new->name, name);
  new->types = (set) new_list();
  new->classes = (set) new_list();
  new->imports = NULL;
  new->exceptions = (set) new_list();
  new->constants = (set) new_list();
  new->brand = NULL;
  new->def = 0;
  AddPredefinedTypes (new->types, new);
  return (new);
}

static boolean FindImport (Imported a, char *b)
{
  return (strcmp(a->name, b) == 0);
}

static boolean has_imported (list imports, char *newimport)
{
  return (list_find(imports, (iluparser_FindProc) FindImport, newimport) != NULL);
}

string interface_name(Interface i)
{
  return ((string) ((i == NULL) ? NULL : name_base_name(i->name)));
}

static Imported new_Imported (string name, string filename)
{
  Imported new = (Imported) iluparser_Malloc (sizeof(struct ilu_imported_s));
  new->name = name;
  new->filename = filename;
  return (new);
}

/**********************************************************************
  Globals and code
**********************************************************************/

static list SearchList = NULL;

static void AddILUPATH (list sl)
{
  char *prefix;
  char *p;
  char *ourstorage;
  char *iluhome = ILU_INTERFACE_HOME;

  if ((prefix = getenv ("ILUPATH")) == NULL) {
    prefix = DEFAULT_INTERFACE_PATH;
    iluhome = NULL;
  } else if (getenv("ILUPATH_NO_ILUHOME") != NULL) {
    iluhome = NULL;
  };
  p = ourstorage = ilu_strdup(prefix);
  while (p != NULL AND *p != '\0')
    {
      list_insert (sl, p);
#if (defined(WIN32) || defined(WIN16))
	/* use common ; path convention for windows platforms */
      p = strchr(p, ';');
#elif defined( macintosh )
      p = strchr(p, ',');
#else
      p = strchr(p, ':');
#endif
      if (p != NULL)
	*p++ = '\0';
    }
  if (iluhome != NULL) {
    p = ilu_strdup(iluhome);
    list_insert(sl, p);
  };
}

void iluparser_RegisterInterfaceDirectories (list directories)
{
  if (SearchList != NULL)
    {
      list_clear (SearchList, FALSE);
    }
  SearchList = directories;
  AddILUPATH (SearchList);
}

static list GetSearchList (void)
{
  if (SearchList == NULL)
    {
      SearchList = new_list();
#if (defined(WIN32) || defined(WIN16))
      list_insert (SearchList, ilu_strdup("."));
#endif
      AddILUPATH (SearchList);
    }
  return (SearchList);
}

string iluparser_FindFileInDir (char *dir, char *name)
{
  char buf[1000];
  char *canonical_name;
  boolean status;

#if (defined(WIN32) || defined(WIN16))
  sprintf (buf, "%s\\%s", dir, name);
#elif defined( macintosh )
  sprintf (buf, "%s%s", dir, name);
#else
  sprintf (buf, "%s/%s", dir, name);
#endif /* (defined(WIN32) || defined(WIN16)) */

  canonical_name = iluparser_CanonicalPathname (buf);

#ifdef _IS_POSIX
  status = (access (canonical_name, R_OK) == 0);
#else
  {
    FILE *f = fopen(canonical_name, "r");
    if (f != NULL)
      fclose(f);
    status = (f != NULL);
  }
#endif
  if (status)
    return canonical_name;
  else {
    iluparser_Free(canonical_name);
    return NULL;
  }
}

static boolean
  FindFileInDir (string dir, string name)
{
  string b = iluparser_FindFileInDir(dir, name);
  if (b == NULL)
    return FALSE;
  else {
    iluparser_Free(b);
    return TRUE;
  }    
}

static string FigureFilename (string name, string extension)
{
  char buf[1000];
  char nbuf[1000];
  char *testname;
  char *dir;
  char *ext;
  
  if ((ext = strrchr(name, '.')) == NULL)
    {
      sprintf (nbuf, "%s%s", name, (extension == NULL) ? ".isl" : extension);
      testname = nbuf;
    }
  else
    testname = name;

#if (defined(WIN32) || defined(WIN16))
  if (*testname == '.' || *testname == '\\')
#elif defined( macintosh )
  /*
     For the Mac implementation, we'll do search list (non-canonical) processing
     only if:
       The file name is simple (no paths, no leading colon).
  */
  if ( (*testname == ':') || ( strchr( testname, ':' ) != 0 ) )
#else
  if (*testname == '.' || *testname == '/')
#endif /* (defined(WIN32) || defined(WIN16)) */
    return (iluparser_CanonicalPathname(testname));

  if ((dir = list_find(GetSearchList(), (iluparser_FindProc) FindFileInDir, testname)) != NULL)
    {  
#if (defined(WIN32) || defined(WIN16))
      sprintf (buf, "%s\\%s", dir, testname);
#elif defined( macintosh )
      sprintf (buf, "%s%s", dir, testname);
#else
      sprintf (buf, "%s/%s", dir, testname);
#endif /* (defined(WIN32) || defined(WIN16)) */
      return (iluparser_CanonicalPathname(buf));
    }
  else
    return NULL;
}

string iluparser_FindFileInIncludes (string filename)
{
  return FigureFilename(filename, "");
}

static boolean
  printInterfaceName (Interface i, char *name)
{
  fprintf (stderr, " imported by %s", interface_name(i));
  return (strcmp(interface_name(i), name) == 0);
}

/* used to return an Interface; changed to be ANSI-conformant for
 * only use in call to list_enumerate().
 */
static boolean GetImportedInterface (Imported s)
{
  if (list_find(ActiveInterfaces, (iluparser_FindProc) FindNamedInterface, s->name) != NULL) {
    fprintf(stderr, "Interface %s referenced recursively, which is not allowed in ISL.\n");
    fprintf(stderr, "Reference chain is %s", s->name);
    list_find(ActiveInterfaces, (iluparser_FindProc) printInterfaceName, stderr);
    fprintf(stderr, ".\n");
    return TRUE;
  };
  return (GetInterface (s->name, s->filename) == NULL);
}

static string type_import_name (Type t)
{
  return ((string) ((t == NULL) ? NULL : name_lang_name (t->name, "import")));
}

static void FixUpImportedType (Type t)
{
  if (t->importInterfaceName != NULL && t->supertype == NULL) {
    Type            ref = FindTypeInInterface(t->importInterfaceName,
					      type_import_name(t));
    if (t->scoping != NULL) {
      list_clear(t->scoping, TRUE); free(t->scoping);
    }
    t->scoping = ref->scoping;
    t->supertype = ref;
    if (strchr(name_base_name(t->name), '.') != NULL)
      t->interface = GetInterface(t->importInterfaceName, NULL);
  }
  return;
}

static string exception_import_name (Exception e)
{
  return ((string) ((e == NULL) ? NULL : name_lang_name (e->name, "import")));
}

static void AssignEnumValue(EnumField ef, long int *count)
{
    if ( ef->id < 0 ) {
        ef->id = *count;
        *count += 1;
    }
    else
	*count = ef -> id + 1;
}

static void AssignEnumerationIDs(Type t)
{
    long count = 0;

    if ( t->importInterfaceName == NULL && 
		type_kind(t) == enumeration_Type ) {
        list_enumerate (type_description(t)->structuredDes.enumeration, 
			(void (*)(refany, refany)) AssignEnumValue, &count );
    }
}

static void AssignArmSpecificValue (Argument arg, int *count)
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = integer_Type;
  new->val.i.sign = 1;
  new->val.i.value = *count;

  arg->values = new_list();
  list_insert(arg->values, new);
  *count += 1;
}

static void CountUnvaluedArms (Argument arm, int *count)
{
  if (arm->values == NULL)
    *count += 1;
}

static boolean FindDefaultArm (Argument arg, Argument *default_arm)
{
  if (arg->values == &iluparser_DefaultUnionArm)
    {
      if (*default_arm != NULL)
	return (TRUE);
      else
	*default_arm = arg;
    }
  return (FALSE);
}

static void FigureUnionIDs (Type t)
{
  long            count = 0;
  unsigned int    arms_without_specific_values = 0;
  TypeDescription td;
  Type            tagt;
  TypeKind        tagtb;
  list            arms;

  if (t->importInterfaceName != NULL ||
      type_kind(t) != union_Type)
    return;

  td = type_description(t);
  arms = td->structuredDes.uniond.types;
  tagt = ur_type(td->structuredDes.uniond.discriminator_type);
  tagtb = type_kind(tagt);

  if (NOT(tagtb == integer_Type OR tagtb == shortinteger_Type
	  OR tagtb == cardinal_Type OR tagtb == shortcardinal_Type
	  OR tagtb == boolean_Type OR tagtb == byte_Type
	  OR tagtb == enumeration_Type)) {
    fprintf(stderr,
	    "Error:  Type \"%s\" specified as tag type for a union.  Only enumerations, [SHORT]CARDINAL, [SHORT]INTEGER, BYTE, or BOOLEAN are allowed.\n",
	    type_name(tagt));
    exit(1);
  }
  if (list_find(arms, (iluparser_FindProc) FindDefaultArm,
		&td->structuredDes.uniond.default_arm)
      != NULL) {
    fprintf(stderr,
	    "Two arms of union \"%s\" declared as default!\n",
	    type_name(t));
    exit(1);
  }
  if (td->structuredDes.uniond.default_arm != NULL
      AND td->structuredDes.uniond.others_allowed) {
    fprintf(stderr, "Union \"%s\":  the keyword OTHERS should not be used with a union type that has a default arm.\n", type_name(t));
    exit(1);
  }
  list_enumerate(arms, (iluparser_EnumProc) CountUnvaluedArms,
		 &arms_without_specific_values);
  if (arms_without_specific_values > 0
      AND list_size(arms) > arms_without_specific_values) {
    fprintf(stderr, "If any arm of a union such as \"%s\" is assigned particular case values or defaulted, all arms must be assigned values.\n",
	    type_name(t));
    exit(1);
  }
  if ((tagtb == enumeration_Type) &&
      (arms_without_specific_values > 0)) {
    fprintf(stderr, "All arms in enumeration-discriminated union \"%s\" must have explicit enumeration values specified.\n", type_name(t));
    exit(1);
  };
  if (arms_without_specific_values > 0)
    list_enumerate(arms, (iluparser_EnumProc) AssignArmSpecificValue,
		   &count);
}

static void FixUpImportedException (Exception e)
{
  if (e->importInterfaceName != NULL && e->import == NULL)
    {
      Exception ref = FindExceptionInInterface (e->importInterfaceName, exception_import_name(e));
      e->import = ref;
      if (e->scoping != NULL) {
	list_clear(e->scoping, TRUE); free(e->scoping);
      };
      e->scoping = ref->scoping;
      if (ref == NULL)
	fprintf (stderr, "Can't find referred-to exception \"%s\" or perhaps interface \"%s\".\n",
		 exception_import_name(e), e->importInterfaceName);
    }
}

static void AssignMethodID (Procedure method, ProtocolId *val)
{
  if (method->id < 0)
    method->id = ++*val;
}

static void FindHighestMethodID (Procedure method, ProtocolId *val)
{
  if (method->id > *val)
    *val = method->id;
}

Class class_object (Type t)
{
  Type rt = ur_type(t);
  if (type_kind(rt) != object_Type)
    return (NULL);
  if (rt->description != NULL)
    return (rt->description->structuredDes.object);
  return NULL;
}

static void AssignMethodIDs (refany element, refany rock)
{
  Type            type = (Type) element;
  Class           od;
  ProtocolId      HighestMethodID;

  if (type == NULL || type_kind(type) != object_Type ||
      (od = class_object(type)) == NULL)
    return;
  list_enumerate(od->superclasses, AssignMethodIDs, NULL);
  if (list_size(od->methods) > 0) {
    HighestMethodID = 0;
    list_enumerate(od->methods,
		   (void (*) (refany, refany)) FindHighestMethodID,
		   &HighestMethodID);
    list_enumerate(od->methods,
		   (void (*) (refany, refany)) AssignMethodID,
		   &HighestMethodID);
  }
}

static boolean ParsingConstant = FALSE;
static boolean ParsingNonRealConstant = FALSE;

static char *ErrorCheckMsg;
static char *ErrorCheckTname;
static boolean ErrorCheckErrors = FALSE;
static char *ErrorCheckFilename;

static void PrintRef (long int ref, char *file)
{
  fprintf (stderr, "%s:%ld:  %s \"%s\".\n", file, ref, ErrorCheckMsg, ErrorCheckTname);
}

static void FindDifferentlyCasedSameException (Exception e1, Exception e2)
{
  if (e1->interface == e2->interface && e1->def != 0 && e2->def != 0
      && ilu_strcasecmp(exception_name(e1), exception_name(e2)) == 0
      && strcmp(exception_name(e1), exception_name(e2)) != 0)
    {
      fprintf (stderr, "%s:%ld:  exception \"%s\" redefined as \"%s\"\n",
	       ErrorCheckFilename, e2->def, exception_name(e1), exception_name(e2));
      ErrorCheckErrors = TRUE;
    }
}

static void FindDifferentlyCasedSameType (Type t1, Type t2)
{
  if (t1->interface == t2->interface && t1->def != 0 && t2->def != 0
      && ilu_strcasecmp(type_name(t1), type_name(t2)) == 0 && strcmp(type_name(t1), type_name(t2)) != 0)
    {
      fprintf (stderr, "%s:%ld:  type \"%s\" redefined as \"%s\"\n",
	       ErrorCheckFilename, t2->def, type_name(t1), type_name(t2));
      ErrorCheckErrors = TRUE;
    }
}

static void CheckTypeDefs (Type type, char *file)
{
  ErrorCheckFilename = file;
  if (!type->builtIn && type->def == 0 && type->importInterfaceName == NULL)
    {
      fprintf (stderr, "%s:*:  undefined type \"%s\".\n", file, name_base_name(type->name));
      ErrorCheckTname = type_name(type);
      ErrorCheckMsg = "undefined type";
      list_enumerate (type->refs, (void (*)(refany, refany)) PrintRef, file);
      ErrorCheckErrors = TRUE;
    }
  else
    {
      if (type->interface != NULL)
	list_enumerate (type->interface->types, (void (*)(refany, refany)) FindDifferentlyCasedSameType, type);
    }
}

static void CheckExceptionDefs (Exception e, char *file)
{
  ErrorCheckFilename = file;
  if (!e->builtIn && e->def == 0 && e->importInterfaceName == NULL)
    {
      ErrorCheckTname = exception_name(e);
      ErrorCheckMsg = "undefined exception";
      fprintf (stderr, "%s:  undefined exception %s\n", file, ErrorCheckTname);
      list_enumerate (e->refs, (void (*)(refany, refany)) PrintRef, file);
      ErrorCheckErrors = TRUE;
    }
  if (e->interface != NULL)
    list_enumerate (e->interface->exceptions, (void (*)(refany, refany)) FindDifferentlyCasedSameException, e);
}

static void FixEnumValuedConstants (Constant c, void *junk)
{
  char *old, *p;

  if ((type_ur_kind(c->type) == enumeration_Type) &&
      (c->value->type == shortcharacter_Type) &&
      ((p = strrchr(c->value->val.s, '.')) != NULL)) {
    old = c->value->val.s;
    c->value->val.s = ilu_strdup(p + 1);
    free(old);
  }
}

static void FigureCollectibility2 (Type type, boolean *v)
{
  Class od;

  if (type == NULL || type_kind(type) != object_Type || (od = class_object(type)) == NULL)
    return;
  if (!od->collectible)
    {
      *v = FALSE;
      return;
    }
  else
    list_enumerate(od->superclasses, (void (*) (refany, refany)) FigureCollectibility2, v);
}

static void FigureCollectibility (Type type, char *file)
{
  Class od;
  boolean was_collectible;

  if (type == NULL || type_kind(type) != object_Type || (od = class_object(type)) == NULL)
    return;
  was_collectible = od->collectible;
  if (!od->collectible)
    return;
  else
    list_enumerate(od->superclasses, (void (*) (refany, refany)) FigureCollectibility2, &od->collectible);
  if (was_collectible AND NOT od->collectible)
    {
      fprintf (stderr, "%s:%ld:  collectible type %s inherits from non-collectible superclasses.\n",
	       type_interface(type)->filename, type->def, type_name(type));
      ErrorCheckErrors = TRUE;
    }
}

static void FigureOptionality2 (Type type, boolean *v)
{
  Class od;

  if (type == NULL || type_kind(type) != object_Type || (od = class_object(type)) == NULL)
    return;
  if (!od->collectible)
    {
      *v = FALSE;
      return;
    }
  else
    list_enumerate(od->superclasses, (void (*) (refany, refany)) FigureOptionality2, v);
}

static void FigureOptionality (Type type, char *file)
{
  Class od;
  boolean was_collectible;

  if (type == NULL || type_kind(type) != object_Type || (od = class_object(type)) == NULL)
    return;
  was_collectible = od->collectible;
  if (!od->collectible)
    return;
  else
    list_enumerate(od->superclasses, (void (*) (refany, refany)) FigureOptionality2, &od->collectible);
  if (was_collectible AND NOT od->collectible)
    {
      fprintf (stderr, "%s:%ld:  optional class %s inherits from non-optional superclasses.\n",
	       type_interface(type)->filename, type->def, type_name(type));
      ErrorCheckErrors = TRUE;
    }
}

static void CheckConstants (Constant c, char *file)
{
  TypeKind ctk, vtk;
  char *cn = name_base_name(c->name);
  char *tn = type_name(c->type);

  ctk = type_ur_kind(c->type);
  vtk = c->value->type;

  switch (ctk)
    {
    case shortinteger_Type:
    case integer_Type:
    case longinteger_Type:
      if (vtk != integer_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated integer value.\n",
		 file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      else if (ctk == shortinteger_Type &&
	       (((c->value->val.i.sign > 0) && (c->value->val.i.value > 0x7FFF)) ||
		((c->value->val.i.sign < 0) && (c->value->val.i.value > 0x8000)))) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must be between %ld and %ld.\n",
		 file, c->def, cn, tn, -32768, 32767);
	ErrorCheckErrors = TRUE;
      }
      else if (ctk == integer_Type &&
	       (((c->value->val.i.sign > 0) && (c->value->val.i.value > 0x7FFFFFFF)) ||
		((c->value->val.i.sign < 0) && (c->value->val.i.value > 0x80000000)))) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must be between %ld and %ld.\n",
		 file, c->def, cn, tn, (-2147483647 - 1), 2147483647);
	ErrorCheckErrors = TRUE;
      }
      break;

    case byte_Type:
    case shortcardinal_Type:
    case cardinal_Type:
    case longcardinal_Type:
      if (vtk != integer_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated integer value.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      else if (c->value->val.i.sign < 0) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" may not be negative.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      else if (ctk == byte_Type && c->value->val.i.value > 255) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must be less than 255.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      else if (ctk == shortcardinal_Type && c->value->val.i.value > 0xFFFF) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must be less than %lu.\n", file, c->def, cn, tn, 0xFFFF);
	ErrorCheckErrors = TRUE;
      }
      else if (ctk == cardinal_Type && c->value->val.i.value > 0xFFFFFFFF) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must be less than %lu.\n", file, c->def, cn, tn, 0xFFFFFFFF);
	ErrorCheckErrors = TRUE;
      }
      break;

    case real_Type:
    case shortreal_Type:
    case longreal_Type:
      if (vtk != real_Type && vtk != integer_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated real or integer value.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      break;

    case boolean_Type:
      if (vtk != boolean_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated boolean value.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      break;

    case sequence_Type:
      if (vtk != shortcharacter_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated string value.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      break;

    case enumeration_Type:
      if (vtk != shortcharacter_Type) {
	fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" must have an associated string value.\n", file, c->def, cn, tn);
	ErrorCheckErrors = TRUE;
      }
      break;

    default:
      fprintf (stderr, "%s:%ld:  %s: constants of type \"%s\" not allowed.\n", file, c->def, cn, tn);
      ErrorCheckErrors = TRUE;
      break;
    }
}

static Type CheckDuplicateField (Argument field, Type t)
{
  int i, nfields;
  list sfields = type_description(ur_type(t))->structuredDes.record.fields;

  nfields = list_size(sfields);
  for (i = 0;  i < nfields;  i++) {
    if (strcmp(argument_name(field), argument_name(list_ref(sfields, i))) == 0)
      return t;
  }
  if (type_description(ur_type(t))->structuredDes.record.supertype != NULL)
    return CheckDuplicateField(field, type_description(ur_type(t))->structuredDes.record.supertype);
  else
    return NULL;
}

static boolean CheckRecordDefs (Type t, char *file)
{
  Type s, p;
  int i, nfields;

  if (type_kind(t) != record_Type)
    return FALSE;
  for (p = t, s = type_description(t)->structuredDes.record.supertype;  (p != NULL && s != NULL);
       p = s, s = type_description(s)->structuredDes.record.supertype) {
    if (type_ur_kind(s) != record_Type) {
      fprintf(stderr, "Non-record type \"%s\" cannot be a supertype for record type \"%s\".\n",
	      type_name(s), type_name(p));
      ErrorCheckErrors = TRUE;
    } else if (!(type_description(ur_type(s))->structuredDes.record.extensible)) {
      fprintf(stderr, "Non-extensible record type \"%s\" cannot be a supertype for record type \"%s\".\n",
	      type_name(s), type_name(p));
      ErrorCheckErrors = TRUE;
    };
  };
  if (type_description(t)->structuredDes.record.supertype != NULL) {
    nfields = list_size(type_description(t)->structuredDes.record.fields);
    for (i = 0;  i < nfields;  i++) {
      if ((s = CheckDuplicateField(list_ref(type_description(t)->structuredDes.record.fields, i),
				   type_description(t)->structuredDes.record.supertype)) != NULL) {
	fprintf(stderr, "Record field \"%s\" declared in type \"%s\" cannot be re-declared in subtype \"%s\".\n",
		argument_name(list_ref(type_description(t)->structuredDes.record.fields, i)),
		type_name(s), type_name(t));
	ErrorCheckErrors = TRUE;
      }
    }
  } else if (list_size(type_description(t)->structuredDes.record.fields) < 1) {
    fprintf (stderr, "Record type \"%s\" has no fields!\n", type_name(t));
    ErrorCheckErrors = TRUE;
  };
  return FALSE;  
}

static boolean MatchEnumFieldName (EnumField ef, char *s)
{
  return (strcmp(ef->name, s) == 0);
}

static boolean CheckUnionDefs (Type t, char *file)
{
  Type d;
  int i, n, nfields;
  list values;
  Argument arm;

  if (type_kind(t) != union_Type)
    return FALSE;
  d = type_description(t)->structuredDes.uniond.discriminator_type;
  if (type_ur_kind(d) == enumeration_Type) {
    /* Check to see all arms have some value attached to them... */
    for (i = 0;  i < list_size(type_description(t)->structuredDes.uniond.types);  i++) {
      arm = (Argument) list_ref(type_description(t)->structuredDes.uniond.types, i);
      if (list_size(arm->values) < 1) {
	if (arm->values != &iluparser_DefaultUnionArm) {
	  char *arm_name;
	  if ((arm_name = argument_name(arm)) == NULL)
	    arm_name = type_name(arm->type);
	  fprintf (stderr, "Enumeration-discriminated union \"%s\" "
		   "has arm (\"%s\") with no assigned discriminant values.\n",
		   type_name(t), arm_name);
	  ErrorCheckErrors = TRUE;
	}
      } else {
	for (n = 0;  n < list_size(arm->values); n++) {
	  ConstantValue val = list_ref(arm->values, n);
	  char *arm_name;
	  if (val->type != shortcharacter_Type) {
	    if ((arm_name = argument_name(arm)) == NULL)
	      arm_name = type_name(arm->type);
	    fprintf (stderr, "Enumeration-discriminated union \"%s\" "
		     "has arm (\"%s\") with non-enumeration discriminant value.\n",
		     type_name(t), arm_name);
	    ErrorCheckErrors = TRUE;
	  } else {
	    if (list_find(type_description(d)->structuredDes.enumeration,
			  (iluparser_FindProc) MatchEnumFieldName, val->val.s) == NULL)
	      {
		if ((arm_name = argument_name(arm)) == NULL)
		  arm_name = type_name(arm->type);
		fprintf (stderr, "Arm \"%s\" of union \"%s\" has "
			 "discriminant value not in enumeration type \"%s\".\n",
			 arm_name, type_name(t), type_name(d));
		ErrorCheckErrors = TRUE;
	      }
	  }
	}
      }
    }
  }
  return FALSE;  
}

static boolean ErrorCheck (Interface s, char *file)
{
  boolean         stat;

  ErrorCheckErrors = FALSE;
  list_enumerate(s->types, (void (*) (refany, refany)) CheckTypeDefs,
		 file);
  list_enumerate(s->types,
		 (void (*) (refany, refany)) CheckRecordDefs, file);
  list_enumerate(s->types,
		 (void (*) (refany, refany)) CheckUnionDefs, file);
  list_enumerate(s->exceptions,
	    (void (*) (refany, refany)) CheckExceptionDefs, file);
  list_enumerate(s->classes,
	  (void (*) (refany, refany)) FigureCollectibility, file);
  list_enumerate(s->classes,
	     (void (*) (refany, refany)) FigureOptionality, file);
  list_enumerate(s->constants,
		 (iluparser_EnumProc) CheckConstants, file);
  stat = ErrorCheckErrors;
  ErrorCheckErrors = FALSE;
  return (stat);
}

static boolean has_suffix(string filename, string suffix)
{
  int offset = strlen(filename) - strlen(suffix);

  return offset >= 0 && strcmp(filename + offset, suffix) == 0;
}

static char* IdlIncludePath = "";

void iluparser_SetIdlIncludePath(string path)
{
  IdlIncludePath = path;
}

static FILE *idl2isl(char *filename)
{
#if (defined(_IS_POSIX) || defined(WIN32))
  static char idl2isl_cmd[] = "idl2isl";
  char command_buffer[1000];
  char name_buffer[L_tmpnam];
  char *isl_name = tmpnam(name_buffer);
  FILE *file = NULL;

#ifndef WIN32
  sprintf(command_buffer, "%s/%s %s %s > %s", IDL2ISL_BINDIR,
	  idl2isl_cmd, IdlIncludePath, filename, isl_name);
#else
/* for WIN32 we assume idl2isl is on the path */
 sprintf(command_buffer, "%s %s %s > %s", 
	  idl2isl_cmd, IdlIncludePath, filename, isl_name);
#endif
  if (system(command_buffer) != 0)
      fprintf (stderr, "IDL to ISL translation failed on file %s.\n", filename);
  else if ((file = fopen(isl_name, "r")) == NULL)
      fprintf (stderr, "Error opening file %s for read.\n", isl_name);
  unlink(isl_name);
  return file;
#else	/* is *not* POSIX  or WIN32 */
  printf("ILU parser:  OMG IDL parsing is only supported on POSIX UNIX or WIN32 platforms.\n");
  exit(1);
  return (0);	/* shut up compiler warning about no return value */
#endif /* _IS_POSIX or WIN32 */
}


static void AddNewInterface (Interface interface, struct parse_s *new)
{
  interface->filename = ilu_strdup(new->filename);

  if (KnownInterfaces == NULL)
    KnownInterfaces = new_list();
  if (list_find(KnownInterfaces,
		(boolean(*) (refany, refany)) FindNamedInterface,
		name_base_name(interface->name))
      == NULL)
    list_insert(KnownInterfaces, interface);
}

static void IdentifyClasses (Type t, list classes)
{
  if (type_kind(t) == object_Type && t->importInterfaceName == NULL)
    list_insert(classes, t);
}

static boolean FixupInterface (Interface interface, struct parse_s *new)
{
  list_enumerate(interface->types, (iluparser_EnumProc) IdentifyClasses, interface->classes);

  list_push(ActiveInterfaces, interface);

  /* Now go and get any imported interfaces. */
  if (list_find(interface->imports,
		(iluparser_FindProc) GetImportedInterface, NULL) != NULL) {
    list_remove(ActiveInterfaces, interface);
    list_remove(KnownInterfaces, interface);
    return TRUE;
  };
  list_remove(ActiveInterfaces, interface);
  list_enumerate(interface->types,
		 (iluparser_EnumProc) FixUpImportedType, NULL);
  list_enumerate(interface->exceptions,
	       (iluparser_EnumProc) FixUpImportedException, NULL);

  /* assign Enumeration IDs */
  list_enumerate(interface->types,
	  (void (*) (refany, refany)) AssignEnumerationIDs, NULL);

  /* assign Union discriminators */
  list_enumerate(interface->types, (iluparser_EnumProc) FigureUnionIDs, NULL);

  /* fix imported enum-valued constants */
  list_enumerate(interface->constants, (iluparser_EnumProc) FixEnumValuedConstants, NULL);

  /* assign Method IDs and unique class ids */
  list_enumerate(interface->classes, AssignMethodIDs, NULL);
  iluparser_ClearMarks();
  list_enumerate(interface->types, (iluparser_EnumProc) FigureTypeUID, NULL);

  /* check for errors and remove if necessary */
  if (ErrorCheck(interface, new->filename)) {
    list_remove(KnownInterfaces, interface);
    return (TRUE);
  } else
    return (FALSE);
}

list ParseFile (string filename)
{
  struct parse_s *new;
  int stat;
  list val = NULL;

  iluparsedebug = ((getenv("ISLDEBUG") != NULL) ? 1 : 0);

  if (KnownInterfaces == NULL)
    KnownInterfaces = new_list();

  if (ActiveInterfaces == NULL)
    ActiveInterfaces = new_list();

  new = (struct parse_s *) iluparser_Malloc (sizeof(struct parse_s));
  new->filename = FigureFilename (filename, ".isl");
  new->interfaces = NULL;
  new->interface = NULL;
  new->input = NULL;
  new->line = 0;
  new->next = NULL;

  if (new->filename == NULL)
    {
      list searched_dirs = GetSearchList();
      int i;
      fprintf (stderr, "ParseFile:  couldn't figure full filename for partial name \"%s\".\n", filename);
      fprintf (stderr, "Directories searched:\n");
      for (i = 0;  i < list_size(searched_dirs);  i++) {
	fprintf (stderr, "  %s\n", (char *) list_ref(searched_dirs, i));
      }
      iluparser_Free(new);
      return (NULL);
    }
  
  new->next = CurrentParse;
  new->interface = NULL;
  new->line = 1;
  
  if (has_suffix(new->filename, ".idl"))
    {
#if   defined(ADD_DIRECT_OMG_IDL_SUPPORT)
      struct idl_parse p;

      p.file=new->filename;
      p.definitions=p.defined_interfaces=p.imported_interfaces=NULL;
      if ((new->interfaces = ParseIDLFile(&p)) == NULL) {
	fprintf (stderr, "ParseFile:  couldn't parse OMG IDL file \"%s\".\n", new->filename);
	iluparser_Free (new->filename);
	iluparser_Free (new);
	return (NULL);
      } else {
	stat = 0;
	list_enumerate(p.imported_interfaces,list_insert1,KnownInterfaces);
	list_enumerate(p.imported_interfaces, (iluparser_EnumProc) FixUpImportedException, new);
      }

#elif defined(ADD_IDL_SUPPORT)

      if ((new->input = idl2isl(new->filename)) == NULL)
	{
	  fprintf (stderr, "ParseFile:  couldn't create ISL from IDL file \"%s\".\n", new->filename);
	  iluparser_Free (new->filename);
	  iluparser_Free (new);
	  return (NULL);
	}

#else

      fprintf(stderr, "Parsing of OMG IDL files not supported in this configuration of ILU.\n");
      return (NULL);

#endif
    }
  else if ((new->input = fopen(new->filename, "r")) == NULL)
    {
      fprintf (stderr, "ParseFile:  Error opening file \"%s\" for read.\n", new->filename);
      iluparser_Free (new->filename);
      iluparser_Free (new);
      return (NULL);
    }

  if (new->interfaces == NULL) {
    CurrentParse = new;
    ParsingConstant = FALSE;
    if (iluparsedebug)
      printf ("parsing %s\n", filename);
    stat = iluparseparse();
    if (iluparsedebug)
      printf ("finished %s\n", filename);
    fclose (new->input);
    CurrentParse = new->next;
  }

  if (stat == 0 AND new->interfaces != NULL)
    {
      Interface invalid_interface;

      list_enumerate (new->interfaces, (iluparser_EnumProc) AddNewInterface, new);

      while ((invalid_interface = (Interface) list_find (new->interfaces, (boolean (*)(refany, refany)) FixupInterface, new)) != NULL)
	list_remove (new->interfaces, invalid_interface);      
      if (list_size(new->interfaces) == 0)
	{
	  iluparser_Free (new->interfaces);
	  val = NULL;
	}
      else
	val = new->interfaces;
      iluparser_Free (new->filename);
      iluparser_Free (new);
    }
  else
    {
      fprintf (stderr, "%s:%ld:  parse error %d\n", new->filename, new->line, stat);
      iluparser_Free (new->filename);
      iluparser_Free (new);
      val = NULL;
    }
  return (val);
}

Interface GetInterface (string interfacename, string filename)
{
  Interface s;

  if (interfacename == NULL)
    return (NULL);

  if (KnownInterfaces == NULL
      || interfacename == NULL
      || (s = (Interface) list_find (KnownInterfaces, (boolean (*)(refany, refany)) FindNamedInterface, interfacename)) == NULL)
    {
      char buf[1000];

      if (filename == NULL)
	{
	  sprintf (buf, "%s.isl", interfacename);
	  ParseFile (buf);
	}
      else
	ParseFile (filename);
    }
  if (KnownInterfaces == NULL
      || (s = (Interface) list_find (KnownInterfaces, (boolean (*)(refany, refany)) FindNamedInterface, interfacename)) == NULL)
    return (NULL);
  else
    return (s);      
}

static boolean MyError = FALSE;

static int iluparseerror (string s)
{
  if (!MyError && (strcmp("parse error", s) == 0) && (!iluparsedebug))
    return 0;

  fprintf (stderr, "%s:%ld:  %s\n", CurrentParse->filename, CurrentParse->line, s);
  return (0);
}

static int iluwarn (string s)
{
  fprintf (stderr, "%s:%ld:  WARNING -- %s\n", CurrentParse->filename, CurrentParse->line, s);
  return 0;
}

static void iluerror (string s)
{
  MyError = TRUE;
  iluparseerror (s);
  MyError = FALSE;
}

static void iluerror1 (string s, refany a)
{
  char buf[1000];

  sprintf (buf, s, a);
  iluerror (buf);
}

static Argument argument_Create (char *name, Type type, boolean sibling,
	ArgDirection direction, long int line_def, list value)
{
  Argument new = new_Argument();
  if ( name )
      name_set_base_name (new->name, name);
  new->def = line_def;
  new->type = type;
  new->values = value;
  new->direction = direction;
  new->sibling = sibling;
  return (new);
}

static Procedure procedure_Create (char *name, boolean functional, boolean asynch, list args, Type returnType, list exceptions, long int id, long int def_line, Interface interface, Type object, char *authentication_type, char *doc_string)
{
  Procedure new = new_Procedure();
  name_set_base_name (new->name, name);
  new->functional = functional;
  new->asynch = asynch;
  new->arguments = args;
  new->returnType = returnType;
  new->returnOptional = FALSE;
  new->exceptions = exceptions;
  new->id = id;
  new->def = def_line;
  new->interface = interface;
  new->object = object;
  new->authentication_type = authentication_type;
  new->doc_string = doc_string;
  return (new);
}

static void AssignClassAttributes (Attribute *a, Class c)
{
  if (a->keyword == o_Brand)
    c->brand = (string) a->value;
  else if (a->keyword == o_Collectible)
    c->collectible = (boolean) a->value;
  else if (a->keyword == o_Optional)
    c->optional = (boolean) a->value;
  else if (a->keyword == o_Singleton)
    c->singleton = (string) a->value;
  else if (a->keyword == o_Superclasses)
    c->superclasses = (list) a->value;
  else if (a->keyword == o_Authentication)
    c->authentication = (string) a->value;
  else if (a->keyword == o_RepositoryID)
    c->corba_rep_id = (string) a->value;
  else if (a->keyword == o_Methods)
    c->methods = (list) a->value;
  else if (a->keyword == o_Documentation)
    c->doc_string = (char *) a->value;
  else
    {
      yyerror ("Bad keyword for object type\n");
    }
  a->value = 0;
}

static boolean CheckForSelf (Imported i, string name)
{
  return (strcmp(i->name, name) == 0);
}

#if ((defined(WIN32) || defined(WIN16)) && defined(_WINIO))
#include <winiodef.h>
#endif /* ((defined(WIN32) || defined(WIN16)) && defined(_WINIO)) */

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		287
#define	YYFLAG		-32768
#define	YYNTBASE	70

#define YYTRANSLATE(x) ((unsigned)(x) <= 324 ? yytranslate[x] : 156)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     5,     8,    10,    12,    15,    17,    19,    21,
    24,    29,    30,    33,    35,    38,    42,    47,    49,    53,
    55,    59,    66,    73,    79,    81,    83,    85,    87,    89,
    91,    93,    95,    97,   100,   101,   103,   105,   108,   111,
   114,   117,   119,   121,   123,   125,   127,   128,   133,   134,
   140,   141,   144,   146,   148,   150,   153,   158,   163,   165,
   169,   175,   176,   179,   183,   185,   187,   193,   198,   204,
   206,   210,   214,   215,   217,   219,   220,   223,   228,   232,
   235,   236,   238,   240,   244,   247,   252,   253,   254,   258,
   260,   263,   264,   266,   269,   272,   275,   279,   281,   285,
   292,   295,   296,   298,   299,   302,   306,   309,   313,   315,
   319,   320,   322,   324,   326,   332,   333,   335,   337,   341,
   344,   345,   348,   351,   354,   357,   360,   363,   366,   369,
   372,   375,   377,   379,   382,   386,   388,   392,   395,   398,
   401,   405,   411,   415,   417,   421,   425,   434,   435,   438,
   439,   441,   443,   444,   446,   447,   451,   455,   456,   459,
   460,   463,   464,   465,   475,   477,   479,   482,   484,   486,
   488,   492,   498,   503,   507,   509,   512,   516,   520,   522,
   524,   525,   527
};

static const short yyrhs[] = {    71,
     0,    70,    71,     0,    74,    72,     0,     1,     0,    73,
     0,    72,    73,     0,    80,     0,   116,     0,   145,     0,
     1,    32,     0,     3,   154,    75,    76,     0,     0,    10,
    61,     0,    32,     0,    77,    32,     0,     7,    78,     9,
     0,     7,    78,    32,     1,     0,    79,     0,    78,    33,
    79,     0,   154,     0,   154,     8,    61,     0,     5,   154,
    28,    81,   118,    32,     0,     5,   154,    28,    85,   118,
    32,     0,     5,   154,    28,   126,    32,     0,    93,     0,
    95,     0,    97,     0,    99,     0,   104,     0,    86,     0,
    88,     0,    82,     0,   113,     0,    43,    85,     0,     0,
    20,     0,    21,     0,    83,    12,     0,    83,    13,     0,
    83,    19,     0,    83,    15,     0,    22,     0,    16,     0,
    44,     0,    84,     0,   155,     0,     0,    14,    87,    96,
    90,     0,     0,    11,    89,    92,    92,    92,     0,     0,
    27,    91,     0,    25,     0,    26,     0,    62,     0,   153,
    62,     0,    39,    40,    94,    85,     0,    39,    94,    40,
    85,     0,    62,     0,    94,    33,    62,     0,    83,    42,
    40,    85,    96,     0,     0,    67,    62,     0,    98,    40,
    85,     0,    58,     0,    59,     0,   102,    37,   103,   100,
     9,     0,   102,    37,     1,     9,     0,   102,    37,   103,
   100,     1,     0,   101,     0,   100,    33,   101,     0,   154,
    29,    85,     0,     0,    18,     0,    17,     0,     0,    47,
    85,     0,   105,   107,     9,   112,     0,   105,   107,     1,
     0,   106,    38,     0,     0,    85,     0,   108,     0,   107,
    33,   108,     0,    85,   109,     0,   154,    29,    85,   109,
     0,     0,     0,    28,   110,   111,     0,    45,     0,   151,
     9,     0,     0,    68,     0,   114,     9,     0,   114,     1,
     0,    41,   115,     0,   114,    33,   115,     0,   154,     0,
   154,    28,    62,     0,     4,   154,   119,   118,   141,    32,
     0,    60,    61,     0,     0,   117,     0,     0,    29,    85,
     0,    30,   121,    31,     0,    30,    31,     0,    30,     1,
    31,     0,   123,     0,   121,    33,   123,     0,     0,    34,
     0,    35,     0,    36,     0,   122,   154,    29,   124,    85,
     0,     0,    55,     0,   155,     0,   125,    33,   155,     0,
    46,   127,     0,     0,   127,   134,     0,   127,   129,     0,
   127,   130,     0,   127,   128,     0,   127,   131,     0,   127,
   133,     0,   127,   117,     0,   127,   136,     0,   127,   135,
     0,    56,    61,     0,    57,     0,    43,     0,    47,   155,
     0,    48,   132,     9,     0,    85,     0,   132,    33,    85,
     0,    49,    61,     0,    10,    61,     0,    52,    61,     0,
    53,   137,     9,     0,    53,   137,    33,     9,     1,     0,
    53,     1,    33,     0,   138,     0,   137,    33,   138,     0,
   137,     1,    33,     0,   140,   154,   120,   139,   142,   143,
   144,   141,     0,     0,    29,    85,     0,     0,    50,     0,
    51,     0,     0,    61,     0,     0,    54,   125,     9,     0,
    54,     1,    33,     0,     0,    28,    62,     0,     0,    49,
    61,     0,     0,     0,     6,   154,    29,    85,    28,   146,
   148,   147,    32,     0,   150,     0,   149,     0,   153,    62,
     0,    61,     0,    24,     0,    23,     0,   153,    62,   152,
     0,   153,    62,    64,    62,   152,     0,   153,    62,    64,
    62,     0,   151,    33,   148,     0,   148,     0,    63,    62,
     0,    63,    65,    62,     0,    63,    66,    62,     0,    65,
     0,    66,     0,     0,    61,     0,    61,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
  2339,  2345,  2352,  2356,  2362,  2364,  2369,  2373,  2377,  2381,
  2391,  2411,  2415,  2421,  2426,  2434,  2438,  2446,  2453,  2463,
  2467,  2473,  2508,  2534,  2556,  2560,  2564,  2568,  2572,  2576,
  2580,  2584,  2591,  2597,  2603,  2607,  2611,  2617,  2621,  2625,
  2629,  2633,  2637,  2641,  2647,  2695,  2701,  2704,  2737,  2740,
  2781,  2785,  2791,  2795,  2799,  2805,  2825,  2835,  2847,  2853,
  2860,  2876,  2880,  2886,  2898,  2902,  2908,  2917,  2923,  2931,
  2937,  2945,  2952,  2956,  2960,  2966,  2970,  2976,  2986,  2994,
  3003,  3007,  3013,  3020,  3027,  3033,  3041,  3045,  3049,  3056,
  3060,  3079,  3083,  3089,  3096,  3103,  3109,  3116,  3123,  3132,
  3154,  3177,  3181,  3187,  3191,  3198,  3202,  3206,  3213,  3219,
  3226,  3230,  3234,  3238,  3244,  3253,  3257,  3263,  3271,  3280,
  3311,  3315,  3321,  3327,  3333,  3339,  3345,  3351,  3357,  3363,
  3371,  3377,  3383,  3389,  3395,  3401,  3407,  3414,  3420,  3426,
  3432,  3436,  3442,  3450,  3457,  3463,  3471,  3500,  3504,  3511,
  3515,  3519,  3525,  3529,  3535,  3539,  3543,  3550,  3554,  3560,
  3564,  3570,  3573,  3576,  3596,  3600,  3606,  3623,  3630,  3637,
  3646,  3656,  3666,  3678,  3684,  3693,  3698,  3702,  3708,  3712,
  3716,  3722,  3746
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","K_INTERFACE",
"K_EXCEPTION","K_TYPE","K_CONSTANT","K_IMPORTS","K_FROM","K_END","K_BRAND","K_FIXEDPOINT",
"K_INTEGER","K_CARDINAL","K_STRING","K_CHARACTER","K_BYTE","K_EXTENSIBLE","K_FIXED",
"K_REAL","K_LONG","K_SHORT","K_BOOLEAN","K_FALSE","K_TRUE","K_UNICODE","K_LATIN1",
"K_CHARSET","K_EQUALS","K_COLON","K_LEFTPAREN","K_RIGHTPAREN","K_SEMICOLON",
"K_COMMA","K_IN","K_OUT","K_INOUT","K_RECORD","K_UNION","K_ARRAY","K_OF","K_ENUMERATION",
"K_SEQUENCE","K_OPTIONAL","K_PICKLE","K_DEFAULT","K_OBJECT","K_SUPERCLASS","K_SUPERTYPES",
"K_AUTHENTICATION","K_FUNCTIONAL","K_ASYNCH","K_DOCUMENTATION","K_METHODS","K_RAISES",
"K_SIBLING","K_SINGLETON","K_COLLECTIBLE","K_SOURCE","K_SINK","K_TYPEID","T_STRING",
"T_NUMBER","K_EXPONENT","K_PERIOD","K_HYPHEN","K_PLUS","K_LIMIT","K_OTHERS",
"K_ALLOWS","interface_list","interface","declaration_list","simple_declaration",
"interface_declaration","optional_brand","interface_end","import_list","import_list2",
"import_statement","type_declaration","type_description","optional_description",
"primitive_size","primitive_type","type_stamp","string_description","@1","fixedpoint_description",
"@2","possible_charset","charset_spec","integer_literal","array_description",
"number_list","sequence_description","possible_limit","pipe_description","pipe_side",
"record_description","record_field_list","record_field_description","possible_extensible",
"possible_supertype","union_description","union_prefix","possible_type_stamp",
"union_type_list","union_type","possible_value","@3","union_value_specifier",
"possible_others","enumeration_description","enumeration_prefix","enumeration_field",
"exception_declaration","corba_rep_id","possible_id","exception_type","arguments",
"argument_list","direction_decl","argument","sibling_decl","exception_list",
"object_description","object_keywords","object_singleton","object_collectible",
"object_optional","object_superclasses","class_list","object_authentication",
"object_brand","object_documentation","object_methods","object_method_list",
"object_method","method_type","possible_asynch_or_functional","possible_documentation",
"method_exceptions","method_id","possible_authentication","constant_declaration",
"@4","@5","constant_value","nonreal_constant_value","real_constant_value","constant_value_list",
"real_exponent","sign","identifier","scoped_identifier", NULL
};
#endif

static const short yyr1[] = {     0,
    70,    70,    71,    71,    72,    72,    73,    73,    73,    73,
    74,    75,    75,    76,    76,    77,    77,    78,    78,    79,
    79,    80,    80,    80,    81,    81,    81,    81,    81,    81,
    81,    81,    81,    82,    83,    83,    83,    84,    84,    84,
    84,    84,    84,    84,    85,    85,    87,    86,    89,    88,
    90,    90,    91,    91,    91,    92,    93,    93,    94,    94,
    95,    96,    96,    97,    98,    98,    99,    99,    99,   100,
   100,   101,   102,   102,   102,   103,   103,   104,   104,   105,
   106,   106,   107,   107,   108,   108,   109,   110,   109,   111,
   111,   112,   112,   113,   113,   114,   114,   115,   115,   116,
   117,   118,   118,   119,   119,   120,   120,   120,   121,   121,
   122,   122,   122,   122,   123,   124,   124,   125,   125,   126,
   127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
   128,   129,   130,   131,   131,   132,   132,   133,   134,   135,
   136,   136,   136,   137,   137,   137,   138,   139,   139,   140,
   140,   140,   141,   141,   142,   142,   142,   143,   143,   144,
   144,   146,   147,   145,   148,   148,   149,   149,   149,   149,
   150,   150,   150,   151,   151,   152,   152,   152,   153,   153,
   153,   154,   155
};

static const short yyr2[] = {     0,
     1,     2,     2,     1,     1,     2,     1,     1,     1,     2,
     4,     0,     2,     1,     2,     3,     4,     1,     3,     1,
     3,     6,     6,     5,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     2,     0,     1,     1,     2,     2,     2,
     2,     1,     1,     1,     1,     1,     0,     4,     0,     5,
     0,     2,     1,     1,     1,     2,     4,     4,     1,     3,
     5,     0,     2,     3,     1,     1,     5,     4,     5,     1,
     3,     3,     0,     1,     1,     0,     2,     4,     3,     2,
     0,     1,     1,     3,     2,     4,     0,     0,     3,     1,
     2,     0,     1,     2,     2,     2,     3,     1,     3,     6,
     2,     0,     1,     0,     2,     3,     2,     3,     1,     3,
     0,     1,     1,     1,     5,     0,     1,     1,     3,     2,
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     1,     1,     2,     3,     1,     3,     2,     2,     2,
     3,     5,     3,     1,     3,     3,     8,     0,     2,     0,
     1,     1,     0,     1,     0,     3,     3,     0,     2,     0,
     2,     0,     0,     9,     1,     1,     2,     1,     1,     1,
     3,     5,     4,     3,     1,     2,     3,     3,     1,     1,
     0,     1,     1
};

static const short yydefact[] = {     0,
     4,     0,     0,     1,     0,   182,    12,     2,     0,     0,
     0,     0,     0,     5,     7,     8,     9,     0,     0,    10,
   104,     0,     0,     6,    13,     0,    14,    11,     0,    35,
   102,    35,    35,     0,    18,    20,    15,    43,    36,    37,
    42,    44,   183,     0,    45,   105,    46,     0,   103,   153,
    49,    47,    75,    74,     0,     0,    35,   121,    65,    66,
   102,    32,     0,    82,    30,    31,    25,    26,    27,     0,
    28,     0,    29,    35,     0,    33,     0,     0,     0,    16,
     0,     0,     0,    38,    39,    41,    40,   101,   154,     0,
   181,    62,     0,    59,     0,    96,    98,    34,   120,     0,
     0,     0,    35,     0,   183,    87,     0,    83,     0,    80,
    95,    94,     0,    24,   162,    17,    19,    21,   100,   179,
   180,   181,     0,     0,    51,    35,     0,    35,     0,     0,
   133,     0,    35,     0,     0,     0,     0,   132,   128,   125,
   123,   124,   126,   127,   122,   130,   129,    22,    35,    23,
    64,     0,    35,     0,    88,    85,    79,    92,    35,    35,
    97,   181,   181,    56,    63,     0,    48,    57,    60,    58,
    99,   139,   134,   136,     0,   138,   140,     0,   151,   152,
     0,   144,     0,   131,    62,    68,    77,     0,    70,     0,
   181,    93,    78,    84,    87,   170,   169,   168,   163,   166,
   165,     0,    50,    53,    54,    55,    52,   135,    35,   143,
     0,   141,   150,     0,    61,    69,    67,     0,    35,    90,
    89,   175,     0,    86,     0,   167,   137,   146,     0,   145,
     0,   148,    71,    72,    91,   181,   164,     0,     0,   171,
   142,     0,   107,   112,   113,   114,     0,     0,   109,    35,
   155,   174,   176,     0,     0,   173,   108,   106,   111,     0,
   149,     0,   158,   177,   178,   172,   110,   116,     0,     0,
   118,     0,   160,   117,    35,   157,   156,     0,   159,     0,
   153,   115,   119,   161,   147,     0,     0
};

static const short yydefgoto[] = {     3,
     4,    13,    14,     5,    19,    28,    29,    34,    35,    15,
    61,    62,    44,    45,   106,    65,    92,    66,    91,   167,
   207,   122,    67,    95,    68,   125,    69,    70,    71,   188,
   189,    72,   154,    73,    74,    75,   107,   108,   156,   191,
   221,   193,    76,    77,    96,    16,    49,    50,    31,   232,
   247,   248,   249,   275,   270,    78,    99,   140,   141,   142,
   143,   175,   144,   145,   146,   147,   181,   182,   251,   183,
    90,   263,   273,   281,    17,   162,   225,   199,   200,   201,
   223,   240,   123,    36,    47
};

static const short yypact[] = {    17,
-32768,   -47,   136,-32768,   190,-32768,    14,-32768,    -3,   -47,
   -47,   -47,   184,-32768,-32768,-32768,-32768,   -23,    84,-32768,
    21,    24,    39,-32768,-32768,   -47,-32768,-32768,    47,    97,
    40,     5,    97,   137,-32768,   112,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,   159,-32768,-32768,-32768,    54,-32768,    64,
-32768,-32768,-32768,-32768,    34,   -47,    97,-32768,-32768,-32768,
    40,-32768,   141,   -15,-32768,-32768,-32768,-32768,-32768,   108,
-32768,   113,-32768,   107,   117,-32768,    74,   127,   135,-32768,
   172,   -47,   125,-32768,-32768,-32768,-32768,-32768,-32768,   145,
   110,   126,   138,-32768,    65,-32768,   173,-32768,    37,   170,
   164,   171,    97,    12,   176,   178,   129,-32768,   179,-32768,
-32768,-32768,   -47,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   110,   147,   148,   180,    88,   149,    97,   150,   152,
-32768,   153,    97,   154,   156,     6,   157,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    97,-32768,
-32768,   210,    97,   -47,-32768,-32768,-32768,   158,   107,    97,
-32768,    79,   110,-32768,-32768,    62,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,    22,-32768,-32768,   187,-32768,-32768,
   133,-32768,   -47,-32768,   126,-32768,-32768,   134,-32768,   192,
    16,-32768,-32768,-32768,   178,-32768,-32768,-32768,-32768,-32768,
-32768,   160,-32768,-32768,-32768,-32768,-32768,-32768,    97,-32768,
   191,-32768,    19,   195,-32768,-32768,-32768,   -47,    97,-32768,
-32768,-32768,    25,-32768,   196,   116,-32768,-32768,   226,-32768,
     1,   200,-32768,-32768,-32768,    79,-32768,    99,   168,-32768,
-32768,   201,-32768,-32768,-32768,-32768,    81,   -47,-32768,    97,
   177,-32768,-32768,   174,   175,   181,-32768,-32768,   163,   204,
-32768,    10,   206,-32768,-32768,-32768,-32768,   183,   202,    32,
-32768,   185,   193,-32768,    97,-32768,-32768,   153,-32768,   182,
    64,-32768,-32768,-32768,-32768,   239,-32768
};

static const short yypgoto[] = {-32768,
   237,-32768,   228,-32768,-32768,-32768,-32768,-32768,   167,-32768,
-32768,-32768,   213,-32768,   -27,-32768,-32768,-32768,-32768,-32768,
-32768,  -110,-32768,   161,-32768,    66,-32768,-32768,-32768,-32768,
    35,-32768,-32768,-32768,-32768,-32768,-32768,    91,    57,-32768,
-32768,-32768,-32768,-32768,   142,-32768,   162,    31,-32768,-32768,
-32768,-32768,    -1,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    43,-32768,-32768,
   -24,-32768,-32768,-32768,-32768,-32768,-32768,  -176,-32768,-32768,
-32768,     3,  -158,    -2,  -131
};


#define	YYLAST		261


static const short yytable[] = {     7,
   173,   242,    46,   202,    64,    79,   178,    21,    22,    23,
   269,   163,   152,     6,   222,    51,  -102,     1,    52,     2,
    38,    53,    54,    18,    39,    40,    41,   229,    20,    98,
   208,   243,   202,   235,   244,   245,   246,    25,   196,   197,
   277,   -73,   -81,    55,    48,    56,   130,    57,    42,    30,
    58,    32,   203,    97,   209,   179,   180,   236,   153,   252,
   220,  -111,    59,    60,   278,    43,  -150,    33,   179,   180,
    43,   109,   -76,    93,   111,   151,   198,   202,    37,   131,
   120,   121,   112,   132,   133,   134,   204,   205,   135,   136,
    26,   100,   137,   138,   102,    94,    48,   127,   168,    48,
   170,   196,   197,    38,   128,   174,   113,    39,    40,    41,
    97,   258,    38,   259,    88,    27,    39,    40,    41,    83,
   127,   185,    38,   206,    89,   187,    39,    40,    41,   157,
   271,    42,   195,   211,   216,   286,     1,   158,     2,   198,
    42,   212,   217,   120,   121,    80,   283,   103,    43,   104,
    42,   190,    84,    85,   110,    86,   109,    43,   114,    87,
   253,   159,   115,   254,   255,   213,   218,   105,    81,    82,
    84,    85,   116,    86,   120,   121,   119,    87,   238,   239,
   214,   227,   101,    -3,     9,   118,    -3,    10,    11,    12,
     9,   234,   124,    10,    11,    12,   244,   245,   246,    94,
   129,   148,   150,   149,  -182,   155,   166,   160,   164,   165,
   169,   171,   172,    43,   176,   190,   177,   184,   186,   210,
   219,   226,   261,   228,   231,   192,   241,   237,   250,   256,
   262,   257,   268,   272,   276,   264,   265,   274,   287,     8,
    24,   280,   284,   238,    63,   260,   279,   282,   117,   194,
   215,   224,   233,   126,   161,   230,   285,   267,   266,     0,
   139
};

static const short yycheck[] = {     2,
   132,     1,    30,   162,    32,    33,     1,    10,    11,    12,
     1,   122,     1,    61,   191,    11,    32,     1,    14,     3,
    16,    17,    18,    10,    20,    21,    22,     9,    32,    57,
     9,    31,   191,     9,    34,    35,    36,    61,    23,    24,
     9,    37,    38,    39,    60,    41,    10,    43,    44,    29,
    46,    28,   163,    56,    33,    50,    51,    33,    47,   236,
    45,    61,    58,    59,    33,    61,    61,    29,    50,    51,
    61,    74,    61,    40,     1,   103,    61,   236,    32,    43,
    65,    66,     9,    47,    48,    49,    25,    26,    52,    53,
     7,    61,    56,    57,    64,    62,    60,    33,   126,    60,
   128,    23,    24,    16,    40,   133,    33,    20,    21,    22,
   113,    31,    16,    33,    61,    32,    20,    21,    22,     8,
    33,   149,    16,    62,    61,   153,    20,    21,    22,     1,
   262,    44,   160,     1,     1,     0,     1,     9,     3,    61,
    44,     9,     9,    65,    66,     9,   278,    40,    61,    37,
    44,   154,    12,    13,    38,    15,   159,    61,    32,    19,
    62,    33,    28,    65,    66,    33,    33,    61,    32,    33,
    12,    13,     1,    15,    65,    66,    32,    19,    63,    64,
   183,   209,    42,     0,     1,    61,     3,     4,     5,     6,
     1,   219,    67,     4,     5,     6,    34,    35,    36,    62,
    28,    32,    32,    40,    29,    28,    27,    29,    62,    62,
    62,    62,    61,    61,    61,   218,    61,    61,     9,    33,
    29,    62,   250,    33,    30,    68,     1,    32,    29,    62,
    54,    31,    29,    28,    33,    62,    62,    55,     0,     3,
    13,    49,    61,    63,    32,   248,    62,   275,    82,   159,
   185,   195,   218,    93,   113,   213,   281,   259,   256,    -1,
    99
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/import/bison-1.25/sparc-sun-solaris2.5/share/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/import/bison-1.25/sparc-sun-solaris2.5/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 2340 "ilu.bison"
{
  CurrentParse->interfaces = new_list();
  list_insert(CurrentParse->interfaces, yyvsp[0]);
  yyval = (refany) CurrentParse->interfaces;
;
    break;}
case 2:
#line 2346 "ilu.bison"
{
  list_insert ((list) yyvsp[-1], yyvsp[0]);
  yyval = yyvsp[-1];
;
    break;}
case 3:
#line 2353 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 4:
#line 2357 "ilu.bison"
{
  iluerror ("Bad interface description.");
  YYABORT;
;
    break;}
case 7:
#line 2370 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 8:
#line 2374 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 9:
#line 2378 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 10:
#line 2382 "ilu.bison"
{
  iluerror ("Bad statement.");
  yyerrok;
  ParsingConstant = FALSE;
  ParsingNonRealConstant = FALSE;
  yyval = yyvsp[-1];
;
    break;}
case 11:
#line 2392 "ilu.bison"
{
  CurrentParse->interface = new_Interface(yyvsp[-2]);
  CurrentParse->interface->brand = (string) yyvsp[-1];
  CurrentParse->interface->def = CurrentParse->line;
  if (!has_imported((list) yyvsp[0], "ilu") && strcmp((string) yyvsp[-2], "ilu") != 0)
    list_insert ((list) yyvsp[0], new_Imported("ilu", NULL));
  CurrentParse->interface->imports = (list) yyvsp[0];
  /* check for import of self */
  if (list_find((list) yyvsp[0], (iluparser_FindProc) CheckForSelf, (refany) yyvsp[-2]) != NULL)
    {
      char buf[1000];
      sprintf(buf, "Interface \"%s\" may not import itself.", (string) yyvsp[-2]);
      iluerror(buf);
      YYERROR;
    }
  yyval = (refany) CurrentParse->interface;
;
    break;}
case 12:
#line 2412 "ilu.bison"
{
  yyval = NULL;
;
    break;}
case 13:
#line 2416 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 14:
#line 2422 "ilu.bison"
{
  list new = new_list();
  yyval = (refany) new;
;
    break;}
case 15:
#line 2428 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 16:
#line 2435 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 17:
#line 2439 "ilu.bison"
{
  iluerror ("Missing END statement in import list.");
  yyerrok;
  yyval = yyvsp[-2];
;
    break;}
case 18:
#line 2447 "ilu.bison"
{
  list new = new_list();

  list_insert(new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 19:
#line 2454 "ilu.bison"
{
  if (!has_imported((list) yyvsp[-2], ((Imported) yyvsp[0])->name))
    list_insert (yyvsp[-2], yyvsp[0]);
  else
    free(yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 20:
#line 2464 "ilu.bison"
{
  yyval = (refany) new_Imported (yyvsp[0], NULL);
;
    break;}
case 21:
#line 2468 "ilu.bison"
{
  yyval = (refany) new_Imported (yyvsp[-2], yyvsp[0]);
;
    break;}
case 22:
#line 2474 "ilu.bison"
{
  Type            new = FIND_OR_CREATE_TYPE(yyvsp[-4]);
  if (new->def != 0) {
    char            buf[500];
    sprintf(buf, "type \"%s\" already defined on line %ld\n",
	    type_name(new), new->def);
    iluerror(buf);
    YYERROR;
  } else {
    TypeDescription d = (TypeDescription) yyvsp[-2];
    new->description = NULL;
    if (d->type == byte_Type) {
      new->supertype = FIND_OR_CREATE_TYPE("byte");
    } else if (d->type == shortcardinal_Type) {
      new->supertype = FIND_OR_CREATE_TYPE("shortcardinal");
    } else if (d->type == cardinal_Type) {
      new->supertype = FIND_OR_CREATE_TYPE("cardinal");
    } else if (d->type == shortinteger_Type) {
      new->supertype = FIND_OR_CREATE_TYPE("shortinteger");
    } else if (d->type == integer_Type) {
      new->supertype = FIND_OR_CREATE_TYPE("integer");
    } else {
      new->supertype = NULL;
      new->description = d;
    }
    new->def = CurrentParse->line;
    new->uid = (char *) yyvsp[-1];
    if (type_kind(new) == object_Type)
      list_enumerate(new->description->structuredDes.object->methods,
		     SetObjectSlotOfMethod,
		     new);
  }
  yyval = (refany) new;
;
    break;}
case 23:
#line 2509 "ilu.bison"
{
  Type            new = NULL;

  if ((strcmp(yyvsp[-4], type_name((Type)yyvsp[-2])) == 0) && ((Type)yyvsp[-2])->importInterfaceName == NULL) {
    char	    buf[500];
    sprintf (buf, "can't define type to be itself:  %s\n", (char*)yyvsp[-4]);
    iluerror(buf);
    YYERROR;
  } else {
    new = FIND_OR_CREATE_TYPE(yyvsp[-4]);
    if (new->def != 0) {
      char            buf[500];
      sprintf(buf, "type \"%s\" already defined on line %ld\n",
	      type_name(new), new->def);
      iluerror(buf);
      new = NULL;
      YYERROR;
    } else {
      new->supertype = (Type) yyvsp[-2];
      new->uid = (char *) yyvsp[-1];
      new->def = CurrentParse->line;
    }
  }
  yyval = (refany) new;
;
    break;}
case 24:
#line 2535 "ilu.bison"
{
  Type            new = FIND_OR_CREATE_TYPE(yyvsp[-3]);
  if (new->def != 0) {
    char            buf[500];
    sprintf(buf, "type \"%s\" already defined on line %ld\n",
	    type_name(new), new->def);
    iluerror(buf);
    YYERROR;
  } else {
    new->description = (TypeDescription) yyvsp[-1];
    new->def = CurrentParse->line;
    if (type_kind(new) == object_Type)
      list_enumerate(new->description->structuredDes.object->methods,
		     SetObjectSlotOfMethod,
		     new);
  }
  yyval = (refany) new;
;
    break;}
case 25:
#line 2557 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 26:
#line 2561 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 27:
#line 2565 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 28:
#line 2569 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 29:
#line 2573 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 30:
#line 2577 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 31:
#line 2581 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 32:
#line 2585 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = optional_Type;
  new->structuredDes.optional = (Type) yyvsp[0];
  yyval = (refany) new;
;
    break;}
case 33:
#line 2592 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 34:
#line 2598 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 35:
#line 2604 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 36:
#line 2608 "ilu.bison"
{
  yyval = (refany) K_LONG;
;
    break;}
case 37:
#line 2612 "ilu.bison"
{
  yyval = (refany) K_SHORT;
;
    break;}
case 38:
#line 2618 "ilu.bison"
{
  yyval = (refany) ((((int)yyvsp[-1]) == 0) ? integer_Type : ((((int)yyvsp[-1]) == K_SHORT) ? shortinteger_Type : longinteger_Type));
;
    break;}
case 39:
#line 2622 "ilu.bison"
{
  yyval = (refany) ((((int)yyvsp[-1]) == 0) ? cardinal_Type : ((((int)yyvsp[-1]) == K_SHORT) ? shortcardinal_Type : longcardinal_Type));
;
    break;}
case 40:
#line 2626 "ilu.bison"
{
  yyval = (refany) ((((int)yyvsp[-1]) == 0) ? real_Type : ((((int)yyvsp[-1]) == K_SHORT) ? shortreal_Type : longreal_Type));
;
    break;}
case 41:
#line 2630 "ilu.bison"
{
  yyval = (refany) ((((int)yyvsp[-1]) == 0 || ((int)yyvsp[-1]) == K_LONG) ? character_Type : shortcharacter_Type);
;
    break;}
case 42:
#line 2634 "ilu.bison"
{
  yyval = (refany) boolean_Type;
;
    break;}
case 43:
#line 2638 "ilu.bison"
{
  yyval = (refany) byte_Type;
;
    break;}
case 44:
#line 2642 "ilu.bison"
{
  yyval = (refany) pickle_Type;
;
    break;}
case 45:
#line 2648 "ilu.bison"
{
  matchname_s s;
#define BTN(sss,nnn,iii)	((sss).name=(nnn),(sss).interface=(iii),&sss)

  if ((TypeKind) yyvsp[0] == integer_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			    (iluparser_FindProc) matchTypeName, BTN(s, "integer", NULL));
  else if ((TypeKind) yyvsp[0] == cardinal_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			 (iluparser_FindProc) matchTypeName, BTN(s, "cardinal", NULL));
  else if ((TypeKind) yyvsp[0] == real_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			    (iluparser_FindProc) matchTypeName, BTN(s, "real", NULL));
  else if ((TypeKind) yyvsp[0] == shortinteger_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
		     (iluparser_FindProc) matchTypeName, BTN(s, "shortinteger", NULL));
  else if ((TypeKind) yyvsp[0] == shortcardinal_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
		    (iluparser_FindProc) matchTypeName, BTN(s, "shortcardinal", NULL));
  else if ((TypeKind) yyvsp[0] == shortreal_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			(iluparser_FindProc) matchTypeName, BTN(s, "shortreal", NULL));
  else if ((TypeKind) yyvsp[0] == longinteger_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
		      (iluparser_FindProc) matchTypeName, BTN(s, "longinteger", NULL));
  else if ((TypeKind) yyvsp[0] == longcardinal_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
		     (iluparser_FindProc) matchTypeName, BTN(s, "longcardinal", NULL));
  else if ((TypeKind) yyvsp[0] == longreal_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			 (iluparser_FindProc) matchTypeName, BTN(s, "longreal", NULL));
  else if ((TypeKind) yyvsp[0] == character_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			(iluparser_FindProc) matchTypeName, BTN(s, "character", NULL));
  else if ((TypeKind) yyvsp[0] == shortcharacter_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
		   (iluparser_FindProc) matchTypeName, BTN(s, "shortcharacter", NULL));
  else if ((TypeKind) yyvsp[0] == boolean_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			    (iluparser_FindProc) matchTypeName, BTN(s, "boolean", NULL));
  else if ((TypeKind) yyvsp[0] == byte_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			    (iluparser_FindProc) matchTypeName, BTN(s, "byte", NULL));
  else if ((TypeKind) yyvsp[0] == pickle_Type)
    yyval = (refany) list_find(CurrentParse->interface->types,
			    (iluparser_FindProc) matchTypeName, BTN(s, "pickle", NULL));
;
    break;}
case 46:
#line 2696 "ilu.bison"
{
  yyval = (refany) FIND_OR_CREATE_TYPE(yyvsp[0]);
;
    break;}
case 47:
#line 2702 "ilu.bison"
{ ParsingConstant = TRUE; ;
    break;}
case 48:
#line 2705 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  unsigned long limit = (unsigned long) yyvsp[-2];
  unsigned charset = (unsigned) yyvsp[-1];

  ParsingConstant = FALSE;
  if (limit == 0)
    limit = 0xFFFFFFFF;
  else if (charset == ISO_8859_1_CHARSET)
    {
      new->type = sequence_Type;
      new->structuredDes.sequence.limit = limit;
      new->structuredDes.sequence.optional = FALSE;
      new->structuredDes.sequence.type = FIND_OR_CREATE_TYPE("ilu.shortcharacter");
    }
  else if (charset == ISO_UNICODE_CHARSET)
    {
      new->type = sequence_Type;
      new->structuredDes.sequence.limit = limit;
      new->structuredDes.sequence.optional = FALSE;
      new->structuredDes.sequence.type = FIND_OR_CREATE_TYPE("ilu.character");
    }
  else
    {
      new->type = string_Type;
      new->structuredDes.string.max_length = limit;
      new->structuredDes.string.charset = charset;
    }
  yyval = (refany) new;
;
    break;}
case 49:
#line 2738 "ilu.bison"
{ ParsingConstant = TRUE; ;
    break;}
case 50:
#line 2742 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  IntegerLiteral maxnum = (IntegerLiteral) yyvsp[-2];
  IntegerLiteral minnum = (IntegerLiteral) yyvsp[-3];
  IntegerLiteral denom = (IntegerLiteral) yyvsp[-1];

  ParsingConstant = FALSE;
  new->type = fixedpoint_Type;
  if (denom->small && (!denom->negative) && (denom->val.direct == 1))
    {
      /* integer types */
      if (minnum->small && (minnum->val.direct == 0)) {
	/* cardinal types */
	if (maxnum->small && (!maxnum->negative) && (maxnum->val.direct == 255)) {
	  /* byte_Type */
	  new->type = byte_Type;
	} else if (maxnum->small && (!maxnum->negative) && (maxnum->val.direct == 0xFFFF)) {
	  /* shortcardinal_Type */
	  new->type = shortcardinal_Type;
	} else if (maxnum->small && (!maxnum->negative) && (maxnum->val.direct == 0xFFFFFFFF)) {
	  new->type = cardinal_Type;
	}
      } else if ((minnum->small && minnum->negative && (minnum->val.direct == 0x80000000)) &&
		 (maxnum->small && (!maxnum->negative) && (maxnum->val.direct == 0x7FFFFFFF))) {
	new->type = integer_Type;
      } else if ((minnum->small && minnum->negative && (minnum->val.direct == 0x8000)) &&
		 (maxnum->small && (!maxnum->negative) && (maxnum->val.direct == 0x7FFF))) {
	new->type = shortinteger_Type;
      }
    }
  if (new->type == fixedpoint_Type) {
    new->structuredDes.fixed.min_numerator = yyvsp[-3];
    new->structuredDes.fixed.max_numerator = yyvsp[-2];
    new->structuredDes.fixed.denominator = yyvsp[-1];
  };
  yyval = (refany) new;
;
    break;}
case 51:
#line 2782 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 52:
#line 2786 "ilu.bison"
{
  yyval = (refany) yyval;
;
    break;}
case 53:
#line 2792 "ilu.bison"
{
  yyval = (refany) ISO_UNICODE_CHARSET;
;
    break;}
case 54:
#line 2796 "ilu.bison"
{
  yyval = (refany) ISO_8859_1_CHARSET;
;
    break;}
case 55:
#line 2800 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 56:
#line 2806 "ilu.bison"
{
  unsigned long val;
  int sign;
  char *p;
  IntegerLiteral new = (IntegerLiteral) iluparser_Malloc (sizeof(*new));
  p = yyvsp[0];
  if (!ilu_strtoul(p, &sign, &new->val.direct, &new->small))
    {
      char buf[1000];
      sprintf(buf, "Integer literal \"%s\" contains invalid character(s).", (string) yyvsp[0]);
      iluerror(buf);
      YYERROR;
    }
  else if (!new->small)
    new->val.string = ilu_strdup(p);
  new->negative = (sign < 0);
  yyval = (void *) new;
;
    break;}
case 57:
#line 2826 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = array_Type;
  new->structuredDes.array.type = (Type) yyvsp[0];
  new->structuredDes.array.optional = FALSE;
  list_insert (((Type) yyvsp[0])->refs, (refany) CurrentParse->line);
  new->structuredDes.array.dimensions = (list) yyvsp[-1];
  yyval = (refany) new;
;
    break;}
case 58:
#line 2836 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = array_Type;
  new->structuredDes.array.type = (Type) yyvsp[0];
  new->structuredDes.array.optional = FALSE;
  list_insert (((Type) yyvsp[0])->refs, (refany) CurrentParse->line);
  new->structuredDes.array.dimensions = (list) yyvsp[-2];
  yyval = (refany) new;
;
    break;}
case 59:
#line 2848 "ilu.bison"
{
  list new = new_list();
  list_insert (new, (refany) ilu_atoi(yyvsp[0]));
  yyval = (refany) new;
;
    break;}
case 60:
#line 2854 "ilu.bison"
{
  list_insert (yyvsp[-2], (refany) ilu_atoi(yyvsp[0]));
  yyval = (refany) yyvsp[-2];
;
    break;}
case 61:
#line 2861 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = sequence_Type;
  new->structuredDes.sequence.type = (Type) yyvsp[-1];
  new->structuredDes.sequence.optional = FALSE;
  new->structuredDes.sequence.limit = (cardinal) yyvsp[0];
  if (new->structuredDes.sequence.limit > 0xFFFF && ((int)yyvsp[-4]) == K_SHORT)
    iluwarn ("Both a limit and SHORT are used on sequence declaration.  SHORT dominates.\n");
  if (((int)yyvsp[-4]) == K_SHORT)
    new->structuredDes.sequence.limit = 0xFFFF;
  list_insert (((Type) yyvsp[-1])->refs, (refany) CurrentParse->line);
  yyval = (refany) new;
;
    break;}
case 62:
#line 2877 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 63:
#line 2881 "ilu.bison"
{
  yyval = (refany) ilu_atoi(yyvsp[0]);
;
    break;}
case 64:
#line 2887 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = pipe_Type;
  new->structuredDes.pipe.type = (Type) yyvsp[0];
  new->structuredDes.pipe.optional = FALSE;
  new->structuredDes.pipe.sink_p = (boolean) yyvsp[-2];
  list_insert (((Type) yyvsp[0])->refs, (refany) CurrentParse->line);
  yyval = (refany) new;
;
    break;}
case 65:
#line 2899 "ilu.bison"
{
  yyval = (refany) FALSE;
;
    break;}
case 66:
#line 2903 "ilu.bison"
{
  yyval = (refany) TRUE;
;
    break;}
case 67:
#line 2909 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = record_Type;
  new->structuredDes.record.fields = (list) yyvsp[-1];
  new->structuredDes.record.extensible = (boolean) yyvsp[-4];
  new->structuredDes.record.supertype = (Type) yyvsp[-2];
  yyval = (refany) new;
;
    break;}
case 68:
#line 2918 "ilu.bison"
{
  iluerror ("Error on record field definitions.");
  yyerrok;
  yyval = NULL;
;
    break;}
case 69:
#line 2924 "ilu.bison"
{
  iluerror( "Missing 'End' in record definition" );
  yyerrok;
  yyval = NULL;
;
    break;}
case 70:
#line 2932 "ilu.bison"
{
  list new = new_list();
  list_insert (new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 71:
#line 2939 "ilu.bison"
{
  list_insert (yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 72:
#line 2946 "ilu.bison"
{
  list_insert (((Type)yyvsp[0])->refs, (refany) CurrentParse->line);
  yyval = (refany) argument_Create ((string) yyvsp[-2], (Type) yyvsp[0], FALSE, In, CurrentParse->line, NULL);
;
    break;}
case 73:
#line 2953 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 74:
#line 2957 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 75:
#line 2961 "ilu.bison"
{
  yyval = (refany) 1;
;
    break;}
case 76:
#line 2967 "ilu.bison"
{
  yyval = (refany) NULL;
;
    break;}
case 77:
#line 2971 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 78:
#line 2977 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = union_Type;
  new->structuredDes.uniond.discriminator_type = yyvsp[-3];
  new->structuredDes.uniond.types = yyvsp[-2];
  new->structuredDes.uniond.default_arm=0;
  new->structuredDes.uniond.others_allowed = (boolean) yyvsp[0];
  yyval = (refany) new;
;
    break;}
case 79:
#line 2987 "ilu.bison"
{
  iluerror ("missing 'END' in Union description.");
  yyerrok;
;
    break;}
case 80:
#line 2995 "ilu.bison"
{
  if (yyvsp[-1] != NULL)
    yyval = yyvsp[-1];
  else
    yyval = (refany) FIND_OR_CREATE_TYPE("shortinteger");
;
    break;}
case 81:
#line 3004 "ilu.bison"
{
  yyval = NULL;
;
    break;}
case 82:
#line 3008 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 83:
#line 3014 "ilu.bison"
{
  list new;
  new = new_list();
  list_insert(new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 84:
#line 3021 "ilu.bison"
{
  list_insert((list) yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 85:
#line 3028 "ilu.bison"
{
  list_insert(((Type) yyvsp[-1])->refs, (refany) CurrentParse->line);
  yyval = argument_Create((string) NULL, (Type) yyvsp[-1], FALSE, In,
		       CurrentParse->line, (list) yyvsp[0]);
;
    break;}
case 86:
#line 3034 "ilu.bison"
{
  list_insert(((Type) yyvsp[-1])->refs, (refany) CurrentParse->line);
  yyval = argument_Create((string) yyvsp[-3], (Type) yyvsp[-1], FALSE, In, CurrentParse->line,
		       (list) yyvsp[0]);
;
    break;}
case 87:
#line 3042 "ilu.bison"
{
  yyval = (refany) NULL;
;
    break;}
case 88:
#line 3046 "ilu.bison"
{ ParsingConstant = TRUE;
			    ParsingNonRealConstant = TRUE; ;
    break;}
case 89:
#line 3049 "ilu.bison"
{ 
  yyval = yyvsp[0];
  ParsingNonRealConstant = FALSE;
  ParsingConstant = FALSE;
;
    break;}
case 90:
#line 3057 "ilu.bison"
{ 
  yyval = (refany) &iluparser_DefaultUnionArm;
;
    break;}
case 91:
#line 3061 "ilu.bison"
{
  list values = (list) yyvsp[-1];
  unsigned long i, n;
  ConstantValue cv;
  char *old, *p;
  for (n = list_size(values), i = 0;  i < n;  i++) {
    cv = list_ref(values, i);
    if ((cv->type == shortcharacter_Type) &&
	((p = strrchr(cv->val.s, '.')) != NULL)) {
      old = cv->val.s;
      cv->val.s = ilu_strdup(p + 1);
      free(old);
    };
  }
  yyval = (refany) values;
;
    break;}
case 92:
#line 3080 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 93:
#line 3084 "ilu.bison"
{
  yyval = (refany) 1;
;
    break;}
case 94:
#line 3090 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();
  new->type = enumeration_Type;
  new->structuredDes.enumeration = (list) yyvsp[-1];
  yyval = (refany) new;
;
    break;}
case 95:
#line 3097 "ilu.bison"
{
  iluerror ("Missing 'END' in enumeration element list.");
  yyerrok;
;
    break;}
case 96:
#line 3104 "ilu.bison"
{
  list new = new_list();
  list_insert (new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 97:
#line 3110 "ilu.bison"
{
  list_insert ((list) yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 98:
#line 3117 "ilu.bison"
{
  EnumField new = (EnumField) iluparser_Malloc(sizeof(struct enumerationField_s));
  new->name = yyvsp[0];
  new->id = -1;
  yyval = (refany) new;
;
    break;}
case 99:
#line 3124 "ilu.bison"
{
  EnumField new = (EnumField) iluparser_Malloc(sizeof(struct enumerationField_s));
  new->name = yyvsp[-2];
  new->id = ilu_atoi(yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 100:
#line 3133 "ilu.bison"
{
  Exception new = FIND_OR_CREATE_EXCEPTION (yyvsp[-4]);
  if (new->def != 0)
    {
      char buf[500];
      sprintf (buf, "exception \"%s\" already defined on line %ld.\n", exception_name(new), new->def);
      iluerror (buf);
      YYERROR;
    }
  else
    {
      new->valueOptional = FALSE;
      new->type = (Type) yyvsp[-3];
      new->def = CurrentParse->line;
      new->corba_rep_id = (char *) yyvsp[-2];
      new->doc_string = (char *) yyvsp[-1];
    }
  yyval = (refany) new;
;
    break;}
case 101:
#line 3155 "ilu.bison"
{
  char *p = strchr((char *) yyvsp[0], ':');
  if (p == NULL)
    {
      char buf[500];
      sprintf (buf, "type ID \"%s\" has no type ID scheme tag.\n", (char *) yyvsp[0]);
      iluerror (buf);
      YYERROR;
    }
  else if ((! isalpha(*((char *)yyvsp[0]))) ||
	   (strspn((char *) yyvsp[0], AlphaNumChars) != (p - ((char *) yyvsp[0]))))
    {
      iluerror ("type ID scheme tags must be alphanumeric beginning with alpha.\n");
      YYERROR;
    }
  else
    {
      yyval = (refany) yyvsp[0];
    }
;
    break;}
case 102:
#line 3178 "ilu.bison"
{
  yyval = (refany) 0;
;
    break;}
case 103:
#line 3182 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 104:
#line 3188 "ilu.bison"
{
  yyval = (refany) NULL;
;
    break;}
case 105:
#line 3192 "ilu.bison"
{
  list_insert (((Type) yyvsp[0])->refs, (refany) CurrentParse->line);
  yyval = yyvsp[0];
;
    break;}
case 106:
#line 3199 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 107:
#line 3203 "ilu.bison"
{
  yyval = (refany) new_list();
;
    break;}
case 108:
#line 3207 "ilu.bison"
{
  yyerrok;
  yyval = (refany) NULL;
;
    break;}
case 109:
#line 3214 "ilu.bison"
{
  list new = new_list();
  list_insert (new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 110:
#line 3220 "ilu.bison"
{
  list_insert (yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 111:
#line 3227 "ilu.bison"
{
  yyval = (refany) In;
;
    break;}
case 112:
#line 3231 "ilu.bison"
{
  yyval = (refany) In;
;
    break;}
case 113:
#line 3235 "ilu.bison"
{
  yyval = (refany) Out;
;
    break;}
case 114:
#line 3239 "ilu.bison"
{
  yyval = (refany) InOut;
;
    break;}
case 115:
#line 3245 "ilu.bison"
{
  /* name, type, sibling, direction, line_def */
  Argument new = argument_Create (yyvsp[-3], yyvsp[0], (boolean) yyvsp[-1], (ArgDirection) yyvsp[-4], CurrentParse->line, NULL);
  list_insert (new->type->refs, (refany) CurrentParse->line);
  yyval = (refany) new;
;
    break;}
case 116:
#line 3254 "ilu.bison"
{
  yyval = (refany) FALSE;
;
    break;}
case 117:
#line 3258 "ilu.bison"
{
  yyval = (refany) TRUE;
;
    break;}
case 118:
#line 3264 "ilu.bison"
{
  list l = new_list();
  Exception new = FIND_OR_CREATE_EXCEPTION (yyvsp[0]);
  list_insert (l, new);
  list_insert (new->refs, (refany) CurrentParse->line);
  yyval = (refany) l;
;
    break;}
case 119:
#line 3272 "ilu.bison"
{
  Exception new = FIND_OR_CREATE_EXCEPTION (yyvsp[0]);
  list_insert (yyvsp[-2], new);
  list_insert (new->refs, (refany) CurrentParse->line);
  yyval = (refany) yyvsp[-2];
;
    break;}
case 120:
#line 3282 "ilu.bison"
{
  TypeDescription new = new_TypeDescription();

  new->type = object_Type;
  new->structuredDes.object = (Class) iluparser_Malloc (sizeof(struct ilu_class_s));
  new->structuredDes.object->brand = NULL;
  new->structuredDes.object->corba_rep_id = NULL;
  new->structuredDes.object->collectible = FALSE;
  new->structuredDes.object->optional = FALSE;
  new->structuredDes.object->singleton = NULL;
  new->structuredDes.object->superclasses = NULL;
  new->structuredDes.object->authentication = NULL;
  new->structuredDes.object->methods = NULL;
  new->structuredDes.object->doc_string = NULL;

  list_enumerate ((list) yyvsp[0], (void (*)(refany, refany)) AssignClassAttributes, new->structuredDes.object);

  if (new->structuredDes.object->superclasses == NULL)
    new->structuredDes.object->superclasses = new_list();
  if (new->structuredDes.object->methods == NULL)
    new->structuredDes.object->methods = new_list();

  list_clear ((list) yyvsp[0], FALSE);
  iluparser_Free((void *) yyvsp[0]);

  yyval = (refany) new;
;
    break;}
case 121:
#line 3312 "ilu.bison"
{
  yyval = (refany) new_list();
;
    break;}
case 122:
#line 3316 "ilu.bison"
{
  O_Brand.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Brand);
  yyval = yyvsp[-1];
;
    break;}
case 123:
#line 3322 "ilu.bison"
{
  O_Collectible.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Collectible);
  yyval = yyvsp[-1];
;
    break;}
case 124:
#line 3328 "ilu.bison"
{
  O_Optional.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Optional);
  yyval = yyvsp[-1];
;
    break;}
case 125:
#line 3334 "ilu.bison"
{
  O_Singleton.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Singleton);
  yyval = yyvsp[-1];
;
    break;}
case 126:
#line 3340 "ilu.bison"
{
  O_Superclasses.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Superclasses);
  yyval = yyvsp[-1];
;
    break;}
case 127:
#line 3346 "ilu.bison"
{
  O_Authentication.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Authentication);
  yyval = yyvsp[-1];
;
    break;}
case 128:
#line 3352 "ilu.bison"
{
  O_RepositoryID.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_RepositoryID);
  yyval = yyvsp[-1];
;
    break;}
case 129:
#line 3358 "ilu.bison"
{
  O_Methods.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Methods);
  yyval = yyvsp[-1];
;
    break;}
case 130:
#line 3364 "ilu.bison"
{
  O_Documentation.value = (refany) yyvsp[0];
  list_insert ((list) yyvsp[-1], (refany) &O_Documentation);
  yyval = yyvsp[-1];
;
    break;}
case 131:
#line 3372 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 132:
#line 3378 "ilu.bison"
{
  yyval = (refany) TRUE;
;
    break;}
case 133:
#line 3384 "ilu.bison"
{
  yyval = (refany) TRUE;
;
    break;}
case 134:
#line 3390 "ilu.bison"
{
  list l = new_list();
  list_insert(l, FIND_OR_CREATE_TYPE(yyvsp[0]));
  yyval = (refany) l;
;
    break;}
case 135:
#line 3396 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 136:
#line 3402 "ilu.bison"
{
  list l = new_list();
  list_insert(l, (Type) yyvsp[0]);
  yyval = (refany) l;
;
    break;}
case 137:
#line 3408 "ilu.bison"
{
  list_insert((list) yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 138:
#line 3415 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 139:
#line 3421 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 140:
#line 3427 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 141:
#line 3433 "ilu.bison"
{
  yyval = (refany) yyvsp[-1];
;
    break;}
case 142:
#line 3437 "ilu.bison"
{
  iluerror ("Trailing comma in list of methods.");
  yyerrok;
  yyval = (refany) yyvsp[-3];
;
    break;}
case 143:
#line 3443 "ilu.bison"
{
  iluerror ("Bad method definition.");
  yyerrok;
  yyval = (refany) yyvsp[-1];
;
    break;}
case 144:
#line 3451 "ilu.bison"
{
  list new = new_list();
  if (yyvsp[0] != NULL)
    list_insert (new, yyvsp[0]);
  yyval = (refany) new;
;
    break;}
case 145:
#line 3458 "ilu.bison"
{
  if (yyvsp[0] != NULL)
    list_insert (yyvsp[-2], yyvsp[0]);
  yyval = yyvsp[-2];
;
    break;}
case 146:
#line 3464 "ilu.bison"
{
  iluerror ("Bad method definition, possible missing comma.");
  yyerrok;
  yyval = yyvsp[-2];
;
    break;}
case 147:
#line 3472 "ilu.bison"
{
  if ((((char *) yyvsp[-7]) == m_Asynchronous) && (yyvsp[-4] != NULL || yyvsp[-3] != NULL))
    {
      iluerror1 ("method \"%s\":  ASYNCHRONOUS methods cannot have return type or exceptions.\n", (char *) yyvsp[-6]);
      yyval = (refany) NULL;
    }
  else if (yyvsp[-5] == NULL)
    {
      iluerror1 ("method \"%s\":  Bad argument list.\n", (char *) yyvsp[-6]);
      yyval = (refany) NULL;
    }
  else
    {
      /* name, functional, async, arguments, returnType, exceptions, id, def_line, interface, object_type, authentication_type, doc_string */
      Type t = (yyvsp[-4] != NULL) ? ((Argument) yyvsp[-4])->type : NULL;

      Procedure new = procedure_Create (yyvsp[-6],
					((char *) yyvsp[-7] == m_Functional),
					((char *) yyvsp[-7] == m_Asynchronous),
					yyvsp[-5], t, yyvsp[-3], (int) yyvsp[-2],
					CurrentParse->line,
					CurrentParse->interface, NULL,
					(char *) yyvsp[-1], (char *) yyvsp[0]);
      yyval = (refany) new;
    }
;
    break;}
case 148:
#line 3501 "ilu.bison"
{
  yyval = NULL;
;
    break;}
case 149:
#line 3505 "ilu.bison"
{
  yyval = (refany) argument_Create (ilu_strdup(""), yyvsp[0], FALSE, In, CurrentParse->line, NULL);
  list_insert(((Type) yyvsp[0])->refs, (refany) CurrentParse->line);
;
    break;}
case 150:
#line 3512 "ilu.bison"
{
  yyval = (refany) FALSE;
;
    break;}
case 151:
#line 3516 "ilu.bison"
{
  yyval = (refany) m_Functional;
;
    break;}
case 152:
#line 3520 "ilu.bison"
{
  yyval = (refany) m_Asynchronous;
;
    break;}
case 153:
#line 3526 "ilu.bison"
{
  yyval = (refany) NULL;
;
    break;}
case 154:
#line 3530 "ilu.bison"
{
  yyval = (refany) yyvsp[0];
;
    break;}
case 155:
#line 3536 "ilu.bison"
{
  yyval = NULL;
;
    break;}
case 156:
#line 3540 "ilu.bison"
{
  yyval = yyvsp[-1];
;
    break;}
case 157:
#line 3544 "ilu.bison"
{
  iluerror ("Missing END on exception list");
  yyval = NULL;
;
    break;}
case 158:
#line 3551 "ilu.bison"
{
  yyval = (refany) -1;
;
    break;}
case 159:
#line 3555 "ilu.bison"
{
  yyval = (refany) ilu_atoi(yyvsp[0]);
;
    break;}
case 160:
#line 3561 "ilu.bison"
{
  yyval = (refany) NULL;
;
    break;}
case 161:
#line 3565 "ilu.bison"
{
  yyval = (refany) ilu_strdup((char *) yyvsp[0]);
;
    break;}
case 162:
#line 3571 "ilu.bison"
{ ParsingConstant = TRUE; ;
    break;}
case 163:
#line 3573 "ilu.bison"
{ ParsingConstant = FALSE; ;
    break;}
case 164:
#line 3576 "ilu.bison"
{
  Constant new = FIND_OR_CREATE_CONSTANT((string) yyvsp[-7]);
  ParsingConstant = FALSE;

  if (new->def != 0)
    {
      char buf[500];
      sprintf (buf, "constant \"%s\" already defined on line %ld\n", (char *) yyvsp[-7], new->def);
      iluerror (buf);
    }
  else
    {
      new->type = (Type) yyvsp[-5];
      new->value = (ConstantValue) yyvsp[-2];
      new->def = CurrentParse->line;
    }
  yyval = (refany) new;
;
    break;}
case 165:
#line 3597 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 166:
#line 3601 "ilu.bison"
{
  yyval = yyvsp[0];
;
    break;}
case 167:
#line 3607 "ilu.bison"
{
  int junk;
  boolean junk2;
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = integer_Type;
  new->val.i.sign = (yyvsp[-1] == 0) ? 1 : -1;
  if (!ilu_strtoul((char *) yyvsp[0], &junk, &new->val.i.value, &junk2))
    {
      char buf[1000];
      sprintf(buf, "Integer literal \"%s\" contains invalid character(s).", (string) yyvsp[0]);
      iluerror(buf);
      YYERROR;
    }
  else
    yyval = (refany) new;
;
    break;}
case 168:
#line 3624 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = shortcharacter_Type;
  new->val.s = (string) yyvsp[0];
  yyval = (refany) new;
;
    break;}
case 169:
#line 3631 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = boolean_Type;
  new->val.b = TRUE;
  yyval = (refany) new;
;
    break;}
case 170:
#line 3638 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = boolean_Type;
  new->val.b = FALSE;
  yyval = (refany) new;
;
    break;}
case 171:
#line 3647 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = real_Type;
  new->val.r.sign = (yyvsp[-2] == 0) ? 1 : -1;
  new->val.r.value = (string) yyvsp[-1];
  new->val.r.fraction = NULL;
  new->val.r.exponent = (long) yyvsp[0];
  yyval = (refany) new;
;
    break;}
case 172:
#line 3657 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = real_Type;
  new->val.r.sign = (yyvsp[-4] == 0) ? 1 : -1;
  new->val.r.value = (string) yyvsp[-3];
  new->val.r.fraction = (string) yyvsp[-1];
  new->val.r.exponent = (long) yyvsp[0];
  yyval = (refany) new;
;
    break;}
case 173:
#line 3667 "ilu.bison"
{
  ConstantValue new = (ConstantValue) iluparser_Malloc (sizeof(struct ilu_constantvalue_s));
  new->type = real_Type;
  new->val.r.sign = (yyvsp[-3] == 0) ? 1 : -1;
  new->val.r.value = (string) yyvsp[-2];
  new->val.r.fraction = (string) yyvsp[0];
  new->val.r.exponent = 0;
  yyval = (refany) new;
;
    break;}
case 174:
#line 3679 "ilu.bison"
{
    if ( yyvsp[0] != NULL )
        list_insert( yyvsp[-2], yyvsp[0] );
    yyval = yyvsp[-2];
;
    break;}
case 175:
#line 3685 "ilu.bison"
{
    list	new = new_list( );

    if ( yyvsp[0] != NULL )
        list_insert( new, yyvsp[0] );
    yyval = ( refany ) new;
;
    break;}
case 176:
#line 3695 "ilu.bison"
{
  yyval = (refany) ilu_atoi(yyvsp[0]);
;
    break;}
case 177:
#line 3699 "ilu.bison"
{
  yyval = (refany) ( - ilu_atoi( yyvsp[0] ));
;
    break;}
case 178:
#line 3703 "ilu.bison"
{
  yyval = (refany) (( cardinal ) ilu_atoi( yyvsp[0] ));
;
    break;}
case 179:
#line 3709 "ilu.bison"
{
  yyval = (refany) 1;
;
    break;}
case 180:
#line 3713 "ilu.bison"
{
  yyval = 0;
;
    break;}
case 181:
#line 3717 "ilu.bison"
{
  yyval = 0;
;
    break;}
case 182:
#line 3723 "ilu.bison"
{
  register char *p;
  if (!isalpha(*((string)yyvsp[0])))
    {
      char buf[500];
      sprintf (buf, "Identifier \"%s\" does not begin with alphabetic character.", (string) yyvsp[0]);
      iluerror (buf);
      YYERROR;
    }
  for (p = (string) yyvsp[0];  *p != '\0';  p++)
    {
      if (!(isalnum(*p) OR (*p == '-')))
	{
	  char buf[500];
	  sprintf (buf, "Identifier \"%s\" contains invalid character %c.", (string) yyvsp[0], *p);
	  iluerror (buf);
	  YYERROR;
	}
    }
  yyval = yyvsp[0];
;
    break;}
case 183:
#line 3747 "ilu.bison"
{
  register char *p;
  if (!isalpha(*((string)yyvsp[0])))
    {
      char buf[500];
      sprintf (buf, "Identifier \"%s\" does not begin with alphabetic character.", (string) yyvsp[0]);
      iluerror (buf);
      YYERROR;
    }
  for (p = (string) yyvsp[0];  *p != '\0';  p++)
    {
      if (!(isalnum(*p) OR (*p == '-') OR (*p == '.')))
	{
	  char buf[500];
	  sprintf (buf, "Scoped identifier \"%s\" contains invalid character %c.", (string) yyvsp[0], *p);
	  iluerror (buf);
	  YYERROR;
	}
    }
  yyval = yyvsp[0];
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/import/bison-1.25/sparc-sun-solaris2.5/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 3770 "ilu.bison"
	/* start of program */


static void GetQuotedString(FILE *file, character match, string buffer, int buffersize);
static int GetChar (FILE *file);

static int EatComment (FILE *file)
{
  boolean possibleEndOfComment, possibleNestedComment, endOfComment;
  register int c;

  /* eat input until end-of-comment.  Handle nested comments. */
  for (c = GetChar(file), possibleNestedComment = FALSE, possibleEndOfComment = FALSE, endOfComment = FALSE;
       c != EOF;  c = GetChar(file))
    {
      if (c == NEWLINE)
	CurrentParse->line += 1;

      if (endOfComment)
	return (c);

      if (possibleNestedComment)
	{
	  if (c == '*')
	    c = EatComment (file);
	  possibleNestedComment = FALSE;
	}
      else if (possibleEndOfComment)
	{
	  if (c == ')')
	    endOfComment = TRUE;
	  possibleEndOfComment = FALSE;
	}

/*
      if (c == '"')
	GetQuotedString (file, c, buffer, sizeof(buffer));
      else
*/
      if (c == '(')
	possibleNestedComment = TRUE;
      else if (c == '*')
	possibleEndOfComment = TRUE;
    }
  return (c);
}

/* ungetc() only provides one character of putback.  Extend this. */

struct putback_char {
  FILE *file;
  char *chars;
  unsigned long allocated;
  unsigned long used;
  struct putback_char *next;
};

static struct putback_char *Putbacks = NULL;

static void PutbackChar (char c, FILE *file)
{
  struct putback_char *p;

  for (p = Putbacks;  p != NULL;  p = p->next)
    if (p->file == file)
      break;
  if (p == NULL)
    {
      p = (struct putback_char *) iluparser_Malloc(sizeof(struct putback_char));
      p->file = file;
      p->chars = iluparser_Malloc(20);
      p->allocated = 20;
      p->used = 0;
      p->next = Putbacks;
      Putbacks = p;
    }
  if (p->used >= p->allocated)
    {
      p->allocated = p->used + 20;
      p->chars = iluparser_Realloc(p->chars, p->allocated);
    }
  p->chars[p->used] = c;
  p->used += 1;
  if (c == NEWLINE)
    {
      CurrentParse->line -= 1;
    }
}

static int GetChar (FILE *file)
{
  struct putback_char *p;

  for (p = Putbacks;  p != NULL;  p = p->next)
    if (p->file == file)
      break;
  if (p == NULL || p->used < 1)
    {
      return (getc(file));
    }
  else
    {
      p->used -= 1;
      return (p->chars[p->used]);
    }
}

static int NextChar (FILE *file)
{
  int c;

  c = GetChar(file);
  if (c == NEWLINE)
    {
      CurrentParse->line += 1;
    }

  while (c == '(')
    {
      c = GetChar(file);
      if (c == NEWLINE)
	CurrentParse->line += 1;
      if (c == '*')
	{
	  c = EatComment (file);
	}
      else
	{
	  PutbackChar ((character) c, file);
	  c = '(';
	  break;
	}
    }
  return (c);
}

static void GetQuotedString (FILE *file, character match, string buffer, int buffersize)
{
/*
  Copy string into buffer, stopping when char matching string[0]
  is encountered.  Backslash is quote character.
*/
  register int c;
  register character *output;
  register cardinal size;

#define IsHexDigit(x) ((((x)>='0')&&((x)<='9'))||(((x)>='a')&&((x)<='f'))||(((x)>='A')&&((x)<='F')))
#define HexValue(x) (((x)<='9')?((x)-'0'):((x)<='F')?((x)-'A'+10):((x)<='f')?((x)-'a'+10):0)

  for (output = buffer, c = NextChar(file), size = 1;  c != EOF && size < (cardinal) buffersize;  c = NextChar(file))
    {
      if (c == match)
	break;
      else
	{
	  if (c == '#')
	    {
	      c = NextChar(file);
	      if (IsHexDigit(c))
		{
		  character oldc = c;
		  unsigned int num = HexValue(c);
		  c = NextChar(file);
		  if (IsHexDigit(c))
		    *output++ = num * 16 + HexValue(c);
		  else
		    {
		      PutbackChar((character) c, file);
		      *output++ = oldc;
		    }
		}
	      else if (c == 'n')
		*output++ = '\n';
	      else if (c == 'r')
		*output++ = '\r';
	      else
		*output++ = c;
	    }
	  else
	    *output++ = c;
	  size += 1;
	}
    }
  *output = (character) 0;
  return;
}

static struct key {
  string k;
  int type;
  cardinal len;
  string trans;
} isl_keywords[] = {

    { "interface",		K_INTERFACE,	9, NULL },
    { "imports",		K_IMPORTS,	7, NULL },
    { "from",			K_FROM,		4, NULL },

    { "type",			K_TYPE,		4, NULL },
    { "short",			K_SHORT,	5, NULL },
    { "long",			K_LONG,		4, NULL },
    { "integer",		K_INTEGER,	7, NULL },
    { "cardinal",		K_CARDINAL,	8, NULL },
    { "extensible",		K_EXTENSIBLE,  10, NULL },
    { "fixed",			K_FIXED,        5, NULL },
    { "fixedpoint",		K_FIXEDPOINT,  10, NULL },
    { "real",			K_REAL,		4, NULL },
    { "byte",			K_BYTE,		4, NULL },
    { "boolean",		K_BOOLEAN,	7, NULL },
    { "character",		K_CHARACTER,	9, NULL },
    { "unicode-charset",	K_UNICODE,     15, NULL },
    { "latin1-charset",		K_LATIN1,      14, NULL },
    { "ilustring",		K_STRING,	9, NULL },
    { "charset",		K_CHARSET,	7, NULL },
    { "enumeration",		K_ENUMERATION, 11, NULL },
    { "union",			K_UNION,	5, NULL },
    { "default",		K_DEFAULT,	7, NULL },
    { "others",			K_OTHERS,	6, NULL },
    { "array",			K_ARRAY,	5, NULL },
    { "sequence",		K_SEQUENCE,	8, NULL },
    { "limit",			K_LIMIT,	5, NULL },
    { "of",			K_OF,		2, NULL },
    { "record",			K_RECORD,	6, NULL },
    { "optional",		K_OPTIONAL,	8, NULL },
    { "pickle",			K_PICKLE,	6, NULL },
    { "allows",			K_ALLOWS,	6, NULL },
    { "end",			K_END,		3, NULL },
    { "source",			K_SOURCE,	6, NULL },
    { "sink",			K_SINK,		4, NULL },

    { "exception",		K_EXCEPTION,	9, NULL },
    { "typeid",			K_TYPEID,	7, NULL },

    { "class",			K_OBJECT,	5, NULL },
    { "object",			K_OBJECT,	6, NULL },
    { "brand",			K_BRAND,	5, NULL },
    { "superclass",		K_SUPERCLASS,  10, NULL },
    { "supertype",		K_SUPERCLASS,	9, NULL },
    { "superclasses",		K_SUPERTYPES,  12, NULL },
    { "supertypes",		K_SUPERTYPES,  10, NULL },
    { "authentication",		K_AUTHENTICATION, 14, NULL },
    { "functional",		K_FUNCTIONAL,  10, NULL },
    { "asynchronous",		K_ASYNCH,      12, NULL },
    { "methods",		K_METHODS,	7, NULL },
    { "in",			K_IN,		2, NULL },
    { "out",			K_OUT,		3, NULL },
    { "inout",			K_INOUT,	5, NULL },
    { "sibling",		K_SIBLING,	7, NULL },
    { "singleton",		K_SINGLETON,	9, NULL },
    { "collectible",		K_COLLECTIBLE, 11, NULL },
    { "raises",			K_RAISES,	6, NULL },
    { "documentation",		K_DOCUMENTATION,13, NULL },

    { "constant",		K_CONSTANT,	8, NULL },
    { "true",			K_TRUE,		4, NULL },
    { "false",			K_FALSE,	5, NULL },

    { NULL, 0, 0} };

static boolean find_keyword (string buffer, cardinal *type, cardinal *length, string *translation)
{
  struct key *p;
/*
  printf ("checking <%s> for keywordness\n", buffer);
*/

  if (buffer == NULL)
    return FALSE;
  for (p = isl_keywords;  p->k != NULL;  p += 1)
    if (ilu_strcasecmp(buffer, p->k) == 0)
      {
	if (type != NULL)
	  *type = p->type;
	if (length != NULL)
	  *length = p->len;
	if (translation != NULL)
	  *translation = p->trans == NULL ? p->k : p->trans;
	return (TRUE);
      }
  return (FALSE);		 
}

boolean iluparser_IsKeyword (char *str)
{
  return (find_keyword (str, NULL, NULL, NULL));
}

static boolean IsBaseDigit (cardinal base, unsigned char digit)
{
  return ((base <= 10 && (((cardinal)(digit - '0')) < base))
	  || ((base > 10) && ((((cardinal)(digit - '0')) < 10)
			      || ((digit >= 'a') && (((cardinal) (digit - 'a' + 10)) < base))
			      || ((digit >= 'A') && (((cardinal) (digit - 'A' + 10)) < base)))));
}

static int GetToken (FILE *file, string buffer, int buffersize, cardinal *type)
{
  static string chars = "();:,=";
  static cardinal types[] = { K_LEFTPAREN, K_RIGHTPAREN, K_SEMICOLON, K_COLON, K_COMMA, K_EQUALS };
  static string funnychars = "&|!()<>\"';:,";
  static string bases = "bBdDoOxX";
  static cardinal base[] = { 2, 2, 10, 10, 8, 8, 16, 16 };
  int length;
  character *q;
  int c;
  string trans;
  string bufferbase = buffer;

#define loop while(1)

  c = NextChar(file);
  while (!isgraph(c) && c != EOF)
    c = NextChar(file);
  if (c == EOF)
    return (EOF);

  if (c == '"' || c == '\'')
    {
      GetQuotedString (file, (character) c, buffer, buffersize);
      *type = T_STRING;
    }
  else if ((q = (char *) strchr(chars, c)) != NULL)
    {
      *buffer = c;
      buffer[1] = (char) 0;
      *type = types[q - chars];
    }
  else if (ParsingConstant && c == '-')
    {
      *type = K_HYPHEN;
    }
  else if (ParsingConstant && c == '+')
    {
      *type = K_PLUS;
    }
  else if (ParsingConstant && c == '.')
    {
      *type = K_PERIOD;
    }
  else if (ParsingConstant && (!ParsingNonRealConstant)
	   && (c == 'e' || c == 'E'))
    {
      *type = K_EXPONENT;
    }
  else if (isdigit(c))
    {
      cardinal CurrentBase = 10;

      *buffer++ = c;
      if ((c == '0') || (c == '#'))
	{
	  c = NextChar(file);
	  if ((q = (char *) strchr(bases, c)) != NULL)
	    {
	      *buffer++ = c;
	      CurrentBase = base[q - bases];
	    }
	  else
	    PutbackChar((character) c, file);
	}
      while ((c = NextChar(file)) != EOF && IsBaseDigit(CurrentBase, (unsigned char) c))
	*buffer++ = c;
      PutbackChar((character) c, file);
      *buffer = 0;
      *type = T_NUMBER;
/*
      if (iluparsedebug)
	fprintf (stderr, "(number)  %s   (%s, %u)\n", bufferbase, CurrentParse->filename, CurrentParse->line);
*/
    }	  
  else
    {
      string orig = buffer;
      loop
	{
	  if (isgraph(c) && (strchr(funnychars, c) == NULL))
	    { *buffer++ = c;  c = NextChar(file); }
	  else
	    {
	      PutbackChar((character) c, file);
	      *buffer = 0;
	      *type = T_STRING;
	      break;
	    }
	}
      if (find_keyword (orig, type, (cardinal *) &length, &trans))
	{
	  strcpy (orig, trans);
	  orig[strlen(trans)] = (char) 0;
/*
	  if (iluparsedebug) 
	    fprintf (stderr, "(keyword)  <%s>   (%s, %u)\n", orig, CurrentParse->filename, CurrentParse->line);
*/
	}
/*
      else if (iluparsedebug)
	fprintf (stderr, "(string)  \"%s\"   (%s, %u)\n", bufferbase, CurrentParse->filename, CurrentParse->line);
*/
    }
  return (c);
}

/*
	"iluparselex"
*/
static int iluparselex (refany *lvalp)
{	/* lexical analysis routine */
  cardinal type;
  char buffer[1000];
  int c;

  if (CurrentParse->input == NULL)
    return (-1);

  buffer[0] = '\0';
  c = GetToken (CurrentParse->input, buffer, sizeof(buffer), &type);
  if (c == EOF)
    return (-1);

  *lvalp = (YYSTYPE) ilu_strdup(buffer);

  return ((int) type);
}

static void ilutokenprint (FILE *where, int tokentype, YYSTYPE token)
{
  if (tokentype == T_STRING)
    fprintf (where, " \"%s\"", (string) token);
  else if (tokentype == T_NUMBER)
    fprintf (where, " %s", (string) token);
}
