#ifndef DEBUG_H
#define DEBUG_H 1
/*
 * debug.h -- definitions for general debugging / tracing routines for
 *	      GSS API shell
 *
 * Antony Courtney, 8/5/95
 * (discretely pilfered from code used for other projects)
 */

#include <stdio.h>
#include <errno.h>

/* a re-definition of strerror() for silly, non-ANSI systems (like Suns!) */
char *_ilugss_sys_strerror(int errnum);

/* debugging routine...*/
void ilugss_debug(unsigned level,...);

#define DEBUG	ilugss_debug

/* packet dump routine */
void ilugss_dump_packet(void *buf,unsigned len);

/* buffer version of gss_dump_packet */
#define _ilugss_dump_buf(b)	ilugss_dump_packet((b)->value,(b)->length)
#define ilugss_dump_buf(b)	ilugss_dump_packet((b)->value,(b)->length)

/* different types of debugging levels */
#define PACKET_DB	0x0001		/* see packets */
#define INIT_DB		0x0002		/* see context initialisation */
#define PROTO_DB	0x0008		/* interp packet contents */
#define ERR_DB		0x0010		/* errors */
#define CALL_DB		0x0020		/* GSS API call traces */
#endif	/* DEBUG_H */

