/***********************************************************************\
*   Copyright (C) 1992 by Michael K. Johnson, johnsonm@sunsite.unc.edu	*
*									*
*	This file is placed under the conditions of the GNU public	*
*	license, version 2, or any later version.  See file COPYING	*
*	for information on distribution conditions.			*
\***********************************************************************/
#include <stdlib.h>
#include <stdio.h>

void *xcalloc(void *pointer, int size) {
    void * ret;
    if (pointer)
        free(pointer);
    if (!(ret = calloc(1, size))) {
        fprintf(stderr, "xcalloc: allocation error, size = %d\n", size);
        exit(1);
    } else {
        return ret;
    }
}

void *xmalloc(unsigned int size) {
    void *p;

    if (size == 0)
        ++size;
    p = malloc(size);
    if (!p) {
	fprintf(stderr, "xmalloc: malloc(%d) failed", size);
	perror(NULL);
	exit(1);
    }
    return(p);
}

void *xrealloc(void *oldp, unsigned int size) {
    void *p;

    if (size == 0)
        ++size;
    p = realloc(oldp, size);
    if (!p) {
	fprintf(stderr, "xrealloc: realloc(%d) failed", size);
	perror(NULL);
	exit(1);
    }
    return(p);
}
