/*  
 *   Copyright (C)1996-1997 Ian Jackson
 *  
 *   This is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *  
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *  
 *   You should have received a copy of the GNU General Public License
 *   along with userv; if not, write to the Free Software
 *   Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */






#ifndef TOKENS_H
#define TOKENS_H

enum tokens {
  tokm_instance=           0x000000ff,
  tokm_repres=             0x00000f00,
  tokm_type=               0xfffff000,
  tokr_nonstring=          0x00000100,
  tokr_word=               0x00000200,
  tokr_punct=              0x00000300,
  tokr_string=             0x00000400,
  tokt_directive=          0x00001000,
  tokt_controlstart=       0x00002000,
  tokt_controlend=         0x00004000,
  tokt_exception=          0x00008000,
  tokt_parmcondition=      0x00010000,
  tokt_condop=             0x00020000,
  tokt_parameter=          0x00040000,
  tokt_number=             0x00080000,
  tokt_fdrange=            0x00100000,
  tokt_logfacility=        0x00200000,
  tokt_loglevel=           0x00400000,
  tokt_readwrite=          0x00800000,
  tokt_string=             0x01000000,
  tokt_execmode=           0x02000000,
  tokt_ehandlemode=        0x04000000,
  tokt_builtinservice=     0x08000000,
  tokt_misc=               0x10000000,
  tokt_internal=           0x20000000,

  toki_word_reject=                                 0x00000001,
  toki_word_executefromdirectory=                   0x00000002,
  toki_word_executefrompath=                        0x00000003,
  toki_word_executebuiltin=                         0x00000004,
  toki_word_errorstostderr=                         0x00000005,
  toki_word_errorstosyslog=                         0x00000006,
  toki_word_errorstofile=                           0x00000007,
  toki_word_requirefd=                              0x00000008,
  toki_word_allowfd=                                0x00000009,
  toki_word_nullfd=                                 0x0000000a,
  toki_word_rejectfd=                               0x0000000b,
  toki_word_ignorefd=                               0x0000000c,
  toki_word_setenvironment=                         0x0000000d,
  toki_word_nosetenvironment=                       0x0000000e,
  toki_word_suppressargs=                           0x0000000f,
  toki_word_nosuppressargs=                         0x00000010,
  toki_word_disconnecthup=                          0x00000011,
  toki_word_nodisconnecthup=                        0x00000012,
  toki_word_cd=                                     0x00000013,
  toki_word_userrcfile=                             0x00000014,
  toki_word_include=                                0x00000015,
  toki_word_includeifexist=                         0x00000016,
  toki_word_includelookup=                          0x00000017,
  toki_word_includelookupall=                       0x00000018,
  toki_word_includedirectory=                       0x00000019,
  toki_word_message=                                0x0000001a,
  toki_word_includesysconfig=                       0x0000001b,
  toki_word_includeuserrcfile=                      0x0000001c,
  toki_word_includeclientconfig=                    0x0000001d,
  toki_word_quit=                                   0x0000001e,
  toki_word_eof=                                    0x0000001f,
  toki_word_if=                                     0x00000020,
  toki_word_catchquit=                              0x00000021,
  toki_word_errorspush=                             0x00000022,
  toki_word_elif=                                   0x00000023,
  toki_word_else=                                   0x00000024,
  toki_word_fi=                                     0x00000025,
  toki_word_hctac=                                  0x00000026,
  toki_word_srorre=                                 0x00000027,
  toki_word_glob=                                   0x00000028,
  toki_word_range=                                  0x00000029,
  toki_word_grep=                                   0x0000002a,
  toki_word_environment=                            0x0000002b,
  toki_word_parameter=                              0x0000002c,
  toki_word_version=                                0x0000002d,
  toki_word_toplevel=                               0x0000002e,
  toki_word_override=                               0x0000002f,
  toki_word_reset=                                  0x00000030,
  toki_word_execute=                                0x00000031,
  toki_word_service=                                0x00000032,
  toki_word_callinguser=                            0x00000033,
  toki_word_callinggroup=                           0x00000034,
  toki_word_callingusershell=                       0x00000035,
  toki_word_serviceuser=                            0x00000036,
  toki_word_servicegroup=                           0x00000037,
  toki_word_serviceusershell=                       0x00000038,
  toki_syslog_debug=                                0x00000039,
  toki_syslog_info=                                 0x0000003a,
  toki_syslog_notice=                               0x0000003b,
  toki_syslog_warning=                              0x0000003c,
  toki_syslog_err=                                  0x0000003d,
  toki_syslog_crit=                                 0x0000003e,
  toki_syslog_alert=                                0x0000003f,
  toki_syslog_emerg=                                0x00000040,
  toki_syslog_authpriv=                             0x00000041,
  toki_syslog_cron=                                 0x00000042,
  toki_syslog_daemon=                               0x00000043,
  toki_syslog_kern=                                 0x00000044,
  toki_syslog_lpr=                                  0x00000045,
  toki_syslog_mail=                                 0x00000046,
  toki_syslog_news=                                 0x00000047,
  toki_syslog_syslog=                               0x00000048,
  toki_syslog_user=                                 0x00000049,
  toki_syslog_uucp=                                 0x0000004a,
  toki_syslog_local0=                               0x0000004b,
  toki_syslog_local1=                               0x0000004c,
  toki_syslog_local2=                               0x0000004d,
  toki_syslog_local3=                               0x0000004e,
  toki_syslog_local4=                               0x0000004f,
  toki_syslog_local5=                               0x00000050,
  toki_syslog_local6=                               0x00000051,
  toki_syslog_local7=                               0x00000052,
  toki_word_read=                                   0x00000053,
  toki_word_write=                                  0x00000054,
  toki_ordinal=                                     0x00000055,
  toki_fdrange=                                     0x00000056,
  toki_fdstoend=                                    0x00000057,
  toki_dollar=                                      0x00000058,
  toki_lwsp=                                        0x00000059,
  toki_newline=                                     0x0000005a,
  toki_barestring=                                  0x0000005b,
  toki_quotedstring=                                0x0000005c,
  toki_eof=                                         0x0000005d,
  toki_quit=                                        0x0000005e,
  toki_error=                                       0x0000005f,
  toki_openparen=                                   0x00000060,
  toki_closeparen=                                  0x00000061,
  toki_not=                                         0x00000062,
  toki_and=                                         0x00000063,
  toki_or=                                          0x00000064,
  toki_word_error=                                  0x00000065,

  tokv_word_reject=             tokt_directive|tokt_execmode|tokr_word|toki_word_reject,
  tokv_word_executefromdirectory=tokt_directive|tokt_execmode|tokr_word|toki_word_executefromdirectory,
  tokv_word_executefrompath=    tokt_directive|tokt_execmode|tokr_word|toki_word_executefrompath,
  tokv_word_executebuiltin=     tokt_directive|tokt_execmode|tokr_word|toki_word_executebuiltin,
  tokv_word_errorstostderr=     tokt_directive|tokt_ehandlemode|tokr_word|toki_word_errorstostderr,
  tokv_word_errorstosyslog=     tokt_directive|tokt_ehandlemode|tokr_word|toki_word_errorstosyslog,
  tokv_word_errorstofile=       tokt_directive|tokt_ehandlemode|tokr_word|toki_word_errorstofile,
  tokv_word_requirefd=          tokt_directive|tokr_word|toki_word_requirefd,
  tokv_word_allowfd=            tokt_directive|tokr_word|toki_word_allowfd,
  tokv_word_nullfd=             tokt_directive|tokr_word|toki_word_nullfd,
  tokv_word_rejectfd=           tokt_directive|tokr_word|toki_word_rejectfd,
  tokv_word_ignorefd=           tokt_directive|tokr_word|toki_word_ignorefd,
  tokv_word_setenvironment=     tokt_directive|tokr_word|toki_word_setenvironment,
  tokv_word_nosetenvironment=   tokt_directive|tokr_word|toki_word_nosetenvironment,
  tokv_word_suppressargs=       tokt_directive|tokr_word|toki_word_suppressargs,
  tokv_word_nosuppressargs=     tokt_directive|tokr_word|toki_word_nosuppressargs,
  tokv_word_disconnecthup=      tokt_directive|tokr_word|toki_word_disconnecthup,
  tokv_word_nodisconnecthup=    tokt_directive|tokr_word|toki_word_nodisconnecthup,
  tokv_word_cd=                 tokt_directive|tokr_word|toki_word_cd,
  tokv_word_userrcfile=         tokt_directive|tokr_word|toki_word_userrcfile,
  tokv_word_include=            tokt_directive|tokr_word|toki_word_include,
  tokv_word_includeifexist=     tokt_directive|tokr_word|toki_word_includeifexist,
  tokv_word_includelookup=      tokt_directive|tokr_word|toki_word_includelookup,
  tokv_word_includelookupall=   tokt_directive|tokr_word|toki_word_includelookupall,
  tokv_word_includedirectory=   tokt_directive|tokr_word|toki_word_includedirectory,
  tokv_word_message=            tokt_directive|tokr_word|toki_word_message,
  tokv_word_includesysconfig=   tokt_directive|tokt_internal|tokr_word|toki_word_includesysconfig,
  tokv_word_includeuserrcfile=  tokt_directive|tokt_internal|tokr_word|toki_word_includeuserrcfile,
  tokv_word_includeclientconfig=tokt_directive|tokt_internal|tokr_word|toki_word_includeclientconfig,
  tokv_word_quit=               tokt_directive|tokr_word|toki_word_quit,
  tokv_word_eof=                tokt_directive|tokr_word|toki_word_eof,
  tokv_word_if=                 tokt_directive|tokt_controlstart|tokr_word|toki_word_if,
  tokv_word_catchquit=          tokt_directive|tokt_controlstart|tokr_word|toki_word_catchquit,
  tokv_word_errorspush=         tokt_directive|tokt_controlstart|tokr_word|toki_word_errorspush,
  tokv_word_elif=               tokt_controlend|tokt_controlstart|tokr_word|toki_word_elif,
  tokv_word_else=               tokt_controlend|tokt_controlstart|tokr_word|toki_word_else,
  tokv_word_fi=                 tokt_controlend|tokr_word|toki_word_fi,
  tokv_word_hctac=              tokt_controlend|tokr_word|toki_word_hctac,
  tokv_word_srorre=             tokt_controlend|tokr_word|toki_word_srorre,
  tokv_word_glob=               tokt_parmcondition|tokr_word|toki_word_glob,
  tokv_word_range=              tokt_parmcondition|tokr_word|toki_word_range,
  tokv_word_grep=               tokt_parmcondition|tokr_word|toki_word_grep,
  tokv_word_environment=        tokt_builtinservice|tokr_word|toki_word_environment,
  tokv_word_parameter=          tokt_builtinservice|tokr_word|toki_word_parameter,
  tokv_word_version=            tokt_builtinservice|tokr_word|toki_word_version,
  tokv_word_toplevel=           tokt_builtinservice|tokr_word|toki_word_toplevel,
  tokv_word_override=           tokt_builtinservice|tokr_word|toki_word_override,
  tokv_word_reset=              tokt_directive|tokt_builtinservice|tokr_word|toki_word_reset,
  tokv_word_execute=            tokt_directive|tokt_builtinservice|tokt_execmode|tokr_word|toki_word_execute,
  tokv_word_service=            tokt_parameter|tokr_word|toki_word_service,
  tokv_word_callinguser=        tokt_parameter|tokr_word|toki_word_callinguser,
  tokv_word_callinggroup=       tokt_parameter|tokr_word|toki_word_callinggroup,
  tokv_word_callingusershell=   tokt_parameter|tokr_word|toki_word_callingusershell,
  tokv_word_serviceuser=        tokt_parameter|tokr_word|toki_word_serviceuser,
  tokv_word_servicegroup=       tokt_parameter|tokr_word|toki_word_servicegroup,
  tokv_word_serviceusershell=   tokt_parameter|tokr_word|toki_word_serviceusershell,
  tokv_syslog_debug=            tokt_loglevel|tokr_word|toki_syslog_debug,
  tokv_syslog_info=             tokt_loglevel|tokr_word|toki_syslog_info,
  tokv_syslog_notice=           tokt_loglevel|tokr_word|toki_syslog_notice,
  tokv_syslog_warning=          tokt_loglevel|tokr_word|toki_syslog_warning,
  tokv_syslog_err=              tokt_loglevel|tokr_word|toki_syslog_err,
  tokv_syslog_crit=             tokt_loglevel|tokr_word|toki_syslog_crit,
  tokv_syslog_alert=            tokt_loglevel|tokr_word|toki_syslog_alert,
  tokv_syslog_emerg=            tokt_loglevel|tokr_word|toki_syslog_emerg,
  tokv_syslog_authpriv=         tokt_logfacility|tokr_word|toki_syslog_authpriv,
  tokv_syslog_cron=             tokt_logfacility|tokr_word|toki_syslog_cron,
  tokv_syslog_daemon=           tokt_logfacility|tokr_word|toki_syslog_daemon,
  tokv_syslog_kern=             tokt_logfacility|tokr_word|toki_syslog_kern,
  tokv_syslog_lpr=              tokt_logfacility|tokr_word|toki_syslog_lpr,
  tokv_syslog_mail=             tokt_logfacility|tokr_word|toki_syslog_mail,
  tokv_syslog_news=             tokt_logfacility|tokr_word|toki_syslog_news,
  tokv_syslog_syslog=           tokt_logfacility|tokr_word|toki_syslog_syslog,
  tokv_syslog_user=             tokt_logfacility|tokr_word|toki_syslog_user,
  tokv_syslog_uucp=             tokt_logfacility|tokr_word|toki_syslog_uucp,
  tokv_syslog_local0=           tokt_logfacility|tokr_word|toki_syslog_local0,
  tokv_syslog_local1=           tokt_logfacility|tokr_word|toki_syslog_local1,
  tokv_syslog_local2=           tokt_logfacility|tokr_word|toki_syslog_local2,
  tokv_syslog_local3=           tokt_logfacility|tokr_word|toki_syslog_local3,
  tokv_syslog_local4=           tokt_logfacility|tokr_word|toki_syslog_local4,
  tokv_syslog_local5=           tokt_logfacility|tokr_word|toki_syslog_local5,
  tokv_syslog_local6=           tokt_logfacility|tokr_word|toki_syslog_local6,
  tokv_syslog_local7=           tokt_logfacility|tokr_word|toki_syslog_local7,
  tokv_word_read=               tokt_readwrite|tokr_word|toki_word_read,
  tokv_word_write=              tokt_readwrite|tokr_word|toki_word_write,
  tokv_ordinal=                 tokt_number|tokt_fdrange|tokr_word|toki_ordinal,
  tokv_fdrange=                 tokt_fdrange|tokr_punct|toki_fdrange,
  tokv_fdstoend=                tokt_fdrange|tokr_punct|toki_fdstoend,
  tokv_dollar=                  tokt_misc|tokr_punct|toki_dollar,
  tokv_lwsp=                    tokt_misc|tokr_nonstring|toki_lwsp,
  tokv_newline=                 tokt_misc|tokr_nonstring|toki_newline,
  tokv_barestring=              tokt_string|tokr_string|toki_barestring,
  tokv_quotedstring=            tokt_string|tokr_string|toki_quotedstring,
  tokv_eof=                     tokt_exception|tokr_nonstring|toki_eof,
  tokv_quit=                    tokt_exception|tokr_nonstring|toki_quit,
  tokv_error=                   tokt_exception|tokr_nonstring|toki_error,
  tokv_openparen=               tokt_condop|tokr_punct|toki_openparen,
  tokv_closeparen=              tokt_condop|tokr_punct|toki_closeparen,
  tokv_not=                     tokt_condop|tokr_punct|toki_not,
  tokv_and=                     tokt_condop|tokr_punct|toki_and,
  tokv_or=                      tokt_condop|tokr_punct|toki_or,
  tokv_word_error=              tokt_directive|tokt_loglevel|tokr_word|toki_word_error,

};



#endif

