#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/mount.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include <newt.h>
#include "lang.h"

extern int fdflush(const char *filename);
extern int set_loop (const char *, const char *, int, int *);
extern int del_loop (const char *);

/* ED: try to read an image through the loop service to determine if it resides
 * on local disk or NFS server.  In the latter case, the loop service cannot be
 * used as is.  The workaround is to copy the image locally before mounting it.
 */
static int
check_loop(const char *loop_dev ) {
  int fd;
  char buf[1];
  int err=0;
  fd=open(loop_dev,O_RDONLY);
  if (!fd)
    return -1;
  if (read(fd,buf,sizeof(buf)) != sizeof(buf))
    err=-1;
  close(fd);
  return err;
}

extern int mount_one(char *blockDevice, char *directory, char *filesystemType, 
  unsigned long flags, char *string_flags, int noMtab, int fake);

static int install_floppy (char *device, const char *type, const char *text) {
  int status;

  if (mount_and_check_floppy(device,type,text)) return 1;
  sprintf(prtbuf,MSG_INSTALLING_FLOPPY,text);
  if (strncmp(device,"/dev/loop",9) ) {
   strcat(prtbuf,"...");
  } else {
   strcat(prtbuf,MSG_FROM_FLOPPY_IMAGES);
  }
  pleaseWaitBox(prtbuf);
  chdir("/floppy");
  status=system("./install.sh /target");
  chdir("/");
  do_umount("/floppy",0);
  newtPopWindow();
  if (status) {
    return 1;
  }
  return 0;
}

int extract_kernel_and_modules (void) {
  DIR* dp;
  char *diskimage;
  struct dirent *dirp;
  int found=0,ro=1,status=0;
  struct fdisk_partition *p;
  int broken_loop=0;

  disqtype=kernel;

  /* Only verify root choice if it is not empty. */

  dp = opendir(T_FILE("/target/."));
  while (NULL != (dirp = readdir(dp))) {
    if (( 0 != strcmp(dirp->d_name, ".")) &&
        ( 0 != strcmp(dirp->d_name, "..")) &&
        ( 0 != strcmp(dirp->d_name, "lost+found"))) {
      found = 1;
      break;
    }
  }

  if (found) {
    sprintf(prtbuf,MSG_MOUNTED_FS);
    p = mounted_partitions;
    while (p) {
      if (! strncmp(p->mount_point,T_FILE("/target"),
                                   strlen(T_FILE("/target")) ) ) {
	char *begg;
        strcat(prtbuf,"\n");
        strcat(prtbuf,p->name);
        strcat(prtbuf," on ");
	begg=(p->mount_point)+strlen(T_FILE("/target"));
	if (*begg=='\0')
		strcat(prtbuf,"/");
	else
		strcat(prtbuf,begg);
      }
      p = p->next_in_use;
    }
    if (! yesNoBox(prtbuf,MSG_VERIFY_FS) ) return 1;
  }
  if ( choose_medium() ) return 1;
  
  if (! strncmp(Archive_Dir,"/dev/fd",7) ) {
    fdflush(Archive_Dir);
    status=install_floppy(Archive_Dir,"rescue",MSG_RESCUE_FLOPPY);
    if (status) {
/* FIXME:  write_it_down "The attempt to extract the rescue floppy failed." */
      eject_floppy(Archive_Dir);
      sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_RESCUE_FLOPPY);
      problemBox(prtbuf, MSG_FLOPPY_ERROR);
    } else {
      fdflush(Archive_Dir);
      eject_floppy(Archive_Dir);
      status=install_floppy(Archive_Dir,"drivers",MSG_DRIVERS_FLOPPY);
      fdflush(Archive_Dir);
      eject_floppy(Archive_Dir);
      if (status) {
/* FIXME:  write_it_down "The attempt to extract the drivers floppy failed." */
        sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_DRIVERS_FLOPPY);
        problemBox(prtbuf, MSG_FLOPPY_ERROR);
      }
    }
  } else {
    if (bootargs.istecra) {
      diskimage=KERDISKIMG_TECRA;
    } else {
      diskimage=KERDISKIMG;
    }
    sprintf(prtbuf,"%s/%s",Archive_Dir,diskimage);
    set_loop("/dev/loop0",prtbuf,0,&ro);
    if (check_loop("/dev/loop0")) {
      /* image is on an NFS server -> loop device is broken, copy to local */
      del_loop("/dev/loop0");
      sprintf(prtbuf,MSG_BROKEN_LOOP_DEV,diskimage);
      pleaseWaitBox(prtbuf);
      sprintf(prtbuf,"cp %s/%s /target/rescue.bin",Archive_Dir,diskimage);
      status=system(prtbuf);
      newtPopWindow();
      if (!status) {
        strcpy(prtbuf,"/target/rescue.bin");
        set_loop("/dev/loop0",prtbuf,0,&ro);
        broken_loop=1;
      }
    }
    if (!status) {
      status=install_floppy("/dev/loop0","rescue",MSG_RESCUE_FLOPPY);
      del_loop("/dev/loop0");
      if (broken_loop)
        unlink("/target/rescue.bin");
    }
    if (status) {
/* FIXME:  write_it_down "The attempt to extract the rescue floppy failed." */
      sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_RESCUE_FLOPPY);
      problemBox(prtbuf, MSG_FLOPPY_ERROR);
    } else {
      if (bootargs.istecra) {
        diskimage=DRVDISKIMG_TECRA;
      } else {
        diskimage=DRVDISKIMG;
      }
      sprintf(prtbuf,"%s/%s",Archive_Dir,diskimage);
      if (!broken_loop)
        set_loop("/dev/loop0",prtbuf,0,&ro);
      else {
        /* image is on an NFS server -> loop device is broken, copy to local */
        sprintf(prtbuf,MSG_BROKEN_LOOP_DEV,diskimage);
        pleaseWaitBox(prtbuf);
        sprintf(prtbuf,"cp %s/%s /target/drivers.bin",Archive_Dir,diskimage);
        status=system(prtbuf);
        newtPopWindow();
        if (!status) {
          strcpy(prtbuf,"/target/drivers.bin");
          set_loop("/dev/loop0",prtbuf,0,&ro);
	}
      }
      if (!status) {
        status=install_floppy("/dev/loop0","drivers",MSG_DRIVERS_FLOPPY);
        sync();
        del_loop("/dev/loop0");
        if (broken_loop)
          unlink("/target/drivers.bin");
      }
      if (status) {
/* FIXME:  write_it_down "The attempt to extract the drivers floppy failed." */
        sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_DRIVERS_FLOPPY);
        problemBox(prtbuf, MSG_FLOPPY_ERROR);
      }
    }
    do_umount("/instmnt",0);
  }
/*  free(Archive_Dir); */
/*  Archive_Dir=NULL; */
  return status;
}
