#!	/bin/sh

# Abort on any non-zero return.
set -e

# Verbose shell execution.
#set -x
#set -v

# Print a usage message and exit if the argument count is wrong.
if [ $# != 2 ]; then
	echo "Usage: "$0" old-floppy new-floppy" 1>&2
	cat 1>&2 << EOF

	old-floppy: Floppy image to modify.
	new-floppy: name for the modified floppy image.
EOF
	exit -1
fi

oldf=$1
newf=$2

mnt=/var/tmp/mnt.$$

loopdevice=/dev/loop3

cp $oldf $newf.tmp

(umount $loopdevice; true)
(/sbin/losetup -d $loopdevice; true)

/sbin/losetup $loopdevice $newf.tmp

syslinux $loopdevice

/sbin/losetup -d $loopdevice

(rm -f -r $newf;true)
mv $newf.tmp $newf
ls -l $newf
exit 0
