//
// /home/ms/sidplay/X11/RCS/STIL.h,v
//

#ifndef STIL_H
#define STIL_H

#include <fstream.h>

class STIL
{

 public:  // --------------------------------------------------------- public
	
	STIL(const char* fileName);
	virtual ~STIL();
	
	virtual const char* getNextEntry();
	virtual const char* getFormattedString();
	
	virtual operator bool()
	{
		return status;
	}

	bool EOB()
	{
		return ((unsigned long)(stilBufEnd-linePtr) == 0);
	}
	
	bool isComment()
	{
		return (*linePtr =='#');
	}
	
	bool isDelimiter()
	{
		return ((*linePtr==0x0A)||(*linePtr==0x0D));
	}	
	
	bool isPath()
	{
		return (*linePtr=='/');
	}
	
	bool isZero()
	{
		return (*linePtr==0);
	}


 protected:  // --------------------------------------------------- protected
	
	unsigned long stilLength;
	char* stilBuffer;
	char* stilBufEnd;

	char* stilEntryStart;
	char* linePtr;
	
	bool status;
	
	virtual void skipLine();
};

#endif  // STIL_H
