//
// /home/ms/sidplay/X11/RCS/STIL.cpp,v
//

#include "STIL.h"

STIL::STIL(const char* fileName)
{
	// Create input file stream. Make it binary because of compatibility to
	// text files from other supported operating systems.
	ifstream stilFile(fileName,ios::in|ios::bin|ios::nocreate|ios::ate);
	stilLength = (unsigned long)stilFile.tellg();
	stilFile.seekg(0,ios::beg);
	if (stilLength != 0)
	{
		stilBuffer = new char[stilLength+1];
	}
	if ((stilBuffer==0) || (!stilFile))
    {
		status = false;
    }
	else
    {
		stilFile.read(stilBuffer,stilLength);
		stilFile.close();
		stilBuffer[stilLength] = 0;
		stilBufEnd = stilBuffer+stilLength;
		// Incorrect, but inits pointer.
		stilEntryStart = stilBuffer;
		linePtr = stilBuffer;
		status = true;
    }
}

STIL::~STIL()
{
	if (stilBuffer != 0)
    {
		delete[] stilBuffer;
    }
}

const char* STIL::getNextEntry()
{
	linePtr = stilEntryStart;
	while ( !EOB() )
	{
		skipLine();
		if ( isPath() )
			break;
	}
	if ( isPath() )
	{
		stilEntryStart = linePtr;
		char* oldLinePtr = linePtr;
		while ( !EOB() && !isDelimiter() && !isZero() )
		{
			linePtr++;
		}
		while ( !EOB() && isDelimiter() )
			*linePtr++ = 0;
		linePtr = oldLinePtr;
		return linePtr;
	}
	else
		return 0;
}

const char* STIL::getFormattedString()
{
	linePtr = stilEntryStart;
	if ( isPath() )
		skipLine();
	char* oldLinePtr = linePtr;
	char* destPtr = linePtr;
	char* pLastDelimiter = destPtr;
	char* pPreviousDelimiter = destPtr;
	while ( !EOB() && !isZero() )
	{
		if ( isDelimiter() )
		{
			pPreviousDelimiter = pLastDelimiter;
			pLastDelimiter = destPtr;
			skipLine();
			*pLastDelimiter = '\n';
			destPtr++;
			if (isComment() || isPath() )
 				break;
		}
		else
		{
			*destPtr++ = *linePtr++;
		}
	}
	// Close string.
	*pLastDelimiter = 0;
	// Permit empty last line (only the trivial case).
	if ((int)(pLastDelimiter-pPreviousDelimiter) == 1)
		*pPreviousDelimiter = 0;
	return (linePtr=oldLinePtr);
}

void STIL::skipLine()
{
	while ( !EOB() && !isDelimiter() && !isZero() )
		linePtr++;
	if ( *linePtr == 0x0A )
	{
		linePtr++;
	}
	else if ( *linePtr == 0x0D )
	{
		linePtr++;
		if ( *linePtr == 0x0A )
		{
			linePtr++;
		}
	}
	while ( !EOB() && isZero() )
		linePtr++;
}
