//
// /home/ms/sidplay/qtsidplay/RCS/MixerDialog.h,v
//

#ifndef MixerDialog_included
#define MixerDialog_included

#include "MixerDialogData.h"
#include "LEDButton.h"

static const int voices = 4;
static const int effects = 4;


class MixerDialog : public MixerDialogData
{
    Q_OBJECT

public:

    MixerDialog
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~MixerDialog();

	void presetButtons();
	void adjustMixerMode();
	void adjustAllMuteButtons();
	void currentSoloButtonOff();
	void allMuteSoloButtonsOff();
	void adjustPanningSliders();
	void newVoiceGain(int voice, int val);
	void newVoicePanPos(int voice, int leftLevel);

	void readAllVoiceVol();
	void writeVoiceVol(int voice);
	void writeVoiceGainOnly(int voice);
	void writeAllVoiceGainOnly();

	void disableVoice(int voice);
	void enableVoice(int voice);
	void restoreAllVoices();

 protected slots:

	void checkMixerButtons(bool,bool,bool);
	void checkEffectButtons(bool,bool,bool);
	
    void setMixerOff();
    void setHighQuality();
    void setFullPanning();
	
    void setEffectsOff();
    void setStereoSurround();
    void setCenteredPanning();

	void setEffect();

    void muteVoice4(bool);
    void setVoice1Pan(int);
    void soloVoice2(bool);
    void muteVoice2(bool);
    void setVoice2Pan(int);
    void soloVoice3(bool);
    void muteVoice3(bool);
    void soloVoice4(bool);
    void setVoice2Volume(int);
    void setVoice1Volume(int);
    void setVoice4Volume(int);
    void setVoice3Volume(int);
    void soloVoice1(bool);
    void setVoice3Pan(int);
    void setVoice4Pan(int);
    void muteVoice1(bool);

 protected:
	
	QSlider* volSliders[voices];
	QScrollBar* panSliders[voices];
	QPushButton* muteButtons[voices];
	QPushButton* soloButtons[voices];
	QWidget* effectWidgets[effects];

	bool dontTouchMuteButtons;
	int soloIsX;
		
	void disableMixer();
	void enableMixer();
	
	void disablePanning();
	void enablePanning();
	
	void disableEffects();
	void enableEffects();
	
};
#endif // MixerDialog_included
